/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CHECKOUTPARAM_H
#define _SC_CHECKOUTPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"


/**
 * Parameter class for CheckoutCmd.
 */
class CheckoutParam : public ScParam
{
public:
  /**
   * construct a CheckoutParam object.
   */
  CheckoutParam( const sc::String& url, const sc::String& path, const svn::RevisionPtr peg,
     const svn::RevisionPtr rev, bool recurse )
    : _url(url), _path(path), _peg(peg), _rev(rev), _recurse(recurse)
  {
  }

  ~CheckoutParam()
  {
  }

  const sc::String& getUrl() const
  {
    return _url;
  }

  void setUrl( const sc::String& url )
  {
    _url = url;
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  void setPath( const sc::String& path )
  {
    _path = path;
  }

  const svn::RevisionPtr getPegRevision() const
  {
    return _peg;
  }

  void setPegRevision( svn::RevisionPtr peg )
  {
    _peg = peg;
  }

  const svn::RevisionPtr getRevision() const
  {
    return _rev;
  }

  void setRevision( svn::RevisionPtr rev )
  {
    _rev = rev;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  void setRecurse( bool recurse )
  {
    _recurse = recurse;
  }

  svn::Revnumber& getRevnumber()
  {
    return _revnum;
  }

  ScParamAccept(CheckoutParam);

private:
  // in
  sc::String        _url;
  sc::String        _path;
  svn::RevisionPtr  _peg;
  svn::RevisionPtr  _rev;
  bool              _recurse;

  // out
  svn::Revnumber    _revnum;
};

#endif // _SC_CHECKOUTPARAM_H
