/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-scan.
 * 
 *   Swac-scan is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-scan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-scan.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _TAG_HH
#define _TAG_HH

#include <string>
#include <map>


typedef std::map<std::string, std::string> ListFields;

class Tag {
protected:
	std::string filename;
	void add_vector(std::string const field, std::string const value, bool const exclude_standards_fields = true);
	void add_vector(std::string const vector, bool const exclude_standards_fields = true);
	bool is_standard_vorbis_comment_field(std::string const field);
public:
	ListFields fields;
	virtual bool extract_from_file(std::string const path, bool const exclude_standards_fields = true);
	void print();
	std::string get_filename();

	virtual ~Tag();
};


#endif
