C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE TRANS1
C                       *****************
C
     * (NDIM,NPOINS,TMPS,
     *  NBCOUF,NCOUPF,VCOUPF,
     *  NBCOUS,NCOUPS,VCOUPS,
     *  NELESF,NDMASF,NODESF,NELESS,NDMASS,NODESS,
     *  NBICOR,BARYF,NCBORF,BARYS,NCBORS,
     *  NPOINF,TF,HHT)
C      ----------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------      
C       Premier passage des donnees du solide vers le fluide           *
C       pour fournir a Saturne des conditions initiales                *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  NCOUPF   ! TE ! D  ! NUMERO DES NOEUDS FLUIDES COUPLES            !
C !  VCOUPF   ! TR !D M ! VALEUR AUX NOEUDS FLUIDES COUPLES            !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
C
C **********************************************************************
C..Variables externes
      INTEGER NDIM,NPOINS,NBCOUF,NPOINF
      INTEGER NBCOUS,NELESF,NDMASF,NELESS,NDMASS,NBICOR
      INTEGER NCOUPF(NBCOUF,2),NCOUPS(NBCOUS)
      INTEGER NODESF(NELESF,NDMASF),NODESS(NELESS,NDMASS)
      INTEGER NCBORF(NBCOUF,NBICOR),NCBORS(NBCOUS,NBICOR)
      DOUBLE PRECISION TMPS(NPOINS)
      DOUBLE PRECISION VCOUPF(NBCOUF,2),VCOUPS(NBCOUS,2)
      DOUBLE PRECISION BARYF(NBCOUF,NDIM),BARYS(NBCOUS,NDIM)
      DOUBLE PRECISION TF(NPOINF),HHT(NPOINF)
C
C..Variables internes
      INTEGER N,NG
      INTEGER MODE,N1
C
C***********************************************************************
C
C     Passage de la temperature solide dans le tableau local 
C     des noeuds couples
      DO N=1,NBCOUS
         NG = NCOUPS(N)
         VCOUPS(N,1) = TMPS(NG)
      ENDDO
C
C     Passage de la temperature solide (vcoups) a la temperature
C     fluide vue de Syrthes (vcoupf)
      MODE=1
      IF (NDIM .EQ. 2) THEN
         CALL PSFNC2 (MODE,
     &                NDIM,NBCOUF,VCOUPF,NBCOUS,VCOUPS,
     &                NELESF,NDMASF,NODESF,NELESS,NDMASS,NODESS,
     &                NBICOR,BARYF,NCBORF,BARYS,NCBORS)
      ELSE
         CALL PSFNC3 (MODE,
     &                NDIM,NBCOUF,VCOUPF,NBCOUS,VCOUPS,
     &                NELESF,NDMASF,NODESF,NELESS,NDMASS,NODESS,
     &                NBICOR,BARYF,NCBORF,BARYS,NCBORS)
      ENDIF
C
C
C     Passage de la temperature fluide vue de Syrthes (vcoupf)
C     a la temperature fluide vue de Saturne (TF)
      N1=1
      CALL SOLFLC (N1,N1,
     &             NDIM,NBCOUF,NCOUPF,VCOUPF(1,1),VCOUPF(1,2),
     &             NPOINF,TF,HHT,N1,NBCOUF)
C
C
C-------
C FORMAT
C-------
C
C----
C FIN
C----
      END
          
