from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


absolute_import = _Mock()

bytes_to_str = _Mock()

cast_bytes_py2 = _Mock()

channel_socket_types = _Mock()

connect_qtconsole = _Mock()

filefind = _Mock()

find_connection_file = _Mock()

get_connection_file = _Mock()

get_connection_info = _Mock()

get_ipython_dir = _Mock()

getpass = _Mock()

glob = _Mock()

json = _Mock()

localhost = _Mock()

os = _Mock()

port_names = _Mock()

socket = _Mock()

str_to_bytes = _Mock()

string_types = _Mock()

sys = _Mock()

tempfile = _Mock()

tunnel = _Mock()

tunnel_to_kernel = _Mock()

write_connection_file = _Mock()

zmq = _Mock()

PIPE = -1

channel = 'control'

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CaselessStrEnum(_Mock):
  pass
  info_text = 'any value'

class Configurable(_Mock):
  pass


class ConnectionFileMixin(_Mock):
  pass


class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class Popen(_Mock):
  pass
  _child_created = False

class ProfileDir(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

