from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


builtin_mod = _Mock()

default_int_handler = _Mock()

ioloop = _Mock()

ipython_version = _Mock()

json_clean = _Mock()

language_version = _Mock()

logging = _Mock()

print_function = _Mock()

protocol_version = _Mock()

py3compat = _Mock()

release = _Mock()

serialize_object = _Mock()

signal = _Mock()

string_types = _Mock()

sys = _Mock()

time = _Mock()

traceback = _Mock()

unpack_apply_message = _Mock()

uuid = _Mock()

zmq = _Mock()

SIGINT = 2

class Any(_Mock):
  pass
  info_text = 'any value'

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Configurable(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class Float(_Mock):
  pass
  default_value = 0.0
  info_text = 'a float'

class Instance(_Mock):
  pass
  info_text = 'any value'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class Kernel(_Mock):
  pass


class List(_Mock):
  pass
  info_text = 'any value'

class Session(_Mock):
  pass


class Set(_Mock):
  pass
  info_text = 'any value'

class StdinNotImplementedError(_Mock):
  pass


class Type(_Mock):
  pass
  info_text = 'any value'

class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class ZMQInteractiveShell(_Mock):
  pass
  default_user_namespaces = True

class ZMQStream(_Mock):
  pass


class datetime(_Mock):
  pass


class unicode_type(_Mock):
  pass


