from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


Compiler = _Mock()

compileUi = _Mock()

compileUiDir = _Mock()

compiler = _Mock()

exceptions = _Mock()

icon_cache = _Mock()

indenter = _Mock()

loadUi = _Mock()

loadUiType = _Mock()

objcreator = _Mock()

port_v2 = _Mock()

properties = _Mock()

uiparser = _Mock()

widgetPluginPath = _Mock()

_display_code = '\nif __name__ == "__main__":\n\timport sys\n\tapp = QtGui.QApplication(sys.argv)\n\t%(widgetname)s = QtGui.%(baseclass)s()\n\tui = %(uiclass)s()\n\tui.setupUi(%(widgetname)s)\n\t%(widgetname)s.show()\n\tsys.exit(app.exec_())\n'

_header = "# -*- coding: utf-8 -*-\n\n# Form implementation generated from reading ui file '%s'\n#\n# Created: %s\n#      by: PyQt4 UI code generator %s\n#\n# WARNING! All changes made in this file will be lost!\n\n"

_pyqt3_wrapper_code = '\nclass %(widgetname)s(QtGui.%(baseclass)s, %(uiclass)s):\n\tdef __init__(self, parent=None, f=QtCore.Qt.WindowFlags()):\n\t\tQtGui.%(baseclass)s.__init__(self, parent, f)\n\n\t\tself.setupUi(self)\n'



