from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


ast = _Mock()

error = _Mock()

extract_code_ranges = _Mock()

extract_symbols = _Mock()

find_file = _Mock()

find_source_lines = _Mock()

get_py_filename = _Mock()

get_text_list = _Mock()

inspect = _Mock()

io = _Mock()

ipython_input_pat = _Mock()

line_magic = _Mock()

magics_class = _Mock()

os = _Mock()

print_function = _Mock()

py3compat = _Mock()

range_re = _Mock()

re = _Mock()

skip_doctest = _Mock()

string_types = _Mock()

sys = _Mock()

unquote_filename = _Mock()

warn = _Mock()



class CodeMagics(_Mock):
  pass
  registered = True

class InteractivelyDefined(_Mock):
  pass


class Macro(_Mock):
  pass


class MacroToEdit(_Mock):
  pass


class Magics(_Mock):
  pass
  registered = False

class StdinNotImplementedError(_Mock):
  pass


class TryNext(_Mock):
  pass


class UsageError(_Mock):
  pass


class chain(_Mock):
  pass


class preserve_keys(_Mock):
  pass


