from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_exception_traceback = _Mock()

_extract_future_flags = _Mock()

anyp = _Mock()

builtin_mod = _Mock()

doctest = _Mock()

doctests = _Mock()

getcwd = _Mock()

getmodule = _Mock()

getpackage = _Mock()

inspect = _Mock()

is_extension_module = _Mock()

linecache = _Mock()

log = _Mock()

logging = _Mock()

nose = _Mock()

os = _Mock()

pdb = _Mock()

re = _Mock()

resolve_name = _Mock()

sys = _Mock()

test_address = _Mock()

tolist = _Mock()

traceback = _Mock()

unittest = _Mock()

PY3 = _Mock()

REPORTING_FLAGS = 960

REPORT_ONLY_FIRST_FAILURE = 512

SKIP = 16

_unittest_reportflags = 0

class DocFileCase(_Mock):
  pass
  _classSetupFailed = False
  _diffThreshold = 65536
  longMessage = False
  maxDiff = 640

class DocTestCase(_Mock):
  pass
  _classSetupFailed = False
  _diffThreshold = 65536
  longMessage = False
  maxDiff = 640

class DocTestFinder(_Mock):
  pass


class DocTestRunner(_Mock):
  pass
  DIVIDER = '**********************************************************************'

class DocTestSkip(_Mock):
  pass
  ds_skip = 'Doctest to skip.\n    >>> 1 #doctest: +SKIP\n    '

class ExtensionDoctest(_Mock):
  pass
  can_configure = False
  enabled = True
  name = 'extdoctest'
  score = 100

class IPDocTestParser(_Mock):
  pass
  _PS1_IP = 'In\\ \\[\\d+\\]:'
  _PS1_PY = '>>>'
  _PS2_IP = '\\ \\ \\ \\.\\.\\.+:'
  _PS2_PY = '\\.\\.\\.'
  _RE_TPL = '\n        # Source consists of a PS1 line followed by zero or more PS2 lines.\n        (?P<source>\n            (?:^(?P<indent> [ ]*) (?P<ps1> %s) .*)    # PS1 line\n            (?:\\n           [ ]*  (?P<ps2> %s) .*)*)  # PS2 lines\n        \\n? # a newline\n        # Want consists of any non-blank lines that do not start with PS1.\n        (?P<want> (?:(?![ ]*$)    # Not a blank line\n                     (?![ ]*%s)   # Not a line starting with PS1\n                     (?![ ]*%s)   # Not a line starting with PS2\n                     .*$\\n?       # But any other line\n                  )*)\n                  '

class IPDocTestRunner(_Mock):
  pass
  DIVIDER = '**********************************************************************'

class IPDoctestOutputChecker(_Mock):
  pass


class IPExample(_Mock):
  pass


class IPExternalExample(_Mock):
  pass


class IPythonDoctest(_Mock):
  pass
  can_configure = False
  enabled = True
  name = 'ipdoctest'
  score = 100

class Plugin(_Mock):
  pass
  can_configure = False
  enabled = False
  score = 100

class StringIO(_Mock):
  pass


class _OutputRedirectingPdb(_Mock):
  pass
  doc_header = 'Documented commands (type help <topic>):'
  doc_leader = ''
  identchars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_'
  lastcmd = ''
  misc_header = 'Miscellaneous help topics:'
  nohelp = '*** No help on %s'
  prompt = '(Cmd) '
  ruler = '='
  undoc_header = 'Undocumented commands:'
  use_rawinput = 1

