/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.eclipse.swt.widgets.Display;
import org.piccolo2d.extras.swt.SWTTimerQueue;

public class SWTTimer
extends Timer {
    private static final long serialVersionUID = 1L;
    private boolean notify = false;
    private int initialDelay;
    private int delay;
    private boolean repeats = true;
    private boolean coalesce = true;
    private Runnable doPostEvent = null;
    private Display display = null;
    private long expirationTime;
    private SWTTimer nextTimer;
    boolean running;

    public SWTTimer(Display display, int delay, ActionListener listener) {
        super(delay, listener);
        this.delay = delay;
        this.initialDelay = delay;
        this.doPostEvent = new SWTDoPostEvent();
        this.display = display;
    }

    protected void fireActionPerformed(ActionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    SWTTimerQueue timerQueue() {
        return SWTTimerQueue.sharedInstance(this.display);
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Invalid delay: " + delay);
        }
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setInitialDelay(int initialDelay) {
        if (initialDelay < 0) {
            throw new IllegalArgumentException("Invalid initial delay: " + initialDelay);
        }
        this.initialDelay = initialDelay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean flag) {
        this.repeats = flag;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public void setCoalesce(boolean flag) {
        boolean old = this.coalesce;
        this.coalesce = flag;
        if (!old && this.coalesce) {
            this.cancelEventOverride();
        }
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.getInitialDelay());
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.cancelEventOverride();
    }

    public void restart() {
        this.stop();
        this.start();
    }

    synchronized void cancelEventOverride() {
        this.notify = false;
    }

    synchronized void postOverride() {
        if (!this.notify || !this.coalesce) {
            this.notify = true;
            this.display.asyncExec(this.doPostEvent);
        }
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    void setNextTimer(SWTTimer nextTimer) {
        this.nextTimer = nextTimer;
    }

    SWTTimer getNextTimer() {
        return this.nextTimer;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    class SWTDoPostEvent
    implements Runnable {
        SWTDoPostEvent() {
        }

        public void run() {
            if (SWTTimer.this.notify) {
                SWTTimer.this.fireActionPerformed(new ActionEvent(SWTTimer.this, 0, null, System.currentTimeMillis(), 0));
                if (SWTTimer.this.coalesce) {
                    SWTTimer.this.cancelEventOverride();
                }
            }
        }

        SWTTimer getTimer() {
            return SWTTimer.this;
        }
    }
}

