---
myst:
  html_meta:
    keywords: LaTeX,sciences humaines,humanités,thèse,rapport,mémoire,linguistique,théologie,histoire,sociologie
---
# Je commence une thèse en sciences humaines. Est-ce que LaTeX est fait pour moi ?

- Oui, bien sûr ! LaTeX a été initalement développé dans la communauté mathématique/informatique, mais son domaine d'excellence est très étendu.

## Pourquoi choisir LaTeX ?

Quelques bonnes raisons de choisir cet outil :

- **Support de très gros documents structurés.** Les thèses de sciences humaines font souvent plusieurs centaines de pages, mais ça ne posera aucun problème à LaTeX. Et de votre côté, en tant que rédacteur, vous pourrez découper votre document en fichiers de taille humainement gérable, ce qui vous permettra de modifier facilement le plan de votre document aussi souvent que nécessaire.
- **Construction de la bibliographie.**
- **Gestion automatique des références internes.**

## Par où commencer ?

- Thomas Pellard, *Faire une thèse en sciences humaines avec LaTeX*, Cipanglossia, 1 juin 2017, <https://cipanglo.hypotheses.org/343> ; ce cours s’adresse particulièrement aux étudiants en sciences humaines et à ceux qui ont à gérer des documents multilingues contenant des écritures complexes et ou rares.

- Maïeul Rouquette, *(Xe)LaTeX appliqué aux sciences humaines*. Ce livre, devenu
  difficile à trouver, existe toujours sous la forme d'un paquet CTAN :
  <ctanpkg:latex-sciences-humaines>. Il a notamment été commenté, dans la revue
  électronique *Lectures*, par Benjamin Caraco :
  <https://doi.org/10.4000/lectures.9324>, et par Laurent Bloch, [sur son blog](https://www.laurentbloch.net/MySpip3/LaTeX-applique-aux-Sciences-humaines).

- Les cours d'informatique de l'ENSSIB : <http://barthes.enssib.fr/cours/informatique-pour-litteraires/>

## Classes et packages spécialisés

- Plusieurs classes se veulent adaptées aux sciences humaines en général. Mais le domaine est vaste, et nous vous laissons faire votre choix. Cette liste n'est pas exhaustive :
- la [classe
  Bredele](https://www.overleaf.com/latex/templates/bredele/wyhhrmqjbdbv), de
  Christophe Masutti, [développée sur
  Framagit](https://framagit.org/Framatophe/Bredele) ;
- le [fichier de style de l'INALCO](https://cipanglo.hypotheses.org/340), de
  Thomas Pellard, [disponible sur
  Bitbucket](https://bitbucket.org/tpellard/theseinalco/src/master/) ;
- et la classe <ctanpkg:yathesis>, dédiée aux thèses préparées en France, quel
  que soit leur domaine.

Pour des usages plus précis :

- la classe <ctanpkg:reledmac>, de Maïeul Rouquette, est dédiée aux éditions
  dotées d'un appareil critique ; déclinée de celle-ci, <ctanpkg:reledpar> est
  dédiée aux textes bilingues commentés.
- la classe <ctanpkg:technica>, dédiée aux humanités.

Styles de bibliographie :

- un style dédié aux humanités et textes juridiques : <ctanpkg:jurabib>
- le style bibliographique de l'École des chartes : <ctanpkg:biblatex-enc>

... et plus généralement, [la page du CTAN dédiée aux humanités](https://www.ctan.org/topic/humanities).

:::{sources}
- le [blog de Maieul Rouquette](http://geekographie.maieul.net/),
- le [blog de Thomas Pellard](https://cipanglo.hypotheses.org/tag/latex),
- [LaTeX ninja'ing in the digital humanities](https://latex-ninja.com/), le blog de Sarah Lang portant notamment sur l'enseignement de LaTeX. En anglais mais l'auteur peut répondre aux questions en français.
:::
