/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2013 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef HIERARCHVARS_SEEN
#define HIERARCHVARS_SEEN

#include "pdbMalloc.h"


void
InvGammaEMFixedC(CdsArray *cdsA, const double c, int iterate);

void
InvgaussFitVars(CdsArray *cdsA, double *mean, double *lambda);

void
InvgaussAdjustVars(CdsArray *cdsA,
                   const double mean, const double lambda);

void
LognormalFitVars(CdsArray *cdsA, double *zeta, double *sigma);

void
LognormalAdjustVars(CdsArray *cdsA, double zeta, double sigma);

void
InvGammaFitVars(CdsArray *cdsA, int iterate);

void
ConjBayesAdjustVar(double *newvar, const double *var, const int vlen, const int cnum, const double phi);

void
WishartAdjustVar(double *newvar, const double *var, const int vlen, const int cnum, const double phi);

void
WishartAdjustVar2(double *newvar, const double *var, const int vlen, const int cnum, const double phi);

void
WishartFitVar(CdsArray *cdsA, int iterate);

void
WishartFitVar2(CdsArray *cdsA, int iterate);

void
InvGammaFitEvals(CdsArray *cdsA, int iterate);

void
InvGammaFitEvalsNoN(CdsArray *cdsA, int iterate);

void
InvGammaFitModeEvals(CdsArray *cdsA, int iterate);

void
InvGammaBayesFitEvals(CdsArray *cdsA, int iterate);

void
InvGammaFitEvalsBfact(CdsArray *cdsA, int iterate);

void
InvGammaFitEvals3(CdsArray *cdsA, int iterate);

void
InvGammaBayesFitEvals3(CdsArray *cdsA, int iterate);

void
InvGammaFitEvalsEq(CdsArray *cdsA, int iterate);

void
InvGammaFitEvals2(CdsArray *cdsA, int iterate);

void
InvGamma1FitEvals(CdsArray *cdsA, int iterate);

void
InvGammaFitVarsND(CdsArray *cdsA, int iterate);

void
InvGammaFitVars_minc(CdsArray *cdsA, const double minc, int iterate);

void
InvGammaFitVars_fixed_c(CdsArray *cdsA, const double c, int iterate);

void
InvGammaMLFixedCFitEvals(CdsArray *cdsA, const double c, int iterate);

void
InvGammaEMFixedCFitEvals(CdsArray *cdsA, const double c, int iterate);

void
InvGammaMLFitEvals(CdsArray *cdsA, int iterate);

void
InvGammaBayesFitVars_fixed_c(CdsArray *cdsA, const double c, int iterate);

void
InvGammaFitVars_GaussVarVar(CdsArray *cdsA, double *b, double *c);

void
InvGammaFitVars_Mode(CdsArray *cdsA, double *b, double *c, const double mode);

void
InvGammaStacyFitVars(CdsArray *cdsA, double *b, double *c);

void
InvGammaMMFitVars(CdsArray *cdsA, double *b, double *c);

void
InvGammaAdjustVars(CdsArray *cdsA, const double b, const double c);

void
InvGammaAdjustCov(CdsArray *cdsA, const double b, const double c);

void
InvGammaAdjustCovMode(CdsArray *cdsA, const double b, const double c);

void
InvGammaAdjustCovND(CdsArray *cdsA, const double b, const double c);

void
RecipInvGaussFitVars(CdsArray *cdsA, double *mu, double *lambda);

void
RecipInvGaussAdjustVars(CdsArray *cdsA,
                            const double mu, const double lambda);

#endif
