/* @HEADER@ */
// ************************************************************************
// 
//                 Playa: Programmable Linear Algebra
//                 Copyright 2012 Sandia Corporation
// 
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact Kevin Long (kevin.long@ttu.edu)
// 

/* @HEADER@ */

#ifndef PLAYA_DEFAULT_BLOCK_VECTOR_DECL_HPP
#define PLAYA_DEFAULT_BLOCK_VECTOR_DECL_HPP

#include "PlayaBlockVectorBaseDecl.hpp"
#include "PlayaVectorDecl.hpp"
#include "Teuchos_Array.hpp"


namespace Playa
{
using Teuchos::Array;

/** 
 * Base class for blocked vectors 
 */
template <class Scalar>
class DefaultBlockVector : public BlockVectorBase<Scalar>
{
public:
  /** */
  DefaultBlockVector(const VectorSpace<Scalar>& space);

  /** */
  DefaultBlockVector(const VectorSpace<Scalar>& space, 
    const Array<Vector<Scalar> >& blocks);

  /** */
  virtual ~DefaultBlockVector(){}

  /** \name VectorBase interface */
  //@{
  /** Access to the space in which this vector lives */
  RCP<const VectorSpaceBase<double> > space() const {return space_.ptr();}
  //@}

  /** */
  virtual void setBlock(int b, const Vector<Scalar>& block) ;

  /** */
  virtual const Vector<Scalar>& getBlock(int b) const ;

  /** */
  virtual Vector<Scalar> getNonConstBlock(int b) ;

  /** */
  virtual int numBlocks() const {return blocks_.size();}
  
private:
  VectorSpace<Scalar> space_;
  Teuchos::Array<Vector<Scalar> > blocks_;
  
};

/** \relates Vector */
template <class Scalar> 
Vector<Scalar> blockVector(
  const Vector<Scalar>& v1);

/** \relates Vector */
template <class Scalar> 
Vector<Scalar> blockVector(
  const Vector<Scalar>& v1,
  const Vector<Scalar>& v2);

/** \relates Vector */
template <class Scalar> 
Vector<Scalar> blockVector(
  const Vector<Scalar>& v1,
  const Vector<Scalar>& v2,
  const Vector<Scalar>& v3);

/** \relates Vector */
template <class Scalar> 
Vector<Scalar> blockVector(
  const Vector<Scalar>& v1,
  const Vector<Scalar>& v2,
  const Vector<Scalar>& v3,
  const Vector<Scalar>& v4);

/** \relates Vector */
template <class Scalar> 
Vector<Scalar> blockVector(const Array<Vector<Scalar> >& x);


}

#endif
