/*
    Tucnak - VHF contest log
    Copyright (C) 2016 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#include "bfu.h"
#include "inputln.h"
#include "main.h"
#include "menu.h"
#include "rain.h"
#include "rc.h"
#include "tsdl.h"

int rain_enable, rain_meteox, rain_wetteronline, rain_chmi, rain_debug;

void refresh_rain_opts(void *arg){
    STORE_INT(cfg, rain_enable);
    STORE_INT(cfg, rain_meteox);
    STORE_INT(cfg, rain_wetteronline);
    STORE_INT(cfg, rain_chmi);
    STORE_INT(cfg, rain_debug);

	free_rain(grain);
	grain = init_rain();
	progress(NULL);
}

void menu_rain_opts(void *itdata, void *menudata){
    struct dialog *d;
    int i;

    LOAD_INT(cfg, rain_enable);
    LOAD_INT(cfg, rain_meteox);
    LOAD_INT(cfg, rain_wetteronline);
    LOAD_INT(cfg, rain_chmi);
    LOAD_INT(cfg, rain_debug);

    d = (struct dialog *)g_malloc(sizeof(struct dialog) + 20 * sizeof(struct dialog_item));
    memset(d, 0, sizeof(struct dialog) + 20 * sizeof(struct dialog_item));
    d->title = VTEXT(T_RAIN_OPTIONS); 
    d->fn = dlg_pf_fn;
    d->refresh = (void (*)(void *))refresh_rain_opts;
    d->y0 = 1;

    d->items[i = 0].type = D_CHECKBOX;      
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&rain_enable;
    d->items[i].msg = CTEXT(T_ENABLE);
    d->items[i].wrap = 2;
    
    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&rain_meteox;
    d->items[i].msg = "Meteox";
    d->items[i].wrap = 1;

    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&rain_wetteronline;
    d->items[i].msg = "Wetteronline";
    d->items[i].wrap = 1;

    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&rain_chmi;
    d->items[i].msg = "CHMI";
    d->items[i].wrap = 2;

	d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&rain_debug;
    d->items[i].msg = "Debug images";
    d->items[i].wrap = 1;

    
//    -----------------------------
    d->items[i].wrap++;
    d->items[++i].type = D_BUTTON; 
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    d->items[i].align = AL_BUTTONS;
    d->items[i].wrap = 1;

    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));

}


