/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef AUTOSTARTINTERFACE_H
#define AUTOSTARTINTERFACE_H

#include <QObject>
#include <QDBusArgument>
#include <QVariant>
#include <QDBusMetaType>
#include <QGSettings>

enum Pos
{
    LOCALPOS,
    SYSTEMPOS
};

struct AutoApp
{
    QString bname;
    QString icon;
    QString name;
    bool hidden;
    int position;
};
const QDBusArgument &operator<<(QDBusArgument &argument, const AutoApp &app);
const QDBusArgument &operator>>(const QDBusArgument &argument, AutoApp &app);
Q_DECLARE_METATYPE(AutoApp)

class AutoStartInterface : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.ukcc.session.Autoboot")
    Q_PROPERTY(QMap <QString , QVariant> statusMap READ getStatusMap)
    Q_PROPERTY(QStringList appList READ getAppList)
public:
    explicit AutoStartInterface(QObject *parent = nullptr);
    AutoApp getAppInfo(const QString &filepath);

protected:
    QStringList getAppList();
    QMap <QString, QVariant> getStatusMap();

private:
    QMap <QString , AutoApp> getLocalAppMap();
    QMap <QString , AutoApp> getServiceMap();
    QMap <QString , AutoApp> getAllAppMap();

public Q_SLOTS:
    bool deleteLocalFile(const QString &filename);
    bool copyFiletoLocal(const QString &filename);
    bool setAppHiddenInfo(const QString &filename, bool hidden);
    bool addAutobootApp(const QString &filename);
    void saveAppStatus(const QString &filename, bool status);
    void setApplist(const QStringList &list);
    bool getDisplayStatus(const QString &filename);

Q_SIGNALS:
    void changed(const QString &key);

private:
    QStringList whiteList;
    QMap <QString , AutoApp> mSysServiceMap;
    QMap <QString , AutoApp> mAllAppMap;

    QGSettings *mUkccGsettings = nullptr;
    QGSettings *mStyleGsettings = nullptr;

};

#endif // AUTOSTARTINTERFACE_H
