/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       LinuxEventLog.h
//
//  Notes:      Definistion of Class LinuxEventLog used to set an Event to the log
//				In Linux
//----------------------------------------------------------------------------

#ifndef _LINUX_EVENT_LOG_H
#define _LINUX_EVENT_LOG_H

#include <syslog.h>
#include "LinuxRegistryInfo.h"
#include "BaseEventLog.h"

//Event types
#define EVENTLOG_SUCCESS 		LOG_INFO
#define EVENTLOG_ERROR_TYPE 		LOG_ERR
#define EVENTLOG_WARNING_TYPE 		LOG_WARNING
#define EVENTLOG_INFORMATION_TYPE 	LOG_INFO

class LinuxEventLog : public BaseEventLog{
private:
	unsigned int msgId;
public:
	//*********************************************
	//LinuxEventLog:
	//Ctor to LinuxEventLog object
	//params:
	//@eventLogSourceName - source name of event log
	//*********************************************
	LinuxEventLog(const char * eventLogSourceName);

	//*********************************************
	//~LinuxEventLog:
	//Dtor to LinuxEventLog object
	//*********************************************
	~LinuxEventLog();

	//*********************************************
	//LogEvent:
	//Record Events for debugging.
	//params:
	//@categoryID - category ID
	//@eventID    - event ID
	//*********************************************
	void LogEvent(unsigned short CategoryID, unsigned long EventID, unsigned long	EventType);

	//*********************************************
	//LogEvent:
	//Record Events for debugging.
	//params:
	//@categoryID - category ID
	//@eventID    - event ID
	//@EventType
	//@ArrayOfStrings
	//@NumOfArrayStr
	//@RawData
	//@RawDataSize
	//*********************************************
	void LogEvent(unsigned short CategoryID,unsigned long	EventID
		          , unsigned long	EventType,const char * ArrayOfStrings[],
				  unsigned int NumOfArrayStr, void * RawData=NULL, unsigned long RawDataSize=0);

};

#endif //_LINUX_EVENT_LOG_H
