/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 2.0
 * Revision 0.0
 * Januray 2002
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdkxdb2/vdkxdb.h>
#include <vdkxdb2/vdkxctrl.h>


VDKXControl::VDKXControl(): 
  table((VDKXTable*) NULL), 
  field_id(-1),
  field_type('U')
{
}
/*
 */
bool 
VDKXControl::AssignTableField(VDKXTable* t,
			      char* fname)
{
  if(t)
    {
      table = t;
      field_name = fname;
      field_id = table->GetFieldNo(fname);
      field_type = table->GetFieldType(field_id);
      return true;
    }
  else
    return false;
}

bool 
VDKXControl::AssignTableField(VDKXDatabase* xdb,
			      char* tablename,
			      char* fieldname)
{
  VDKXTable* t = (*xdb)[tablename];
  if(t)
    return AssignTableField(t, fieldname);
  else
    return false;
}





