/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.geodesic;

import java.util.Hashtable;
import javax.vecmath.Vector3f;

public class Geodesic {
    private static final float halfRoot5 = (float)(0.5 * Math.sqrt(5.0));
    private static final float oneFifth = 1.2566371f;
    private static final float oneTenth = 0.62831855f;
    private static final short[] faceVertexesIcosahedron = new short[]{0, 1, 2, 0, 2, 3, 0, 3, 4, 0, 4, 5, 0, 5, 1, 1, 6, 2, 2, 7, 3, 3, 8, 4, 4, 9, 5, 5, 10, 1, 6, 1, 10, 7, 2, 6, 8, 3, 7, 9, 4, 8, 10, 5, 9, 11, 6, 10, 11, 7, 6, 11, 8, 7, 11, 9, 8, 11, 10, 9};
    private static final short[] neighborVertexesIcosahedron = new short[]{1, 2, 3, 4, 5, -1, 0, 5, 10, 6, 2, -1, 0, 1, 6, 7, 3, -1, 0, 2, 7, 8, 4, -1, 0, 3, 8, 9, 5, -1, 0, 4, 9, 10, 1, -1, 1, 10, 11, 7, 2, -1, 2, 6, 11, 8, 3, -1, 3, 7, 11, 9, 4, -1, 4, 8, 11, 10, 5, -1, 5, 9, 11, 6, 1, -1, 6, 7, 8, 9, 10, -1};
    public static final int standardLevel = 3;
    private static final int maxLevel = 4;
    private static short[] vertexCounts;
    private static Vector3f[] vertexVectors;
    private static short[][] faceVertexesArrays;
    private static short[][] neighborVertexesArrays;
    private static short vertexNext;
    private static Hashtable htVertex;
    private static final boolean VALIDATE = true;

    public static short[][] getFaceVertexesArrays() {
        return faceVertexesArrays;
    }

    public static short[][] getNeighborVertexesArrays() {
        return neighborVertexesArrays;
    }

    public static int getVertexCount(int n) {
        if (vertexCounts == null) {
            Geodesic.createGeodesic();
        }
        return vertexCounts[n];
    }

    public static Vector3f[] getVertexVectors() {
        return vertexVectors;
    }

    public static int getVertexVectorsCount() {
        return vertexVectors == null ? 0 : vertexVectors.length;
    }

    public static Vector3f getVertexVector(int n) {
        return vertexVectors[n];
    }

    public static short[] getFaceVertexes(int n) {
        return faceVertexesArrays[n];
    }

    private static synchronized void createGeodesic() {
        int n;
        if (vertexCounts != null) {
            return;
        }
        short[] sArray = new short[4];
        neighborVertexesArrays = new short[4][];
        faceVertexesArrays = new short[4][];
        vertexVectors = new Vector3f[12];
        Geodesic.vertexVectors[0] = new Vector3f(0.0f, 0.0f, halfRoot5);
        for (n = 0; n < 5; ++n) {
            Geodesic.vertexVectors[n + 1] = new Vector3f((float)Math.cos((float)n * 1.2566371f), (float)Math.sin((float)n * 1.2566371f), 0.5f);
            Geodesic.vertexVectors[n + 6] = new Vector3f((float)Math.cos((float)n * 1.2566371f + 0.62831855f), (float)Math.sin((float)n * 1.2566371f + 0.62831855f), -0.5f);
        }
        Geodesic.vertexVectors[11] = new Vector3f(0.0f, 0.0f, -halfRoot5);
        n = 12;
        while (--n >= 0) {
            vertexVectors[n].normalize();
        }
        Geodesic.faceVertexesArrays[0] = faceVertexesIcosahedron;
        Geodesic.neighborVertexesArrays[0] = neighborVertexesIcosahedron;
        sArray[0] = 12;
        for (n = 0; n < 3; ++n) {
            Geodesic.quadruple(n, sArray);
        }
        vertexCounts = sArray;
    }

    private static void quadruple(int n, short[] sArray) {
        short s;
        short s2;
        short s3;
        short s4;
        htVertex = new Hashtable();
        int n2 = vertexVectors.length;
        short[] sArray2 = faceVertexesArrays[n];
        int n3 = sArray2.length;
        int n4 = n3 / 3;
        int n5 = n2 + n4 - 2;
        int n6 = n2 + n5;
        int n7 = 4 * n4;
        Vector3f[] vector3fArray = new Vector3f[n6];
        System.arraycopy(vertexVectors, 0, vector3fArray, 0, n2);
        vertexVectors = vector3fArray;
        short[] sArray3 = new short[3 * n7];
        Geodesic.faceVertexesArrays[n + 1] = sArray3;
        short[] sArray4 = new short[6 * n6];
        Geodesic.neighborVertexesArrays[n + 1] = sArray4;
        int n8 = sArray4.length;
        while (--n8 >= 0) {
            sArray4[n8] = -1;
        }
        sArray[n + 1] = (short)n6;
        vertexNext = (short)n2;
        n8 = 0;
        int n9 = 0;
        while (n9 < n3) {
            s4 = sArray2[n9++];
            s3 = sArray2[n9++];
            s2 = sArray2[n9++];
            s = Geodesic.getVertex(s4, s3);
            short s5 = Geodesic.getVertex(s3, s2);
            short s6 = Geodesic.getVertex(s2, s4);
            sArray3[n8++] = s4;
            sArray3[n8++] = s;
            sArray3[n8++] = s6;
            sArray3[n8++] = s3;
            sArray3[n8++] = s5;
            sArray3[n8++] = s;
            sArray3[n8++] = s2;
            sArray3[n8++] = s6;
            sArray3[n8++] = s5;
            sArray3[n8++] = s6;
            sArray3[n8++] = s;
            sArray3[n8++] = s5;
            Geodesic.addNeighboringVertexes(sArray4, s, s4);
            Geodesic.addNeighboringVertexes(sArray4, s, s6);
            Geodesic.addNeighboringVertexes(sArray4, s, s5);
            Geodesic.addNeighboringVertexes(sArray4, s, s3);
            Geodesic.addNeighboringVertexes(sArray4, s5, s3);
            Geodesic.addNeighboringVertexes(sArray4, s5, s6);
            Geodesic.addNeighboringVertexes(sArray4, s5, s2);
            Geodesic.addNeighboringVertexes(sArray4, s6, s2);
            Geodesic.addNeighboringVertexes(sArray4, s6, s4);
        }
        n9 = vertexVectors.length;
        if (n8 != sArray3.length) {
            throw new NullPointerException();
        }
        if (vertexNext != n6) {
            throw new NullPointerException();
        }
        for (s4 = 0; s4 < 12; ++s4) {
            for (s3 = 0; s3 < 5; ++s3) {
                s2 = sArray4[s4 * 6 + s3];
                if (s2 < 0) {
                    throw new NullPointerException();
                }
                if (s2 >= n9) {
                    throw new NullPointerException();
                }
                if (sArray4[s4 * 6 + 5] == -1) continue;
                throw new NullPointerException();
            }
        }
        for (s4 = 72; s4 < sArray4.length; ++s4) {
            s3 = sArray4[s4];
            if (s3 < 0) {
                throw new NullPointerException();
            }
            if (s3 < n9) continue;
            throw new NullPointerException();
        }
        for (s4 = 0; s4 < n6; ++s4) {
            s3 = 0;
            s2 = sArray4.length;
            while (--s2 >= 0) {
                if (sArray4[s2] != s4) continue;
                ++s3;
            }
            if (s4 < 12 && s3 != 5 || s4 >= 12 && s3 != 6) {
                throw new NullPointerException();
            }
            s2 = 0;
            s = sArray3.length;
            while (--s >= 0) {
                if (sArray3[s] != s4) continue;
                ++s2;
            }
            if ((s4 >= 12 || s2 == 5) && (s4 < 12 || s2 == 6)) continue;
            throw new NullPointerException();
        }
        htVertex = null;
    }

    private static void addNeighboringVertexes(short[] sArray, short s, short s2) {
        int n;
        int n2 = n + 6;
        for (n = s * 6; n < n2; ++n) {
            int n3;
            if (sArray[n] == s2) {
                return;
            }
            if (sArray[n] >= 0) continue;
            sArray[n] = s2;
            int n4 = n3 + 6;
            for (n3 = s2 * 6; n3 < n4; ++n3) {
                if (sArray[n3] == s) {
                    return;
                }
                if (sArray[n3] >= 0) continue;
                sArray[n3] = s;
                return;
            }
        }
        throw new NullPointerException();
    }

    private static short getVertex(short s, short s2) {
        Vector3f vector3f;
        Integer n;
        Short s3;
        if (s > s2) {
            short s4 = s;
            s = s2;
            s2 = s4;
        }
        if ((s3 = (Short)htVertex.get(n = new Integer((s << 16) + s2))) != null) {
            return s3;
        }
        Geodesic.vertexVectors[Geodesic.vertexNext] = vector3f = new Vector3f(vertexVectors[s]);
        vector3f.add(vertexVectors[s2]);
        vector3f.scale(0.5f);
        vector3f.normalize();
        htVertex.put(n, new Short(vertexNext));
        short s5 = vertexNext;
        vertexNext = (short)(s5 + 1);
        return s5;
    }
}

