/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.MainPanel;
import WIMSchem.Molecule;
import WIMSchem.SaveListener;
import WIMSchem.ds.DataTableModel;
import WIMSchem.ds.TableMoleculeEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class EditWindow
extends JFrame
implements SaveListener,
WindowListener,
CellEditorListener {
    private MainPanel mainPanel;
    private DataTableModel model;
    private TableMoleculeEditor edcell;
    private boolean hardkill = false;

    public EditWindow(Molecule mol, DataTableModel model, TableMoleculeEditor edcell) {
        super("WIMSchem - Cell Edit");
        this.model = model;
        this.edcell = edcell;
        this.setFocusableWindowState(true);
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.setDefaultCloseOperation(0);
        this.mainPanel = new MainPanel(null, 3, this);
        this.mainPanel.setMolecule(mol);
        this.mainPanel.setSaveListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
        this.setIconImage(this.mainPanel.mainIcon.getImage());
        this.addWindowListener(this);
    }

    public void saveMolecule(Molecule mol) {
        this.edcell.setMolecule(this.mainPanel.molData().clone());
    }

    public void editingCanceled(ChangeEvent e) {
        this.hardkill = true;
        this.dispose();
    }

    public void editingStopped(ChangeEvent e) {
        this.hardkill = true;
        this.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (!this.hardkill) {
            this.edcell.stopCellEditing();
        }
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

