/*
 
 *****************************************************************************
 * Author:                                                                   *
 * ------                                                                    *
 *  Anton Kokalj                                  Email: Tone.Kokalj@ijs.si  *
 *  Department of Physical and Organic Chemistry  Phone: x 386 1 477 3523    *
 *  Jozef Stefan Institute                          Fax: x 386 1 477 3811    *
 *  Jamova 39, SI-1000 Ljubljana                                             *
 *  SLOVENIA                                                                 *
 *                                                                           *
 * Source: $XCRYSDEN_TOPDIR/C/atoms.h
 * ------                                                                    *
 * Copyright (c) 1996-2003 by Anton Kokalj                                   *
 *****************************************************************************

*/

#include <GL/gl.h>


char *element[] = {
  "X",
  "H",  "He", "Li", "Be", "B",  "C",  "N",  "O", 
  "F",  "Ne", "Na", "Mg", "Al", "Si", "P",  "S", 
  "Cl", "Ar", "K",  "Ca", "Sc", "Ti", "V",  "Cr", 
  "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", 
  "As", "Se", "Br", "Kr", "Rb", "Sr", "Y",  "Zr", 
  "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", 
  "In", "Sn", "Sb", "Te", "I",  "Xe", "Cs", "Ba", 
  "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", 
  "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", 
  "Ta", "W",  "Re", "Os", "Ir", "Pt", "Au", "Hg", 
  "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", 
  "Ac", "Th", "Pa", "U",  "Np", "Pu", "Am", "Cm", 
  "Bk", "Cf", "Es", "Fm"};


double rcovdef[MAXNAT + 1] = { 
  0.38000, 
  0.38000,0.38000,1.23000,0.89000,0.91000,
  0.77000,0.75000,0.73000,0.71000,0.71000,
  1.60000,1.40000,1.25000,1.11000,1.00000,
  1.04000,0.99000,0.98000,2.13000,1.74000,
  1.60000,1.40000,1.35000,1.40000,1.40000,
  1.40000,1.35000,1.35000,1.35000,1.35000,
  1.30000,1.25000,1.15000,1.15000,1.14000,
  1.12000,2.20000,2.00000,1.85000,1.55000,
  1.45000,1.45000,1.35000,1.30000,1.35000,
  1.40000,1.60000,1.55000,1.55000,1.41000,
  1.45000,1.40000,1.40000,1.31000,2.60000,
  2.00000,1.75000,1.55000,1.55000,1.55000,
  1.55000,1.55000,1.55000,1.55000,1.55000,
  1.55000,1.55000,1.55000,1.55000,1.55000,
  1.55000,1.55000,1.45000,1.35000,1.35000,
  1.30000,1.35000,1.35000,1.35000,1.50000,
  1.90000,1.80000,1.60000,1.55000,1.55000,
  1.55000,2.80000,1.44000,1.95000,1.55000,
  1.55000,1.55000,1.55000,1.55000,1.55000,
  1.55000,1.55000,1.55000,1.55000,1.55000};

double rvdw[MAXNAT + 1] = { 
  0.38000, 	
  1.17000,1.40000,1.80000,2.10000,2.10000,
  1.70000,1.58000,1.52000,1.47000,1.60000,
  2.30000,1.70000,2.10000,1.70000,1.80000,
  1.80000,1.78000,1.90000,2.80000,2.10000,
  2.10000,2.10000,2.10000,2.10000,2.10000,
  2.10000,2.10000,1.60000,1.40000,1.40000,
  1.90000,2.10000,1.85000,1.90000,1.85000,
  2.00000,2.10000,2.10000,2.10000,2.10000,
  2.10000,2.10000,2.10000,2.10000,2.10000,
  1.60000,1.70000,1.60000,1.90000,1.00000,
  2.10000,2.06000,1.96000,2.16000,2.10000,
  2.10000,2.10000,2.10000,2.10000,2.10000,
  2.10000,2.10000,2.10000,2.10000,2.10000,
  2.10000,2.10000,2.10000,2.10000,2.10000,
  2.10000,2.10000,2.10000,2.10000,2.10000,
  2.10000,2.10000,1.75000,1.70000,1.50000,
  2.00000,2.10000,2.10000,2.10000,2.10000,
  2.10000,3.50000,3.50000,3.50000,2.10000,
  2.10000,2.10000,2.10000,2.10000,2.10000,
  2.10000,2.10000,2.10000,2.10000,2.10000};

GLfloat DefAtCol[MAXNAT + 1][3] = {
  {0.7700, 1.0000, 0.4200},  /* this is color of selected atom */
  {0.0000, 0.9500, 0.9500},
  {0.9500, 0.9500, 0.9500},
  {0.9500, 0.9500, 0.9500},
  {0.7079, 0.7079, 0.7079},
  {0.7079, 0.7079, 0.7079},
  {0.9500, 0.9500, 0.0000},
  {0.6445, 0.8047, 0.8569},
  {0.7000, 0.0000, 0.0000}, /* changed */
  {0.8345, 0.9500, 0.9500},
  {0.9500, 0.9500, 0.9500},
  {0.0000, 0.9500, 0.9500},
  {0.0000, 0.9500, 0.9500},
  {0.9500, 0.0000, 0.9500},
  {0.0000, 0.9500, 0.9500},
  {0.9500, 0.9500, 0.0000},
  {0.9500, 0.9500, 0.4500},
  {0.7100, 1.0000, 0.0000},
  {0.9500, 0.9500, 0.9500},
  {0.0000, 0.9500, 0.9500},
  {0.0000, 0.9500, 0.9500},
  {0.0000, 0.9500, 0.9500},
  {0.6000, 0.6000, 0.6000},
  {0.6445, 0.8047, 0.8569},
  {0.6445, 0.8047, 0.8569},
  {0.6445, 0.8047, 0.8569},
  {0.9500, 0.0000, 0.0000},
  {0.6445, 0.8047, 0.8569},
  {0.6445, 0.8047, 0.8569},
  {0.8200, 0.4500, 0.1400},
  {0.9500, 0.0000, 0.9500},
  {0.9500, 0.0000, 0.9500},
  {0.9500, 0.0000, 0.9500},
  {0.9500, 0.9500, 0.0000},
  {0.9500, 0.9500, 0.0000},
  {0.9500, 0.0000, 0.0000},
  {0.7500, 0.7500, 0.7500},
  {0.0000, 0.9500, 0.9500},
  {0.0000, 0.9500, 0.9500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {1.0000, 1.0000, 1.0000}, /* changed */
  /*  {0.7500, 0.7500, 0.7500},  silver */
  {1.0000, 1.0000, 1.0000}, /* silver-white */
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.0000, 0.9500, 0.9500},
  {0.0000, 0.9500, 0.9500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {1.0000, 0.8500, 0.0000},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.7500, 0.7500, 0.7500},
  {0.9314, 0.8755, 0.8010},
  {0.9314, 0.8755, 0.8010}
};

GLclampf DefFrameCol[3]   = { 0.88, 1.00, 0.67 };
GLclampf DefBg[4]         = { 0.00, 0.00, 0.00, 1.00 };
GLclampf DefUnibondCol[4] = { 1.00, 1.00, 1.00, 1.00 };

GLfloat DefAtCol_Ambient_by_Diffuse = 1.0;
