// Boost.Geometry
// Unit Test

// Copyright (c) 2016 Oracle and/or its affiliates.

// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_GEOMETRY_TEST_INTERSECTION_CASES_HPP
#define BOOST_GEOMETRY_TEST_INTERSECTION_CASES_HPP

struct coordinates
{
    double lon;
    double lat;
};

struct expected_result
{
    double lon;
    double lat;
};

struct expected_results
{
    coordinates p1;
    coordinates p2;
    coordinates q1;
    coordinates q2;
    expected_result gnomonic_vincenty;
    expected_result gnomonic_thomas;
    expected_result sjoberg_vincenty;
    expected_result sjoberg_thomas;
    expected_result sjoberg_andoyer;
    expected_result great_elliptic;
};

#define ND 1000

expected_results expected[] =
{
    {
        { -1, -1 },{ 1, 1 },
        { -1, 1 },{ 1, -1 },
        { 0.0000000000000000, 0.0000000000000000 },
        { 0.0000000000000000, 0.0000000000000000 },
        { 0.0000000000626537, -0.0000000000000000 },
        { -0.0000000187861002, -0.0000000000000000 },
        { -0.0000055778585615, -0.0000000000000000 },
        { -0.0000000000000000, -0.0000000000000000 }
    },{
        // TODO: Newton method in Sjoberg formula is not used in this case
        //    due to f1 - f2 == 0. The other method is used instead.
        //    Hence different results. Look into this.
        { 1, 1 },{ -1, -1 },
        { -1, 1 },{ 1, -1 },
        { 0.0000000000000000, 0.0000000000000000 },
        { 0.0000000000000000, 0.0000000000000000 },
        { 0.0000000000000000, 0.0000000000626632 },
        { -0.0000000000000006, -0.0000000187889745 },
        { -0.0000000000000001, -0.0000055787431353 },
        { -0.0000000000000000, 0.0000000000000000 }
    },{
        // TODO: Newton method in Sjoberg formula is not used in this case
        //    due to f1 - f2 == 0. The other method is used instead.
        //    Hence different results. Look into this.
        { -1, -1 },{ 1, 1 },
        { 1, -1 },{ -1, 1 },
        { 0.0000000000000000, 0.0000000000000000 },
        { 0.0000000000000000, 0.0000000000000000 },
        { -0.0000000000000000, -0.0000000000626632 },
        { -0.0000000000000004, 0.0000000187889746 },
        { 0.0000000000000001, 0.0000055787431353 },
        { 0.0000000000000000, 0.0000000000000000 }
    },{
        { 1, 1 },{ -1, -1 },
        { 1, -1 },{ -1, 1 },
        { 0.0000000000000000, 0.0000000000000000 },
        { 0.0000000000000000, 0.0000000000000000 },
        { -0.0000000000626537, -0.0000000000000000 },
        { 0.0000000187860994, 0.0000000000000001 },
        { 0.0000055778585615, -0.0000000000000000 },
        { -0.0000000000000000, 0.0000000000000000 }
    },{
        { 0, 0 },{ 1, 1 },
        { 0, 1 },{ 1, 0 },
        { 0.5000000000000000, 0.5000573755188470 },
        { 0.5000000000000000, 0.5000573755109839 },
        { 0.5000000000313266, 0.5000573755188389 },
        { 0.4999999906069524, 0.5000573755152582 },
        { 0.4999972102164753, 0.5000573755151276 },
        { 0.4999999999999999, 0.5000571197534014 }
    },{
        { 1, 1 },{ 0, 0 },
        { 0, 1 },{ 1, 0 },
        { 0.5000000000000000, 0.5000573755188470 },
        { 0.5000000000000000, 0.5000573755109839 },
        { 0.5000000000000000, 0.5000573755501669 },
        { 0.4999999999999996, 0.5000573661218464 },
        { 0.4999999999999999, 0.5000545856093679 },
        { 0.4999999999999999, 0.5000571197534014 }
    },{
        { 0, 0 },{ 1, 1 },
        { 1, 0 },{ 0, 1 },
        { 0.5000000000000000, 0.5000573755188470 },
        { 0.5000000000000000, 0.5000573755109839 },
        { 0.4999999999999999, 0.5000573754875109 },
        { 0.4999999999999999, 0.5000573849086647 },
        { 0.5000000000000000, 0.5000601654208935 },
        { 0.4999999999999999, 0.5000571197534014 }
    },{
        { 1, 1 },{ 0, 0 },
        { 1, 0 },{ 0, 1 },
        { 0.5000000000000000, 0.5000573755188470 },
        { 0.5000000000000000, 0.5000573755109839 },
        { 0.4999999999686731, 0.5000573755188389 },
        { 0.5000000093930521, 0.5000573755152582 },
        { 0.5000027897835244, 0.5000573755151276 },
        { 0.4999999999999999, 0.5000571197534014 }
    },{
        { 1, 1 }, {2, 2},
        {-2, -1}, {-1, -1},
        { ND, ND },
        { ND, ND },
        { -0.9981650042162076, -0.999999718164758 },
        { ND, ND },
        { ND, ND },
        { -0.9981731758085121, -0.9999997213000095 }
    },{
        {-25, -31}, {3, 44},
        {-66, -14}, {-1, -1},
        { ND, ND },
        { ND, ND },
        { -15.83269406235058, -4.87746450262433 },
        { ND, ND },
        { ND, ND },
        { -15.82846301029918, -4.869650527718342 }
    },{
        {-47, -8}, {-1, -4},
        {-40, -5}, {-5, -5},
        { ND, ND },
        { ND, ND },
        { -10.28209064194141, -5.124101297536392 },
        { ND, ND },
        { ND, ND },
        { -10.29663941896089, -5.123527178300465 }
    }, {
        {-43, -8}, {3, -4},
        {-43, -5}, {3, -7},
        { ND, ND },
        { ND, ND },
        { -19.95519754153282, -6.521540589691206 },
        { ND, ND },
        { ND, ND },
        { -19.95535387979888, -6.517861579906892 }
    }, {
        {-1, -17}, {-5, 3},
        {-40, -5}, {-1, -5},
        { ND, ND },
        { ND, ND },
        { -3.424525475838061, -5.070550173747042 },
        { ND, ND },
        { ND, ND },
        { -3.424493504575876, -5.070060631936228 }
    }, {
        {-29, -4}, {-1, -5},
        {-40, -5}, {-1, -5},
        { ND, ND },
        { ND, ND },
        { -0.9999999978280006, -5.00000000000684 },
        { ND, ND },
        { ND, ND },
        { -0.9999999999999919, -5 }
    }, {
        {-4, -6}, {-40, -5},
        {-40, -5}, {-1, -5},
        { ND, ND },
        { ND, ND },
        { -40.00000000470697, -4.999999999854269 },
        { ND, ND },
        { ND, ND },
        { -40.00000000000003, -4.999999999999998 }
    }, {
        {5, -4}, {-25, -5},
        {-40, -5}, {-1, -5},
        { ND, ND },
        { ND, ND },
        { -40.04870859732954, -4.998490166905039 },
        { ND, ND },
        { ND, ND },
        { -39.87674154148858, -5.003778171392734 }
    }, {
        {-44, -1}, {38, -7},
        {-54, -10}, {27, 3},
        { ND, ND },
        { ND, ND },
        { -12.49994722584679, -4.492062263169279 },
        { ND, ND },
        { ND, ND },
        { -12.49786552878283, -4.48224349980724 }
    }, {
        {-29, -5}, {10, -5},
        {-40, -5}, {-1, -5},
        { ND, ND },
        { ND, ND },
        { -14.99999999880286, -5.280237387890117 },
        { ND, ND },
        { ND, ND },
        { -14.99999999999999, -5.278284829442087 }
    }, {
        {-29, -5}, {7, -5},
        {-40, -5}, {-1, -5},
        { ND, ND },
        { ND, ND },
        { -12.68814198534678, -5.255404335144863 },
        { ND, ND },
        { ND, ND },
        { -12.68883814704657, -5.253634733357015 }
    }, {
        {-29, -5}, {2, -5},
        {-40, -5}, {-1, -5},
        { ND, ND },
        { ND, ND },
        { -6.793546728871506, -5.153444544719724 },
        { ND, ND },
        { ND, ND },
        { -6.794933162619669, -5.152409434095275 }
    }, {
        {-29, -5}, {2, -5},
        {-30, -5}, {-1, -5},
        { ND, ND },
        { ND, ND },
        { -22.13104411461423, -5.130155316882458 },
        { ND, ND },
        { ND, ND },
        { -22.13016591567375, -5.129277412801533 }
    }, {
        {-29, -5}, {2, -5},
        {-32, -5}, {-1, -5},
        { ND, ND },
        { ND, ND },
        { -14.99999999908104, -5.187213913248173 },
        { ND, ND },
        { ND, ND },
        { -15.00000000000009, -5.185931965560752 }
    }, {
        {-92, -24}, {44, 19},
        {-78, -5}, {50, -5},
        { ND, ND },
        { ND, ND },
        { -31.65127861442256, -10.84411293410938 },
        { ND, ND },
        { ND, ND },
        { -31.65294079308247, -10.76785432928444 }
    }, {
        {-93, -15}, {22, 3},
        {-78, -5}, {50, -5},
        { ND, ND },
        { ND, ND },
        { -32.33383382062637, -10.80295061031259 },
        { ND, ND },
        { ND, ND },
        { -32.26069578187354, -10.73176059393484 }
    }, {
        {-93, -15}, {28, 3},
        {-78, -5}, {50, -5},
        { ND, ND },
        { ND, ND },
        { -25.71257598566304, -11.13752154787724 },
        { ND, ND },
        { ND, ND },
        { -25.67761999514295, -11.05881610957402 }
    }, {
        {-54, -21}, {20, 17},
        {-59, -5}, {13, -5},
        { ND, ND },
        { ND, ND },
        { -22.96397490169162, -6.181426780426698 },
        { ND, ND },
        { ND, ND },
        { -22.95999443662035, -6.172089364736989 }
    }, {
        {-31, -10}, {-31, -2},
        {-37, -10}, {-25, -2},
        { ND, ND },
        { ND, ND },
        { -31.00000000000001, -6.062729839503469 },
        { ND, ND },
        { ND, ND },
        { -31, -6.062411484514648 }
    }, {
        {-26, -10}, {-26, 13},
        {-37, -4}, {-18, -4},
        { ND, ND },
        { ND, ND },
        { -25.99999999999969, -4.05441766735837 },
        { ND, ND },
        { ND, ND },
        { -26, -4.05405101510235 }
    }, {
        {-26, -10}, {154, 78},
        {-46, 41}, {-13, 36},
        { ND, ND },
        { ND, ND },
        { -26, 39.19492836828103 },
        { ND, ND },
        { ND, ND },
        { -26, 39.19004133747198 }
    }, {
        {-26, -10}, {154, 68},
        {-85, 79}, {22, 80},
        { ND, ND },
        { ND, ND },
        { -26.00000000000013, 83.7164889918963 },
        { ND, ND },
        { ND, ND },
        { -26.00000000000002, 83.71603758698208 }
    }, {
        {-25, 55}, {155, 68},
        {178, 79}, {124, 80},
        { ND, ND },
        { ND, ND },
        { 155, 80.55982670305147 },
        { ND, ND },
        { ND, ND },
        { 155, 80.55961176607357 }
    }
};

size_t const expected_size = sizeof(expected) / sizeof(expected_results);

#endif // BOOST_GEOMETRY_TEST_INTERSECTION_CASES_HPP
