/* { dg-do run { target { aarch64_sve256_hw && aarch64_sve2p1_hw } } } */
/* { dg-options "-O2 -msve-vector-bits=256" } */

#include "zipq_1.c"

typedef svuint16_t fixed_uint16_t __attribute__((arm_sve_vector_bits(256)));

#define TEST(A, B)							\
  do {									\
    typeof(A) actual_ = (A);						\
    if (__builtin_memcmp (&actual_, &(B), sizeof (actual_)) != 0)	\
      __builtin_abort ();						\
  } while (0)

int
main ()
{
  fixed_int64_t a64 = { 0x1122LL << 31, -1LL << 47, 0x5566 << 15, -2 };
  fixed_int64_t b64 = { 42, -0x3344LL << 19, 303, -0x7788LL << 27 };
  fixed_int64_t expected1 = { 0x1122LL << 31, 42,
			      0x5566 << 15, 303 };
  fixed_int64_t expected2 = { -1LL << 47, -0x3344LL << 19,
			      -2, -0x7788LL << 27 };
  TEST (f1 (a64, b64), expected1);
  TEST (f2 (a64, b64), expected2);

  fixed_float32_t a32 = { 0.5, 0.75, 1, 1.25, 2.5, 2.75, 3, 3.25 };
  fixed_float32_t b32 = { -0.5, -0.75, -1, -1.25, -2.5, -2.75, -3, -3.25 };
  fixed_float32_t expected3 = { 0.5, -0.5, 0.75, -0.75,
				2.5, -2.5, 2.75, -2.75 };
  fixed_float32_t expected4 = { 1, -1, 1.25, -1.25,
				3, -3, 3.25, -3.25 };
  TEST (f3 (a32, b32), expected3);
  TEST (f4 (a32, b32), expected4);

  fixed_uint16_t a16_i = { 0x9a12, 0xbc34, 0xde56, 0xf078,
			   0x00ff, 0x11ee, 0x22dd, 0x33cc,
			   0x44bb, 0x55aa, 0x6699, 0x7788,
			   0xfe01, 0xdc23, 0xba45, 0x9867 };
  fixed_uint16_t b16_i = { 0x1010, 0x2020, 0x3030, 0x4040,
			   0x5050, 0x6060, 0x7070, 0x8080,
			   0x9090, 0xa0a0, 0xb0b0, 0xc0c0,
			   0xd0d0, 0xe0e0, 0xf0f0, 0x0f0f };
  fixed_uint16_t expected5 = { 0x9a12, 0x1010, 0xbc34, 0x2020,
			       0xde56, 0x3030, 0xf078, 0x4040,
			       0x44bb, 0x9090, 0x55aa, 0xa0a0,
			       0x6699, 0xb0b0, 0x7788, 0xc0c0 };
  fixed_uint16_t expected6 = { 0x00ff, 0x5050, 0x11ee, 0x6060,
			       0x22dd, 0x7070, 0x33cc, 0x8080,
			       0xfe01, 0xd0d0, 0xdc23, 0xe0e0,
			       0xba45, 0xf0f0, 0x9867, 0x0f0f };
  fixed_bfloat16_t a16, b16;
  __builtin_memcpy (&a16, &a16_i, sizeof (a16));
  __builtin_memcpy (&b16, &b16_i, sizeof (b16));
  TEST (f5 (a16, b16), expected5);
  TEST (f6 (a16, b16), expected6);

  fixed_uint8_t a8 = { 0x01, 0x12, 0x23, 0x34, 0x45, 0x56, 0x67, 0x70,
		       0x89, 0x9a, 0xab, 0xbc, 0xcd, 0xde, 0xef, 0xf8,
		       0xfe, 0xed, 0xdc, 0xcb, 0xba, 0xa9, 0x98, 0x8f,
		       0x76, 0x65, 0x54, 0x43, 0x32, 0x21, 0x10, 0x07 };
  fixed_uint8_t b8 = { 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88,
		       0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x00,
		       0x13, 0x24, 0x35, 0x46, 0x57, 0x68, 0x79, 0x8a,
		       0x9b, 0xac, 0xbd, 0xce, 0xdf, 0xe0, 0xf1, 0x02 };
  fixed_uint8_t expected7 = { 0x01, 0x11, 0x12, 0x22, 0x23, 0x33, 0x34, 0x44,
			      0x45, 0x55, 0x56, 0x66, 0x67, 0x77, 0x70, 0x88,
			      0xfe, 0x13, 0xed, 0x24, 0xdc, 0x35, 0xcb, 0x46,
			      0xba, 0x57, 0xa9, 0x68, 0x98, 0x79, 0x8f, 0x8a };
  fixed_uint8_t expected8 = { 0x89, 0x99, 0x9a, 0xaa, 0xab, 0xbb, 0xbc, 0xcc,
			      0xcd, 0xdd, 0xde, 0xee, 0xef, 0xff, 0xf8, 0x00,
			      0x76, 0x9b, 0x65, 0xac, 0x54, 0xbd, 0x43, 0xce,
			      0x32, 0xdf, 0x21, 0xe0, 0x10, 0xf1, 0x07, 0x02 };
  TEST (f7 (a8, b8), expected7);
  TEST (f8 (a8, b8), expected8);

  return 0;
}
