; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-unknown-unknown < %s | FileCheck %s
; rdar://7610418

%ptr = type { i8* }
%struct.s1 = type { %ptr, %ptr }
%struct.s2 = type { i32, i8*, i8*, [256 x %struct.s1*], [8 x i32], i64, i8*, i32, i64, i64, i32, %struct.s3*, %struct.s3*, [49 x i64] }
%struct.s3 = type { %struct.s3*, %struct.s3*, i32, i32, i32 }

define fastcc i8* @t(i32 %base) nounwind {
; CHECK-LABEL: t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    shlq $9, %rax
; CHECK-NEXT:    leaq (%rax,%rax,4), %rdi
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    testb %al, %al
; CHECK-NEXT:    jne .LBB0_2
; CHECK-NEXT:  # %bb.1: # %bb1
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB0_2: # %bb2
; CHECK-NEXT:    callq foo
entry:
  %0 = zext i32 %base to i64
  %1 = getelementptr inbounds %struct.s2, %struct.s2* null, i64 %0
  br i1 undef, label %bb1, label %bb2

bb1:
  %2 = getelementptr inbounds %struct.s2, %struct.s2* null, i64 %0, i32 0
  call void @bar(i32* %2) nounwind
  unreachable

bb2:
  %3 = call fastcc i8* @foo(%struct.s2* %1) nounwind
  unreachable

bb3:
  ret i8* undef
}

declare void @bar(i32*)

declare fastcc i8* @foo(%struct.s2*) nounwind

; rdar://8773371

declare void @printf(...) nounwind

define void @commute(i32 %test_case, i32 %scale) nounwind ssp {
; CHECK-LABEL: commute:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $esi killed $esi def $rsi
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal -1(%rdi), %eax
; CHECK-NEXT:    cmpl $2, %eax
; CHECK-NEXT:    ja .LBB1_4
; CHECK-NEXT:  # %bb.1: # %sw.bb
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    testb %al, %al
; CHECK-NEXT:    jne .LBB1_4
; CHECK-NEXT:  # %bb.2: # %if.end34
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    imull %edi, %esi
; CHECK-NEXT:    leal (%rsi,%rsi,2), %esi
; CHECK-NEXT:    # kill: def $edi killed $edi killed $rdi
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    callq printf
; CHECK-NEXT:    addq $8, %rsp
; CHECK-NEXT:    .p2align 4, 0x90
; CHECK-NEXT:  .LBB1_3: # %for.body53.us
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    jmp .LBB1_3
; CHECK-NEXT:  .LBB1_4: # %sw.bb307
; CHECK-NEXT:    retq
entry:
  switch i32 %test_case, label %sw.bb307 [
    i32 1, label %sw.bb
    i32 2, label %sw.bb
    i32 3, label %sw.bb
  ]

sw.bb:
  %mul = mul nsw i32 %test_case, 3
  %mul20 = mul nsw i32 %mul, %scale
  br i1 undef, label %if.end34, label %sw.bb307

if.end34:
  tail call void (...) @printf(i32 %test_case, i32 %mul20) nounwind
  %tmp = mul i32 %scale, %test_case
  %tmp752 = mul i32 %tmp, 3
  %tmp753 = zext i32 %tmp752 to i64
  br label %bb.nph743.us

for.body53.us:
  %exitcond = icmp eq i64 undef, %tmp753
  br i1 %exitcond, label %bb.nph743.us, label %for.body53.us

bb.nph743.us:
  br label %for.body53.us

sw.bb307:
  ret void
}

; CSE physical register defining instruction across MBB boundary.
; rdar://10660865
define i32 @cross_mbb_phys_cse(i32 %a, i32 %b) nounwind ssp {
; CHECK-LABEL: cross_mbb_phys_cse:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $1, %eax
; CHECK-NEXT:    cmpl %esi, %edi
; CHECK-NEXT:    ja .LBB2_2
; CHECK-NEXT:  # %bb.1: # %if.end
; CHECK-NEXT:    sbbl %eax, %eax
; CHECK-NEXT:  .LBB2_2: # %return
; CHECK-NEXT:    retq
entry:
  %cmp = icmp ugt i32 %a, %b
  br i1 %cmp, label %return, label %if.end

if.end:
  %cmp1 = icmp ult i32 %a, %b
  %. = sext i1 %cmp1 to i32
  br label %return

return:
  %retval.0 = phi i32 [ 1, %entry ], [ %., %if.end ]
  ret i32 %retval.0
}

; rdar://11393714
define i8* @bsd_memchr(i8* %s, i32 %a, i32 %c, i64 %n) nounwind ssp {
; CHECK-LABEL: bsd_memchr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    testq %rcx, %rcx
; CHECK-NEXT:    je .LBB3_4
; CHECK-NEXT:  # %bb.1: # %preheader
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    movzbl %dl, %edx
; CHECK-NEXT:    .p2align 4, 0x90
; CHECK-NEXT:  .LBB3_2: # %do.body
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    cmpl %edx, %esi
; CHECK-NEXT:    je .LBB3_5
; CHECK-NEXT:  # %bb.3: # %do.cond
; CHECK-NEXT:    # in Loop: Header=BB3_2 Depth=1
; CHECK-NEXT:    incq %rax
; CHECK-NEXT:    decq %rcx
; CHECK-NEXT:    jne .LBB3_2
; CHECK-NEXT:  .LBB3_4:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:  .LBB3_5: # %return
; CHECK-NEXT:    retq
entry:
  %cmp = icmp eq i64 %n, 0
  br i1 %cmp, label %return, label %preheader

preheader:
  %conv2 = and i32 %c, 255
  br label %do.body

do.body:
  %n.addr.0 = phi i64 [ %dec, %do.cond ], [ %n, %preheader ]
  %p.0 = phi i8* [ %incdec.ptr, %do.cond ], [ %s, %preheader ]
  %cmp3 = icmp eq i32 %a, %conv2
  br i1 %cmp3, label %return, label %do.cond

do.cond:
  %incdec.ptr = getelementptr inbounds i8, i8* %p.0, i64 1
  %dec = add i64 %n.addr.0, -1
  %cmp6 = icmp eq i64 %dec, 0
  br i1 %cmp6, label %return, label %do.body

return:
  %retval.0 = phi i8* [ null, %entry ], [ null, %do.cond ], [ %p.0, %do.body ]
  ret i8* %retval.0
}

; PR13578
@t2_global = external dso_local global i32

declare i1 @t2_func()

define i32 @t2() nounwind {
; CHECK-LABEL: t2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movl $42, {{.*}}(%rip)
; CHECK-NEXT:    callq t2_func
; CHECK-NEXT:    testb $1, %al
; CHECK-NEXT:    je .LBB4_2
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    movl {{.*}}(%rip), %eax
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    retq
; CHECK-NEXT:  .LBB4_2: # %b
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    retq
  store i32 42, i32* @t2_global
  %c = call i1 @t2_func()
  br i1 %c, label %a, label %b

a:
  %l = load i32, i32* @t2_global
  ret i32 %l

b:
  ret i32 0
}

