; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I

; Test for handling of AND with constant. If this constant exceeds simm12 and
; also is a non-empty sequence of ones starting at the least significant bit
; with the remainder zero, we can replace it with SLLI + SLRI

define i32 @and32_0x7ff(i32 %x) {
; RV32I-LABEL: and32_0x7ff:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a0, a0, 2047
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and32_0x7ff:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a0, a0, 2047
; RV64I-NEXT:    ret
  %a = and i32 %x, 2047
  ret i32 %a
}

define i32 @and32_0xfff(i32 %x) {
; RV32I-LABEL: and32_0xfff:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 20
; RV32I-NEXT:    srli a0, a0, 20
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and32_0xfff:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 52
; RV64I-NEXT:    srli a0, a0, 52
; RV64I-NEXT:    ret
  %a = and i32 %x, 4095
  ret i32 %a
}

define i64 @and64_0x7ff(i64 %x) {
; RV32I-LABEL: and64_0x7ff:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a0, a0, 2047
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and64_0x7ff:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a0, a0, 2047
; RV64I-NEXT:    ret
  %a = and i64 %x, 2047
  ret i64 %a
}

define i64 @and64_0xfff(i64 %x) {
; RV32I-LABEL: and64_0xfff:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 20
; RV32I-NEXT:    srli a0, a0, 20
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and64_0xfff:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 52
; RV64I-NEXT:    srli a0, a0, 52
; RV64I-NEXT:    ret
  %a = and i64 %x, 4095
  ret i64 %a
}

