; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -O1 -S < %s | FileCheck %s

; Make sure we reassociate and1 with and2 before instcombine to allow
; Demorgan logic fold:
; (a & ~b) & ~c --> a & ~(b | c)
define i4 @not_reassociate_and_and_not(i4 %a, i4 %b, i4 %c, i4 %d) {
; CHECK-LABEL: @not_reassociate_and_and_not(
; CHECK-NEXT:    [[TMP1:%.*]] = or i4 [[B:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = xor i4 [[TMP1]], -1
; CHECK-NEXT:    [[AND2:%.*]] = and i4 [[TMP2]], [[A:%.*]]
; CHECK-NEXT:    [[AND3:%.*]] = and i4 [[AND2]], [[D:%.*]]
; CHECK-NEXT:    ret i4 [[AND3]]
;
  %notb = xor i4 %b, -1
  %notc = xor i4 %c, -1
  %and1 = and i4 %a, %notb
  %and2 = and i4 %and1, %d
  %and3 = and i4 %and2, %notc
  ret i4 %and3
}

; (a | ~b) | ~c --> a | ~(b & c)
define i32 @not_reassociate_or_or_not(i32 %a, i32 %b, i32 %c, i32 %d) {
; CHECK-LABEL: @not_reassociate_or_or_not(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[B:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], -1
; CHECK-NEXT:    [[B2:%.*]] = or i32 [[TMP2]], [[A:%.*]]
; CHECK-NEXT:    [[B3:%.*]] = or i32 [[B2]], [[D:%.*]]
; CHECK-NEXT:    ret i32 [[B3]]
;
  %notb = xor i32 %b, -1
  %notc = xor i32 %c, -1
  %b1 = or i32 %a, %notb
  %b2 = or i32 %b1, %d
  %b3 = or i32 %b2, %notc
  ret i32 %b3
}
