; RUN: llc -mtriple=aarch64-none-eabi -mattr=-fp-armv8 %s -o - | FileCheck %s  -check-prefix=nofp

; In the novfp case, the compiler is forced to assign a core register,
; even if the input is a float.

; nofp-LABEL: f1
; nofp-CHECK: ldr x0, [sp]

; This can be generated by a function such as:
;  void f1(float f) {asm volatile ("ldr $0, [sp]" : : "X" (f));}

define void @f1(float %f) {
entry:
  call void asm sideeffect "ldr $0, [sp]", "X" (float %f) nounwind

  ret void
}
