; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v \
; RUN:   -verify-machineinstrs | FileCheck %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v \
; RUN:   -verify-machineinstrs | FileCheck %s
declare <vscale x 1 x i8> @llvm.riscv.vid.nxv1i8(
  <vscale x 1 x i8>,
  iXLen);

define <vscale x 1 x i8> @intrinsic_vid_v_nxv1i8(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i8> @llvm.riscv.vid.nxv1i8(
    <vscale x 1 x i8> undef,
    iXLen %0)

  ret <vscale x 1 x i8> %a
}

declare <vscale x 1 x i8> @llvm.riscv.vid.mask.nxv1i8(
  <vscale x 1 x i8>,
  <vscale x 1 x i1>,
  iXLen, iXLen);

define <vscale x 1 x i8> @intrinsic_vid_mask_v_nxv1i8(<vscale x 1 x i8> %0, <vscale x 1 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i8> @llvm.riscv.vid.mask.nxv1i8(
    <vscale x 1 x i8> %0,
    <vscale x 1 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 1 x i8> %a
}

declare <vscale x 2 x i8> @llvm.riscv.vid.nxv2i8(
  <vscale x 2 x i8>,
  iXLen);

define <vscale x 2 x i8> @intrinsic_vid_v_nxv2i8(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i8> @llvm.riscv.vid.nxv2i8(
    <vscale x 2 x i8> undef,
    iXLen %0)

  ret <vscale x 2 x i8> %a
}

declare <vscale x 2 x i8> @llvm.riscv.vid.mask.nxv2i8(
  <vscale x 2 x i8>,
  <vscale x 2 x i1>,
  iXLen, iXLen);

define <vscale x 2 x i8> @intrinsic_vid_mask_v_nxv2i8(<vscale x 2 x i8> %0, <vscale x 2 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i8> @llvm.riscv.vid.mask.nxv2i8(
    <vscale x 2 x i8> %0,
    <vscale x 2 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 2 x i8> %a
}

declare <vscale x 4 x i8> @llvm.riscv.vid.nxv4i8(
  <vscale x 4 x i8>,
  iXLen);

define <vscale x 4 x i8> @intrinsic_vid_v_nxv4i8(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i8> @llvm.riscv.vid.nxv4i8(
    <vscale x 4 x i8> undef,
    iXLen %0)

  ret <vscale x 4 x i8> %a
}

declare <vscale x 4 x i8> @llvm.riscv.vid.mask.nxv4i8(
  <vscale x 4 x i8>,
  <vscale x 4 x i1>,
  iXLen, iXLen);

define <vscale x 4 x i8> @intrinsic_vid_mask_v_nxv4i8(<vscale x 4 x i8> %0, <vscale x 4 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i8> @llvm.riscv.vid.mask.nxv4i8(
    <vscale x 4 x i8> %0,
    <vscale x 4 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 4 x i8> %a
}

declare <vscale x 8 x i8> @llvm.riscv.vid.nxv8i8(
  <vscale x 8 x i8>,
  iXLen);

define <vscale x 8 x i8> @intrinsic_vid_v_nxv8i8(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i8> @llvm.riscv.vid.nxv8i8(
    <vscale x 8 x i8> undef,
    iXLen %0)

  ret <vscale x 8 x i8> %a
}

declare <vscale x 8 x i8> @llvm.riscv.vid.mask.nxv8i8(
  <vscale x 8 x i8>,
  <vscale x 8 x i1>,
  iXLen, iXLen);

define <vscale x 8 x i8> @intrinsic_vid_mask_v_nxv8i8(<vscale x 8 x i8> %0, <vscale x 8 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i8> @llvm.riscv.vid.mask.nxv8i8(
    <vscale x 8 x i8> %0,
    <vscale x 8 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 8 x i8> %a
}

declare <vscale x 16 x i8> @llvm.riscv.vid.nxv16i8(
  <vscale x 16 x i8>,
  iXLen);

define <vscale x 16 x i8> @intrinsic_vid_v_nxv16i8(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i8> @llvm.riscv.vid.nxv16i8(
    <vscale x 16 x i8> undef,
    iXLen %0)

  ret <vscale x 16 x i8> %a
}

declare <vscale x 16 x i8> @llvm.riscv.vid.mask.nxv16i8(
  <vscale x 16 x i8>,
  <vscale x 16 x i1>,
  iXLen, iXLen);

define <vscale x 16 x i8> @intrinsic_vid_mask_v_nxv16i8(<vscale x 16 x i8> %0, <vscale x 16 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i8> @llvm.riscv.vid.mask.nxv16i8(
    <vscale x 16 x i8> %0,
    <vscale x 16 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 16 x i8> %a
}

declare <vscale x 32 x i8> @llvm.riscv.vid.nxv32i8(
  <vscale x 32 x i8>,
  iXLen);

define <vscale x 32 x i8> @intrinsic_vid_v_nxv32i8(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i8> @llvm.riscv.vid.nxv32i8(
    <vscale x 32 x i8> undef,
    iXLen %0)

  ret <vscale x 32 x i8> %a
}

declare <vscale x 32 x i8> @llvm.riscv.vid.mask.nxv32i8(
  <vscale x 32 x i8>,
  <vscale x 32 x i1>,
  iXLen, iXLen);

define <vscale x 32 x i8> @intrinsic_vid_mask_v_nxv32i8(<vscale x 32 x i8> %0, <vscale x 32 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i8> @llvm.riscv.vid.mask.nxv32i8(
    <vscale x 32 x i8> %0,
    <vscale x 32 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 32 x i8> %a
}

declare <vscale x 1 x i16> @llvm.riscv.vid.nxv1i16(
  <vscale x 1 x i16>,
  iXLen);

define <vscale x 1 x i16> @intrinsic_vid_v_nxv1i16(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i16> @llvm.riscv.vid.nxv1i16(
    <vscale x 1 x i16> undef,
    iXLen %0)

  ret <vscale x 1 x i16> %a
}

declare <vscale x 1 x i16> @llvm.riscv.vid.mask.nxv1i16(
  <vscale x 1 x i16>,
  <vscale x 1 x i1>,
  iXLen, iXLen);

define <vscale x 1 x i16> @intrinsic_vid_mask_v_nxv1i16(<vscale x 1 x i16> %0, <vscale x 1 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i16> @llvm.riscv.vid.mask.nxv1i16(
    <vscale x 1 x i16> %0,
    <vscale x 1 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 1 x i16> %a
}

declare <vscale x 2 x i16> @llvm.riscv.vid.nxv2i16(
  <vscale x 2 x i16>,
  iXLen);

define <vscale x 2 x i16> @intrinsic_vid_v_nxv2i16(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i16> @llvm.riscv.vid.nxv2i16(
    <vscale x 2 x i16> undef,
    iXLen %0)

  ret <vscale x 2 x i16> %a
}

declare <vscale x 2 x i16> @llvm.riscv.vid.mask.nxv2i16(
  <vscale x 2 x i16>,
  <vscale x 2 x i1>,
  iXLen, iXLen);

define <vscale x 2 x i16> @intrinsic_vid_mask_v_nxv2i16(<vscale x 2 x i16> %0, <vscale x 2 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i16> @llvm.riscv.vid.mask.nxv2i16(
    <vscale x 2 x i16> %0,
    <vscale x 2 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 2 x i16> %a
}

declare <vscale x 4 x i16> @llvm.riscv.vid.nxv4i16(
  <vscale x 4 x i16>,
  iXLen);

define <vscale x 4 x i16> @intrinsic_vid_v_nxv4i16(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i16> @llvm.riscv.vid.nxv4i16(
    <vscale x 4 x i16> undef,
    iXLen %0)

  ret <vscale x 4 x i16> %a
}

declare <vscale x 4 x i16> @llvm.riscv.vid.mask.nxv4i16(
  <vscale x 4 x i16>,
  <vscale x 4 x i1>,
  iXLen, iXLen);

define <vscale x 4 x i16> @intrinsic_vid_mask_v_nxv4i16(<vscale x 4 x i16> %0, <vscale x 4 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i16> @llvm.riscv.vid.mask.nxv4i16(
    <vscale x 4 x i16> %0,
    <vscale x 4 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 4 x i16> %a
}

declare <vscale x 8 x i16> @llvm.riscv.vid.nxv8i16(
  <vscale x 8 x i16>,
  iXLen);

define <vscale x 8 x i16> @intrinsic_vid_v_nxv8i16(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i16> @llvm.riscv.vid.nxv8i16(
    <vscale x 8 x i16> undef,
    iXLen %0)

  ret <vscale x 8 x i16> %a
}

declare <vscale x 8 x i16> @llvm.riscv.vid.mask.nxv8i16(
  <vscale x 8 x i16>,
  <vscale x 8 x i1>,
  iXLen, iXLen);

define <vscale x 8 x i16> @intrinsic_vid_mask_v_nxv8i16(<vscale x 8 x i16> %0, <vscale x 8 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i16> @llvm.riscv.vid.mask.nxv8i16(
    <vscale x 8 x i16> %0,
    <vscale x 8 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 8 x i16> %a
}

declare <vscale x 16 x i16> @llvm.riscv.vid.nxv16i16(
  <vscale x 16 x i16>,
  iXLen);

define <vscale x 16 x i16> @intrinsic_vid_v_nxv16i16(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i16> @llvm.riscv.vid.nxv16i16(
    <vscale x 16 x i16> undef,
    iXLen %0)

  ret <vscale x 16 x i16> %a
}

declare <vscale x 16 x i16> @llvm.riscv.vid.mask.nxv16i16(
  <vscale x 16 x i16>,
  <vscale x 16 x i1>,
  iXLen, iXLen);

define <vscale x 16 x i16> @intrinsic_vid_mask_v_nxv16i16(<vscale x 16 x i16> %0, <vscale x 16 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i16> @llvm.riscv.vid.mask.nxv16i16(
    <vscale x 16 x i16> %0,
    <vscale x 16 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 16 x i16> %a
}

declare <vscale x 32 x i16> @llvm.riscv.vid.nxv32i16(
  <vscale x 32 x i16>,
  iXLen);

define <vscale x 32 x i16> @intrinsic_vid_v_nxv32i16(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i16> @llvm.riscv.vid.nxv32i16(
    <vscale x 32 x i16> undef,
    iXLen %0)

  ret <vscale x 32 x i16> %a
}

declare <vscale x 32 x i16> @llvm.riscv.vid.mask.nxv32i16(
  <vscale x 32 x i16>,
  <vscale x 32 x i1>,
  iXLen, iXLen);

define <vscale x 32 x i16> @intrinsic_vid_mask_v_nxv32i16(<vscale x 32 x i16> %0, <vscale x 32 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i16> @llvm.riscv.vid.mask.nxv32i16(
    <vscale x 32 x i16> %0,
    <vscale x 32 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 32 x i16> %a
}

declare <vscale x 1 x i32> @llvm.riscv.vid.nxv1i32(
  <vscale x 1 x i32>,
  iXLen);

define <vscale x 1 x i32> @intrinsic_vid_v_nxv1i32(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i32> @llvm.riscv.vid.nxv1i32(
    <vscale x 1 x i32> undef,
    iXLen %0)

  ret <vscale x 1 x i32> %a
}

declare <vscale x 1 x i32> @llvm.riscv.vid.mask.nxv1i32(
  <vscale x 1 x i32>,
  <vscale x 1 x i1>,
  iXLen, iXLen);

define <vscale x 1 x i32> @intrinsic_vid_mask_v_nxv1i32(<vscale x 1 x i32> %0, <vscale x 1 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i32> @llvm.riscv.vid.mask.nxv1i32(
    <vscale x 1 x i32> %0,
    <vscale x 1 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 1 x i32> %a
}

declare <vscale x 2 x i32> @llvm.riscv.vid.nxv2i32(
  <vscale x 2 x i32>,
  iXLen);

define <vscale x 2 x i32> @intrinsic_vid_v_nxv2i32(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i32> @llvm.riscv.vid.nxv2i32(
    <vscale x 2 x i32> undef,
    iXLen %0)

  ret <vscale x 2 x i32> %a
}

declare <vscale x 2 x i32> @llvm.riscv.vid.mask.nxv2i32(
  <vscale x 2 x i32>,
  <vscale x 2 x i1>,
  iXLen, iXLen);

define <vscale x 2 x i32> @intrinsic_vid_mask_v_nxv2i32(<vscale x 2 x i32> %0, <vscale x 2 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i32> @llvm.riscv.vid.mask.nxv2i32(
    <vscale x 2 x i32> %0,
    <vscale x 2 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 2 x i32> %a
}

declare <vscale x 4 x i32> @llvm.riscv.vid.nxv4i32(
  <vscale x 4 x i32>,
  iXLen);

define <vscale x 4 x i32> @intrinsic_vid_v_nxv4i32(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i32> @llvm.riscv.vid.nxv4i32(
    <vscale x 4 x i32> undef,
    iXLen %0)

  ret <vscale x 4 x i32> %a
}

declare <vscale x 4 x i32> @llvm.riscv.vid.mask.nxv4i32(
  <vscale x 4 x i32>,
  <vscale x 4 x i1>,
  iXLen, iXLen);

define <vscale x 4 x i32> @intrinsic_vid_mask_v_nxv4i32(<vscale x 4 x i32> %0, <vscale x 4 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i32> @llvm.riscv.vid.mask.nxv4i32(
    <vscale x 4 x i32> %0,
    <vscale x 4 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 4 x i32> %a
}

declare <vscale x 8 x i32> @llvm.riscv.vid.nxv8i32(
  <vscale x 8 x i32>,
  iXLen);

define <vscale x 8 x i32> @intrinsic_vid_v_nxv8i32(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i32> @llvm.riscv.vid.nxv8i32(
    <vscale x 8 x i32> undef,
    iXLen %0)

  ret <vscale x 8 x i32> %a
}

declare <vscale x 8 x i32> @llvm.riscv.vid.mask.nxv8i32(
  <vscale x 8 x i32>,
  <vscale x 8 x i1>,
  iXLen, iXLen);

define <vscale x 8 x i32> @intrinsic_vid_mask_v_nxv8i32(<vscale x 8 x i32> %0, <vscale x 8 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i32> @llvm.riscv.vid.mask.nxv8i32(
    <vscale x 8 x i32> %0,
    <vscale x 8 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 8 x i32> %a
}

declare <vscale x 16 x i32> @llvm.riscv.vid.nxv16i32(
  <vscale x 16 x i32>,
  iXLen);

define <vscale x 16 x i32> @intrinsic_vid_v_nxv16i32(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i32> @llvm.riscv.vid.nxv16i32(
    <vscale x 16 x i32> undef,
    iXLen %0)

  ret <vscale x 16 x i32> %a
}

declare <vscale x 16 x i32> @llvm.riscv.vid.mask.nxv16i32(
  <vscale x 16 x i32>,
  <vscale x 16 x i1>,
  iXLen, iXLen);

define <vscale x 16 x i32> @intrinsic_vid_mask_v_nxv16i32(<vscale x 16 x i32> %0, <vscale x 16 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i32> @llvm.riscv.vid.mask.nxv16i32(
    <vscale x 16 x i32> %0,
    <vscale x 16 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 16 x i32> %a
}

declare <vscale x 1 x i64> @llvm.riscv.vid.nxv1i64(
  <vscale x 1 x i64>,
  iXLen);

define <vscale x 1 x i64> @intrinsic_vid_v_nxv1i64(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i64> @llvm.riscv.vid.nxv1i64(
    <vscale x 1 x i64> undef,
    iXLen %0)

  ret <vscale x 1 x i64> %a
}

declare <vscale x 1 x i64> @llvm.riscv.vid.mask.nxv1i64(
  <vscale x 1 x i64>,
  <vscale x 1 x i1>,
  iXLen, iXLen);

define <vscale x 1 x i64> @intrinsic_vid_mask_v_nxv1i64(<vscale x 1 x i64> %0, <vscale x 1 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i64> @llvm.riscv.vid.mask.nxv1i64(
    <vscale x 1 x i64> %0,
    <vscale x 1 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 1 x i64> %a
}

declare <vscale x 2 x i64> @llvm.riscv.vid.nxv2i64(
  <vscale x 2 x i64>,
  iXLen);

define <vscale x 2 x i64> @intrinsic_vid_v_nxv2i64(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i64> @llvm.riscv.vid.nxv2i64(
    <vscale x 2 x i64> undef,
    iXLen %0)

  ret <vscale x 2 x i64> %a
}

declare <vscale x 2 x i64> @llvm.riscv.vid.mask.nxv2i64(
  <vscale x 2 x i64>,
  <vscale x 2 x i1>,
  iXLen, iXLen);

define <vscale x 2 x i64> @intrinsic_vid_mask_v_nxv2i64(<vscale x 2 x i64> %0, <vscale x 2 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i64> @llvm.riscv.vid.mask.nxv2i64(
    <vscale x 2 x i64> %0,
    <vscale x 2 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 2 x i64> %a
}

declare <vscale x 4 x i64> @llvm.riscv.vid.nxv4i64(
  <vscale x 4 x i64>,
  iXLen);

define <vscale x 4 x i64> @intrinsic_vid_v_nxv4i64(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i64> @llvm.riscv.vid.nxv4i64(
    <vscale x 4 x i64> undef,
    iXLen %0)

  ret <vscale x 4 x i64> %a
}

declare <vscale x 4 x i64> @llvm.riscv.vid.mask.nxv4i64(
  <vscale x 4 x i64>,
  <vscale x 4 x i1>,
  iXLen, iXLen);

define <vscale x 4 x i64> @intrinsic_vid_mask_v_nxv4i64(<vscale x 4 x i64> %0, <vscale x 4 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i64> @llvm.riscv.vid.mask.nxv4i64(
    <vscale x 4 x i64> %0,
    <vscale x 4 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 4 x i64> %a
}

declare <vscale x 8 x i64> @llvm.riscv.vid.nxv8i64(
  <vscale x 8 x i64>,
  iXLen);

define <vscale x 8 x i64> @intrinsic_vid_v_nxv8i64(iXLen %0) nounwind {
; CHECK-LABEL: intrinsic_vid_v_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i64> @llvm.riscv.vid.nxv8i64(
    <vscale x 8 x i64> undef,
    iXLen %0)

  ret <vscale x 8 x i64> %a
}

declare <vscale x 8 x i64> @llvm.riscv.vid.mask.nxv8i64(
  <vscale x 8 x i64>,
  <vscale x 8 x i1>,
  iXLen, iXLen);

define <vscale x 8 x i64> @intrinsic_vid_mask_v_nxv8i64(<vscale x 8 x i64> %0, <vscale x 8 x i1> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vid_mask_v_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, tu, mu
; CHECK-NEXT:    vid.v v8, v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i64> @llvm.riscv.vid.mask.nxv8i64(
    <vscale x 8 x i64> %0,
    <vscale x 8 x i1> %1,
    iXLen %2, iXLen 0)

  ret <vscale x 8 x i64> %a
}
