; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

define i32 @test_srem_canonicalize_op0(i32 %x, i32 %y) {
; CHECK-LABEL: @test_srem_canonicalize_op0(
; CHECK-NEXT:    [[TMP1:%.*]] = srem i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SREM:%.*]] = sub nsw i32 0, [[TMP1]]
; CHECK-NEXT:    ret i32 [[SREM]]
;
  %neg = sub nsw i32 0, %x
  %srem = srem i32 %neg, %y
  ret i32 %srem
}

; (X srem -Y) is not equal to -(X srem Y), don't canonicalize.
define i32 @test_srem_canonicalize_op1(i32 %x, i32 %z) {
; CHECK-LABEL: @test_srem_canonicalize_op1(
; CHECK-NEXT:    [[Y:%.*]] = mul i32 [[Z:%.*]], 3
; CHECK-NEXT:    [[NEG:%.*]] = sub nsw i32 0, [[X:%.*]]
; CHECK-NEXT:    [[SREM:%.*]] = srem i32 [[Y]], [[NEG]]
; CHECK-NEXT:    ret i32 [[SREM]]
;
  %y = mul i32 %z, 3
  %neg = sub nsw i32 0, %x
  %srem = srem i32 %y, %neg
  ret i32 %srem
}

define i32 @test_srem_canonicalize_nonsw(i32 %x, i32 %y) {
; CHECK-LABEL: @test_srem_canonicalize_nonsw(
; CHECK-NEXT:    [[NEG:%.*]] = sub i32 0, [[X:%.*]]
; CHECK-NEXT:    [[SREM:%.*]] = srem i32 [[NEG]], [[Y:%.*]]
; CHECK-NEXT:    ret i32 [[SREM]]
;
  %neg = sub i32 0, %x
  %srem = srem i32 %neg, %y
  ret i32 %srem
}

define <2 x i32> @test_srem_canonicalize_vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @test_srem_canonicalize_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = srem <2 x i32> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SREM:%.*]] = sub nsw <2 x i32> zeroinitializer, [[TMP1]]
; CHECK-NEXT:    ret <2 x i32> [[SREM]]
;
  %neg = sub nsw <2 x i32> <i32 0, i32 0>, %x
  %srem = srem <2 x i32> %neg, %y
  ret <2 x i32> %srem
}

define i32 @test_srem_canonicalize_multiple_uses(i32 %x, i32 %y) {
; CHECK-LABEL: @test_srem_canonicalize_multiple_uses(
; CHECK-NEXT:    [[NEG:%.*]] = sub nsw i32 0, [[X:%.*]]
; CHECK-NEXT:    [[SREM:%.*]] = srem i32 [[NEG]], [[Y:%.*]]
; CHECK-NEXT:    [[SREM2:%.*]] = srem i32 [[SREM]], [[NEG]]
; CHECK-NEXT:    ret i32 [[SREM2]]
;
  %neg = sub nsw i32 0, %x
  %srem = srem i32 %neg, %y
  %srem2 = srem i32 %srem, %neg
  ret i32 %srem2
}

