# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -instruction-tables < %s | FileCheck %s

llwpcb %edi
llwpcb %rdi

lwpins $-1985229329, %esi, %edi
lwpins $-1985229329, (%rsi), %edi

lwpins $-1985229329, %esi, %rdi
lwpins $-1985229329, (%rsi), %rdi

lwpval $-1985229329, %esi, %edi
lwpval $-1985229329, (%rsi), %edi

lwpval $-1985229329, %esi, %rdi
lwpval $-1985229329, (%rsi), %rdi

slwpcb %edi
slwpcb %rdi

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      100   0.33    *      *      U     llwpcb	%edi
# CHECK-NEXT:  1      100   0.33    *      *      U     llwpcb	%rdi
# CHECK-NEXT:  1      100   0.33    *      *      U     lwpins	$-1985229329, %esi, %edi
# CHECK-NEXT:  1      100   0.33    *      *      U     lwpins	$-1985229329, (%rsi), %edi
# CHECK-NEXT:  1      100   0.33    *      *      U     lwpins	$-1985229329, %esi, %rdi
# CHECK-NEXT:  1      100   0.33    *      *      U     lwpins	$-1985229329, (%rsi), %rdi
# CHECK-NEXT:  1      100   0.33    *      *      U     lwpval	$-1985229329, %esi, %edi
# CHECK-NEXT:  1      100   0.33    *      *      U     lwpval	$-1985229329, (%rsi), %edi
# CHECK-NEXT:  1      100   0.33    *      *      U     lwpval	$-1985229329, %esi, %rdi
# CHECK-NEXT:  1      100   0.33    *      *      U     lwpval	$-1985229329, (%rsi), %rdi
# CHECK-NEXT:  1      100   0.33    *      *      U     slwpcb	%edi
# CHECK-NEXT:  1      100   0.33    *      *      U     slwpcb	%rdi

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SBDivider
# CHECK-NEXT: [1]   - SBFPDivider
# CHECK-NEXT: [2]   - SBPort0
# CHECK-NEXT: [3]   - SBPort1
# CHECK-NEXT: [4]   - SBPort4
# CHECK-NEXT: [5]   - SBPort5
# CHECK-NEXT: [6.0] - SBPort23
# CHECK-NEXT: [6.1] - SBPort23

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6.0]  [6.1]
# CHECK-NEXT:  -      -     4.00   4.00    -     4.00    -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6.0]  [6.1]  Instructions:
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     llwpcb	%edi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     llwpcb	%rdi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     lwpins	$-1985229329, %esi, %edi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     lwpins	$-1985229329, (%rsi), %edi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     lwpins	$-1985229329, %esi, %rdi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     lwpins	$-1985229329, (%rsi), %rdi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     lwpval	$-1985229329, %esi, %edi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     lwpval	$-1985229329, (%rsi), %edi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     lwpval	$-1985229329, %esi, %rdi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     lwpval	$-1985229329, (%rsi), %rdi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     slwpcb	%edi
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     slwpcb	%rdi
