static const ucschar hangul_keyboard_table_2[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x0021,     /* 0x21 exclam:       exclamation mark               */
    0x0022,     /* 0x22 quotedbl:     quotation mark                 */
    0x0023,     /* 0x23 numbersign:   number sign                    */
    0x0024,     /* 0x24 dollar:       dollar sign                    */
    0x0025,     /* 0x25 percent:      percent sign                   */
    0x0026,     /* 0x26 ampersand:    ampersand                      */
    0x0027,     /* 0x27 apostrophe:   apostrophe                     */
    0x0028,     /* 0x28 parenleft:    left parenthesis               */
    0x0029,     /* 0x29 parenright:   right parenthesis              */
    0x002a,     /* 0x2A asterisk:     asterisk                       */
    0x002b,     /* 0x2B plus:         plus sign                      */
    0x002c,     /* 0x2C comma:        comma                          */
    0x002d,     /* 0x2D minus:        minus sign                     */
    0x002e,     /* 0x2E period:       period                         */
    0x002f,     /* 0x2F slash:        slash                          */
    0x0030,     /* 0x30 0:            0                              */
    0x0031,     /* 0x31 1:            1                              */
    0x0032,     /* 0x32 2:            2                              */
    0x0033,     /* 0x33 3:            3                              */
    0x0034,     /* 0x34 4:            4                              */
    0x0035,     /* 0x35 5:            5                              */
    0x0036,     /* 0x36 6:            6                              */
    0x0037,     /* 0x37 7:            7                              */
    0x0038,     /* 0x38 8:            8                              */
    0x0039,     /* 0x39 9:            9                              */
    0x003a,     /* 0x3A colon:        colon                          */
    0x003b,     /* 0x3B semicolon:    semicolon                      */
    0x003c,     /* 0x3C less:         less-than sign                 */
    0x003d,     /* 0x3D equal:        equals sign                    */
    0x003e,     /* 0x3E greater:      greater-than sign              */
    0x003f,     /* 0x3F question:     question mark                  */
    0x0040,     /* 0x40 at:           commercial at                  */
    0x1106,     /* 0x41 A:            choseong mieum                 */
    0x1172,     /* 0x42 B:            jungseong yu                   */
    0x110e,     /* 0x43 C:            choseong chieuch               */
    0x110b,     /* 0x44 D:            choseong ieung                 */
    0x1104,     /* 0x45 E:            choseong ssangtikeut           */
    0x1105,     /* 0x46 F:            choseong rieul                 */
    0x1112,     /* 0x47 G:            choseong hieuh                 */
    0x1169,     /* 0x48 H:            jungseong o                    */
    0x1163,     /* 0x49 I:            jungseong ya                   */
    0x1165,     /* 0x4A J:            jungseong eo                   */
    0x1161,     /* 0x4B K:            jungseong a                    */
    0x1175,     /* 0x4C L:            jungseong i                    */
    0x1173,     /* 0x4D M:            jungseong eu                   */
    0x116e,     /* 0x4E N:            jungseong u                    */
    0x1164,     /* 0x4F O:            jungseong yae                  */
    0x1168,     /* 0x50 P:            jungseong ye                   */
    0x1108,     /* 0x51 Q:            choseong ssangpieup            */
    0x1101,     /* 0x52 R:            choseong ssangkiyeok           */
    0x1102,     /* 0x53 S:            choseong nieun                 */
    0x110a,     /* 0x54 T:            choseong ssangsios             */
    0x1167,     /* 0x55 U:            jungseong yeo                  */
    0x1111,     /* 0x56 V:            choseong phieuph               */
    0x110d,     /* 0x57 W:            choseong ssangcieuc            */
    0x1110,     /* 0x58 X:            choseong thieuth               */
    0x116d,     /* 0x59 Y:            jungseong yo                   */
    0x110f,     /* 0x5A Z:            choseong khieukh               */
    0x005b,     /* 0x5B bracketleft:  left bracket                   */
    0x005c,     /* 0x5C backslash:    backslash                      */
    0x005d,     /* 0x5D bracketright: right bracket                  */
    0x005e,     /* 0x5E asciicircum:  circumflex accent              */
    0x005f,     /* 0x5F underscore:   underscore                     */
    0x0060,     /* 0x60 quoteleft:    grave accent                   */
    0x1106,     /* 0x61 a:            choseong  mieum                */
    0x1172,     /* 0x62 b:            jungseong yu                   */
    0x110e,     /* 0x63 c:            choseong  chieuch              */
    0x110b,     /* 0x64 d:            choseong  ieung                */
    0x1103,     /* 0x65 e:            choseong  tikeut               */
    0x1105,     /* 0x66 f:            choseong  rieul                */
    0x1112,     /* 0x67 g:            choseong  hieuh                */
    0x1169,     /* 0x68 h:            jungseong o                    */
    0x1163,     /* 0x69 i:            jungseong ya                   */
    0x1165,     /* 0x6A j:            jungseong eo                   */
    0x1161,     /* 0x6B k:            jungseong a                    */
    0x1175,     /* 0x6C l:            jungseong i                    */
    0x1173,     /* 0x6D m:            jungseong eu                   */
    0x116e,     /* 0x6E n:            jungseong u                    */
    0x1162,     /* 0x6F o:            jungseong ae                   */
    0x1166,     /* 0x70 p:            jungseong e                    */
    0x1107,     /* 0x71 q:            choseong  pieup                */
    0x1100,     /* 0x72 r:            choseong  kiyeok               */
    0x1102,     /* 0x73 s:            choseong  nieun                */
    0x1109,     /* 0x74 t:            choseong  sios                 */
    0x1167,     /* 0x75 u:            jungseong yeo                  */
    0x1111,     /* 0x76 v:            choseong  phieuph              */
    0x110c,     /* 0x77 w:            choseong  cieuc                */
    0x1110,     /* 0x78 x:            choseong  thieuth              */
    0x116d,     /* 0x79 y:            jungseong yo                   */
    0x110f,     /* 0x7A z:            choseong  khieukh              */
    0x007b,     /* 0x7B braceleft:    left brace                     */
    0x007c,     /* 0x7C bar:          vertical bar                   */
    0x007d,     /* 0x7D braceright:   right brace                    */
    0x007e,     /* 0x7E asciitilde:   tilde                          */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_2y[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x0021,     /* 0x21 exclam:       exclamation mark               */
    0x0022,     /* 0x22 quotedbl:     quotation mark                 */
    0x0023,     /* 0x23 numbersign:   number sign                    */
    0x0024,     /* 0x24 dollar:       dollar sign                    */
    0x0025,     /* 0x25 percent:      percent sign                   */
    0x0026,     /* 0x26 ampersand:    ampersand                      */
    0x0027,     /* 0x27 apostrophe:   apostrophe                     */
    0x0028,     /* 0x28 parenleft:    left parenthesis               */
    0x0029,     /* 0x29 parenright:   right parenthesis              */
    0x002a,     /* 0x2A asterisk:     asterisk                       */
    0x002b,     /* 0x2B plus:         plus sign                      */
    0x002c,     /* 0x2C comma:        comma                          */
    0x002d,     /* 0x2D minus:        minus sign                     */
    0x002e,     /* 0x2E period:       period                         */
    0x002f,     /* 0x2F slash:        slash                          */
    0x0030,     /* 0x30 0:            0                              */
    0x0031,     /* 0x31 1:            1                              */
    0x0032,     /* 0x32 2:            2                              */
    0x0033,     /* 0x33 3:            3                              */
    0x0034,     /* 0x34 4:            4                              */
    0x0035,     /* 0x35 5:            5                              */
    0x0036,     /* 0x36 6:            6                              */
    0x0037,     /* 0x37 7:            7                              */
    0x0038,     /* 0x38 8:            8                              */
    0x0039,     /* 0x39 9:            9                              */
    0x003a,     /* 0x3A colon:        colon                          */
    0x003b,     /* 0x3B semicolon:    semicolon                      */
    0x003c,     /* 0x3C less:         less-than sign                 */
    0x003d,     /* 0x3D equal:        equals sign                    */
    0x003e,     /* 0x3E greater:      greater-than sign              */
    0x003f,     /* 0x3F question:     question mark                  */
    0x0040,     /* 0x40 at:           commercial at                  */
    0x1140,     /* 0x41 A:            choseong pansios               */
    0x1154,     /* 0x42 B:            choseong chitueumchieuch       */
    0x114e,     /* 0x43 C:            choseong chitueumcieuc         */
    0x114c,     /* 0x44 D:            choseong yesieung              */
    0x1104,     /* 0x45 E:            choseong ssangtikeut           */
    0x111a,     /* 0x46 F:            choseong rieul-hieuh           */
    0x1159,     /* 0x47 G:            choseong yeorinhieuh           */
    0x1183,     /* 0x48 H:            jungseong o-u                  */
    0x1163,     /* 0x49 I:            jungseong ya                   */
    0x1165,     /* 0x4A J:            jungseong eo                   */
    0x119e,     /* 0x4B K:            jungseong araea                */
    0x1194,     /* 0x4C L:            jungseong yu-i                 */
    0x1173,     /* 0x4D M:            jungseong eu                   */
    0x1155,     /* 0x4E N:            choseong ceongchieumchieuch    */
    0x1164,     /* 0x4F O:            jungseong yae                  */
    0x1168,     /* 0x50 P:            jungseong ye                   */
    0x1108,     /* 0x51 Q:            choseong ssangpieup            */
    0x1101,     /* 0x52 R:            choseong ssangkiyeok           */
    0x115d,     /* 0x53 S:            choseong nieun-hieuh           */
    0x110a,     /* 0x54 T:            choseong ssangsios             */
    0x1167,     /* 0x55 U:            jungseong yeo                  */
    0x1150,     /* 0x56 V:            choseong ceongchieumcieuc      */
    0x110d,     /* 0x57 W:            choseong ssangcieuc            */
    0x113e,     /* 0x58 X:            choseong ceongchieumsios       */
    0x116d,     /* 0x59 Y:            jungseong yo                   */
    0x113c,     /* 0x5A Z:            choseong chitueumsios          */
    0x005b,     /* 0x5B bracketleft:  left bracket                   */
    0x005c,     /* 0x5C backslash:    backslash                      */
    0x005d,     /* 0x5D bracketright: right bracket                  */
    0x005e,     /* 0x5E asciicircum:  circumflex accent              */
    0x005f,     /* 0x5F underscore:   underscore                     */
    0x0060,     /* 0x60 quoteleft:    grave accent                   */
    0x1106,     /* 0x61 a:            choseong  mieum                */
    0x1172,     /* 0x62 b:            jungseong yu                   */
    0x110e,     /* 0x63 c:            choseong  chieuch              */
    0x110b,     /* 0x64 d:            choseong  ieung                */
    0x1103,     /* 0x65 e:            choseong  tikeut               */
    0x1105,     /* 0x66 f:            choseong  rieul                */
    0x1112,     /* 0x67 g:            choseong  hieuh                */
    0x1169,     /* 0x68 h:            jungseong o                    */
    0x1163,     /* 0x69 i:            jungseong ya                   */
    0x1165,     /* 0x6A j:            jungseong eo                   */
    0x1161,     /* 0x6B k:            jungseong a                    */
    0x1175,     /* 0x6C l:            jungseong i                    */
    0x1173,     /* 0x6D m:            jungseong eu                   */
    0x116e,     /* 0x6E n:            jungseong u                    */
    0x1162,     /* 0x6F o:            jungseong ae                   */
    0x1166,     /* 0x70 p:            jungseong e                    */
    0x1107,     /* 0x71 q:            choseong  pieup                */
    0x1100,     /* 0x72 r:            choseong  kiyeok               */
    0x1102,     /* 0x73 s:            choseong  nieun                */
    0x1109,     /* 0x74 t:            choseong  sios                 */
    0x1167,     /* 0x75 u:            jungseong yeo                  */
    0x1111,     /* 0x76 v:            choseong  phieuph              */
    0x110c,     /* 0x77 w:            choseong  cieuc                */
    0x1110,     /* 0x78 x:            choseong  thieuth              */
    0x116d,     /* 0x79 y:            jungseong yo                   */
    0x110f,     /* 0x7A z:            choseong  khieukh              */
    0x007b,     /* 0x7B braceleft:    left brace                     */
    0x007c,     /* 0x7C bar:          vertical bar                   */
    0x007d,     /* 0x7D braceright:   right brace                    */
    0x007e,     /* 0x7E asciitilde:   tilde                          */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_32[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x0021,     /* 0x21 exclam:         exclamation mark             */
    0x0022,     /* 0x22 quotedbl:       quotation mark               */
    0x0023,     /* 0x23 numbersign:     number sign                  */
    0x0024,     /* 0x24 dollar:         dollar sign                  */
    0x0025,     /* 0x25 percent:        percent sign                 */
    0x0026,     /* 0x26 ampersand:      ampersand                    */
    0x0027,     /* 0x27 apostrophe:     apostrophe                   */
    0x0028,     /* 0x28 parenleft:      left parenthesis             */
    0x0029,     /* 0x29 parenright:     right parenthesis            */
    0x002a,     /* 0x2A asterisk:       asterisk                     */
    0x002b,     /* 0x2B plus:           plus sign                    */
    0x002c,     /* 0x2C comma:          comma                        */
    0x002d,     /* 0x2D minus:          minus sign                   */
    0x002e,     /* 0x2E period:         period                       */
    0x002f,     /* 0x2F slash:          slash                        */
    0x0030,     /* 0x30 0:              0                            */
    0x0031,     /* 0x31 1:              1                            */
    0x0032,     /* 0x32 2:              2                            */
    0x0033,     /* 0x33 3:              3                            */
    0x0034,     /* 0x34 4:              4                            */
    0x0035,     /* 0x35 5:              5                            */
    0x0036,     /* 0x36 6:              6                            */
    0x0037,     /* 0x37 7:              7                            */
    0x0038,     /* 0x38 8:              8                            */
    0x0039,     /* 0x39 9:              9                            */
    0x003a,     /* 0x3A colon:          colon                        */
    0x003b,     /* 0x3B semicolon:      semicolon                    */
    0x003c,     /* 0x3C less:           less-than sign               */
    0x003d,     /* 0x3D equal:          equals sign                  */
    0x003e,     /* 0x3E greater:        greater-than sign            */
    0x003f,     /* 0x3F question:       question mark                */
    0x0040,     /* 0x40 at:             commercial at                */
    0x11b7,     /* 0x41 A:              jongseong mieum              */
    0x1172,     /* 0x42 B:              jungseong yu                 */
    0x11be,     /* 0x43 C:              jongseong chieuch            */
    0x11bc,     /* 0x44 D:              jongseong ieung              */
    0x11ae,     /* 0x45 E:              jongseong tikeut             */
    0x11af,     /* 0x46 F:              jongseong rieul              */
    0x11c2,     /* 0x47 G:              jongseong hieuh              */
    0x1169,     /* 0x48 H:              jungseong o                  */
    0x1163,     /* 0x49 I:              jungseong ya                 */
    0x1165,     /* 0x4A J:              jungseong eo                 */
    0x1161,     /* 0x4B K:              jungseong a                  */
    0x1175,     /* 0x4C L:              jungseong i                  */
    0x1173,     /* 0x4D M:              jungseong eu                 */
    0x116e,     /* 0x4E N:              jungseong u                  */
    0x1164,     /* 0x4F O:              jungseong yae                */
    0x1168,     /* 0x50 P:              jungseong ye                 */
    0x11b8,     /* 0x51 Q:              jongseong pieup              */
    0x11a8,     /* 0x52 R:              jongseong kiyeok             */
    0x11ab,     /* 0x53 S:              jongseong nieun              */
    0x11ba,     /* 0x54 T:              jongseong sios               */
    0x1167,     /* 0x55 U:              jungseong yeo                */
    0x11c1,     /* 0x56 V:              jongseong phieuph            */
    0x11bd,     /* 0x57 W:              jongseong cieuc              */
    0x11c0,     /* 0x58 X:              jongseong thieuth            */
    0x116d,     /* 0x59 Y:              jungseong yo                 */
    0x11bf,     /* 0x5A Z:              jongseong khieukh            */
    0x005b,     /* 0x5B bracketleft:    left bracket                 */
    0x005c,     /* 0x5C backslash:      backslash                    */
    0x005d,     /* 0x5D bracketright:   right bracket                */
    0x005e,     /* 0x5E asciicircum:    circumflex accent            */
    0x005f,     /* 0x5F underscore:     underscore                   */
    0x0060,     /* 0x60 quoteleft:      grave accent                 */
    0x1106,     /* 0x61 a:              choseong  mieum              */
    0x1172,     /* 0x62 b:              jungseong yu                 */
    0x110e,     /* 0x63 c:              choseong  chieuch            */
    0x110b,     /* 0x64 d:              choseong  ieung              */
    0x1103,     /* 0x65 e:              choseong  tikeut             */
    0x1105,     /* 0x66 f:              choseong  rieul              */
    0x1112,     /* 0x67 g:              choseong  hieuh              */
    0x1169,     /* 0x68 h:              jungseong o                  */
    0x1163,     /* 0x69 i:              jungseong ya                 */
    0x1165,     /* 0x6A j:              jungseong eo                 */
    0x1161,     /* 0x6B k:              jungseong a                  */
    0x1175,     /* 0x6C l:              jungseong i                  */
    0x1173,     /* 0x6D m:              jungseong eu                 */
    0x116e,     /* 0x6E n:              jungseong u                  */
    0x1162,     /* 0x6F o:              jungseong ae                 */
    0x1166,     /* 0x70 p:              jungseong e                  */
    0x1107,     /* 0x71 q:              choseong  pieup              */
    0x1100,     /* 0x72 r:              choseong  kiyeok             */
    0x1102,     /* 0x73 s:              choseong  nieun              */
    0x1109,     /* 0x74 t:              choseong  sios               */
    0x1167,     /* 0x75 u:              jungseong yeo                */
    0x1111,     /* 0x76 v:              choseong  phieuph            */
    0x110c,     /* 0x77 w:              choseong  cieuc              */
    0x1110,     /* 0x78 x:              choseong  thieuth            */
    0x116d,     /* 0x79 y:              jungseong yo                 */
    0x110f,     /* 0x7A z:              choseong  khieukh            */
    0x007b,     /* 0x7B braceleft:      left brace                   */
    0x007c,     /* 0x7C bar:            vertical bar                 */
    0x007d,     /* 0x7D braceright:     right brace                  */
    0x203b,     /* 0x7E asciitilde:     tilde                        */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_390[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x11bd,     /* 0x21 exclam:         jongseong cieuc              */
    0x0022,     /* 0x22 quotedbl:       quotatioin mark              */
    0x0023,     /* 0x23 numbersign:     number sign                  */
    0x0024,     /* 0x24 dollar:         dollar sign                  */
    0x0025,     /* 0x25 percent:        percent sign                 */
    0x0026,     /* 0x26 ampersand:      ampersand                    */
    0x1110,     /* 0x27 apostrophe:     choseong thieuth             */
    0x0028,     /* 0x28 parenleft:      left parenthesis             */
    0x0029,     /* 0x29 parenright:     right parenthesis            */
    0x002a,     /* 0x2A asterisk:       asterisk                     */
    0x002b,     /* 0x2B plus:           plus sign                    */
    0x002c,     /* 0x2C comma:          comma                        */
    0x002d,     /* 0x2D minus:          minus sign                   */
    0x002e,     /* 0x2E period:         period                       */
    0x1169,     /* 0x2F slash:          jungseong o                  */
    0x110f,     /* 0x30 0:              choseong  khieukh            */
    0x11c2,     /* 0x31 1:              jongseong hieuh              */
    0x11bb,     /* 0x32 2:              jongseong ssangsios          */
    0x11b8,     /* 0x33 3:              jongseong pieup              */
    0x116d,     /* 0x34 4:              jungseong yo                 */
    0x1172,     /* 0x35 5:              jungseong yu                 */
    0x1163,     /* 0x36 6:              jungseong ya                 */
    0x1168,     /* 0x37 7:              jungseong ye                 */
    0x1174,     /* 0x38 8:              jungseong yi                 */
    0x116e,     /* 0x39 9:              jungseong u                  */
    0x003a,     /* 0x3A colon:          colon                        */
    0x1107,     /* 0x3B semicolon:      choseong  pieup              */
    0x0032,     /* 0x3C less:           2                            */
    0x003d,     /* 0x3D equal:          euals sign                   */
    0x0033,     /* 0x3E greater:        3                            */
    0x003f,     /* 0x3F question:       question mark                */
    0x0040,     /* 0x40 at:             commertial at                */
    0x11ae,     /* 0x41 A:              jongseong tikeut             */
    0x0021,     /* 0x42 B:              exclamation mark             */
    0x11b1,     /* 0x43 C:              jongseong rieul-mieum        */
    0x11b0,     /* 0x44 D:              jongseong rieul-kiyeok       */
    0x11bf,     /* 0x45 E:              jongseong khieukh            */
    0x11a9,     /* 0x46 F:              jongseong ssangkiyeok        */
    0x002f,     /* 0x47 G:              slash                        */
    0x0027,     /* 0x48 H:              apostrophe                   */
    0x0038,     /* 0x49 I:              8                            */
    0x0034,     /* 0x4A J:              4                            */
    0x0035,     /* 0x4B K:              5                            */
    0x0036,     /* 0x4C L:              6                            */
    0x0031,     /* 0x4D M:              1                            */
    0x0030,     /* 0x4E N:              0                            */
    0x0039,     /* 0x4F O:              9                            */
    0x003e,     /* 0x50 P:              greater-than sign            */
    0x11c1,     /* 0x51 Q:              jongseong phieuph            */
    0x1164,     /* 0x52 R:              jungseong yae                */
    0x11ad,     /* 0x53 S:              jongseong nieun-hieuh        */
    0x003b,     /* 0x54 T:              semicolon                    */
    0x0037,     /* 0x55 U:              7                            */
    0x11b6,     /* 0x56 V:              jongseong rieul-hieuh        */
    0x11c0,     /* 0x57 W:              jongseong thikeuth           */
    0x11b9,     /* 0x58 X:              jongseong pieup-sios         */
    0x003c,     /* 0x59 Y:              less-than sign               */
    0x11be,     /* 0x5A Z:              jongseong chieuch            */
    0x005b,     /* 0x5B bracketleft:    left bracket                 */
    0x005c,     /* 0x5C backslash:      backslash                    */
    0x005d,     /* 0x5D bracketright:   right bracket                */
    0x005e,     /* 0x5E asciicircum:    circumflex accent            */
    0x005f,     /* 0x5F underscore:     underscore                   */
    0x0060,     /* 0x60 quoteleft:      grave accent                 */
    0x11bc,     /* 0x61 a:              jongseong ieung              */
    0x116e,     /* 0x62 b:              jungseong u                  */
    0x1166,     /* 0x63 c:              jungseong e                  */
    0x1175,     /* 0x64 d:              jungseong i                  */
    0x1167,     /* 0x65 e:              jungseong yeo                */
    0x1161,     /* 0x66 f:              jungseong a                  */
    0x1173,     /* 0x67 g:              jungseong eu                 */
    0x1102,     /* 0x68 h:              choseong  nieun              */
    0x1106,     /* 0x69 i:              choseong  mieum              */
    0x110b,     /* 0x6A j:              choseong  ieung              */
    0x1100,     /* 0x6B k:              choseong  kiyeok             */
    0x110c,     /* 0x6C l:              choseong  cieuc              */
    0x1112,     /* 0x6D m:              choseong  hieuh              */
    0x1109,     /* 0x6E n:              choseong  sios               */
    0x110e,     /* 0x6F o:              choseong  chieuch            */
    0x1111,     /* 0x70 p:              choseong  phieuph            */
    0x11ba,     /* 0x71 q:              jongseong sios               */
    0x1162,     /* 0x72 r:              jungseong ae                 */
    0x11ab,     /* 0x73 s:              jongseong nieun              */
    0x1165,     /* 0x74 t:              jungseong eo                 */
    0x1103,     /* 0x75 u:              choseong  tikeut             */
    0x1169,     /* 0x76 v:              jungseong o                  */
    0x11af,     /* 0x77 w:              jongseong rieul              */
    0x11a8,     /* 0x78 x:              jongseong kiyeok             */
    0x1105,     /* 0x79 y:              choseong  rieul              */
    0x11b7,     /* 0x7A z:              jongseong mieum              */
    0x007b,     /* 0x7B braceleft:      left brace                   */
    0x007c,     /* 0x7C bar:            vertical line(bar)           */
    0x007d,     /* 0x7D braceright:     right brace                  */
    0x007e,     /* 0x7E asciitilde:     tilde                        */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_3final[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x11a9,     /* 0x21 exclam:         jongseong ssangkiyeok        */
    0x00b7,     /* 0x22 quotedbl:       middle dot                   */
    0x11bd,     /* 0x23 numbersign:     jognseong cieuc              */
    0x11b5,     /* 0x24 dollar:         jongseong rieul-phieuph      */
    0x11b4,     /* 0x25 percent:        jongseong rieul-thieuth      */
    0x201c,     /* 0x26 ampersand:      left double quotation mark   */
    0x1110,     /* 0x27 apostrophe:     choseong  thieuth            */
    0x0027,     /* 0x28 parenleft:      apostrophe                   */
    0x007e,     /* 0x29 parenright:     Tilde                        */
    0x201d,     /* 0x2A asterisk:       right double quotation mark  */
    0x002b,     /* 0x2B plus:           plus sign                    */
    0x002c,     /* 0x2C comma:          comma                        */
    0x0029,     /* 0x2D minus:          right parenthesis            */
    0x002e,     /* 0x2E period:         period                       */
    0x1169,     /* 0x2F slash:          jungseong o                  */
    0x110f,     /* 0x30 0:              choseong  khieukh            */
    0x11c2,     /* 0x31 1:              jongseong hieuh              */
    0x11bb,     /* 0x32 2:              jongseong ssangsios          */
    0x11b8,     /* 0x33 3:              jongseong pieup              */
    0x116d,     /* 0x34 4:              jungseong yo                 */
    0x1172,     /* 0x35 5:              jungseong yu                 */
    0x1163,     /* 0x36 6:              jungseong ya                 */
    0x1168,     /* 0x37 7:              jungseong ye                 */
    0x1174,     /* 0x38 8:              jungseong yi                 */
    0x116e,     /* 0x39 9:              jungseong u                  */
    0x0034,     /* 0x3A colon:          4                            */
    0x1107,     /* 0x3B semicolon:      choseong  pieup              */
    0x002c,     /* 0x3C less:           comma                        */
    0x003e,     /* 0x3D equal:          greater-than sign            */
    0x002e,     /* 0x3E greater:        period                       */
    0x0021,     /* 0x3F question:       exclamation mark             */
    0x11b0,     /* 0x40 at:             jongseong rieul-kiyeok       */
    0x11ae,     /* 0x41 A:              jongseong tikeut             */
    0x003f,     /* 0x42 B:              question mark                */
    0x11bf,     /* 0x43 C:              jongseong khieukh            */
    0x11b2,     /* 0x44 D:              jongseong rieul-pieup        */
    0x11ac,     /* 0x45 E:              jongseong nieun-cieuc        */
    0x11b1,     /* 0x46 F:              jongseong rieul-mieum        */
    0x1164,     /* 0x47 G:              jungseong yae                */
    0x0030,     /* 0x48 H:              0                            */
    0x0037,     /* 0x49 I:              7                            */
    0x0031,     /* 0x4A J:              1                            */
    0x0032,     /* 0x4B K:              2                            */
    0x0033,     /* 0x4C L:              3                            */
    0x0022,     /* 0x4D M:              double quotation mark        */
    0x002d,     /* 0x4E N:              minus sign                   */
    0x0038,     /* 0x4F O:              8                            */
    0x0039,     /* 0x50 P:              9                            */
    0x11c1,     /* 0x51 Q:              jongseong phieuph            */
    0x11b6,     /* 0x52 R:              jongseong rieul-hieuh        */
    0x11ad,     /* 0x53 S:              jongseong nieun-hieuh        */
    0x11b3,     /* 0x54 T:              jongseong rieul-sios         */
    0x0036,     /* 0x55 U:              6                            */
    0x11aa,     /* 0x56 V:              jongseong kiyeok-sios        */
    0x11c0,     /* 0x57 W:              jongseong thikeuth           */
    0x11b9,     /* 0x58 X:              jongseong pieup-sios         */
    0x0035,     /* 0x59 Y:              5                            */
    0x11be,     /* 0x5A Z:              jongseong chieuch            */
    0x0028,     /* 0x5B bracketleft:    left parenthesis             */
    0x003a,     /* 0x5C backslash:      colon                        */
    0x003c,     /* 0x5D bracketright:   less-than sign               */
    0x003d,     /* 0x5E asciicircum:    equals sign                  */
    0x003b,     /* 0x5F underscore:     semicolon                    */
    0x002a,     /* 0x60 quoteleft:      asterisk                     */
    0x11bc,     /* 0x61 a:              jongseong ieung              */
    0x116e,     /* 0x62 b:              jungseong u                  */
    0x1166,     /* 0x63 c:              jungseong e                  */
    0x1175,     /* 0x64 d:              jungseong i                  */
    0x1167,     /* 0x65 e:              jungseong yeo                */
    0x1161,     /* 0x66 f:              jungseong a                  */
    0x1173,     /* 0x67 g:              jungseong eu                 */
    0x1102,     /* 0x68 h:              choseong  nieun              */
    0x1106,     /* 0x69 i:              choseong  mieum              */
    0x110b,     /* 0x6A j:              choseong  ieung              */
    0x1100,     /* 0x6B k:              choseong  kiyeok             */
    0x110c,     /* 0x6C l:              choseong  cieuc              */
    0x1112,     /* 0x6D m:              choseong  hieuh              */
    0x1109,     /* 0x6E n:              choseong  sios               */
    0x110e,     /* 0x6F o:              choseong  chieuch            */
    0x1111,     /* 0x70 p:              choseong  phieuph            */
    0x11ba,     /* 0x71 q:              jongseong sios               */
    0x1162,     /* 0x72 r:              jungseong ae                 */
    0x11ab,     /* 0x73 s:              jongseong nieun              */
    0x1165,     /* 0x74 t:              jungseong eo                 */
    0x1103,     /* 0x75 u:              choseong  tikeut             */
    0x1169,     /* 0x76 v:              jungseong o                  */
    0x11af,     /* 0x77 w:              jongseong rieul              */
    0x11a8,     /* 0x78 x:              jongseong kiyeok             */
    0x1105,     /* 0x79 y:              choseong  rieul              */
    0x11b7,     /* 0x7A z:              jongseong mieum              */
    0x0025,     /* 0x7B braceleft:      percent sign                 */
    0x005c,     /* 0x7C bar:            backslash                    */
    0x002f,     /* 0x7D braceright:     slash                        */
    0x203b,     /* 0x7E asciitilde:     reference mark               */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_3sun[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x0021,     /* 0x21 exclam:         exclamation mark             */
    0x0022,     /* 0x22 quotedbl:       quotatioin mark              */
    0x0023,     /* 0x23 numbersign:     number sign                  */
    0x0024,     /* 0x24 dollar:         dollar sign                  */
    0x0025,     /* 0x25 percent:        percent sign                 */
    0x0026,     /* 0x26 ampersand:      ampersand                    */
    0x1110,     /* 0x27 apostrophe:     choseong thieuth             */
    0x0028,     /* 0x28 parenleft:      left parenthesis             */
    0x0029,     /* 0x29 parenright:     right parenthesis            */
    0x002a,     /* 0x2A asterisk:       asterisk                     */
    0x002b,     /* 0x2B plus:           plus sign                    */
    0x002c,     /* 0x2C comma:          comma                        */
    0x11bd,     /* 0x2D minus:          jongseong cieuc              */
    0x002e,     /* 0x2E period:         period                       */
    0x11ae,     /* 0x2F slash:          jongseong tikeut             */
    0x1164,     /* 0x30 0:              choseong  yae                */
    0x11c2,     /* 0x31 1:              jongseong hieuh              */
    0x11bb,     /* 0x32 2:              jongseong ssangsios          */
    0x11b8,     /* 0x33 3:              jongseong pieup              */
    0x116d,     /* 0x34 4:              jungseong yo                 */
    0x1172,     /* 0x35 5:              jungseong yu                 */
    0x1163,     /* 0x36 6:              jungseong ya                 */
    0x1168,     /* 0x37 7:              jungseong ye                 */
    0x1174,     /* 0x38 8:              jungseong yi                 */
    0x110f,     /* 0x39 9:              choseong khieukh             */
    0x003a,     /* 0x3A colon:          colon                        */
    0x1107,     /* 0x3B semicolon:      choseong  pieup              */
    0x0032,     /* 0x3C less:           2                            */
    0x11be,     /* 0x3D equal:          jongseong chieuch            */
    0x0033,     /* 0x3E greater:        3                            */
    0x003f,     /* 0x3F question:       question mark                */
    0x0040,     /* 0x40 at:             commertial at                */
    0x11bc,     /* 0x41 A:              jongseong ieung              */
    0x0021,     /* 0x42 B:              exclamation mark             */
    0x005c,     /* 0x43 C:              backslash                    */
    0x005d,     /* 0x44 D:              right bracket                */
    0x1167,     /* 0x45 E:              jungseong yeo                */
    0x1161,     /* 0x46 F:              jungseong a                  */
    0x002f,     /* 0x47 G:              slash                        */
    0x0027,     /* 0x48 H:              apostrophe                   */
    0x0038,     /* 0x49 I:              8                            */
    0x0034,     /* 0x4A J:              4                            */
    0x0035,     /* 0x4B K:              5                            */
    0x0036,     /* 0x4C L:              6                            */
    0x0031,     /* 0x4D M:              1                            */
    0x0030,     /* 0x4E N:              0                            */
    0x0039,     /* 0x4F O:              9                            */
    0x003e,     /* 0x50 P:              greater-than sign            */
    0x11ba,     /* 0x51 Q:              jongseong sios               */
    0x1162,     /* 0x52 R:              jungseong ae                 */
    0x005b,     /* 0x53 S:              left bracket                 */
    0x003b,     /* 0x54 T:              semicolon                    */
    0x0037,     /* 0x55 U:              7                            */
    0x1169,     /* 0x56 V:              jungseong o                  */
    0x11af,     /* 0x57 W:              jongseong rieul              */
    0x003d,     /* 0x58 X:              equals sign                  */
    0x003c,     /* 0x59 Y:              less-than sign               */
    0x002d,     /* 0x5A Z:              minus sign                   */
    0x11c0,     /* 0x5B bracketleft:    jongseong thieuth            */
    0x11bf,     /* 0x5C backslash:      jongseong khieukh            */
    0x11c1,     /* 0x5D bracketright:   jongseong phieuph            */
    0x005e,     /* 0x5E asciicircum:    circumflex accent            */
    0x005f,     /* 0x5F underscore:     underscore                   */
    0x0060,     /* 0x60 quoteleft:      grave accent                 */
    0x11bc,     /* 0x61 a:              jongseong ieung              */
    0x116e,     /* 0x62 b:              jungseong u                  */
    0x1166,     /* 0x63 c:              jungseong e                  */
    0x1175,     /* 0x64 d:              jungseong i                  */
    0x1167,     /* 0x65 e:              jungseong yeo                */
    0x1161,     /* 0x66 f:              jungseong a                  */
    0x1173,     /* 0x67 g:              jungseong eu                 */
    0x1102,     /* 0x68 h:              choseong  nieun              */
    0x1106,     /* 0x69 i:              choseong  mieum              */
    0x110b,     /* 0x6A j:              choseong  ieung              */
    0x1100,     /* 0x6B k:              choseong  kiyeok             */
    0x110c,     /* 0x6C l:              choseong  cieuc              */
    0x1112,     /* 0x6D m:              choseong  hieuh              */
    0x1109,     /* 0x6E n:              choseong  sios               */
    0x110e,     /* 0x6F o:              choseong  chieuch            */
    0x1111,     /* 0x70 p:              choseong  phieuph            */
    0x11ba,     /* 0x71 q:              jongseong sios               */
    0x1162,     /* 0x72 r:              jungseong ae                 */
    0x11ab,     /* 0x73 s:              jongseong nieun              */
    0x1165,     /* 0x74 t:              jungseong eo                 */
    0x1103,     /* 0x75 u:              choseong  tikeut             */
    0x1169,     /* 0x76 v:              jungseong o                  */
    0x11af,     /* 0x77 w:              jongseong rieul              */
    0x11a8,     /* 0x78 x:              jongseong kiyeok             */
    0x1105,     /* 0x79 y:              choseong  rieul              */
    0x11b7,     /* 0x7A z:              jongseong mieum              */
    0x007b,     /* 0x7B braceleft:      left brace                   */
    0x007c,     /* 0x7C bar:            vertical line(bar)           */
    0x007d,     /* 0x7D braceright:     right brace                  */
    0x007e,     /* 0x7E asciitilde:     tilde                        */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_3yet[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x11bd,     /* 0x21 exclam:         jongseong cieuc              */
    0x0022,     /* 0x22 quotedbl:       quotatioin mark              */
    0x0023,     /* 0x23 numbersign:     number sign                  */
    0x0024,     /* 0x24 dollar:         dollar sign                  */
    0x0025,     /* 0x25 percent:        percent sign                 */
    0x0026,     /* 0x26 ampersand:      ampersand                    */
    0x1110,     /* 0x27 apostrophe:     choseong thieuth             */
    0x0028,     /* 0x28 parenleft:      left parenthesis             */
    0x0029,     /* 0x29 parenright:     right parenthesis            */
    0x002a,     /* 0x2A asterisk:       asterisk                     */
    0x002b,     /* 0x2B plus:           plus sign                    */
    0x002c,     /* 0x2C comma:          comma                        */
    0x002d,     /* 0x2D minus:          minus sign                   */
    0x002e,     /* 0x2E period:         period                       */
    0x1169,     /* 0x2F slash:          jungseong o                  */
    0x110f,     /* 0x30 0:              choseong  khieukh            */
    0x11c2,     /* 0x31 1:              jongseong hieuh              */
    0x11bb,     /* 0x32 2:              jongseong ssangsios          */
    0x11b8,     /* 0x33 3:              jongseong pieup              */
    0x116d,     /* 0x34 4:              jungseong yo                 */
    0x1172,     /* 0x35 5:              jungseong yu                 */
    0x1163,     /* 0x36 6:              jungseong ya                 */
    0x1168,     /* 0x37 7:              jungseong ye                 */
    0x1174,     /* 0x38 8:              jungseong yi                 */
    0x116e,     /* 0x39 9:              jungseong u                  */
    0x003a,     /* 0x3A colon:          colon                        */
    0x1107,     /* 0x3B semicolon:      choseong  pieup              */
    0x113c,     /* 0x3C less:           choseong chitueumsios        */
    0x003d,     /* 0x3D equal:          euals sign                   */
    0x113e,     /* 0x3E greater:        choseong ceongchieumsios     */
    0x003f,     /* 0x3F question:       question mark                */
    0x11eb,     /* 0x40 at:             jongseong pansios            */
    0x11ae,     /* 0x41 A:              jongseong tikeut             */
    0x0021,     /* 0x42 B:              exclamation mark             */
    0x11b1,     /* 0x43 C:              jongseong rieul-mieum        */
    0x11b0,     /* 0x44 D:              jongseong rieul-kiyeok       */
    0x11bf,     /* 0x45 E:              jongseong khieukh            */
    0x11a9,     /* 0x46 F:              jongseong ssangkiyeok        */
    0x119e,     /* 0x47 G:              jungseong araea              */
    0x0027,     /* 0x48 H:              apostrophe                   */
    0x1154,     /* 0x49 I:              choseong chitueumchieuch     */
    0x114c,     /* 0x4A J:              choseong yesieung            */
    0x114e,     /* 0x4B K:              choseong chitueumcieuc       */
    0x1150,     /* 0x4C L:              choseong ceongchieumcieuc    */
    0x1159,     /* 0x4D M:              choseong yeorinhieuh         */
    0x1140,     /* 0x4E N:              choseong pansios             */
    0x1155,     /* 0x4F O:              choseong ceongchieumchieuch  */
    0x003e,     /* 0x50 P:              greater-than sign            */
    0x11c1,     /* 0x51 Q:              jongseong phieuph            */
    0x1164,     /* 0x52 R:              jungseong yae                */
    0x11ad,     /* 0x53 S:              jongseong nieun-hieuh        */
    0x003b,     /* 0x54 T:              semicolon                    */
    0x00b7,     /* 0x55 U:              middle dot                   */
    0x11b6,     /* 0x56 V:              jongseong rieul-hieuh        */
    0x11c0,     /* 0x57 W:              jongseong thikeuth           */
    0x11b9,     /* 0x58 X:              jongseong pieup-sios         */
    0x003c,     /* 0x59 Y:              less-than sign               */
    0x11be,     /* 0x5A Z:              jongseong chieuch            */
    0x005b,     /* 0x5B bracketleft:    left bracket                 */
    0x005c,     /* 0x5C backslash:      backslash                    */
    0x005d,     /* 0x5D bracketright:   right bracket                */
    0x114c,     /* 0x5E asciicircum:    choseong yesieung            */
    0x005f,     /* 0x5F underscore:     underscore                   */
    0x11f9,     /* 0x60 quoteleft:      jongseong yeorinhieuh        */
    0x11bc,     /* 0x61 a:              jongseong ieung              */
    0x116e,     /* 0x62 b:              jungseong u                  */
    0x1166,     /* 0x63 c:              jungseong e                  */
    0x1175,     /* 0x64 d:              jungseong i                  */
    0x1167,     /* 0x65 e:              jungseong yeo                */
    0x1161,     /* 0x66 f:              jungseong a                  */
    0x1173,     /* 0x67 g:              jungseong eu                 */
    0x1102,     /* 0x68 h:              choseong  nieun              */
    0x1106,     /* 0x69 i:              choseong  mieum              */
    0x110b,     /* 0x6A j:              choseong  ieung              */
    0x1100,     /* 0x6B k:              choseong  kiyeok             */
    0x110c,     /* 0x6C l:              choseong  cieuc              */
    0x1112,     /* 0x6D m:              choseong  hieuh              */
    0x1109,     /* 0x6E n:              choseong  sios               */
    0x110e,     /* 0x6F o:              choseong  chieuch            */
    0x1111,     /* 0x70 p:              choseong  phieuph            */
    0x11ba,     /* 0x71 q:              jongseong sios               */
    0x1162,     /* 0x72 r:              jungseong ae                 */
    0x11ab,     /* 0x73 s:              jongseong nieun              */
    0x1165,     /* 0x74 t:              jungseong eo                 */
    0x1103,     /* 0x75 u:              choseong  tikeut             */
    0x1169,     /* 0x76 v:              jungseong o                  */
    0x11af,     /* 0x77 w:              jongseong rieul              */
    0x11a8,     /* 0x78 x:              jongseong kiyeok             */
    0x1105,     /* 0x79 y:              choseong  rieul              */
    0x11b7,     /* 0x7A z:              jongseong mieum              */
    0x007b,     /* 0x7B braceleft:      left brace                   */
    0x007c,     /* 0x7C bar:            vertical line(bar)           */
    0x007d,     /* 0x7D braceright:     right brace                  */
    0x11f0,     /* 0x7E asciitilde:     jongseong yesieung           */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_romaja[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x0021,     /* 0x21 exclam:       exclamation mark               */
    0x0022,     /* 0x22 quotedbl:     quotation mark                 */
    0x0023,     /* 0x23 numbersign:   number sign                    */
    0x0024,     /* 0x24 dollar:       dollar sign                    */
    0x0025,     /* 0x25 percent:      percent sign                   */
    0x0026,     /* 0x26 ampersand:    ampersand                      */
    0x0027,     /* 0x27 apostrophe:   apostrophe                     */
    0x0028,     /* 0x28 parenleft:    left parenthesis               */
    0x0029,     /* 0x29 parenright:   right parenthesis              */
    0x002a,     /* 0x2A asterisk:     asterisk                       */
    0x002b,     /* 0x2B plus:         plus sign                      */
    0x002c,     /* 0x2C comma:        comma                          */
    0x002d,     /* 0x2D minus:        minus sign                     */
    0x002e,     /* 0x2E period:       period                         */
    0x002f,     /* 0x2F slash:        slash                          */
    0x0030,     /* 0x30 0:            0                              */
    0x0031,     /* 0x31 1:            1                              */
    0x0032,     /* 0x32 2:            2                              */
    0x0033,     /* 0x33 3:            3                              */
    0x0034,     /* 0x34 4:            4                              */
    0x0035,     /* 0x35 5:            5                              */
    0x0036,     /* 0x36 6:            6                              */
    0x0037,     /* 0x37 7:            7                              */
    0x0038,     /* 0x38 8:            8                              */
    0x0039,     /* 0x39 9:            9                              */
    0x003a,     /* 0x3A colon:        colon                          */
    0x003b,     /* 0x3B semicolon:    semicolon                      */
    0x003c,     /* 0x3C less:         less-than sign                 */
    0x003d,     /* 0x3D equal:        equals sign                    */
    0x003e,     /* 0x3E greater:      greater-than sign              */
    0x003f,     /* 0x3F question:     question mark                  */
    0x0040,     /* 0x40 at:           commercial at                  */
    0x1161,     /* 0x41 A:            jungseong a                    */
    0x1107,     /* 0x42 B:            choseong  pieup                */
    0x110e,     /* 0x43 C:            choseong  chieuch              */
    0x1103,     /* 0x44 D:            choseong  tikeut               */
    0x1166,     /* 0x45 E:            jungseong e                    */
    0x1111,     /* 0x46 F:            choseong  phieuph              */
    0x1100,     /* 0x47 G:            choseong  kiyeok               */
    0x1112,     /* 0x48 H:            choseong  heiuh                */
    0x1175,     /* 0x49 I:            jungseong i                    */
    0x110c,     /* 0x4A J:            choseong  cieuc                */
    0x110f,     /* 0x4B K:            choseong  khieukh              */
    0x1105,     /* 0x4C L:            choseong  rieul                */
    0x1106,     /* 0x4D M:            choseong  mieum                */
    0x1102,     /* 0x4E N:            choseong  nieun                */
    0x1169,     /* 0x4F O:            jungseong o                    */
    0x1111,     /* 0x50 P:            choseong  phieuph              */
    0x110f,     /* 0x51 Q:            choseong  khieukh              */
    0x1105,     /* 0x52 R:            choseong  rieul                */
    0x1109,     /* 0x53 S:            choseong  sios                 */
    0x1110,     /* 0x54 T:            choseong  thieuth              */
    0x116e,     /* 0x55 U:            jungseong u                    */
    0x1107,     /* 0x56 V:            choseong  pieup                */
    0x116e,     /* 0x57 W:            jungseong u                    */
    0x110c,     /* 0x58 X:            choseong  cieuc                */
    0x1175,     /* 0x59 Y:            jungseong i                    */
    0x110c,     /* 0x5A Z:            choseong  cieuc                */
    0x005b,     /* 0x5B bracketleft:  left bracket                   */
    0x005c,     /* 0x5C backslash:    backslash                      */
    0x005d,     /* 0x5D bracketright: right bracket                  */
    0x005e,     /* 0x5E asciicircum:  circumflex accent              */
    0x005f,     /* 0x5F underscore:   underscore                     */
    0x0060,     /* 0x60 quoteleft:    grave accent                   */
    0x1161,     /* 0x61 a:            jungseong a                    */
    0x1107,     /* 0x62 b:            choseong  pieup                */
    0x110e,     /* 0x63 c:            choseong  chieuch              */
    0x1103,     /* 0x64 d:            choseong  tikeut               */
    0x1166,     /* 0x65 e:            jungseong e                    */
    0x1111,     /* 0x66 f:            choseong  phieuph              */
    0x1100,     /* 0x67 g:            choseong  kiyeok               */
    0x1112,     /* 0x68 h:            choseong  hieuh                */
    0x1175,     /* 0x69 i:            jungseong i                    */
    0x110c,     /* 0x6A j:            choseong  cieuc                */
    0x110f,     /* 0x6B k:            choseong  khieukh              */
    0x1105,     /* 0x6C l:            choseong  rieul                */
    0x1106,     /* 0x6D m:            choseong  mieum                */
    0x1102,     /* 0x6E n:            choseong  nieun                */
    0x1169,     /* 0x6F o:            jungseong o                    */
    0x1111,     /* 0x70 p:            choseong  pieup                */
    0x110f,     /* 0x71 q:            choseong  khieukh              */
    0x1105,     /* 0x72 r:            choseong  rieul                */
    0x1109,     /* 0x73 s:            choseong  sios                 */
    0x1110,     /* 0x74 t:            choseong  thieuth              */
    0x116e,     /* 0x75 u:            jungseong u                    */
    0x1107,     /* 0x76 v:            choseong  phieuph              */
    0x116e,     /* 0x77 w:            jungseong u                    */
    0x11aa,     /* 0x78 x:            jongseong kiyeoksios           */
    0x1175,     /* 0x79 y:            jungseong i                    */
    0x110c,     /* 0x7A z:            choseong  cieuc                */
    0x007b,     /* 0x7B braceleft:    left brace                     */
    0x007c,     /* 0x7C bar:          vertical bar                   */
    0x007d,     /* 0x7D braceright:   right brace                    */
    0x007e,     /* 0x7E asciitilde:   tilde                          */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_ahn[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x0021,     /* 0x21 exclam:       exclamation mark               */
    0x0022,     /* 0x22 quotedbl:     quotation mark                 */
    0x0023,     /* 0x23 numbersign:   number sign                    */
    0x0024,     /* 0x24 dollar:       dollar sign                    */
    0x0025,     /* 0x25 percent:      percent sign                   */
    0x0026,     /* 0x26 ampersand:    ampersand                      */
    0x002e,     /* 0x27 apostrophe:   period                         */
    0x0028,     /* 0x28 parenleft:    left parenthesis               */
    0x0029,     /* 0x29 parenright:   right parenthesis              */
    0x002a,     /* 0x2A asterisk:     asterisk                       */
    0x002b,     /* 0x2B plus:         plus sign                      */
    0x11b7,     /* 0x2C comma:        jongseong mieum                */
    0x002d,     /* 0x2D minus:        minus sign                     */
    0x11af,     /* 0x2E period:       jongseong rieul                */
    0x11c2,     /* 0x2F slash:        jongseong hieuh                */
    0x0030,     /* 0x30 0:            0                              */
    0x0031,     /* 0x31 1:            1                              */
    0x0032,     /* 0x32 2:            2                              */
    0x0033,     /* 0x33 3:            3                              */
    0x0034,     /* 0x34 4:            4                              */
    0x0035,     /* 0x35 5:            5                              */
    0x0036,     /* 0x36 6:            6                              */
    0x0037,     /* 0x37 7:            7                              */
    0x0038,     /* 0x38 8:            8                              */
    0x0039,     /* 0x39 9:            9                              */
    0x003a,     /* 0x3A colon:        colon                          */
    0x116e,     /* 0x3B semicolon:    jungseong u                    */
    0x003c,     /* 0x3C less:         less-than sign                 */
    0x003d,     /* 0x3D equal:        equals sign                    */
    0x003e,     /* 0x3E greater:      greater-than sign              */
    0x11f9,     /* 0x3F question:     jongseong yeorinhieuh          */
    0x0040,     /* 0x40 at:           commercial at                  */
    0x1107,     /* 0x41 A:            choseong pieup                 */
    0x11f0,     /* 0x42 B:            jongseong yesieung             */
    0x11b8,     /* 0x43 C:            jongseong pieup                */
    0x1103,     /* 0x44 D:            choseong tikeut                */
    0x1102,     /* 0x45 E:            choseong nieun                 */
    0x1100,     /* 0x46 F:            choseong kiyeok                */
    0x114c,     /* 0x47 G:            choseong yesieung              */
    0x1165,     /* 0x48 H:            jungseong eo                   */
    0x002f,     /* 0x49 I:            slash                          */
    0x119e,     /* 0x4A J:            jungseong araea                */
    0x1175,     /* 0x4B K:            jungseong i                    */
    0x1169,     /* 0x4C L:            jungseong o                    */
    0x11ab,     /* 0x4D M:            jongseong nienu                */
    0x11eb,     /* 0x4E N:            jongseung pansios              */
    0x005b,     /* 0x4F O:            left bracket                   */
    0x005d,     /* 0x50 P:            right bracket                  */
    0x1106,     /* 0x51 Q:            choseong mieum                 */
    0x1105,     /* 0x52 R:            choseong rieul                 */
    0x110c,     /* 0x53 S:            choseong cieuc                 */
    0x1159,     /* 0x54 T:            choseong yeorinhieuh           */
    0x0027,     /* 0x55 U:            apostrophe                     */
    0x11a8,     /* 0x56 V:            jongseong kiyeok               */
    0x1140,     /* 0x57 W:            choseong pansios               */
    0x11ae,     /* 0x58 X:            jongseong tikeut               */
    0x003b,     /* 0x59 Y:            semicolon                      */
    0x11bd,     /* 0x5A Z:            jongseong cieuc                */
    0x002c,     /* 0x5B bracketleft:  comma                          */
    0x005c,     /* 0x5C backslash:    backslash                      */
    0x003f,     /* 0x5D bracketright: qustion mark                   */
    0x005e,     /* 0x5E asciicircum:  circumflex accent              */
    0x005f,     /* 0x5F underscore:   underscore                     */
    0x0060,     /* 0x60 quoteleft:    grave accent                   */
    0x1107,     /* 0x61 a:            choseong  pieup                */
    0x11bc,     /* 0x62 b:            jongseong ieung                */
    0x11b8,     /* 0x63 c:            jongseong pieup                */
    0x1103,     /* 0x64 d:            choseong  tikeut               */
    0x1102,     /* 0x65 e:            choseong nieun                 */
    0x1100,     /* 0x66 f:            choseong kiyeok                */
    0x110b,     /* 0x67 g:            choseong ieung                 */
    0x1165,     /* 0x68 h:            jungseong eo                   */
    0x1173,     /* 0x69 i:            jungseong eu                   */
    0x1161,     /* 0x6A j:            jungseong a                    */
    0x1175,     /* 0x6B k:            jungseong i                    */
    0x1169,     /* 0x6C l:            jungseong o                    */
    0x11ab,     /* 0x6D m:            jongseong nieun                */
    0x11ba,     /* 0x6E n:            jongseong sios                 */
    0x116d,     /* 0x6F o:            jungseong yo                   */
    0x1172,     /* 0x70 p:            jungseong yu                   */
    0x1106,     /* 0x71 q:            choseong mieum                 */
    0x1105,     /* 0x72 r:            choseong rieul                 */
    0x110c,     /* 0x73 s:            choseong cieuc                 */
    0x1112,     /* 0x74 t:            choseong hieuh                 */
    0x1163,     /* 0x75 u:            jungseong ya                   */
    0x11a8,     /* 0x76 v:            jongseong kiyok                */
    0x1109,     /* 0x77 w:            choseong sios                  */
    0x11ae,     /* 0x78 x:            jongseong tikeut               */
    0x1167,     /* 0x79 y:            jungseong yeo                  */
    0x11bd,     /* 0x7A z:            jongseong cieuc                */
    0x007b,     /* 0x7B braceleft:    left brace                     */
    0x007c,     /* 0x7C bar:          vertical bar                   */
    0x007d,     /* 0x7D braceright:   right brace                    */
    0x007e,     /* 0x7E asciitilde:   tilde                          */
    0x0000      /* 0x7F delete                                       */
};

static const HangulCombinationItem hangul_combination_table_default[] = {
  { 0x11001100, 0x1101 }, /* choseong  kiyeok + kiyeok  = ssangkiyeok   */
  { 0x11031103, 0x1104 }, /* choseong  tikeut + tikeut  = ssangtikeut   */
  { 0x11071107, 0x1108 }, /* choseong  pieup  + pieup   = ssangpieup    */
  { 0x11091109, 0x110a }, /* choseong  sios   + sios    = ssangsios     */
  { 0x110c110c, 0x110d }, /* choseong  cieuc  + cieuc   = ssangcieuc    */
  { 0x11691161, 0x116a }, /* jungseong o      + a       = wa            */
  { 0x11691162, 0x116b }, /* jungseong o      + ae      = wae           */
  { 0x11691175, 0x116c }, /* jungseong o      + i       = oe            */
  { 0x116e1165, 0x116f }, /* jungseong u      + eo      = weo           */
  { 0x116e1166, 0x1170 }, /* jungseong u      + e       = we            */
  { 0x116e1175, 0x1171 }, /* jungseong u      + i       = wi            */
  { 0x11731175, 0x1174 }, /* jungseong eu     + i       = yi            */
  { 0x11a811a8, 0x11a9 }, /* jongseong kiyeok + kiyeok  = ssangekiyeok  */
  { 0x11a811ba, 0x11aa }, /* jongseong kiyeok + sios    = kiyeok-sois   */
  { 0x11ab11bd, 0x11ac }, /* jongseong nieun  + cieuc   = nieun-cieuc   */
  { 0x11ab11c2, 0x11ad }, /* jongseong nieun  + hieuh   = nieun-hieuh   */
  { 0x11af11a8, 0x11b0 }, /* jongseong rieul  + kiyeok  = rieul-kiyeok  */
  { 0x11af11b7, 0x11b1 }, /* jongseong rieul  + mieum   = rieul-mieum   */
  { 0x11af11b8, 0x11b2 }, /* jongseong rieul  + pieup   = rieul-pieup   */
  { 0x11af11ba, 0x11b3 }, /* jongseong rieul  + sios    = rieul-sios    */
  { 0x11af11c0, 0x11b4 }, /* jongseong rieul  + thieuth = rieul-thieuth */
  { 0x11af11c1, 0x11b5 }, /* jongseong rieul  + phieuph = rieul-phieuph */
  { 0x11af11c2, 0x11b6 }, /* jongseong rieul  + hieuh   = rieul-hieuh   */
  { 0x11b811ba, 0x11b9 }, /* jongseong pieup  + sios    = pieup-sios    */
  { 0x11ba11ba, 0x11bb }, /* jongseong sios   + sios    = ssangsios     */
};

static const HangulCombinationItem hangul_combination_table_romaja[] = {
  { 0x11001100, 0x1101 }, /* choseong  kiyeok + kiyeok  = ssangkiyeok   */
  { 0x11031103, 0x1104 }, /* choseong  tikeut + tikeut  = ssangtikeut   */
  { 0x11071107, 0x1108 }, /* choseong  pieup  + pieup   = ssangpieup    */
  { 0x11091109, 0x110a }, /* choseong  sios   + sios    = ssangsios     */
  { 0x110c110c, 0x110d }, /* choseong  cieuc  + cieuc   = ssangcieuc    */
  { 0x110e1112, 0x110e }, /* choseong  chieuch+ hieuh   = chieuch       */
  { 0x11611166, 0x1162 }, /* jungseong a      + e       = ae            */
  { 0x11611175, 0x1162 }, /* jungseong a      + i       = ae            */
  { 0x11631166, 0x1164 }, /* jungseong ya     + e       = yae           */
  { 0x11631175, 0x1164 }, /* jungseong ya     + i       = yae           */
  { 0x11661169, 0x1165 }, /* jungseong e      + o       = eo            */
  { 0x1166116e, 0x1173 }, /* jungseong e      + u       = eu            */
  { 0x11681169, 0x1167 }, /* jungseong ye     + o       = yeo           */
  { 0x11691161, 0x116a }, /* jungseong o      + a       = wa            */
  { 0x11691162, 0x116b }, /* jungseong o      + ae      = wae           */
  { 0x11691175, 0x116c }, /* jungseong o      + i       = oe            */
  { 0x116a1166, 0x116b }, /* jungseong wa     + e       = wae           */
  { 0x116a1175, 0x116b }, /* jungseong wa     + i       = wae           */
  { 0x116e1161, 0x116a }, /* jungseong u      + a       = wa            */
  { 0x116e1165, 0x116f }, /* jungseong u      + eo      = weo           */
  { 0x116e1166, 0x1170 }, /* jungseong u      + e       = we            */
  { 0x116e1169, 0x116f }, /* jungseong u      + o       = weo           */
  { 0x116e1175, 0x1171 }, /* jungseong u      + i       = wi            */
  { 0x11701169, 0x116f }, /* jungseong we     + o       = weo           */
  { 0x11731175, 0x1174 }, /* jungseong eu     + i       = yi            */
  { 0x11751161, 0x1163 }, /* jungseong i      + a       = ya            */
  { 0x11751162, 0x1164 }, /* jungseong i      + ae      = yae           */
  { 0x11751165, 0x1167 }, /* jungseong i      + eo      = yeo           */
  { 0x11751166, 0x1168 }, /* jungseong i      + e       = ye            */
  { 0x11751169, 0x116d }, /* jungseong i      + o       = yo            */
  { 0x1175116e, 0x1172 }, /* jungseong i      + u       = yu            */
  { 0x11a811a8, 0x11a9 }, /* jongseong kiyeok + kiyeok  = ssangekiyeok  */
  { 0x11a811ba, 0x11aa }, /* jongseong kiyeok + sios    = kiyeok-sois   */
  { 0x11ab11a8, 0x11bc }, /* jongseong nieun  + kiyeok  = ieung         */
  { 0x11ab11bd, 0x11ac }, /* jongseong nieun  + cieuc   = nieun-cieuc   */
  { 0x11ab11c2, 0x11ad }, /* jongseong nieun  + hieuh   = nieun-hieuh   */
  { 0x11af11a8, 0x11b0 }, /* jongseong rieul  + kiyeok  = rieul-kiyeok  */
  { 0x11af11b7, 0x11b1 }, /* jongseong rieul  + mieum   = rieul-mieum   */
  { 0x11af11b8, 0x11b2 }, /* jongseong rieul  + pieup   = rieul-pieup   */
  { 0x11af11ba, 0x11b3 }, /* jongseong rieul  + sios    = rieul-sios    */
  { 0x11af11c0, 0x11b4 }, /* jongseong rieul  + thieuth = rieul-thieuth */
  { 0x11af11c1, 0x11b5 }, /* jongseong rieul  + phieuph = rieul-phieuph */
  { 0x11af11c2, 0x11b6 }, /* jongseong rieul  + hieuh   = rieul-hieuh   */
  { 0x11b811ba, 0x11b9 }, /* jongseong pieup  + sios    = pieup-sios    */
  { 0x11ba11ba, 0x11bb }, /* jongseong sios   + sios    = ssangsios     */
};

static const HangulCombinationItem hangul_combination_table_full[] = {
  { 0x11001100, 0x1101 }, /* choseong kiyeok + kiyeok          = ssangkiyeok */
  { 0x11001103, 0x115a }, /* choseong kiyeok + tikeut          = kiyeok-tikeut */
  { 0x11021100, 0x1113 }, /* choseong nieun + kiyeok           = nieun-kiyeok */
  { 0x11021102, 0x1114 }, /* choseong nieun + nieun            = ssangnieun */
  { 0x11021103, 0x1115 }, /* choseong nieun + tikeut           = nieun-tikeut */
  { 0x11021107, 0x1116 }, /* choseong nieun + pieup            = nieun-pieup */
  { 0x11021109, 0x115b }, /* choseong nieun + sios             = nieun-sios */
  { 0x1102110c, 0x115c }, /* choseong nieun + cieuc            = nieun-cieuc */
  { 0x11021112, 0x115d }, /* choseong nieun + hieuh            = nieun-hieuh */
  { 0x11031100, 0x1117 }, /* choseong tikeut + kiyeok          = tikeut-kiyeok */
  { 0x11031103, 0x1104 }, /* choseong tikeut + tikeut          = ssangtikeut */
  { 0x11031105, 0x115e }, /* choseong tikeut + rieul           = tikeut-rieul */
  { 0x11031106, 0xa960 }, /* choseong tikeut + mieum           = tikeut-mieum */
  { 0x11031107, 0xa961 }, /* choseong tikeut + pieup           = tikeut-pieup */
  { 0x11031109, 0xa962 }, /* choseong tikeut + sios            = tikeut-sios */
  { 0x1103110c, 0xa963 }, /* choseong tikeut + cieuc           = tikeut-cieuc */
  { 0x11051100, 0xa964 }, /* choseong rieul + kiyeok           = rieul-kiyeok */
  { 0x11051101, 0xa965 }, /* choseong rieul + ssangkiyeok      = rieul-ssangkiyeok */
  { 0x11051102, 0x1118 }, /* choseong rieul + nieun            = rieul-nieun */
  { 0x11051103, 0xa966 }, /* choseong rieul + tikeut           = rieul-tikeut */
  { 0x11051104, 0xa967 }, /* choseong rieul + ssangtikeut      = rieul-ssangtikeut */
  { 0x11051105, 0x1119 }, /* choseong rieul + rieul            = ssangrieul */
  { 0x11051106, 0xa968 }, /* choseong rieul + mieum            = rieul-mieum */
  { 0x11051107, 0xa969 }, /* choseong rieul + pieup            = rieul-pieup */
  { 0x11051108, 0xa96a }, /* choseong rieul + ssangpieup       = rieul-ssangpieup */
  { 0x11051109, 0xa96c }, /* choseong rieul + sios             = rieul-sios */
  { 0x1105110b, 0x111b }, /* choseong rieul + ieung            = kapyeounrieul */
  { 0x1105110c, 0xa96d }, /* choseong rieul + cieuc            = rieul-cieuc */
  { 0x1105110f, 0xa96e }, /* choseong rieul + khieukh          = rieul-khieukh */
  { 0x11051112, 0x111a }, /* choseong rieul + hieuh            = rieul-hieuh */
  { 0x1105112b, 0xa96b }, /* choseong rieul + kapyeounpieup    = rieul-kapyeounpieup */
  { 0x11061100, 0xa96f }, /* choseong mieum + kiyeok           = mieum-kiyeok */
  { 0x11061103, 0xa970 }, /* choseong mieum + tikeut           = mieum-tikeut */
  { 0x11061107, 0x111c }, /* choseong mieum + pieup            = mieum-pieup */
  { 0x11061109, 0xa971 }, /* choseong mieum + sios             = mieum-sios */
  { 0x1106110b, 0x111d }, /* choseong mieum + ieung            = kapyeounmieum */
  { 0x11071100, 0x111e }, /* choseong pieup + kiyeok           = pieup-kiyeok */
  { 0x11071102, 0x111f }, /* choseong pieup + nieun            = pieup-nieun */
  { 0x11071103, 0x1120 }, /* choseong pieup + tikeut           = pieup-tikeut */
  { 0x11071107, 0x1108 }, /* choseong pieup + pieup            = ssangpieup */
  { 0x11071109, 0x1121 }, /* choseong pieup + sios             = pieup-sios */
  { 0x1107110a, 0x1125 }, /* choseong pieup + ssangsios        = pieup-ssangsios */
  { 0x1107110b, 0x112b }, /* choseong pieup + ieung            = kapyeounpieup */
  { 0x1107110c, 0x1127 }, /* choseong pieup + cieuc            = pieup-cieuc */
  { 0x1107110e, 0x1128 }, /* choseong pieup + chieuch          = pieup-chieuch */
  { 0x1107110f, 0xa973 }, /* choseong pieup + khieukh          = pieup-khieukh */
  { 0x11071110, 0x1129 }, /* choseong pieup + thieuth          = pieup-thieuth */
  { 0x11071111, 0x112a }, /* choseong pieup + phieuph          = pieup-phieuph */
  { 0x11071112, 0xa974 }, /* choseong pieup + hieuh            = pieup-hieuh */
  { 0x1107112b, 0x112c }, /* choseong pieup + kapyeounpieup    = kapyeounssangpieup */
  { 0x1107112d, 0x1122 }, /* choseong pieup + sios-kiyeok      = pieup-sios-kiyeok */
  { 0x1107112f, 0x1123 }, /* choseong pieup + sios-tikeut      = pieup-sios-tikeut */
  { 0x11071132, 0x1124 }, /* choseong pieup + sios-pieup       = pieup-sios-pieup */
  { 0x11071136, 0x1126 }, /* choseong pieup + sios-cieuc       = pieup-sios-cieuc */
  { 0x11071139, 0xa972 }, /* choseong pieup + sios-thieuth     = pieup-sios-thieuth */
  { 0x1108110b, 0x112c }, /* choseong ssangpieup + ieung       = kapyeounssangpieup */
  { 0x11091100, 0x112d }, /* choseong sios + kiyeok            = sios-kiyeok */
  { 0x11091102, 0x112e }, /* choseong sios + nieun             = sios-nieun */
  { 0x11091103, 0x112f }, /* choseong sios + tikeut            = sios-tikeut */
  { 0x11091105, 0x1130 }, /* choseong sios + rieul             = sios-rieul */
  { 0x11091106, 0x1131 }, /* choseong sios + mieum             = sios-mieum */
  { 0x11091107, 0x1132 }, /* choseong sios + pieup             = sios-pieup */
  { 0x11091109, 0x110a }, /* choseong sios + sios              = ssangsios */
  { 0x1109110a, 0x1134 }, /* choseong sios + ssangsios         = sios-ssangsios */
  { 0x1109110b, 0x1135 }, /* choseong sios + ieung             = sios-ieung */
  { 0x1109110c, 0x1136 }, /* choseong sios + cieuc             = sios-cieuc */
  { 0x1109110e, 0x1137 }, /* choseong sios + chieuch           = sios-chieuch */
  { 0x1109110f, 0x1138 }, /* choseong sios + khieukh           = sios-khieukh */
  { 0x11091110, 0x1139 }, /* choseong sios + thieuth           = sios-thieuth */
  { 0x11091111, 0x113a }, /* choseong sios + phieuph           = sios-phieuph */
  { 0x11091112, 0x113b }, /* choseong sios + hieuh             = sios-hieuh */
  { 0x1109111e, 0x1133 }, /* choseong sios + pieup-kiyeok      = sios-pieup-kiyeok */
  { 0x11091132, 0xa975 }, /* choseong sios + sios-pieup        = ssangsios-pieup */
  { 0x110a1107, 0xa975 }, /* choseong ssangsios + pieup        = ssangsios-pieup */
  { 0x110a1109, 0x1134 }, /* choseong ssangsios + sios         = sios-ssangsios */
  { 0x110b1100, 0x1141 }, /* choseong ieung + kiyeok           = ieung-kiyeok */
  { 0x110b1103, 0x1142 }, /* choseong ieung + tikeut           = ieung-tikeut */
  { 0x110b1105, 0xa976 }, /* choseong ieung + rieul            = ieung-rieul */
  { 0x110b1106, 0x1143 }, /* choseong ieung + mieum            = ieung-mieum */
  { 0x110b1107, 0x1144 }, /* choseong ieung + pieup            = ieung-pieup */
  { 0x110b1109, 0x1145 }, /* choseong ieung + sios             = ieung-sios */
  { 0x110b110b, 0x1147 }, /* choseong ieung + ieung            = ssangieung */
  { 0x110b110c, 0x1148 }, /* choseong ieung + cieuc            = ieung-cieuc */
  { 0x110b110e, 0x1149 }, /* choseong ieung + chieuch          = ieung-chieuch */
  { 0x110b1110, 0x114a }, /* choseong ieung + thieuth          = ieung-thieuth */
  { 0x110b1111, 0x114b }, /* choseong ieung + phieuph          = ieung-phieuph */
  { 0x110b1112, 0xa977 }, /* choseong ieung + hieuh            = ieung-hieuh */
  { 0x110b1140, 0x1146 }, /* choseong ieung + pansios          = ieung-pansios */
  { 0x110c110b, 0x114d }, /* choseong cieuc + ieung            = cieuc-ieung */
  { 0x110c110c, 0x110d }, /* choseong cieuc + cieuc            = ssangcieuc */
  { 0x110d1112, 0xa978 }, /* choseong ssangcieuc + hieuh       = ssangcieuc-hieuh */
  { 0x110e110f, 0x1152 }, /* choseong chieuch + khieukh        = chieuch-khieukh */
  { 0x110e1112, 0x1153 }, /* choseong chieuch + hieuh          = chieuch-hieuh */
  { 0x11101110, 0xa979 }, /* choseong thieuth + thieuth        = ssangthieuth */
  { 0x11111107, 0x1156 }, /* choseong phieuph + pieup          = phieuph-pieup */
  { 0x1111110b, 0x1157 }, /* choseong phieuph + ieung          = kapyeounphieuph */
  { 0x11111112, 0xa97a }, /* choseong phieuph + hieuh          = phieuph-hieuh */
  { 0x11121109, 0xa97b }, /* choseong hieuh + sios             = hieuh-sios */
  { 0x11121112, 0x1158 }, /* choseong hieuh + hieuh            = ssanghieuh */
  { 0x11211100, 0x1122 }, /* choseong pieup-sios + kiyeok      = pieup-sios-kiyeok */
  { 0x11211103, 0x1123 }, /* choseong pieup-sios + tikeut      = pieup-sios-tikeut */
  { 0x11211107, 0x1124 }, /* choseong pieup-sios + pieup       = pieup-sios-pieup */
  { 0x11211109, 0x1125 }, /* choseong pieup-sios + sios        = pieup-ssangsios */
  { 0x1121110c, 0x1126 }, /* choseong pieup-sios + cieuc       = pieup-sios-cieuc */
  { 0x11211110, 0xa972 }, /* choseong pieup-sios + thieuth     = pieup-sios-thieuth */
  { 0x11321100, 0x1133 }, /* choseong sios-pieup + kiyeok      = sios-pieup-kiyeok */
  { 0x113c113c, 0x113d }, /* choseong chitueumsios + chitueumsios = chitueumssangsios */
  { 0x113e113e, 0x113f }, /* choseong ceongchieumsios + ceongchieumsios = ceongchieumssangsios */
  { 0x114e114e, 0x114f }, /* choseong chitueumcieuc + chitueumcieuc = chitueumssangcieuc */
  { 0x11501150, 0x1151 }, /* choseong ceongchieumcieuc + ceongchieumcieuc = ceongchieumssangcieuc */
  { 0x11591159, 0xa97c }, /* choseong yeorinhieuh + yeorinhieuh = ssangyeorinhieuh */
  { 0x11611161, 0x119e }, /* jungseong a + a                   = arae-a */
  { 0x11611169, 0x1176 }, /* jungseong a + o                   = a-o */
  { 0x1161116e, 0x1177 }, /* jungseong a + u                   = a-u */
  { 0x11611173, 0x11a3 }, /* jungseong a + eu                  = a-eu */
  { 0x11611175, 0x1162 }, /* jungseong a + i                   = ae */
  { 0x11631169, 0x1178 }, /* jungseong ya + o                  = ya-o */
  { 0x1163116d, 0x1179 }, /* jungseong ya + yo                 = ya-yo */
  { 0x1163116e, 0x11a4 }, /* jungseong ya + u                  = ya-u */
  { 0x11631175, 0x1164 }, /* jungseong ya + i                  = yae */
  { 0x11651169, 0x117a }, /* jungseong eo + o                  = eo-o */
  { 0x1165116e, 0x117b }, /* jungseong eo + u                  = eo-u */
  { 0x11651173, 0x117c }, /* jungseong eo + eu                 = eo-eu */
  { 0x11651175, 0x1166 }, /* jungseong eo + i                  = e */
  { 0x11671163, 0x11a5 }, /* jungseong yeo + ya                = yeo-ya */
  { 0x11671169, 0x117d }, /* jungseong yeo + o                 = yeo-o */
  { 0x1167116e, 0x117e }, /* jungseong yeo + u                 = yeo-u */
  { 0x11671175, 0x1168 }, /* jungseong yeo + i                 = ye */
  { 0x11691161, 0x116a }, /* jungseong o + a                   = wa */
  { 0x11691162, 0x116b }, /* jungseong o + ae                  = wae */
  { 0x11691163, 0x11a6 }, /* jungseong o + ya                  = o-ya */
  { 0x11691164, 0x11a7 }, /* jungseong o + yae                 = o-yae */
  { 0x11691165, 0x117f }, /* jungseong o + eo                  = o-eo */
  { 0x11691166, 0x1180 }, /* jungseong o + e                   = o-e */
  { 0x11691167, 0xd7b0 }, /* jungseong o + yeo                 = o-yeo */
  { 0x11691168, 0x1181 }, /* jungseong o + ye                  = o-ye */
  { 0x11691169, 0x1182 }, /* jungseong o + o                   = o-o */
  { 0x1169116e, 0x1183 }, /* jungseong o + u                   = o-u */
  { 0x11691175, 0x116c }, /* jungseong o + i                   = oe */
  { 0x116a1175, 0x116b }, /* jungseong wa + i                  = wae */
  { 0x116d1161, 0xd7b2 }, /* jungseong yo + a                  = yo-a */
  { 0x116d1162, 0xd7b3 }, /* jungseong yo + ae                 = yo-ae */
  { 0x116d1163, 0x1184 }, /* jungseong yo + ya                 = yo-ya */
  { 0x116d1164, 0x1185 }, /* jungseong yo + yae                = yo-yae */
  { 0x116d1165, 0xd7b4 }, /* jungseong yo + eo                 = yo-eo */
  { 0x116d1167, 0x1186 }, /* jungseong yo + yeo                = yo-yeo */
  { 0x116d1169, 0x1187 }, /* jungseong yo + o                  = yo-o */
  { 0x116d1175, 0x1188 }, /* jungseong yo + i                  = yo-i */
  { 0x116e1161, 0x1189 }, /* jungseong u + a                   = u-a */
  { 0x116e1162, 0x118a }, /* jungseong u + ae                  = u-ae */
  { 0x116e1165, 0x116f }, /* jungseong u + eo                  = weo */
  { 0x116e1166, 0x1170 }, /* jungseong u + e                   = we */
  { 0x116e1167, 0xd7b5 }, /* jungseong u + yeo                 = u-yeo */
  { 0x116e1168, 0x118c }, /* jungseong u + ye                  = u-ye */
  { 0x116e116e, 0x118d }, /* jungseong u + u                   = u-u */
  { 0x116e1175, 0x1171 }, /* jungseong u + i                   = wi */
  { 0x116e117c, 0x118b }, /* jungseong u + eo-eu               = u-eo-eu */
  { 0x116ed7c4, 0xd7b6 }, /* jungseong u + i-i                 = u-i-i */
  { 0x116f1173, 0x118b }, /* jungseong weo + eu                = u-eo-eu */
  { 0x116f1175, 0x1170 }, /* jungseong weo + i                 = we */
  { 0x11711175, 0xd7b6 }, /* jungseong wi + i                  = u-i-i */
  { 0x11721161, 0x118e }, /* jungseong yu + a                  = yu-a */
  { 0x11721162, 0xd7b7 }, /* jungseong yu + ae                 = yu-ae */
  { 0x11721165, 0x118f }, /* jungseong yu + eo                 = yu-eo */
  { 0x11721166, 0x1190 }, /* jungseong yu + e                  = yu-e */
  { 0x11721167, 0x1191 }, /* jungseong yu + yeo                = yu-yeo */
  { 0x11721168, 0x1192 }, /* jungseong yu + ye                 = yu-ye */
  { 0x11721169, 0xd7b8 }, /* jungseong yu + o                  = yu-o */
  { 0x1172116e, 0x1193 }, /* jungseong yu + u                  = yu-u */
  { 0x11721175, 0x1194 }, /* jungseong yu + i                  = yu-i */
  { 0x11731161, 0xd7b9 }, /* jungseong eu + a                  = eu-a */
  { 0x11731165, 0xd7ba }, /* jungseong eu + eo                 = eu-eo */
  { 0x11731166, 0xd7bb }, /* jungseong eu + e                  = eu-e */
  { 0x11731169, 0xd7bc }, /* jungseong eu + o                  = eu-o */
  { 0x1173116e, 0x1195 }, /* jungseong eu + u                  = eu-u */
  { 0x11731173, 0x1196 }, /* jungseong eu + eu                 = eu-eu */
  { 0x11731175, 0x1174 }, /* jungseong eu + i                  = yi */
  { 0x1174116e, 0x1197 }, /* jungseong yi + u                  = yi-u */
  { 0x11751161, 0x1198 }, /* jungseong i + a                   = i-a */
  { 0x11751163, 0x1199 }, /* jungseong i + ya                  = i-ya */
  { 0x11751164, 0xd7be }, /* jungseong i + yae                 = i-yae */
  { 0x11751167, 0xd7bf }, /* jungseong i + yeo                 = i-yeo */
  { 0x11751168, 0xd7c0 }, /* jungseong i + ye                  = i-ye */
  { 0x11751169, 0x119a }, /* jungseong i + o                   = i-o */
  { 0x1175116d, 0xd7c2 }, /* jungseong i + yo                  = i-yo */
  { 0x1175116e, 0x119b }, /* jungseong i + u                   = i-u */
  { 0x11751172, 0xd7c3 }, /* jungseong i + yu                  = i-yu */
  { 0x11751173, 0x119c }, /* jungseong i + eu                  = i-eu */
  { 0x11751175, 0xd7c4 }, /* jungseong i + i                   = i-i */
  { 0x11751178, 0xd7bd }, /* jungseong i + ya-o                = i-ya-o */
  { 0x1175119e, 0x119d }, /* jungseong i + araea               = i-araea */
  { 0x11821175, 0xd7b1 }, /* jungseong o-o + i                 = o-o-i */
  { 0x11991169, 0xd7bd }, /* jungseong i-ya + o                = i-ya-o */
  { 0x119a1175, 0xd7c1 }, /* jungseong i-o + i                 = i-o-i */
  { 0x119e1161, 0xd7c5 }, /* jungseong araea + a               = araea-a */
  { 0x119e1165, 0x119f }, /* jungseong araea + eo              = araea-eo */
  { 0x119e1166, 0xd7c6 }, /* jungseong araea + e               = araea-e */
  { 0x119e116e, 0x11a0 }, /* jungseong araea + u               = araea-u */
  { 0x119e1175, 0x11a1 }, /* jungseong araea + i               = araea-i */
  { 0x119e119e, 0x11a2 }, /* jungseong araea + araea           = ssangaraea */
  { 0x11a811a8, 0x11a9 }, /* jongseong kiyeok + kiyeok         = ssangkiyeok */
  { 0x11a811ab, 0x11fa }, /* jongseong kiyeok + nieun          = kiyeok-nieun */
  { 0x11a811af, 0x11c3 }, /* jongseong kiyeok + rieul          = kiyeok-rieul */
  { 0x11a811b8, 0x11fb }, /* jongseong kiyeok + pieup          = kiyeok-pieup */
  { 0x11a811ba, 0x11aa }, /* jongseong kiyeok + sios           = kiyeok-sios */
  { 0x11a811be, 0x11fc }, /* jongseong kiyeok + chieuch        = kiyeok-chieuch */
  { 0x11a811bf, 0x11fd }, /* jongseong kiyeok + khieukh        = kiyeok-khieukh */
  { 0x11a811c2, 0x11fe }, /* jongseong kiyeok + hieuh          = kiyeok-hieuh */
  { 0x11a811e7, 0x11c4 }, /* jongseong kiyeok + sios-kiyeok    = kiyeok-sios-kiyeok */
  { 0x11aa11a8, 0x11c4 }, /* jongseong kiyeok-sios + kiyeok    = kiyeok-sios-kiyeok */
  { 0x11ab11a8, 0x11c5 }, /* jongseong nieun + kiyeok          = nieun-kiyeok */
  { 0x11ab11ab, 0x11ff }, /* jongseong nieun + nieun           = ssangnieun */
  { 0x11ab11ae, 0x11c6 }, /* jongseong nieun + tikeut          = nieun-tikeut */
  { 0x11ab11af, 0xd7cb }, /* jongseong nieun + rieul           = nieun-rieul */
  { 0x11ab11ba, 0x11c7 }, /* jongseong nieun + sios            = nieun-sios */
  { 0x11ab11bd, 0x11ac }, /* jongseong nieun + cieuc           = nieun-cieuc */
  { 0x11ab11be, 0xd7cc }, /* jongseong nieun + chieuch         = nieun-chieuch */
  { 0x11ab11c0, 0x11c9 }, /* jongseong nieun + thieuth         = nieun-thieuth */
  { 0x11ab11c2, 0x11ad }, /* jongseong nieun + hieuh           = nieun-hieuh */
  { 0x11ab11eb, 0x11c8 }, /* jongseong nieun + pansios         = nieun-pansios */
  { 0x11ae11a8, 0x11ca }, /* jongseong tikeut + kiyeok         = tikeut-kiyeok */
  { 0x11ae11ae, 0xd7cd }, /* jongseong tikeut + tikeut         = ssangtikeut */
  { 0x11ae11af, 0x11cb }, /* jongseong tikeut + rieul          = tikeut-rieul */
  { 0x11ae11b8, 0xd7cf }, /* jongseong tikeut + pieup          = tikeut-pieup */
  { 0x11ae11ba, 0xd7d0 }, /* jongseong tikeut + sios           = tikeut-sios */
  { 0x11ae11bd, 0xd7d2 }, /* jongseong tikeut + cieuc          = tikeut-cieuc */
  { 0x11ae11be, 0xd7d3 }, /* jongseong tikeut + chieuch        = tikeut-chieuch */
  { 0x11ae11c0, 0xd7d4 }, /* jongseong tikeut + thieuth        = tikeut-thieuth */
  { 0x11ae11e7, 0xd7d1 }, /* jongseong tikeut + sios-kiyeok    = tikeut-sios-kiyeok */
  { 0x11aed7cf, 0xd7ce }, /* jongseong tikeut + tikeut-pieup   = ssangtikeut-pieup */
  { 0x11af11a8, 0x11b0 }, /* jongseong rieul + kiyeok          = rieul-kiyeok */
  { 0x11af11a9, 0xd7d5 }, /* jongseong rieul + ssangkiyeok     = rieul-ssangkiyeok */
  { 0x11af11aa, 0x11cc }, /* jongseong rieul + kiyeok-sios     = rieul-kiyeok-sios */
  { 0x11af11ab, 0x11cd }, /* jongseong rieul + nieun           = rieul-nieun */
  { 0x11af11ae, 0x11ce }, /* jongseong rieul + tikeut          = rieul-tikeut */
  { 0x11af11af, 0x11d0 }, /* jongseong rieul + rieul           = ssangrieul */
  { 0x11af11b7, 0x11b1 }, /* jongseong rieul + mieum           = rieul-mieum */
  { 0x11af11b8, 0x11b2 }, /* jongseong rieul + pieup           = rieul-pieup */
  { 0x11af11b9, 0x11d3 }, /* jongseong rieul + pieup-sios      = rieul-pieup-sios */
  { 0x11af11ba, 0x11b3 }, /* jongseong rieul + sios            = rieul-sios */
  { 0x11af11bb, 0x11d6 }, /* jongseong rieul + ssangsios       = rieul-ssangsios */
  { 0x11af11bc, 0xd7dd }, /* jongseong rieul + ieung           = kapyeounrieul */
  { 0x11af11bf, 0x11d8 }, /* jongseong rieul + khieukh         = rieul-khieukh */
  { 0x11af11c0, 0x11b4 }, /* jongseong rieul + thieuth         = rieul-thieuth */
  { 0x11af11c1, 0x11b5 }, /* jongseong rieul + phieuph         = rieul-phieuph */
  { 0x11af11c2, 0x11b6 }, /* jongseong rieul + hieuh           = rieul-hieuh */
  { 0x11af11d8, 0xd7d7 }, /* jongseong rieul + rieul-khieukh   = ssangrieul-khieukh */
  { 0x11af11da, 0x11d1 }, /* jongseong rieul + mieum-kiyeok    = rieul-mieum-kiyeok */
  { 0x11af11dd, 0x11d2 }, /* jongseong rieul + mieum-sios      = rieul-mieum-sios */
  { 0x11af11e1, 0xd7d8 }, /* jongseong rieul + mieum-hieuh     = rieul-mieum-hieuh */
  { 0x11af11e4, 0xd7da }, /* jongseong rieul + pieup-phieuph   = rieul-pieup-phieuph */
  { 0x11af11e5, 0x11d4 }, /* jongseong rieul + pieup-hieuh     = rieul-pieup-hieuh */
  { 0x11af11e6, 0x11d5 }, /* jongseong rieul + kapyeounpieup   = rieul-kapyeounpieup */
  { 0x11af11eb, 0x11d7 }, /* jongseong rieul + pansios         = rieul-pansios */
  { 0x11af11f0, 0xd7db }, /* jongseong rieul + yesieung        = rieul-yesieung */
  { 0x11af11f9, 0x11d9 }, /* jongseong rieul + yeorinhieuh     = rieul-yeorinhieuh */
  { 0x11af11fe, 0xd7d6 }, /* jongseong rieul + kiyeok-hieuh    = rieul-kiyeok-hieuh */
  { 0x11afd7e3, 0xd7d9 }, /* jongseong rieul + pieup-tikeut    = rieul-pieup-tikeut */
  { 0x11b011a8, 0xd7d5 }, /* jongseong rieul-kiyeok + kiyeok   = rieul-ssangkiyeok */
  { 0x11b011ba, 0x11cc }, /* jongseong rieul-kiyeok + sios     = rieul-kiyeok-sios */
  { 0x11b011c2, 0xd7d6 }, /* jongseong rieul-kiyeok + hieuh    = rieul-kiyeok-hieuh */
  { 0x11b111a8, 0x11d1 }, /* jongseong rieul-mieum + kiyeok    = rieul-mieum-kiyeok */
  { 0x11b111ba, 0x11d2 }, /* jongseong rieul-mieum + sios      = rieul-mieum-sios */
  { 0x11b111c2, 0xd7d8 }, /* jongseong rieul-mieum + hieuh     = rieul-mieum-hieuh */
  { 0x11b211ae, 0xd7d9 }, /* jongseong rieul-pieup + tikeut    = rieul-pieup-tikeut */
  { 0x11b211ba, 0x11d3 }, /* jongseong rieul-pieup + sios      = rieul-pieup-sios */
  { 0x11b211bc, 0x11d5 }, /* jongseong rieul-pieup + ieung     = rieul-kapyeounpieup */
  { 0x11b211c1, 0xd7da }, /* jongseong rieul-pieup + phieuph   = rieul-pieup-phieuph */
  { 0x11b211c2, 0x11d4 }, /* jongseong rieul-pieup + hieuh     = rieul-pieup-hieuh */
  { 0x11b311ba, 0x11d6 }, /* jongseong rieul-sios + sios       = rieul-ssangsios */
  { 0x11b711a8, 0x11da }, /* jongseong mieum + kiyeok          = mieum-kiyeok */
  { 0x11b711ab, 0xd7de }, /* jongseong mieum + nieun           = mieum-nieun */
  { 0x11b711af, 0x11db }, /* jongseong mieum + rieul           = mieum-rieul */
  { 0x11b711b7, 0xd7e0 }, /* jongseong mieum + mieum           = ssangmieum */
  { 0x11b711b8, 0x11dc }, /* jongseong mieum + pieup           = mieum-pieup */
  { 0x11b711b9, 0xd7e1 }, /* jongseong mieum + pieup-sios      = mieum-pieup-sios */
  { 0x11b711ba, 0x11dd }, /* jongseong mieum + sios            = mieum-sios */
  { 0x11b711bb, 0x11de }, /* jongseong mieum + ssangsios       = mieum-ssangsios */
  { 0x11b711bc, 0x11e2 }, /* jongseong mieum + ieung           = kapyeounmieum */
  { 0x11b711bd, 0xd7e2 }, /* jongseong mieum + cieuc           = mieum-cieuc */
  { 0x11b711be, 0x11e0 }, /* jongseong mieum + chieuch         = mieum-chieuch */
  { 0x11b711c2, 0x11e1 }, /* jongseong mieum + hieuh           = mieum-hieuh */
  { 0x11b711eb, 0x11df }, /* jongseong mieum + pansios         = mieum-pansios */
  { 0x11b711ff, 0xd7df }, /* jongseong mieum + ssangnieun      = mieum-ssangnieun */
  { 0x11b811ae, 0xd7e3 }, /* jongseong pieup + tikeut          = pieup-tikeut */
  { 0x11b811af, 0x11e3 }, /* jongseong pieup + rieul           = pieup-rieul */
  { 0x11b811b5, 0xd7e4 }, /* jongseong pieup + rieul-phieuph   = pieup-rieul-phieuph */
  { 0x11b811b7, 0xd7e5 }, /* jongseong pieup + mieum           = pieup-mieum */
  { 0x11b811b8, 0xd7e6 }, /* jongseong pieup + pieup           = ssangpieup */
  { 0x11b811ba, 0x11b9 }, /* jongseong pieup + sios            = pieup-sios */
  { 0x11b811bc, 0x11e6 }, /* jongseong pieup + ieung           = kapyeounpieup */
  { 0x11b811bd, 0xd7e8 }, /* jongseong pieup + cieuc           = pieup-cieuc */
  { 0x11b811be, 0xd7e9 }, /* jongseong pieup + chieuch         = pieup-chieuch */
  { 0x11b811c1, 0x11e4 }, /* jongseong pieup + phieuph         = pieup-phieuph */
  { 0x11b811c2, 0x11e5 }, /* jongseong pieup + hieuh           = pieup-hieuh */
  { 0x11b811e8, 0xd7e7 }, /* jongseong pieup + sios-tikeut     = pieup-sios-tikeut */
  { 0x11b911ae, 0xd7e7 }, /* jongseong pieup-sios + tikeut     = pieup-sios-tikeut */
  { 0x11ba11a8, 0x11e7 }, /* jongseong sios + kiyeok           = sios-kiyeok */
  { 0x11ba11ae, 0x11e8 }, /* jongseong sios + tikeut           = sios-tikeut */
  { 0x11ba11af, 0x11e9 }, /* jongseong sios + rieul            = sios-rieul */
  { 0x11ba11b7, 0xd7ea }, /* jongseong sios + mieum            = sios-mieum */
  { 0x11ba11b8, 0x11ea }, /* jongseong sios + pieup            = sios-pieup */
  { 0x11ba11ba, 0x11bb }, /* jongseong sios + sios             = ssangsios */
  { 0x11ba11bd, 0xd7ef }, /* jongseong sios + cieuc            = sios-cieuc */
  { 0x11ba11be, 0xd7f0 }, /* jongseong sios + chieuch          = sios-chieuch */
  { 0x11ba11c0, 0xd7f1 }, /* jongseong sios + thieuth          = sios-thieuth */
  { 0x11ba11c2, 0xd7f2 }, /* jongseong sios + hieuh            = sios-hieuh */
  { 0x11ba11e6, 0xd7eb }, /* jongseong sios + kapyeounpieup    = sios-kapyeounpieup */
  { 0x11ba11e7, 0xd7ec }, /* jongseong sios + sios-kiyeok      = ssangsios-kiyeok */
  { 0x11ba11e8, 0xd7ed }, /* jongseong sios + sios-tikeut      = ssangsios-tikeut */
  { 0x11ba11eb, 0xd7ee }, /* jongseong sios + pansios          = sios-pansios */
  { 0x11bb11a8, 0xd7ec }, /* jongseong ssangsios + kiyeok      = ssangsios-kiyeok */
  { 0x11bb11ae, 0xd7ed }, /* jongseong ssangsios + tikeut      = ssangsios-tikeut */
  { 0x11bd11b8, 0xd7f7 }, /* jongseong cieuc + pieup           = cieuc-pieup */
  { 0x11bd11bd, 0xd7f9 }, /* jongseong cieuc + cieuc           = ssangcieuc */
  { 0x11bdd7e6, 0xd7f8 }, /* jongseong cieuc + ssangpieup      = cieuc-ssangpieup */
  { 0x11c111b8, 0x11f3 }, /* jongseong phieuph + pieup         = phieuph-pieup */
  { 0x11c111ba, 0xd7fa }, /* jongseong phieuph + sios          = phieuph-sios */
  { 0x11c111bc, 0x11f4 }, /* jongseong phieuph + ieung         = kapyeounphieuph */
  { 0x11c111c0, 0xd7fb }, /* jongseong phieuph + thieuth       = phieuph-thieuth */
  { 0x11c211ab, 0x11f5 }, /* jongseong hieuh + nieun           = hieuh-nieun */
  { 0x11c211af, 0x11f6 }, /* jongseong hieuh + rieul           = hieuh-rieul */
  { 0x11c211b7, 0x11f7 }, /* jongseong hieuh + mieum           = hieuh-mieum */
  { 0x11c211b8, 0x11f8 }, /* jongseong hieuh + pieup           = hieuh-pieup */
  { 0x11ce11c2, 0x11cf }, /* jongseong rieul-tikeut + hieuh    = rieul-tikeut-hieuh */
  { 0x11d011bf, 0xd7d7 }, /* jongseong ssangrieul + khieukh    = ssangrieul-khieukh */
  { 0x11d911c2, 0xd7dc }, /* jongseong rieul-yeorinhieuh + hieuh = rieul-yeorinhieuh-hieuh */
  { 0x11dc11ba, 0xd7e1 }, /* jongseong mieum-pieup + sios      = mieum-pieup-sios */
  { 0x11dd11ba, 0x11de }, /* jongseong mieum-sios + sios       = mieum-ssangsios */
  { 0x11e311c1, 0xd7e4 }, /* jongseong pieup-rieul + phieuph   = pieup-rieul-phieuph */
  { 0x11ea11bc, 0xd7eb }, /* jongseong sios-pieup + ieung      = sios-kapyeounpieup */
  { 0x11eb11b8, 0xd7f3 }, /* jongseong pansios + pieup         = pansios-pieup */
  { 0x11eb11e6, 0xd7f4 }, /* jongseong pansios + kapyeounpieup = pansios-kapyeounpieup */
  { 0x11ec11a8, 0x11ed }, /* jongseong ieung-kiyeok + kiyeok   = ieung-ssangkiyeok */
  { 0x11f011a8, 0x11ec }, /* jongseong yesieung + kiyeok       = yesieung-kiyeok */
  { 0x11f011a9, 0x11ed }, /* jongseong yesieung + ssangkiyeok  = yesieung-ssangkiyeok */
  { 0x11f011b7, 0xd7f5 }, /* jongseong yesieung + mieum        = yesieung-mieum */
  { 0x11f011ba, 0x11f1 }, /* jongseong yesieung + sios         = yesieung-sios */
  { 0x11f011bf, 0x11ef }, /* jongseong yesieung + khieukh      = yesieung-khieukh */
  { 0x11f011c2, 0xd7f6 }, /* jongseong yesieung + hieuh        = yesieung-hieuh */
  { 0x11f011eb, 0x11f2 }, /* jongseong yesieung + pansios      = yesieung-pansios */
  { 0x11f011f0, 0x11ee }, /* jongseong yesieung + yesieung     = ssangyesieung */
  { 0xa9641100, 0xa965 }, /* choseong rieul-kiyeok + kiyeok    = rieul-ssangkiyeok */
  { 0xa9661103, 0xa967 }, /* choseong rieul-tikeut + tikeut    = rieul-ssangtikeut */
  { 0xa9691107, 0xa96a }, /* choseong rieul-pieup + pieup      = rieul-ssangpieup */
  { 0xa969110b, 0xa96b }, /* choseong rieul-pieup + ieung      = rieul-kapyeounpieup */
  { 0xd7c51161, 0x11a2 }, /* jungseong araea-a + a             = ssangaraea */
  { 0xd7cd11b8, 0xd7ce }, /* jongseong ssangtikeut + pieup     = ssangtikeut-pieup */
  { 0xd7d011a8, 0xd7d1 }, /* jongseong tikeut-sios + kiyeok    = tikeut-sios-kiyeok */
  { 0xd7de11ab, 0xd7df }, /* jongseong mieum-nieun + nieun     = mieum-ssangnieun */
  { 0xd7f311bc, 0xd7f4 }, /* jongseong pansios-pieup + ieung   = pansios-kapyeounpieup */
  { 0xd7f711b8, 0xd7f8 }, /* jongseong cieuc-pieup + pieup     = cieuc-ssangpieup */
};

static const HangulCombinationItem hangul_combination_table_ahn[] = {
  { 0x11001103, 0x1104 }, /* choseong  kiyeok       + tikeut = ssangtikeut   */
  { 0x1100110b, 0x1101 }, /* choseong  kiyeok       + ieung  = ssangkiyeok   */
  { 0x11001112, 0x110f }, /* choseong  kiyeok       + hieuh  = khieukh       */
  { 0x11021109, 0x110a }, /* choseong  nieun        + sios   = ssangsios     */
  { 0x11031100, 0x1104 }, /* choseong  tikeut       + kiyeok = ssangtikeut   */
  { 0x1103110c, 0x110d }, /* choseong  tikeut       + cieuc  = ssangcieuc    */
  { 0x11031112, 0x1110 }, /* choseong  tikeut       + hieuh  = thieuth       */
  { 0x1107110c, 0x1108 }, /* choseong  pieup        + cieuc  = ssangpieup    */
  { 0x11071112, 0x1111 }, /* choseong  pieup        + hieuh  = phieuph       */
  { 0x11091102, 0x110a }, /* choseong  sios         + nieun  = ssangsios     */
  { 0x110b1100, 0x1101 }, /* choseong  ieung        + kiyeok = ssangkiyeok   */
  { 0x110c1103, 0x110d }, /* choseong  cieuc        + tikeut = ssangcieuc    */
  { 0x110c1107, 0x1108 }, /* choseong  cieuc        + pieup  = ssangpieup    */
  { 0x110c1112, 0x110e }, /* choseong  cieuc        + hieuh  = chieuch       */
  { 0x11121100, 0x110f }, /* choseong  hieuh        + kiyeok = khieukh       */
  { 0x11121103, 0x1110 }, /* choseong  hieuh        + tikeut = thieuth       */
  { 0x11121107, 0x1111 }, /* choseong  hieuh        + pieup  = phieuph       */
  { 0x1112110c, 0x110e }, /* choseong  hieuh        + cieuc  = chieuch       */
  { 0x11611169, 0x116a }, /* jungseong a            + o      = wa            */
  { 0x11611175, 0x1162 }, /* jungseong a            + i      = ae            */
  { 0x11621169, 0x116b }, /* jungseong ae           + o      = wae           */
  { 0x11631175, 0x1164 }, /* jungseong ya           + i      = yae           */
  { 0x1165116e, 0x116f }, /* jungseong eo           + u      = weo           */
  { 0x11651175, 0x1166 }, /* jungseong eo           + i      = e             */
  { 0x1166116e, 0x1170 }, /* jungseong e            + u      = we            */
  { 0x11671175, 0x1168 }, /* jungseong yeo          + i      = ye            */
  { 0x11691161, 0x116a }, /* jungseong o            + a      = wa            */
  { 0x11691175, 0x116c }, /* jungseong o            + i      = oe            */
  { 0x116a1175, 0x116b }, /* jungseong wa           + i      = wae           */
  { 0x116c1161, 0x116b }, /* jungseong oe           + a      = wae           */
  { 0x116e1165, 0x116f }, /* jungseong u            + eo     = weo           */
  { 0x116e1175, 0x1171 }, /* jungseong u            + i      = wi            */
  { 0x116f1175, 0x1170 }, /* jungseong weo          + i      = we            */
  { 0x11711165, 0x1170 }, /* jungseong wi           + eo     = we            */
  { 0x11731175, 0x1174 }, /* jungseong eu           + i      = yi            */
  { 0x11751161, 0x1162 }, /* jungseong i            + a      = ae            */
  { 0x11751163, 0x1164 }, /* jungseong i            + ya     = yae           */
  { 0x11751165, 0x1166 }, /* jungseong i            + eo     = e             */
  { 0x11751167, 0x1168 }, /* jungseong i            + yeo    = ye            */
  { 0x11751169, 0x116c }, /* jungseong i            + o      = oe            */
  { 0x1175116e, 0x1171 }, /* jungseong i            + u      = wi            */
  { 0x11751173, 0x1174 }, /* jungseong i            + eu     = yi            */
  { 0x11a811af, 0x11b0 }, /* jongseong kiyeok       + rieul  = rieul-kiyeok  */
  { 0x11a811ba, 0x11aa }, /* jongseong kiyeok       + sios   = kiyeok-sios   */
  { 0x11a811bc, 0x11a9 }, /* jongseong kiyeok       + ieung  = ssangkiyeok   */
  { 0x11a811c2, 0x11bf }, /* jongseong kiyeok       + hieuh  = khieukh       */
  { 0x11ab11ba, 0x11bb }, /* jongseong nieun        + sios   = ssangsios     */
  { 0x11ab11bd, 0x11ac }, /* jongseong nieun        + cieuc  = nieun-cieuc   */
  { 0x11ab11c2, 0x11ad }, /* jongseong nieun        + hieuh  = nieun-hieuh   */
  { 0x11ae11af, 0x11ce }, /* jongseong tikeut       + rieul  = rieul-tikeut  */
  { 0x11ae11c2, 0x11c0 }, /* jongseong tikeut       + hieuh  = thieuth       */
  { 0x11af11a8, 0x11b0 }, /* jongseong rieul        + kiyeok = rieul-kiyeok  */
  { 0x11af11ae, 0x11ce }, /* jongseong rieul        + tikeut = rieul-tikeut  */
  { 0x11af11b7, 0x11b1 }, /* jongseong rieul        + mieum  = rieul-mieum   */
  { 0x11af11b8, 0x11b2 }, /* jongseong rieul        + pieup  = rieul-pieup   */
  { 0x11af11ba, 0x11b3 }, /* jongseong rieul        + sios   = rieul-sios    */
  { 0x11af11c2, 0x11b6 }, /* jongseong rieul        + hieuh  = rieul-hieuh   */
  { 0x11b211c2, 0x11b5 }, /* jongseong rieul-pieup  + hieuh  = rieul-phieuph */
  { 0x11b611ae, 0x11b4 }, /* jongseong rieul-hieuh  + tikeut = rieul-thieuth */
  { 0x11b611b8, 0x11b5 }, /* jongseong rieul-hieuh  + pieup  = rieul-phieuph */
  { 0x11b711af, 0x11b1 }, /* jongseong mieum        + rieul  = rieul-mieum   */
  { 0x11b811af, 0x11b2 }, /* jongseong pieup        + rieul  = rieul-pieup   */
  { 0x11b811ba, 0x11b9 }, /* jongseong pieup        + sios   = pieup-sios    */
  { 0x11b811c2, 0x11c1 }, /* jongseong pieup        + hieuh  = phieuph       */
  { 0x11ba11a8, 0x11aa }, /* jongseong sios         + kiyeok = kiyeok-sios   */
  { 0x11ba11ab, 0x11bb }, /* jongseong sios         + nieun  = ssangsios     */
  { 0x11ba11af, 0x11b3 }, /* jongseong sios         + rieul  = rieul-sios    */
  { 0x11ba11b8, 0x11b9 }, /* jongseong sios         + pieup  = pieup-sios    */
  { 0x11bc11a8, 0x11a9 }, /* jongseong ieung        + kiyeok = ssangkiyeok   */
  { 0x11bd11ab, 0x11ac }, /* jongseong cieuc        + nieun  = nieun-cieuc   */
  { 0x11bd11c2, 0x11be }, /* jongseong cieuc        + hieuh  = chieuch       */
  { 0x11c011af, 0x11b4 }, /* jongseong thieuth      + rieul  = rieul-thieuth */
  { 0x11c111af, 0x11b5 }, /* jongseong phieuph      + rieul  = rieul-phieuph */
  { 0x11c211a8, 0x11bf }, /* jongseong hieuh        + kiyeok = khieukh       */
  { 0x11c211ab, 0x11ad }, /* jongseong hieuh        + nieun  = nieun-hieuh   */
  { 0x11c211ae, 0x11c0 }, /* jongseong hieuh        + tikeut = thieuth       */
  { 0x11c211af, 0x11b6 }, /* jongseong hieuh        + rieul  = rieul-hieuh   */
  { 0x11c211b8, 0x11c1 }, /* jongseong hieuh        + pieup  = phieuph       */
  { 0x11c211bd, 0x11be }, /* jongseong hieuh        + cieuc  = chieuch       */
  { 0x11ce11c2, 0x11b4 }, /* jongseong rieul-tikeut + hieuh  = rieul-thieuth */
};
