/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.contrib.Layoutable;
import org.jhotdraw.contrib.Layouter;
import org.jhotdraw.contrib.SimpleLayouter;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;

public class StandardLayouter
extends SimpleLayouter {
    public StandardLayouter() {
        this(null);
    }

    public StandardLayouter(Layoutable layoutable) {
        super(layoutable);
    }

    public Layouter create(Layoutable layoutable) {
        return new StandardLayouter(layoutable);
    }

    public Rectangle calculateLayout(Point point, Point point2) {
        int n = Math.abs(point2.x - point.x);
        int n2 = this.getInsets().top;
        FigureEnumeration figureEnumeration = this.getLayoutable().figures();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            Rectangle rectangle = null;
            if (figure instanceof Layoutable) {
                Layouter layouter = ((Layoutable)figure).getLayouter();
                rectangle = layouter.calculateLayout(new Point(0, 0), new Point(0, 0));
            } else {
                rectangle = new Rectangle(figure.displayBox().getBounds());
            }
            n = Math.max(n, rectangle.width + this.getInsets().left + this.getInsets().right);
            n2 += rectangle.height;
        }
        return new Rectangle(point.x, point.y, n, n2 += this.getInsets().bottom);
    }

    public Rectangle layout(Point point, Point point2) {
        Rectangle rectangle = this.calculateLayout(point, point2);
        int n = this.getInsets().top;
        FigureEnumeration figureEnumeration = this.getLayoutable().figures();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            Point point3 = new Point(rectangle.x + this.getInsets().left, rectangle.y + n);
            Point point4 = new Point(rectangle.x + rectangle.width - this.getInsets().right, rectangle.y + n + figure.displayBox().height);
            figure.displayBox(point3, point4);
            n += figure.displayBox().height;
        }
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, n + this.getInsets().bottom);
    }
}

