/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.AbstractConnector;
import org.jhotdraw.util.Geom;

public class ChopBoxConnector
extends AbstractConnector {
    private static final long serialVersionUID = -1461450322712345462L;

    public ChopBoxConnector() {
    }

    public ChopBoxConnector(Figure figure) {
        super(figure);
    }

    public Point findStart(ConnectionFigure connectionFigure) {
        Figure figure = connectionFigure.getStartConnector().owner();
        Rectangle rectangle = connectionFigure.getEndConnector().displayBox();
        Point point = null;
        point = connectionFigure.pointCount() == 2 ? new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2) : connectionFigure.pointAt(1);
        return this.chop(figure, point);
    }

    public Point findEnd(ConnectionFigure connectionFigure) {
        Figure figure = connectionFigure.getEndConnector().owner();
        Rectangle rectangle = connectionFigure.getStartConnector().displayBox();
        Point point = null;
        point = connectionFigure.pointCount() == 2 ? new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2) : connectionFigure.pointAt(connectionFigure.pointCount() - 2);
        return this.chop(figure, point);
    }

    protected Point chop(Figure figure, Point point) {
        Rectangle rectangle = figure.displayBox();
        return Geom.angleToPoint(rectangle, Geom.pointToAngle(rectangle, point));
    }
}

