/* Generated by re2c */
#line 1 "condition_06.cs.re"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define	BSIZE	8192

typedef struct Scanner
{
	FILE			*fp;
	unsigned char	*cur, *tok, *lim, *eof;
	unsigned char 	buffer[BSIZE];
} Scanner;

int fill(Scanner *s, int len)
{
	if (!len)
	{
		s->cur = s->tok = s->lim = s->buffer;
		s->eof = 0;
	}
	if (!s->eof)
	{
		int got, cnt = s->tok - s->buffer;

		if (cnt > 0)
		{
			memcpy(s->buffer, s->tok, s->lim - s->tok);
			s->tok -= cnt;
			s->cur -= cnt;
			s->lim -= cnt;
		}
		cnt = BSIZE - cnt;
		if ((got = fread(s->lim, 1, cnt, s->fp)) != cnt)
		{
			s->eof = &s->lim[got];
		}
		s->lim += got;
	}
	else if (s->cur + len > s->eof)
	{
		return 0; /* not enough input data */
	}
	return -1;
}

void fputl(const char *s, size_t len, FILE *stream)
{
	while(len-- > 0)
	{
		fputc(*s++, stream);
	}
}

#line 57 "condition_06.cs.c"
enum YYCONDTYPE {
	EStateNormal,
	EStateComment,
	EStateSkiptoeol,
	EStateString,
};
#line 54 "condition_06.cs.re"


void scan(Scanner *s)
{
	int cond = EStateNormal;
	
	fill(s, 0);

	for(;;)
	{
		s->tok = s->cur;

#line 77 "condition_06.cs.c"
		{
			unsigned char yych;
			if (cond < 2) {
				if (cond < 1) {
					goto yyc_Normal;
				} else {
					goto yyc_Comment;
				}
			} else {
				if (cond < 3) {
					goto yyc_Skiptoeol;
				} else {
					goto yyc_String;
				}
			}
/* *********************************** */
yyc_Normal:
			if ((s->lim - s->cur) < 3) { if(fill(s, 3) >= 0) break; }
			yych = *s->cur;
			if (yych <= '.') {
				if (yych == '"') goto yy5;
			} else {
				if (yych <= '/') goto yy7;
				if (yych == '?') goto yy8;
			}
			++s->cur;
yy4:
#line 140 "condition_06.cs.re"
			{
				fputc(*s->tok, stdout);
				continue;
			}
#line 110 "condition_06.cs.c"
yy5:
			++s->cur;
#line 134 "condition_06.cs.re"
			{
				fputc(*s->tok, stdout);
				state = EStateString;
				continue;
			}
#line 119 "condition_06.cs.c"
yy7:
			yych = *++s->cur;
			if (yych == '*') goto yy9;
			if (yych == '/') goto yy11;
			goto yy4;
yy8:
			yych = *(s->tok = ++s->cur);
			if (yych == '?') goto yy13;
			goto yy4;
yy9:
			++s->cur;
#line 126 "condition_06.cs.re"
			{
				goto yyc_Comment;
			}
#line 135 "condition_06.cs.c"
yy11:
			++s->cur;
#line 130 "condition_06.cs.re"
			{
				goto yyc_Skiptoeol;
			}
#line 142 "condition_06.cs.c"
yy13:
			yych = *++s->cur;
			switch (yych) {
			case '!':	goto yy15;
			case '\'':	goto yy17;
			case '(':	goto yy19;
			case ')':	goto yy21;
			case '-':	goto yy23;
			case '/':	goto yy25;
			case '<':	goto yy27;
			case '=':	goto yy29;
			case '>':	goto yy31;
			default:	goto yy14;
			}
yy14:
			s->cur = s->tok;
			goto yy4;
yy15:
			++s->cur;
#line 116 "condition_06.cs.re"
			{
				fputc('|', stdout);
				continue;
			}
#line 167 "condition_06.cs.c"
yy17:
			++s->cur;
#line 111 "condition_06.cs.re"
			{
				fputc('^', stdout);
				continue;
			}
#line 175 "condition_06.cs.c"
yy19:
			++s->cur;
#line 81 "condition_06.cs.re"
			{
				fputc('[', stdout);
				continue;
			}
#line 183 "condition_06.cs.c"
yy21:
			++s->cur;
#line 86 "condition_06.cs.re"
			{
				fputc(']', stdout);
				continue;
			}
#line 191 "condition_06.cs.c"
yy23:
			++s->cur;
#line 121 "condition_06.cs.re"
			{
				fputc('~', stdout);
				continue;
			}
#line 199 "condition_06.cs.c"
yy25:
			++s->cur;
#line 106 "condition_06.cs.re"
			{
				fputc('\\', stdout);
				continue;
			}
#line 207 "condition_06.cs.c"
yy27:
			++s->cur;
#line 91 "condition_06.cs.re"
			{
				fputc('{', stdout);
				continue;
			}
#line 215 "condition_06.cs.c"
yy29:
			++s->cur;
#line 101 "condition_06.cs.re"
			{
				fputc('#', stdout);
				continue;
			}
#line 223 "condition_06.cs.c"
yy31:
			++s->cur;
#line 96 "condition_06.cs.re"
			{
				fputc('}', stdout);
				continue;
			}
#line 231 "condition_06.cs.c"
/* *********************************** */
yyc_Comment:
			if ((s->lim - s->cur) < 2) { if(fill(s, 2) >= 0) break; }
			yych = *s->cur;
			if (yych == '*') goto yy37;
			++s->cur;
yy36:
#line 149 "condition_06.cs.re"
			{
				goto yyc_Comment;
			}
#line 243 "condition_06.cs.c"
yy37:
			yych = *++s->cur;
			if (yych != '/') goto yy36;
			++s->cur;
#line 145 "condition_06.cs.re"
			{
				continue;
			}
#line 252 "condition_06.cs.c"
/* *********************************** */
yyc_Skiptoeol:
			if ((s->lim - s->cur) < 5) { if(fill(s, 5) >= 0) break; }
			yych = *s->cur;
			if (yych <= '>') {
				if (yych == '\n') goto yy44;
			} else {
				if (yych <= '?') goto yy46;
				if (yych == '\\') goto yy47;
			}
			++s->cur;
yy43:
#line 165 "condition_06.cs.re"
			{
				goto yyc_Skiptoeol;
			}
#line 269 "condition_06.cs.c"
yy44:
			++s->cur;
#line 161 "condition_06.cs.re"
			{
				continue;
			}
#line 276 "condition_06.cs.c"
yy46:
			yych = *(s->tok = ++s->cur);
			if (yych == '?') goto yy48;
			goto yy43;
yy47:
			yych = *(s->tok = ++s->cur);
			if (yych == '\n') goto yy50;
			if (yych == '\r') goto yy52;
			goto yy43;
yy48:
			yych = *++s->cur;
			if (yych == '/') goto yy53;
yy49:
			s->cur = s->tok;
			goto yy43;
yy50:
			++s->cur;
#line 157 "condition_06.cs.re"
			{
				goto yyc_Skiptoeol;
			}
#line 298 "condition_06.cs.c"
yy52:
			yych = *++s->cur;
			if (yych == '\n') goto yy50;
			goto yy49;
yy53:
			yych = *++s->cur;
			if (yych == '\n') goto yy54;
			if (yych == '\r') goto yy56;
			goto yy49;
yy54:
			++s->cur;
#line 153 "condition_06.cs.re"
			{
				goto yyc_Skiptoeol;
			}
#line 314 "condition_06.cs.c"
yy56:
			yych = *++s->cur;
			if (yych == '\n') goto yy54;
			goto yy49;
/* *********************************** */
yyc_String:
			if ((s->lim - s->cur) < 2) { if(fill(s, 2) >= 0) break; }
			yych = *s->cur;
			if (yych == '"') goto yy61;
			if (yych == '\\') goto yy63;
			++s->cur;
yy60:
#line 179 "condition_06.cs.re"
			{
				fputc(*s->tok, stdout);
				continue;
			}
#line 332 "condition_06.cs.c"
yy61:
			++s->cur;
#line 174 "condition_06.cs.re"
			{
				fputc(*s->tok, stdout);
				continue;
			}
#line 340 "condition_06.cs.c"
yy63:
			yych = *++s->cur;
			if (yych == '\n') goto yy60;
			++s->cur;
#line 169 "condition_06.cs.re"
			{
				fputl((const char*)s->tok, 2, stdout);
				continue;
			}
#line 350 "condition_06.cs.c"
		}
#line 183 "condition_06.cs.re"

	}
}

int main(int argc, char **argv)
{
	Scanner in;
	char c;

	if (argc != 2)
	{
		fprintf(stderr, "%s <file>\n", argv[0]);
		return 1;;
	}

	memset((char*) &in, 0, sizeof(in));

	if (!strcmp(argv[1], "-"))
	{
		in.fp = stdin;
	}
	else if ((in.fp = fopen(argv[1], "r")) == NULL)
	{
		fprintf(stderr, "Cannot open file '%s'\n", argv[1]);
		return 1;
	}

	scan(&in);

	if (in.fp != stdin)
	{
		fclose(in.fp);
	}
	return 0;
}
