An invalid number of generic parameters was passed to an intrinsic function.

Erroneous code example:

```compile_fail,E0094
#![feature(intrinsics, rustc_attrs)]
#![allow(internal_features)]

extern "rust-intrinsic" {
    #[rustc_safe_intrinsic]
    fn size_of<T, U>() -> usize; // error: intrinsic has wrong number
                                 //        of type parameters
}
```

Please check that you provided the right number of type parameters
and verify with the function declaration in the Rust source code.
Example:

```
#![feature(intrinsics, rustc_attrs)]
#![allow(internal_features)]

extern "rust-intrinsic" {
    #[rustc_safe_intrinsic]
    fn size_of<T>() -> usize; // ok!
}
```
