/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ta" locale.
 */
public class LocalizedNamesImpl_ta extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "FK",
        "FJ",
        "FO",
        "GF",
        "TF",
        "PF",
        "AI",
        "AO",
        "AZ",
        "AQ",
        "AD",
        "AS",
        "IE",
        "AW",
        "AR",
        "DZ",
        "AL",
        "AC",
        "AG",
        "AF",
        "AM",
        "AX",
        "AT",
        "AU",
        "IT",
        "IN",
        "ID",
        "IQ",
        "LK",
        "IL",
        "GQ",
        "EC",
        "IR",
        "UG",
        "UA",
        "UY",
        "UZ",
        "EG",
        "ET",
        "ER",
        "SV",
        "EE",
        "YE",
        "US",
        "AE",
        "EU",
        "IM",
        "CI",
        "IS",
        "OM",
        "QO",
        "QA",
        "CA",
        "KH",
        "GY",
        "KZ",
        "CC",
        "CD",
        "CG",
        "GH",
        "GM",
        "GW",
        "GN",
        "CU",
        "GD",
        "KI",
        "GL",
        "GR",
        "KG",
        "CX",
        "CP",
        "TL",
        "CK",
        "HR",
        "GT",
        "GU",
        "KW",
        "KE",
        "GG",
        "IC",
        "GA",
        "CV",
        "CM",
        "KY",
        "CO",
        "KM",
        "CR",
        "GP",
        "WS",
        "SA",
        "TD",
        "SM",
        "ZM",
        "SB",
        "ST",
        "SG",
        "SL",
        "EA",
        "SY",
        "CL",
        "CN",
        "SD",
        "SR",
        "CZ",
        "SN",
        "KN",
        "BL",
        "PM",
        "LC",
        "SH",
        "MF",
        "VC",
        "RS",
        "CS",
        "CY",
        "SO",
        "JP",
        "JM",
        "GE",
        "DJ",
        "GI",
        "ZW",
        "JE",
        "DE",
        "JO",
        "TC",
        "TZ",
        "DG",
        "TA",
        "TN",
        "DK",
        "DO",
        "DM",
        "TK",
        "TG",
        "TO",
        "TT",
        "TJ",
        "TH",
        "TR",
        "TM",
        "TV",
        "ZA",
        "KR",
        "GS",
        "TW",
        "NA",
        "NF",
        "NO",
        "NI",
        "NU",
        "NC",
        "NZ",
        "NL",
        "AN",
        "NP",
        "NE",
        "NG",
        "NR",
        "BD",
        "PA",
        "BG",
        "BS",
        "BH",
        "PK",
        "PG",
        "PY",
        "BB",
        "PS",
        "PW",
        "PN",
        "FI",
        "PR",
        "FR",
        "GB",
        "IO",
        "VG",
        "BR",
        "PH",
        "BI",
        "BN",
        "BF",
        "BT",
        "BJ",
        "PE",
        "BM",
        "BY",
        "BZ",
        "BE",
        "BO",
        "BV",
        "BW",
        "PT",
        "PL",
        "BA",
        "MO",
        "MN",
        "MG",
        "CF",
        "YT",
        "MY",
        "MK",
        "ME",
        "MQ",
        "MH",
        "MV",
        "MW",
        "ML",
        "MT",
        "MD",
        "MM",
        "MX",
        "EH",
        "FM",
        "MZ",
        "MC",
        "MA",
        "MU",
        "MS",
        "MR",
        "UM",
        "VI",
        "RU",
        "RE",
        "RO",
        "RW",
        "LU",
        "LV",
        "LA",
        "LI",
        "LT",
        "LY",
        "LS",
        "LB",
        "LR",
        "KP",
        "MP",
        "VU",
        "VA",
        "WF",
        "VN",
        "VE",
        "SC",
        "ES",
        "SK",
        "SI",
        "SJ",
        "SZ",
        "CH",
        "SE",
        "HU",
        "HK",
        "HN",
        "HT",
        "HM",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "உலகம்");
    namesMap.put("002", "ஆப்ரிக்கா");
    namesMap.put("003", "வடக்கு அமெரிக்கா கண்டம்");
    namesMap.put("005", "தெற்கு அமெரிக்கா");
    namesMap.put("009", "ஓஷெனியா");
    namesMap.put("011", "மேற்கு ஆப்ரிக்கா");
    namesMap.put("013", "மத்திய அமெரிக்கா");
    namesMap.put("014", "கிழக்கு ஆப்ரிக்கா");
    namesMap.put("015", "வடக்கு ஆப்ரிக்கா");
    namesMap.put("017", "மத்திய ஆப்ரிக்கா");
    namesMap.put("018", "தென்னாப்ரிக்கா");
    namesMap.put("019", "அமெர்க்காஸ்");
    namesMap.put("021", "வடக்கு அமெரிக்கா");
    namesMap.put("029", "கரீபியன்");
    namesMap.put("030", "கிழக்கு ஆசியா");
    namesMap.put("034", "தெற்கு ஆசியா");
    namesMap.put("035", "தென்-கிழக்கு ஆசியா");
    namesMap.put("039", "தெற்கு ஐரோப்பா");
    namesMap.put("053", "ஆஸ்திரேலியா மற்றும் நியூசிலாந்து");
    namesMap.put("054", "மெலனேஷியா");
    namesMap.put("057", "மைக்ரோ நேஷியா பிரதேசம்");
    namesMap.put("061", "பாலினேஷியா");
    namesMap.put("062", "மத்திய-தெற்காசியா");
    namesMap.put("142", "ஆசியா");
    namesMap.put("143", "மத்திய ஆசியா");
    namesMap.put("145", "மேற்கு ஆசியா");
    namesMap.put("150", "ஈரோப்");
    namesMap.put("151", "கிழக்கு ஐரோப்பா");
    namesMap.put("154", "வடக்கு ஐரோப்பா");
    namesMap.put("155", "மேற்கு ஐரோப்பா");
    namesMap.put("172", "சுதந்திர மாநிலங்களின் காமன்வெல்த்");
    namesMap.put("200", "செகோஸ்லோவாக்யா");
    namesMap.put("419", "லத்தீன் அமெரிக்கா மற்றும் கரீபியன்");
    namesMap.put("830", "சேனல் தீவுகள்");
    namesMap.put("AC", "அஷன்ஷியன் தீவு");
    namesMap.put("AD", "அன்டோரா");
    namesMap.put("AE", "ஐக்கிய அரபு கூட்டாட்சி");
    namesMap.put("AF", "ஆப்கானிஸ்தான்");
    namesMap.put("AG", "ஆண்டிகுவா மற்றும் பார்புடா");
    namesMap.put("AI", "அங்குய்லா");
    namesMap.put("AL", "அல்பேனியா");
    namesMap.put("AM", "ஆர்மேனியா");
    namesMap.put("AN", "நெதர்லாந்து ஆண்டில்லெஸ்");
    namesMap.put("AO", "அங்கோலா");
    namesMap.put("AQ", "அண்டார்டிகா");
    namesMap.put("AR", "அர்ஜென்டினா");
    namesMap.put("AS", "அமெரிக்க சமோவா");
    namesMap.put("AT", "ஆஸ்திரியா");
    namesMap.put("AU", "ஆஸ்திரேலியா");
    namesMap.put("AW", "அரூபா");
    namesMap.put("AX", "ஆலந்து தீவுகள்");
    namesMap.put("AZ", "அஜர்பைஜான்");
    namesMap.put("BA", "போஸ்னியா மற்றும் ஹெர்ஸிகோவினா");
    namesMap.put("BB", "பார்படோஸ்");
    namesMap.put("BD", "பங்களாதேஷ்");
    namesMap.put("BE", "பெல்ஜியம்");
    namesMap.put("BF", "புர்கினா ஃபாஸோ");
    namesMap.put("BG", "பல்கேரியா");
    namesMap.put("BH", "பஹ்ரைன்");
    namesMap.put("BI", "புருண்டி");
    namesMap.put("BJ", "பெனின்");
    namesMap.put("BL", "செயின்ட் பார்தேலெமி");
    namesMap.put("BM", "பெர்முடா");
    namesMap.put("BN", "புரூனேய்");
    namesMap.put("BO", "பொலிவியா");
    namesMap.put("BR", "பிரேஸில்");
    namesMap.put("BS", "பஹாமாஸ்");
    namesMap.put("BT", "பூடான்");
    namesMap.put("BV", "பொவேட் தீவுகள்");
    namesMap.put("BW", "போட்ஸ்வானா");
    namesMap.put("BY", "பெலாரூஸ்");
    namesMap.put("BZ", "பெலிஸ்");
    namesMap.put("CA", "கனடா");
    namesMap.put("CC", "காகோஸ் தீவுகள்");
    namesMap.put("CD", "காங்கோ - கின்ஷாசா");
    namesMap.put("CF", "மத்திய ஆப்ரிக்கக் குடியரசு");
    namesMap.put("CG", "காங்கோ - ப்ராஸாவில்லே");
    namesMap.put("CH", "ஸ்விட்சர்லாந்து");
    namesMap.put("CI", "ஐவரி கோஸ்ட்");
    namesMap.put("CK", "குக் தீவுகள்");
    namesMap.put("CL", "சிலி");
    namesMap.put("CM", "கேமரூன்");
    namesMap.put("CN", "சீனா");
    namesMap.put("CO", "கொலம்பியா");
    namesMap.put("CP", "கிலிப்பர்டன் தீவு");
    namesMap.put("CR", "கோஸ்டாரிகா");
    namesMap.put("CS", "செர்பியா மற்றும் மான்டேநெக்ரோ");
    namesMap.put("CU", "கியூபா");
    namesMap.put("CV", "கேப் வெர்டே");
    namesMap.put("CX", "கிறிஸ்துமஸ் தீவு");
    namesMap.put("CY", "சைப்ரஸ்");
    namesMap.put("CZ", "செக் குடியரசு");
    namesMap.put("DE", "ஜெர்மன்");
    namesMap.put("DG", "டியகோ கார்ஷியா");
    namesMap.put("DJ", "ஜிபௌட்டி");
    namesMap.put("DK", "டென்மார்க்");
    namesMap.put("DM", "டொமினிகா");
    namesMap.put("DO", "டொமினிகன் குடியரசு");
    namesMap.put("DZ", "அல்ஜீரியா");
    namesMap.put("EA", "சியூடா மற்றும் மெலில்லா");
    namesMap.put("EC", "ஈக்வடார்");
    namesMap.put("EE", "எஸ்டோனியா");
    namesMap.put("EG", "எகிப்து");
    namesMap.put("EH", "மேற்கு சஹாரா");
    namesMap.put("ER", "எரிட்ரியா");
    namesMap.put("ES", "ஸ்பெயின்");
    namesMap.put("ET", "எதியோப்பியா");
    namesMap.put("EU", "ஐரோப்பியன் யூனியன்");
    namesMap.put("FI", "பின்லாந்து");
    namesMap.put("FJ", "ஃபிஜி");
    namesMap.put("FK", "ஃபாக்லாந்து தீவுகள்");
    namesMap.put("FM", "மைக்ரோனேஷியா");
    namesMap.put("FO", "ஃபெரௌ தீவுகள்");
    namesMap.put("FR", "பிரான்ஸ்");
    namesMap.put("GA", "கேபான்");
    namesMap.put("GB", "பிரிடிஷ் கூட்டரசு");
    namesMap.put("GD", "கிரனெடா");
    namesMap.put("GE", "ஜார்ஜியா");
    namesMap.put("GF", "ஃப்ரென்ச் கயானா");
    namesMap.put("GG", "கெர்ன்சி");
    namesMap.put("GH", "கானா");
    namesMap.put("GI", "ஜிப்ரால்டர்");
    namesMap.put("GL", "கிரீன்லாந்து");
    namesMap.put("GM", "காம்பியா");
    namesMap.put("GN", "கினியா");
    namesMap.put("GP", "க்வாதேலோப்");
    namesMap.put("GQ", "ஈக்குவாடோரியல் கினி");
    namesMap.put("GR", "கிரீஸ்");
    namesMap.put("GS", "தென் ஜியார்ஜியா மற்றும் தென் சான்ட்விச் தீவுகள்");
    namesMap.put("GT", "குவாத்தாமாலா");
    namesMap.put("GU", "குவாம்");
    namesMap.put("GW", "கினி-பிஸ்ஸாவ்");
    namesMap.put("GY", "கயானா");
    namesMap.put("HK", "ஹாங்காங்");
    namesMap.put("HM", "ஹேர்ட் மற்றும் மெக்டொனால்டு");
    namesMap.put("HN", "ஹாண்டுராஸ்");
    namesMap.put("HR", "குரோசியா");
    namesMap.put("HT", "ஹெய்தி");
    namesMap.put("HU", "ஹங்கேரி");
    namesMap.put("IC", "கேனரி தீவுகள்");
    namesMap.put("ID", "இந்தோனேஷியா");
    namesMap.put("IE", "அயர்லாந்து");
    namesMap.put("IL", "இஸ்ரேல்");
    namesMap.put("IM", "ஐல் ஆஃப் மேன்");
    namesMap.put("IN", "இந்தியா");
    namesMap.put("IO", "பிரிட்டிஷ் இந்தியப் பெருங்கடல் பகுதி");
    namesMap.put("IQ", "இராக்");
    namesMap.put("IR", "ஈரான்");
    namesMap.put("IS", "ஐஸ்லாந்து");
    namesMap.put("IT", "இத்தாலி");
    namesMap.put("JE", "ஜெர்சி");
    namesMap.put("JM", "ஜமைகா");
    namesMap.put("JO", "ஜொர்டான்");
    namesMap.put("JP", "ஜப்பான்");
    namesMap.put("KE", "கென்யா");
    namesMap.put("KG", "கிர்கிஸ்தான்");
    namesMap.put("KH", "கம்போடியா");
    namesMap.put("KI", "கிரிபடி");
    namesMap.put("KM", "கோமரோஸ்");
    namesMap.put("KN", "செயின்ட் கிட்ஸ் மற்றும் நெவிஸ்");
    namesMap.put("KP", "வட கொரியா");
    namesMap.put("KR", "தென் கொரியா");
    namesMap.put("KW", "குவைத்து");
    namesMap.put("KY", "கேமென் தீவுகள்");
    namesMap.put("KZ", "கஸகஸ்தான்");
    namesMap.put("LA", "லாவோஸ்");
    namesMap.put("LB", "லெபனான்");
    namesMap.put("LC", "செயின்ட் லூசியா");
    namesMap.put("LI", "லிச்செண்ஸ்டெய்ன்");
    namesMap.put("LK", "இலங்கை");
    namesMap.put("LR", "லைபீரியா");
    namesMap.put("LS", "லெசோதோ");
    namesMap.put("LT", "லிதுவேனியா");
    namesMap.put("LU", "லக்ஸ்சம்பர்க்");
    namesMap.put("LV", "லாட்வியா");
    namesMap.put("LY", "லிபியா");
    namesMap.put("MA", "மொராக்கோ");
    namesMap.put("MC", "மொனாக்கோ");
    namesMap.put("MD", "மால்டோவா");
    namesMap.put("ME", "மான்டேனெக்ரோ");
    namesMap.put("MF", "செயின் மார்டீன்");
    namesMap.put("MG", "மடகாஸ்கர்");
    namesMap.put("MH", "மார்ஷல் தீவுகள்");
    namesMap.put("MK", "மாசிடோனியா");
    namesMap.put("ML", "மாலீ");
    namesMap.put("MM", "மியான்மார் [பர்மா]");
    namesMap.put("MN", "மங்கோலியா");
    namesMap.put("MO", "மகாவோ");
    namesMap.put("MP", "வடக்கு மரியானா தீவுகள்");
    namesMap.put("MQ", "மார்டினிக்");
    namesMap.put("MR", "மௌரிடானியா");
    namesMap.put("MS", "மௌன்ட்செராட்");
    namesMap.put("MT", "மால்டா");
    namesMap.put("MU", "மொரிசியஸ்");
    namesMap.put("MV", "மாலத்தீவு");
    namesMap.put("MW", "மாலவி");
    namesMap.put("MX", "மெக்சிகோ");
    namesMap.put("MY", "மலேஷியா");
    namesMap.put("MZ", "மொசாம்பிக்");
    namesMap.put("NA", "நமீபியா");
    namesMap.put("NC", "நியூ கேலிடோனியா");
    namesMap.put("NE", "நைஜர்");
    namesMap.put("NF", "நார்ஃபாக் தீவுகள்");
    namesMap.put("NG", "நைஜீரியா");
    namesMap.put("NI", "நிகாரகுவா");
    namesMap.put("NL", "நெதர்லாந்து");
    namesMap.put("NO", "நார்வே");
    namesMap.put("NP", "நேபாளம்");
    namesMap.put("NR", "நௌரு");
    namesMap.put("NU", "நியூ");
    namesMap.put("NZ", "நியூசிலாந்து");
    namesMap.put("OM", "ஓமன்");
    namesMap.put("PA", "பனாமா");
    namesMap.put("PE", "பெரு");
    namesMap.put("PF", "ஃப்ரென்ச் பாலினேஷியா");
    namesMap.put("PG", "பாப்புவா நியூ கினி");
    namesMap.put("PH", "பிலிப்பைன்ஸ்");
    namesMap.put("PK", "பாகிஸ்தான்");
    namesMap.put("PL", "போலந்து");
    namesMap.put("PM", "செயின்ட் பியர் மற்றும் மிக்வேலான்");
    namesMap.put("PN", "பிட்கெய்ர்ன்");
    namesMap.put("PR", "பியூர்டோ ரிகோ");
    namesMap.put("PS", "பாலஸ்தீனியன் மாஹாணங்கள்");
    namesMap.put("PT", "போர்ச்சுக்கல்");
    namesMap.put("PW", "பாலோ");
    namesMap.put("PY", "பாரகுவே");
    namesMap.put("QA", "கதார்");
    namesMap.put("QO", "ஔட்லையிங் ஓசானியா");
    namesMap.put("RE", "ரீயூனியன்");
    namesMap.put("RO", "ருமேனியா");
    namesMap.put("RS", "செர்பியா");
    namesMap.put("RU", "ரஷ்யா");
    namesMap.put("RW", "ருவான்டா");
    namesMap.put("SA", "சவூதி அரேபியா");
    namesMap.put("SB", "சாலமன் தீவுகள்");
    namesMap.put("SC", "ஸேசேல்ஸ்");
    namesMap.put("SD", "சூடான்");
    namesMap.put("SE", "ஸ்வீடன்");
    namesMap.put("SG", "சிங்கப்பூர்");
    namesMap.put("SH", "செயின்ட் ஹெலெனா");
    namesMap.put("SI", "ஸ்லோவேனியா");
    namesMap.put("SJ", "ஸ்வல்பார்டு மற்றும் ஜான் மேயன்");
    namesMap.put("SK", "ஸ்லோவாகியா");
    namesMap.put("SL", "சியர்ரா லியோன்");
    namesMap.put("SM", "சான் மெரினோ");
    namesMap.put("SN", "செனெகல்");
    namesMap.put("SO", "சொமாலியா");
    namesMap.put("SR", "சூரினாம்");
    namesMap.put("ST", "சாவ் தோம் மற்றும் ப்ரின்சிபி");
    namesMap.put("SV", "எல் சால்வடார்");
    namesMap.put("SY", "சிரியா");
    namesMap.put("SZ", "ஸ்வாஸிலாண்ட்");
    namesMap.put("TA", "டிரிஸ்டன் டா குன்ஹா");
    namesMap.put("TC", "டர்க்ஸ் மற்றும் கைகோஸ் தீவுகள்");
    namesMap.put("TD", "சாட்");
    namesMap.put("TF", "ஃப்ரென்ச் தெற்கு மாஹாணங்கள்");
    namesMap.put("TG", "டோகோ");
    namesMap.put("TH", "தாய்லாந்து");
    namesMap.put("TJ", "தாஜிகிஸ்தான்");
    namesMap.put("TK", "டோகேலோ");
    namesMap.put("TL", "கிழக்கு தைமூர்");
    namesMap.put("TM", "துர்க்மெனிஸ்தான்");
    namesMap.put("TN", "டுனிசியா");
    namesMap.put("TO", "டோங்கா");
    namesMap.put("TR", "துருக்கி");
    namesMap.put("TT", "ட்ரினிடாட் மற்றும் டுபாகோ");
    namesMap.put("TV", "துவாலூ");
    namesMap.put("TW", "தைவான்");
    namesMap.put("TZ", "டான்சானியா");
    namesMap.put("UA", "உக்ரைன்");
    namesMap.put("UG", "உகாண்டா");
    namesMap.put("UM", "யுனைட்டட் ஸ்டேட்ஸும் சிறிய அவுட்லைன் தீவுகளும்");
    namesMap.put("US", "ஐக்கிய அமெரிக்க குடியரசு");
    namesMap.put("UY", "உருகுவே");
    namesMap.put("UZ", "உஸ்பெகிஸ்தான்");
    namesMap.put("VA", "வாடிகன்");
    namesMap.put("VC", "செயின் வின்சன்ட் மற்றும் கிரெனடைன்ஸ்");
    namesMap.put("VE", "வெனஜுவேலா");
    namesMap.put("VG", "பிரிட்டீஷ் கன்னித் தீவுகள்");
    namesMap.put("VI", "யூ.எஸ் கன்னித் தீவுகள்");
    namesMap.put("VN", "வியட்நாம்");
    namesMap.put("VU", "வனுவாட்டு");
    namesMap.put("WF", "வாலிஸ் மற்றும் ஃபுடுனா தீவுகள்");
    namesMap.put("WS", "சமோவா");
    namesMap.put("YE", "ஏமன்");
    namesMap.put("YT", "மயோத்");
    namesMap.put("ZA", "தென் ஆப்பிரிக்கா");
    namesMap.put("ZM", "சாம்பியா");
    namesMap.put("ZW", "ஜிம்பாப்வே");
    namesMap.put("ZZ", "தெரியாத அல்லது செல்லாத பிரதேசம்");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "உலகம்",
        "002": "ஆப்ரிக்கா",
        "003": "வடக்கு அமெரிக்கா கண்டம்",
        "005": "தெற்கு அமெரிக்கா",
        "009": "ஓஷெனியா",
        "011": "மேற்கு ஆப்ரிக்கா",
        "013": "மத்திய அமெரிக்கா",
        "014": "கிழக்கு ஆப்ரிக்கா",
        "015": "வடக்கு ஆப்ரிக்கா",
        "017": "மத்திய ஆப்ரிக்கா",
        "018": "தென்னாப்ரிக்கா",
        "019": "அமெர்க்காஸ்",
        "021": "வடக்கு அமெரிக்கா",
        "029": "கரீபியன்",
        "030": "கிழக்கு ஆசியா",
        "034": "தெற்கு ஆசியா",
        "035": "தென்-கிழக்கு ஆசியா",
        "039": "தெற்கு ஐரோப்பா",
        "053": "ஆஸ்திரேலியா மற்றும் நியூசிலாந்து",
        "054": "மெலனேஷியா",
        "057": "மைக்ரோ நேஷியா பிரதேசம்",
        "061": "பாலினேஷியா",
        "062": "மத்திய-தெற்காசியா",
        "142": "ஆசியா",
        "143": "மத்திய ஆசியா",
        "145": "மேற்கு ஆசியா",
        "150": "ஈரோப்",
        "151": "கிழக்கு ஐரோப்பா",
        "154": "வடக்கு ஐரோப்பா",
        "155": "மேற்கு ஐரோப்பா",
        "172": "சுதந்திர மாநிலங்களின் காமன்வெல்த்",
        "200": "செகோஸ்லோவாக்யா",
        "419": "லத்தீன் அமெரிக்கா மற்றும் கரீபியன்",
        "830": "சேனல் தீவுகள்",
        "AC": "அஷன்ஷியன் தீவு",
        "AD": "அன்டோரா",
        "AE": "ஐக்கிய அரபு கூட்டாட்சி",
        "AF": "ஆப்கானிஸ்தான்",
        "AG": "ஆண்டிகுவா மற்றும் பார்புடா",
        "AI": "அங்குய்லா",
        "AL": "அல்பேனியா",
        "AM": "ஆர்மேனியா",
        "AN": "நெதர்லாந்து ஆண்டில்லெஸ்",
        "AO": "அங்கோலா",
        "AQ": "அண்டார்டிகா",
        "AR": "அர்ஜென்டினா",
        "AS": "அமெரிக்க சமோவா",
        "AT": "ஆஸ்திரியா",
        "AU": "ஆஸ்திரேலியா",
        "AW": "அரூபா",
        "AX": "ஆலந்து தீவுகள்",
        "AZ": "அஜர்பைஜான்",
        "BA": "போஸ்னியா மற்றும் ஹெர்ஸிகோவினா",
        "BB": "பார்படோஸ்",
        "BD": "பங்களாதேஷ்",
        "BE": "பெல்ஜியம்",
        "BF": "புர்கினா ஃபாஸோ",
        "BG": "பல்கேரியா",
        "BH": "பஹ்ரைன்",
        "BI": "புருண்டி",
        "BJ": "பெனின்",
        "BL": "செயின்ட் பார்தேலெமி",
        "BM": "பெர்முடா",
        "BN": "புரூனேய்",
        "BO": "பொலிவியா",
        "BR": "பிரேஸில்",
        "BS": "பஹாமாஸ்",
        "BT": "பூடான்",
        "BV": "பொவேட் தீவுகள்",
        "BW": "போட்ஸ்வானா",
        "BY": "பெலாரூஸ்",
        "BZ": "பெலிஸ்",
        "CA": "கனடா",
        "CC": "காகோஸ் தீவுகள்",
        "CD": "காங்கோ - கின்ஷாசா",
        "CF": "மத்திய ஆப்ரிக்கக் குடியரசு",
        "CG": "காங்கோ - ப்ராஸாவில்லே",
        "CH": "ஸ்விட்சர்லாந்து",
        "CI": "ஐவரி கோஸ்ட்",
        "CK": "குக் தீவுகள்",
        "CL": "சிலி",
        "CM": "கேமரூன்",
        "CN": "சீனா",
        "CO": "கொலம்பியா",
        "CP": "கிலிப்பர்டன் தீவு",
        "CR": "கோஸ்டாரிகா",
        "CS": "செர்பியா மற்றும் மான்டேநெக்ரோ",
        "CU": "கியூபா",
        "CV": "கேப் வெர்டே",
        "CX": "கிறிஸ்துமஸ் தீவு",
        "CY": "சைப்ரஸ்",
        "CZ": "செக் குடியரசு",
        "DE": "ஜெர்மன்",
        "DG": "டியகோ கார்ஷியா",
        "DJ": "ஜிபௌட்டி",
        "DK": "டென்மார்க்",
        "DM": "டொமினிகா",
        "DO": "டொமினிகன் குடியரசு",
        "DZ": "அல்ஜீரியா",
        "EA": "சியூடா மற்றும் மெலில்லா",
        "EC": "ஈக்வடார்",
        "EE": "எஸ்டோனியா",
        "EG": "எகிப்து",
        "EH": "மேற்கு சஹாரா",
        "ER": "எரிட்ரியா",
        "ES": "ஸ்பெயின்",
        "ET": "எதியோப்பியா",
        "EU": "ஐரோப்பியன் யூனியன்",
        "FI": "பின்லாந்து",
        "FJ": "ஃபிஜி",
        "FK": "ஃபாக்லாந்து தீவுகள்",
        "FM": "மைக்ரோனேஷியா",
        "FO": "ஃபெரௌ தீவுகள்",
        "FR": "பிரான்ஸ்",
        "GA": "கேபான்",
        "GB": "பிரிடிஷ் கூட்டரசு",
        "GD": "கிரனெடா",
        "GE": "ஜார்ஜியா",
        "GF": "ஃப்ரென்ச் கயானா",
        "GG": "கெர்ன்சி",
        "GH": "கானா",
        "GI": "ஜிப்ரால்டர்",
        "GL": "கிரீன்லாந்து",
        "GM": "காம்பியா",
        "GN": "கினியா",
        "GP": "க்வாதேலோப்",
        "GQ": "ஈக்குவாடோரியல் கினி",
        "GR": "கிரீஸ்",
        "GS": "தென் ஜியார்ஜியா மற்றும் தென் சான்ட்விச் தீவுகள்",
        "GT": "குவாத்தாமாலா",
        "GU": "குவாம்",
        "GW": "கினி-பிஸ்ஸாவ்",
        "GY": "கயானா",
        "HK": "ஹாங்காங்",
        "HM": "ஹேர்ட் மற்றும் மெக்டொனால்டு",
        "HN": "ஹாண்டுராஸ்",
        "HR": "குரோசியா",
        "HT": "ஹெய்தி",
        "HU": "ஹங்கேரி",
        "IC": "கேனரி தீவுகள்",
        "ID": "இந்தோனேஷியா",
        "IE": "அயர்லாந்து",
        "IL": "இஸ்ரேல்",
        "IM": "ஐல் ஆஃப் மேன்",
        "IN": "இந்தியா",
        "IO": "பிரிட்டிஷ் இந்தியப் பெருங்கடல் பகுதி",
        "IQ": "இராக்",
        "IR": "ஈரான்",
        "IS": "ஐஸ்லாந்து",
        "IT": "இத்தாலி",
        "JE": "ஜெர்சி",
        "JM": "ஜமைகா",
        "JO": "ஜொர்டான்",
        "JP": "ஜப்பான்",
        "KE": "கென்யா",
        "KG": "கிர்கிஸ்தான்",
        "KH": "கம்போடியா",
        "KI": "கிரிபடி",
        "KM": "கோமரோஸ்",
        "KN": "செயின்ட் கிட்ஸ் மற்றும் நெவிஸ்",
        "KP": "வட கொரியா",
        "KR": "தென் கொரியா",
        "KW": "குவைத்து",
        "KY": "கேமென் தீவுகள்",
        "KZ": "கஸகஸ்தான்",
        "LA": "லாவோஸ்",
        "LB": "லெபனான்",
        "LC": "செயின்ட் லூசியா",
        "LI": "லிச்செண்ஸ்டெய்ன்",
        "LK": "இலங்கை",
        "LR": "லைபீரியா",
        "LS": "லெசோதோ",
        "LT": "லிதுவேனியா",
        "LU": "லக்ஸ்சம்பர்க்",
        "LV": "லாட்வியா",
        "LY": "லிபியா",
        "MA": "மொராக்கோ",
        "MC": "மொனாக்கோ",
        "MD": "மால்டோவா",
        "ME": "மான்டேனெக்ரோ",
        "MF": "செயின் மார்டீன்",
        "MG": "மடகாஸ்கர்",
        "MH": "மார்ஷல் தீவுகள்",
        "MK": "மாசிடோனியா",
        "ML": "மாலீ",
        "MM": "மியான்மார் [பர்மா]",
        "MN": "மங்கோலியா",
        "MO": "மகாவோ",
        "MP": "வடக்கு மரியானா தீவுகள்",
        "MQ": "மார்டினிக்",
        "MR": "மௌரிடானியா",
        "MS": "மௌன்ட்செராட்",
        "MT": "மால்டா",
        "MU": "மொரிசியஸ்",
        "MV": "மாலத்தீவு",
        "MW": "மாலவி",
        "MX": "மெக்சிகோ",
        "MY": "மலேஷியா",
        "MZ": "மொசாம்பிக்",
        "NA": "நமீபியா",
        "NC": "நியூ கேலிடோனியா",
        "NE": "நைஜர்",
        "NF": "நார்ஃபாக் தீவுகள்",
        "NG": "நைஜீரியா",
        "NI": "நிகாரகுவா",
        "NL": "நெதர்லாந்து",
        "NO": "நார்வே",
        "NP": "நேபாளம்",
        "NR": "நௌரு",
        "NU": "நியூ",
        "NZ": "நியூசிலாந்து",
        "OM": "ஓமன்",
        "PA": "பனாமா",
        "PE": "பெரு",
        "PF": "ஃப்ரென்ச் பாலினேஷியா",
        "PG": "பாப்புவா நியூ கினி",
        "PH": "பிலிப்பைன்ஸ்",
        "PK": "பாகிஸ்தான்",
        "PL": "போலந்து",
        "PM": "செயின்ட் பியர் மற்றும் மிக்வேலான்",
        "PN": "பிட்கெய்ர்ன்",
        "PR": "பியூர்டோ ரிகோ",
        "PS": "பாலஸ்தீனியன் மாஹாணங்கள்",
        "PT": "போர்ச்சுக்கல்",
        "PW": "பாலோ",
        "PY": "பாரகுவே",
        "QA": "கதார்",
        "QO": "ஔட்லையிங் ஓசானியா",
        "RE": "ரீயூனியன்",
        "RO": "ருமேனியா",
        "RS": "செர்பியா",
        "RU": "ரஷ்யா",
        "RW": "ருவான்டா",
        "SA": "சவூதி அரேபியா",
        "SB": "சாலமன் தீவுகள்",
        "SC": "ஸேசேல்ஸ்",
        "SD": "சூடான்",
        "SE": "ஸ்வீடன்",
        "SG": "சிங்கப்பூர்",
        "SH": "செயின்ட் ஹெலெனா",
        "SI": "ஸ்லோவேனியா",
        "SJ": "ஸ்வல்பார்டு மற்றும் ஜான் மேயன்",
        "SK": "ஸ்லோவாகியா",
        "SL": "சியர்ரா லியோன்",
        "SM": "சான் மெரினோ",
        "SN": "செனெகல்",
        "SO": "சொமாலியா",
        "SR": "சூரினாம்",
        "ST": "சாவ் தோம் மற்றும் ப்ரின்சிபி",
        "SV": "எல் சால்வடார்",
        "SY": "சிரியா",
        "SZ": "ஸ்வாஸிலாண்ட்",
        "TA": "டிரிஸ்டன் டா குன்ஹா",
        "TC": "டர்க்ஸ் மற்றும் கைகோஸ் தீவுகள்",
        "TD": "சாட்",
        "TF": "ஃப்ரென்ச் தெற்கு மாஹாணங்கள்",
        "TG": "டோகோ",
        "TH": "தாய்லாந்து",
        "TJ": "தாஜிகிஸ்தான்",
        "TK": "டோகேலோ",
        "TL": "கிழக்கு தைமூர்",
        "TM": "துர்க்மெனிஸ்தான்",
        "TN": "டுனிசியா",
        "TO": "டோங்கா",
        "TR": "துருக்கி",
        "TT": "ட்ரினிடாட் மற்றும் டுபாகோ",
        "TV": "துவாலூ",
        "TW": "தைவான்",
        "TZ": "டான்சானியா",
        "UA": "உக்ரைன்",
        "UG": "உகாண்டா",
        "UM": "யுனைட்டட் ஸ்டேட்ஸும் சிறிய அவுட்லைன் தீவுகளும்",
        "US": "ஐக்கிய அமெரிக்க குடியரசு",
        "UY": "உருகுவே",
        "UZ": "உஸ்பெகிஸ்தான்",
        "VA": "வாடிகன்",
        "VC": "செயின் வின்சன்ட் மற்றும் கிரெனடைன்ஸ்",
        "VE": "வெனஜுவேலா",
        "VG": "பிரிட்டீஷ் கன்னித் தீவுகள்",
        "VI": "யூ.எஸ் கன்னித் தீவுகள்",
        "VN": "வியட்நாம்",
        "VU": "வனுவாட்டு",
        "WF": "வாலிஸ் மற்றும் ஃபுடுனா தீவுகள்",
        "WS": "சமோவா",
        "YE": "ஏமன்",
        "YT": "மயோத்",
        "ZA": "தென் ஆப்பிரிக்கா",
        "ZM": "சாம்பியா",
        "ZW": "ஜிம்பாப்வே",
        "ZZ": "தெரியாத அல்லது செல்லாத பிரதேசம்"
    };
  }-*/;
}
