(** Bookmarks - Incomplete and unsupported. *)
type target = int(* Just page number for now *)

(** The type of bookmarks. *)
type bookmark =
  {level : int;
   text : string;
   target : target;
   isopen : bool}

val pagenumber_of_target : target -> int

val target_of_pagenumber : int -> target

val read_bookmarks : Pdf.pdfdoc -> bookmark list
(** Read the bookmarks from a document. *)

val remove_bookmarks : Pdf.pdfdoc -> Pdf.pdfdoc
(** Remove the bookmarks from a document. *)

val add_bookmarks : bookmark list -> Pdf.pdfdoc -> Pdf.pdfdoc
(** Add bookmarks to a document, replacing any currently there. *)
