/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/***********************************************************************
 * This program saves a copy of its input to a file and prints a copy to
 * the standard output.
 *
 * Author: James Hall
 */

#include <stdio.h>
#include "getopt.h"
#include "freedos.h"


void usage (void);


main (int argc, char **argv)
{
  int i;
  char ch;
  FILE *pFile;

  /* Check the command line */

  while ((i = getopt (argc, argv, "?")) != EOF)
    {
      switch (i)
	{
	default:
	  usage ();
	  break;
	}
    }

  if (argc != 2)
    {
      usage ();
    }

  /* Open the output file */

  if ((pFile = fopen (argv[1], "w")) == NULL)
    {
      fprintf (stderr, "Cannot open output file %s\n", argv[1]);
      exit (2);
    }

  /* Tee the input */

  outtee (stdin, pFile, stdout);
  exit (0);
}

void 
usage (void)
{
  printp ("TEE", "Saves a copy of its input to a file and prints it.");
  printu ("TEE", "file");
  exit (1);
}
