/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.cert.X509Certificate;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.BinarySecurity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PKIPathSecurity
extends BinarySecurity {
    private static final String type = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1";

    public PKIPathSecurity(Element elem) throws WSSecurityException {
        super(elem);
        if (!this.getValueType().equals(PKIPathSecurity.getType())) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{type, this.getValueType()});
        }
    }

    public PKIPathSecurity(Document doc) {
        super(doc);
        this.setValueType(PKIPathSecurity.getType());
    }

    public X509Certificate[] getX509Certificates(boolean reverse, Crypto crypto) throws WSSecurityException {
        byte[] data = this.getToken();
        if (data == null) {
            return null;
        }
        return crypto.getX509Certificates(data, reverse);
    }

    public void setX509Certificates(X509Certificate[] certs, boolean reverse, Crypto crypto) throws WSSecurityException {
        if (certs == null) {
            throw new WSSecurityException(0, "noCert");
        }
        byte[] data = crypto.getCertificateData(reverse, certs);
        this.setToken(data);
    }

    public static String getType() {
        return type;
    }
}

