/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.bcf2;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.broadinstitute.variant.bcf2.BCF2Decoder;
import org.broadinstitute.variant.bcf2.BCF2Type;
import org.broadinstitute.variant.bcf2.BCF2Utils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.vcf.VCFHeader;

public class BCF2GenotypeFieldDecoders {
    private static final boolean ENABLE_FASTPATH_GT = true;
    private static final int MIN_SAMPLES_FOR_FASTPATH_GENOTYPES = 0;
    private final HashMap<String, Decoder> genotypeFieldDecoder = new HashMap();
    private final Decoder defaultDecoder = new GenericDecoder();

    public BCF2GenotypeFieldDecoders(VCFHeader header) {
        this.genotypeFieldDecoder.put("GT", new GTDecoder());
        this.genotypeFieldDecoder.put("FT", new FTDecoder());
        this.genotypeFieldDecoder.put("DP", new DPDecoder());
        this.genotypeFieldDecoder.put("AD", new ADDecoder());
        this.genotypeFieldDecoder.put("PL", new PLDecoder());
        this.genotypeFieldDecoder.put("GQ", new GQDecoder());
    }

    @Requires(value={"field != null"})
    @Ensures(value={"result != null"})
    public Decoder getDecoder(String field) {
        Decoder d = this.genotypeFieldDecoder.get(field);
        return d == null ? this.defaultDecoder : d;
    }

    private class FTDecoder
    implements Decoder {
        private FTDecoder() {
        }

        @Override
        public void decode(List<Allele> siteAlleles, String field, BCF2Decoder decoder, byte typeDescriptor, int numElements, GenotypeBuilder[] gbs) throws IOException {
            for (GenotypeBuilder gb : gbs) {
                Object value = decoder.decodeTypedValue(typeDescriptor, numElements);
                assert (value == null || value instanceof String);
                gb.filter((String)value);
            }
        }
    }

    private class GenericDecoder
    implements Decoder {
        private GenericDecoder() {
        }

        @Override
        public void decode(List<Allele> siteAlleles, String field, BCF2Decoder decoder, byte typeDescriptor, int numElements, GenotypeBuilder[] gbs) throws IOException {
            for (GenotypeBuilder gb : gbs) {
                Object value = decoder.decodeTypedValue(typeDescriptor, numElements);
                if (value == null) continue;
                if (value instanceof List && ((List)value).size() == 1) {
                    value = ((List)value).get(0);
                }
                gb.attribute(field, value);
            }
        }
    }

    private class PLDecoder
    implements Decoder {
        private PLDecoder() {
        }

        @Override
        public void decode(List<Allele> siteAlleles, String field, BCF2Decoder decoder, byte typeDescriptor, int numElements, GenotypeBuilder[] gbs) throws IOException {
            for (GenotypeBuilder gb : gbs) {
                gb.PL(decoder.decodeIntArray(typeDescriptor, numElements));
            }
        }
    }

    private class ADDecoder
    implements Decoder {
        private ADDecoder() {
        }

        @Override
        public void decode(List<Allele> siteAlleles, String field, BCF2Decoder decoder, byte typeDescriptor, int numElements, GenotypeBuilder[] gbs) throws IOException {
            for (GenotypeBuilder gb : gbs) {
                gb.AD(decoder.decodeIntArray(typeDescriptor, numElements));
            }
        }
    }

    private class GQDecoder
    implements Decoder {
        private GQDecoder() {
        }

        @Override
        public void decode(List<Allele> siteAlleles, String field, BCF2Decoder decoder, byte typeDescriptor, int numElements, GenotypeBuilder[] gbs) throws IOException {
            for (GenotypeBuilder gb : gbs) {
                gb.GQ(decoder.decodeInt(typeDescriptor, -1));
            }
        }
    }

    private class DPDecoder
    implements Decoder {
        private DPDecoder() {
        }

        @Override
        public void decode(List<Allele> siteAlleles, String field, BCF2Decoder decoder, byte typeDescriptor, int numElements, GenotypeBuilder[] gbs) throws IOException {
            for (GenotypeBuilder gb : gbs) {
                gb.DP(decoder.decodeInt(typeDescriptor, -1));
            }
        }
    }

    private class GTDecoder
    implements Decoder {
        private GTDecoder() {
        }

        @Override
        public void decode(List<Allele> siteAlleles, String field, BCF2Decoder decoder, byte typeDescriptor, int numElements, GenotypeBuilder[] gbs) throws IOException {
            if (siteAlleles.size() == 2 && numElements == 2 && gbs.length >= 0) {
                this.fastBiallelicDiploidDecode(siteAlleles, decoder, typeDescriptor, gbs);
            } else {
                this.generalDecode(siteAlleles, numElements, decoder, typeDescriptor, gbs);
            }
        }

        @Requires(value={"siteAlleles.size() == 2"})
        private final void fastBiallelicDiploidDecode(List<Allele> siteAlleles, BCF2Decoder decoder, byte typeDescriptor, GenotypeBuilder[] gbs) throws IOException {
            BCF2Type type = BCF2Utils.decodeType(typeDescriptor);
            int nPossibleGenotypes = 9;
            Object[] allGenotypes = new Object[9];
            for (GenotypeBuilder gb : gbs) {
                int a1 = decoder.decodeInt(type);
                int a2 = decoder.decodeInt(type);
                if (a1 == type.getMissingBytes()) {
                    assert (a2 == type.getMissingBytes());
                    gb.alleles(null);
                } else if (a2 == type.getMissingBytes()) {
                    gb.alleles(Arrays.asList(this.getAlleleFromEncoded(siteAlleles, a1)));
                } else {
                    int offset = (a1 >> 1) * 3 + (a2 >> 1);
                    assert (offset < allGenotypes.length);
                    List<Allele> gt = (List<Allele>)allGenotypes[offset];
                    if (gt == null) {
                        Allele allele1 = this.getAlleleFromEncoded(siteAlleles, a1);
                        Allele allele2 = this.getAlleleFromEncoded(siteAlleles, a2);
                        allGenotypes[offset] = gt = Arrays.asList(allele1, allele2);
                    }
                    gb.alleles(gt);
                }
                boolean phased = (a1 & 1) == 1;
                gb.phased(phased);
            }
        }

        private final void generalDecode(List<Allele> siteAlleles, int ploidy, BCF2Decoder decoder, byte typeDescriptor, GenotypeBuilder[] gbs) throws IOException {
            BCF2Type type = BCF2Utils.decodeType(typeDescriptor);
            int[] tmp = new int[ploidy];
            for (GenotypeBuilder gb : gbs) {
                int[] encoded = decoder.decodeIntArray(ploidy, type, tmp);
                if (encoded == null) {
                    gb.alleles(null);
                    continue;
                }
                assert (encoded.length > 0);
                ArrayList<Allele> gt = new ArrayList<Allele>(encoded.length);
                for (int encode : encoded) {
                    gt.add(this.getAlleleFromEncoded(siteAlleles, encode));
                }
                gb.alleles(gt);
                boolean phased = (encoded[0] & 1) == 1;
                gb.phased(phased);
            }
        }

        @Requires(value={"siteAlleles != null && ! siteAlleles.isEmpty()", "encode >= 0"})
        @Ensures(value={"result != null"})
        private final Allele getAlleleFromEncoded(List<Allele> siteAlleles, int encode) {
            int offset = encode >> 1;
            return offset == 0 ? Allele.NO_CALL : siteAlleles.get(offset - 1);
        }
    }

    public static interface Decoder {
        @Requires(value={"siteAlleles != null", "! siteAlleles.isEmpty()", "field != null", "decoder != null", "gbs != null", "gbs.length != 0"})
        public void decode(List<Allele> var1, String var2, BCF2Decoder var3, byte var4, int var5, GenotypeBuilder[] var6) throws IOException;
    }
}

