/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractButtonDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.fixture.TextDisplayFixture;
import org.fest.swing.fixture.TwoStateButtonFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JToggleButtonFixture
extends ComponentFixture<JToggleButton>
implements CommonComponentFixture,
JComponentFixture,
JPopupMenuInvokerFixture,
TextDisplayFixture,
TwoStateButtonFixture {
    private AbstractButtonDriver driver;

    public JToggleButtonFixture(Robot robot, JToggleButton target) {
        super(robot, target);
        this.createDriver();
    }

    public JToggleButtonFixture(Robot robot, String toggleButtonName) {
        super(robot, toggleButtonName, JToggleButton.class);
        this.createDriver();
    }

    private void createDriver() {
        this.driver(new AbstractButtonDriver(this.robot));
    }

    protected final void driver(AbstractButtonDriver newDriver) {
        JToggleButtonFixture.validateNotNull(newDriver);
        this.driver = newDriver;
    }

    @Override
    public String text() {
        return this.driver.textOf((AbstractButton)this.target);
    }

    public JToggleButtonFixture check() {
        this.driver.select((AbstractButton)this.target);
        return this;
    }

    public JToggleButtonFixture uncheck() {
        this.driver.unselect((AbstractButton)this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JToggleButtonFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JToggleButtonFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JToggleButtonFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JToggleButtonFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JToggleButtonFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JToggleButtonFixture requireSelected() {
        this.driver.requireSelected((AbstractButton)this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture requireNotSelected() {
        this.driver.requireNotSelected((AbstractButton)this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture requireText(String expected) {
        this.driver.requireText((AbstractButton)this.target, expected);
        return this;
    }

    @Override
    public JToggleButtonFixture requireText(Pattern pattern) {
        this.driver.requireText((AbstractButton)this.target, pattern);
        return this;
    }

    @Override
    public JToggleButtonFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JToggleButtonFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JToggleButtonFixture requireToolTip(String expected) {
        this.driver.requireToolTip((JComponent)this.target, expected);
        return this;
    }

    @Override
    public JToggleButtonFixture requireToolTip(Pattern pattern) {
        this.driver.requireToolTip((JComponent)this.target, pattern);
        return this;
    }

    @Override
    public Object clientProperty(Object key) {
        return this.driver.clientProperty((JComponent)this.target, key);
    }

    @Override
    public JPopupMenuFixture showPopupMenu() {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target));
    }

    @Override
    public JPopupMenuFixture showPopupMenuAt(Point p) {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target, p));
    }
}

