/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_OperatingSystemCurrentRunLevelAccess.h"

string _InstanceID;
const string _ElementName = "CurrentRunLevel";

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(_InstanceID, errorMessage));
	_InstanceID = "OpenDRIM_OperatingSystem:" + _InstanceID + ":CurrentRunLevel";
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OperatingSystemCurrentRunLevel>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_OperatingSystemCurrentRunLevel instance;
	instance.setInstanceID(_InstanceID);
	if (discriminant == "ei") {
		CF_assert(OS_OpenDRIM_OperatingSystemCurrentRunLevel_getInstanceInfo(instance, errorMessage));
	}
	result.push_back(instance);
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OperatingSystemCurrentRunLevel& instance, const char** properties, string& errorMessage) {
	_E_;
	string InstanceID;
	instance.getInstanceID(InstanceID);
	if (!CF_strCmpNoCase(InstanceID, _InstanceID))
		return NOT_FOUND;
	CF_assert(OS_OpenDRIM_OperatingSystemCurrentRunLevel_getInstanceInfo(instance, errorMessage));
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemCurrentRunLevel& newInstance, const OpenDRIM_OperatingSystemCurrentRunLevel& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	unsigned char newValue, oldValue;
	oldInstance.getValue(oldValue);
	if (newInstance.getValue(newValue) == OK && newValue != oldValue) {
		CF_assert(OS_OpenDRIM_OperatingSystemCurrentRunLevel_setValue(newValue, errorMessage));
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemCurrentRunLevel& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemCurrentRunLevel& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_populate(OpenDRIM_OperatingSystemCurrentRunLevel& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_getInstanceInfo(OpenDRIM_OperatingSystemCurrentRunLevel& instance, string& errorMessage) {
	_E_;
	instance.setElementName(_ElementName);
	instance.setChangeableType(1);
	unsigned char Value;
	CF_assert(OS_OpenDRIM_OperatingSystemCurrentRunLevel_getValue(Value, errorMessage));
	instance.setValue(Value);
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_getValue(unsigned char& Value, string& errorMessage) {
	_E_;
	string runlevel, stdErr;
	CF_assert(CF_runCommand("/sbin/runlevel", runlevel, stdErr, errorMessage));
	vector<string> runlevel_elements;
	CF_splitTextBySpace(runlevel_elements, runlevel);
	if (runlevel_elements.size() < 2) {
		errorMessage = "Wrong level: /sbin/runlevel";
		return FAILED;
	}
	Value = atoi(runlevel_elements[1].c_str());
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_setValue(const unsigned char& newValue, string& errorMessage) {
	_E_;
	if (newValue > 6) {
		errorMessage = "Invalid property value (0 <= Value <= 6): Value";
		return FAILED;
	}
	string stdOut, stdErr;
	CF_assert(CF_runCommand("/sbin/telinit " + CF_intToStr(newValue), stdOut, stdErr, errorMessage));
	_L_;
	return OK;
}
