#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# My Lovely Family:
# - My Lovely Daughter
# - My Lovely Wife
# send your bug reports to contact@dotslashplay.it
###

script_version=20240426.2

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID_DAUGHTER='my-lovely-daughter'
GAME_NAME_DAUGHTER='My Lovely Daughter'

GAME_ID_WIFE='my-lovely-wife'
GAME_NAME_WIFE='My Lovely Wife'

ARCHIVE_BASE_DAUGHTER_0_NAME='setup_my_lovely_daughter_1.27f6_gog_linkfix_(70980).exe'
ARCHIVE_BASE_DAUGHTER_0_MD5='66af1010c276944acc0c66ebef72cc0e'
ARCHIVE_BASE_DAUGHTER_0_TYPE='innosetup'
ARCHIVE_BASE_DAUGHTER_0_SIZE='337658'
ARCHIVE_BASE_DAUGHTER_0_VERSION='1.27f6-gog70980'
ARCHIVE_BASE_DAUGHTER_0_URL='https://www.gog.com/game/my_lovely_daughter'

ARCHIVE_BASE_WIFE_0_NAME='setup_my_lovely_wife_1.1.11_gog_(70816).exe'
ARCHIVE_BASE_WIFE_0_MD5='52472f09b7516676b29a43e3a40cd121'
ARCHIVE_BASE_WIFE_0_TYPE='innosetup'
ARCHIVE_BASE_WIFE_0_SIZE='691604'
ARCHIVE_BASE_WIFE_0_VERSION='1.1.11-gog70816'
ARCHIVE_BASE_WIFE_0_URL='https://www.gog.com/game/my_lovely_wife'

UNITY3D_NAME_DAUGHTER='my lovely daughter'
UNITY3D_NAME_WIFE='my lovely wife'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES_DAUGHTER='
users/${USER}/AppData/LocalLow/GameChanger Studio/My Lovely Daughter'
WINE_PERSISTENT_DIRECTORIES_WIFE='
users/${USER}/AppData/LocalLow/GameChanger Studio/My Lovely Wife'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID_DAUGHTER="${GAME_ID_DAUGHTER}-data"
PKG_DATA_ID_WIFE="${GAME_ID_WIFE}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS_DAUGHTER="$PKG_DATA_ID_DAUGHTER"
PKG_BIN_DEPS_WIFE="$PKG_DATA_ID_WIFE"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
