#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Baldur's Gate 3
###

script_version=20240703.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='baldurs-gate-3'
GAME_NAME='Baldurʼs Gate Ⅲ'

ARCHIVE_BASE_PATCH6_1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479).exe'
ARCHIVE_BASE_PATCH6_1_MD5='a68f1a0edcf026a1095c20efe1fa6edc'
ARCHIVE_BASE_PATCH6_1_TYPE='innosetup'
ARCHIVE_BASE_PATCH6_1_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-1.bin'
ARCHIVE_BASE_PATCH6_1_PART1_MD5='c479abb170e4741bf731d5c89cb985c5'
ARCHIVE_BASE_PATCH6_1_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-2.bin'
ARCHIVE_BASE_PATCH6_1_PART2_MD5='4d3c3d90c5b70abf10502b2eac7e7b91'
ARCHIVE_BASE_PATCH6_1_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-3.bin'
ARCHIVE_BASE_PATCH6_1_PART3_MD5='34e7830447cfe59b71a6d3cdc627d473'
ARCHIVE_BASE_PATCH6_1_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-4.bin'
ARCHIVE_BASE_PATCH6_1_PART4_MD5='7700f5bd163051ad3b544920267158a5'
ARCHIVE_BASE_PATCH6_1_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-5.bin'
ARCHIVE_BASE_PATCH6_1_PART5_MD5='f7e89a93a24a921c71ed7d9efdb2cc52'
ARCHIVE_BASE_PATCH6_1_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-6.bin'
ARCHIVE_BASE_PATCH6_1_PART6_MD5='cf6044ced2436c68fa644b16c43bd486'
ARCHIVE_BASE_PATCH6_1_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-7.bin'
ARCHIVE_BASE_PATCH6_1_PART7_MD5='91bb08a6576f56dc7eecdfc8475cbbea'
ARCHIVE_BASE_PATCH6_1_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-8.bin'
ARCHIVE_BASE_PATCH6_1_PART8_MD5='735d68133f1ad45d43b67a19bdcaf6b7'
ARCHIVE_BASE_PATCH6_1_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-9.bin'
ARCHIVE_BASE_PATCH6_1_PART9_MD5='76334ea7438e73cb4ff83f03b9aa4f0b'
ARCHIVE_BASE_PATCH6_1_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-10.bin'
ARCHIVE_BASE_PATCH6_1_PART10_MD5='d9ee57b1a0fa335c9ddbf8857cdf83b6'
ARCHIVE_BASE_PATCH6_1_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-11.bin'
ARCHIVE_BASE_PATCH6_1_PART11_MD5='eae123041bbf9f775b285da32ffa234c'
ARCHIVE_BASE_PATCH6_1_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-12.bin'
ARCHIVE_BASE_PATCH6_1_PART12_MD5='ccd6d28381f5e375aec2768714b8f825'
ARCHIVE_BASE_PATCH6_1_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-13.bin'
ARCHIVE_BASE_PATCH6_1_PART13_MD5='8042f5a7280456fe309dd7840c04125f'
ARCHIVE_BASE_PATCH6_1_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-14.bin'
ARCHIVE_BASE_PATCH6_1_PART14_MD5='71899991f13404154119dc4eb88ee68d'
ARCHIVE_BASE_PATCH6_1_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-15.bin'
ARCHIVE_BASE_PATCH6_1_PART15_MD5='23f96cb8a4c49d99935805a9b7c531e1'
ARCHIVE_BASE_PATCH6_1_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-16.bin'
ARCHIVE_BASE_PATCH6_1_PART16_MD5='2adbe0b025aacbd2a24d8f91caed65c6'
ARCHIVE_BASE_PATCH6_1_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-17.bin'
ARCHIVE_BASE_PATCH6_1_PART17_MD5='518e9ea117e9bab82e3ba3ff12ee99a3'
ARCHIVE_BASE_PATCH6_1_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-18.bin'
ARCHIVE_BASE_PATCH6_1_PART18_MD5='d1c1b477754b7f2661b0669c8b3eebd4'
ARCHIVE_BASE_PATCH6_1_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-19.bin'
ARCHIVE_BASE_PATCH6_1_PART19_MD5='0b93534901cbfb0c523c690181cc4bde'
ARCHIVE_BASE_PATCH6_1_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-20.bin'
ARCHIVE_BASE_PATCH6_1_PART20_MD5='d8efb4ef169d590c89f884c240a0bf72'
ARCHIVE_BASE_PATCH6_1_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-21.bin'
ARCHIVE_BASE_PATCH6_1_PART21_MD5='b5babfb43c75a5b919e497d7d54c86bd'
ARCHIVE_BASE_PATCH6_1_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-22.bin'
ARCHIVE_BASE_PATCH6_1_PART22_MD5='bb9419ce976980f86df35a21646da355'
ARCHIVE_BASE_PATCH6_1_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-23.bin'
ARCHIVE_BASE_PATCH6_1_PART23_MD5='a2cb3ae76774d36ce04346510dd019b0'
ARCHIVE_BASE_PATCH6_1_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-24.bin'
ARCHIVE_BASE_PATCH6_1_PART24_MD5='a33ab802e04f0c4d4f17f1e7e9e8b94a'
ARCHIVE_BASE_PATCH6_1_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-25.bin'
ARCHIVE_BASE_PATCH6_1_PART25_MD5='9bdfa763b6832aff6dc023a2d8d340c9'
ARCHIVE_BASE_PATCH6_1_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-26.bin'
ARCHIVE_BASE_PATCH6_1_PART26_MD5='c852917906a08488e823e60500cfc175'
ARCHIVE_BASE_PATCH6_1_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-27.bin'
ARCHIVE_BASE_PATCH6_1_PART27_MD5='608cf14bb3839e87e755683ee22059bb'
ARCHIVE_BASE_PATCH6_1_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-28.bin'
ARCHIVE_BASE_PATCH6_1_PART28_MD5='f5b16334779fbb662323966ed4735f61'
ARCHIVE_BASE_PATCH6_1_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-29.bin'
ARCHIVE_BASE_PATCH6_1_PART29_MD5='441e05f65ad6f0cb2642c29468302385'
ARCHIVE_BASE_PATCH6_1_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-30.bin'
ARCHIVE_BASE_PATCH6_1_PART30_MD5='5565eb0a62b83e3ab2eab663f1ad802e'
ARCHIVE_BASE_PATCH6_1_PART31_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-31.bin'
ARCHIVE_BASE_PATCH6_1_PART31_MD5='b73f8e36b290be55b5aec3ba5aaf197e'
ARCHIVE_BASE_PATCH6_1_PART32_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-32.bin'
ARCHIVE_BASE_PATCH6_1_PART32_MD5='181d4fc84ee71980b1dce7d04003f5bf'
ARCHIVE_BASE_PATCH6_1_SIZE='149637909'
ARCHIVE_BASE_PATCH6_1_VERSION='4.1.1.5022896-gog72479'
ARCHIVE_BASE_PATCH6_1_URL='https://www.gog.com/game/baldurs_gate_iii'

ARCHIVE_BASE_PATCH6_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689).exe'
ARCHIVE_BASE_PATCH6_0_MD5='1adeda86e51f6dd711059c27e8d5224f'
ARCHIVE_BASE_PATCH6_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH6_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-1.bin'
ARCHIVE_BASE_PATCH6_0_PART1_MD5='c4274fcae2412d61045b986fa1368ed4'
ARCHIVE_BASE_PATCH6_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-2.bin'
ARCHIVE_BASE_PATCH6_0_PART2_MD5='d69c73883f75b5e40888b6bb218fb5fd'
ARCHIVE_BASE_PATCH6_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-3.bin'
ARCHIVE_BASE_PATCH6_0_PART3_MD5='fb8254fc7e30d46c6150dcf065651a1e'
ARCHIVE_BASE_PATCH6_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-4.bin'
ARCHIVE_BASE_PATCH6_0_PART4_MD5='304db0f5a987953c987eca014544fd56'
ARCHIVE_BASE_PATCH6_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-5.bin'
ARCHIVE_BASE_PATCH6_0_PART5_MD5='417ef6d694d4247f6d71e60ee0e90a65'
ARCHIVE_BASE_PATCH6_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-6.bin'
ARCHIVE_BASE_PATCH6_0_PART6_MD5='8c8a6f514debdd9088fe303c1297ab06'
ARCHIVE_BASE_PATCH6_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-7.bin'
ARCHIVE_BASE_PATCH6_0_PART7_MD5='7eeebee2ce06232bd75370172bdbb3ec'
ARCHIVE_BASE_PATCH6_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-8.bin'
ARCHIVE_BASE_PATCH6_0_PART8_MD5='70b3c3910424e753c49effc573fb52cd'
ARCHIVE_BASE_PATCH6_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-9.bin'
ARCHIVE_BASE_PATCH6_0_PART9_MD5='4ee21874b53da4039d946b2c8dcde9ea'
ARCHIVE_BASE_PATCH6_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-10.bin'
ARCHIVE_BASE_PATCH6_0_PART10_MD5='2f0403a69a7e968ab52c89aca56ffee7'
ARCHIVE_BASE_PATCH6_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-11.bin'
ARCHIVE_BASE_PATCH6_0_PART11_MD5='8168954995979ba3259ef515ac1399e6'
ARCHIVE_BASE_PATCH6_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-12.bin'
ARCHIVE_BASE_PATCH6_0_PART12_MD5='b1ed340641bb988cfe412c9c1f729f12'
ARCHIVE_BASE_PATCH6_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-13.bin'
ARCHIVE_BASE_PATCH6_0_PART13_MD5='831e762e66bcf2cf20a8434f35d1cc27'
ARCHIVE_BASE_PATCH6_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-14.bin'
ARCHIVE_BASE_PATCH6_0_PART14_MD5='be44bad0b9eb5cf649e3568f473b1331'
ARCHIVE_BASE_PATCH6_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-15.bin'
ARCHIVE_BASE_PATCH6_0_PART15_MD5='2140db0a5068b86d329bc55c26d4e822'
ARCHIVE_BASE_PATCH6_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-16.bin'
ARCHIVE_BASE_PATCH6_0_PART16_MD5='ed03595ca67160d089c305fb4c9bde3d'
ARCHIVE_BASE_PATCH6_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-17.bin'
ARCHIVE_BASE_PATCH6_0_PART17_MD5='0a0b02e5ba1a6079a038e0437afd1f2f'
ARCHIVE_BASE_PATCH6_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-18.bin'
ARCHIVE_BASE_PATCH6_0_PART18_MD5='aeb62197de4f69c0a019c391f3a7e3c3'
ARCHIVE_BASE_PATCH6_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-19.bin'
ARCHIVE_BASE_PATCH6_0_PART19_MD5='7fcf7864a1118e818c7de8362a88e5d2'
ARCHIVE_BASE_PATCH6_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-20.bin'
ARCHIVE_BASE_PATCH6_0_PART20_MD5='08cb9545c8f7e032a3dbabb6a24a363c'
ARCHIVE_BASE_PATCH6_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-21.bin'
ARCHIVE_BASE_PATCH6_0_PART21_MD5='fb6376493dba115a7c674899fddf28ce'
ARCHIVE_BASE_PATCH6_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-22.bin'
ARCHIVE_BASE_PATCH6_0_PART22_MD5='c4e8ac5364bc37eba2df4915439085f8'
ARCHIVE_BASE_PATCH6_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-23.bin'
ARCHIVE_BASE_PATCH6_0_PART23_MD5='a894d6a54bdc26ca8bcefd2554dedec9'
ARCHIVE_BASE_PATCH6_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-24.bin'
ARCHIVE_BASE_PATCH6_0_PART24_MD5='b422de0996ffb51c75ff00cf167c79cd'
ARCHIVE_BASE_PATCH6_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-25.bin'
ARCHIVE_BASE_PATCH6_0_PART25_MD5='4149e5c36d40b7bb0d00a1e99990ae2f'
ARCHIVE_BASE_PATCH6_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-26.bin'
ARCHIVE_BASE_PATCH6_0_PART26_MD5='da645662e22d6a56408c002c1a21d80e'
ARCHIVE_BASE_PATCH6_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-27.bin'
ARCHIVE_BASE_PATCH6_0_PART27_MD5='2e9e7ad933f31a6932a03cc96683996e'
ARCHIVE_BASE_PATCH6_0_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-28.bin'
ARCHIVE_BASE_PATCH6_0_PART28_MD5='534def45ff6461622c6ad00b1896064c'
ARCHIVE_BASE_PATCH6_0_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-29.bin'
ARCHIVE_BASE_PATCH6_0_PART29_MD5='969580653831dd9300a0140f956ba075'
ARCHIVE_BASE_PATCH6_0_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-30.bin'
ARCHIVE_BASE_PATCH6_0_PART30_MD5='bd384da9ed9589b42afe2bafdf16f84d'
ARCHIVE_BASE_PATCH6_0_PART31_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-31.bin'
ARCHIVE_BASE_PATCH6_0_PART31_MD5='6947e03d8f686bdde5e384b7b3443a30'
ARCHIVE_BASE_PATCH6_0_PART32_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4890942_-_patch_patch6_hotfix4__(64bit)_(71689)-32.bin'
ARCHIVE_BASE_PATCH6_0_PART32_MD5='c47aeb4934f076c85240bc5e1d42a59c'
ARCHIVE_BASE_PATCH6_0_SIZE='149344069'
ARCHIVE_BASE_PATCH6_0_VERSION='4.1.1.4890942-gog71689'

ARCHIVE_BASE_PATCH5_1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408).exe'
ARCHIVE_BASE_PATCH5_1_MD5='41d296389ec755596846312c290188ba'
ARCHIVE_BASE_PATCH5_1_TYPE='innosetup'
ARCHIVE_BASE_PATCH5_1_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-1.bin'
ARCHIVE_BASE_PATCH5_1_PART1_MD5='ebbff6fbb2a38f555a30fe8e5c1a8b31'
ARCHIVE_BASE_PATCH5_1_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-2.bin'
ARCHIVE_BASE_PATCH5_1_PART2_MD5='a6577500e4ae2df79027a3aab47180ce'
ARCHIVE_BASE_PATCH5_1_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-3.bin'
ARCHIVE_BASE_PATCH5_1_PART3_MD5='413949288793c7ef6e7576cb573e6561'
ARCHIVE_BASE_PATCH5_1_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-4.bin'
ARCHIVE_BASE_PATCH5_1_PART4_MD5='ba3b2132916fb1a9924668e9c121eacd'
ARCHIVE_BASE_PATCH5_1_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-5.bin'
ARCHIVE_BASE_PATCH5_1_PART5_MD5='2833f2573f0c231eace28e5d55cdf760'
ARCHIVE_BASE_PATCH5_1_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-6.bin'
ARCHIVE_BASE_PATCH5_1_PART6_MD5='a14412e73266f5284fe3512f8531d5d6'
ARCHIVE_BASE_PATCH5_1_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-7.bin'
ARCHIVE_BASE_PATCH5_1_PART7_MD5='598fb783c55f0e750ce0dc9ff33d4e91'
ARCHIVE_BASE_PATCH5_1_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-8.bin'
ARCHIVE_BASE_PATCH5_1_PART8_MD5='4f15395994841e57ab238a417ad19f76'
ARCHIVE_BASE_PATCH5_1_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-9.bin'
ARCHIVE_BASE_PATCH5_1_PART9_MD5='3e0aeed6e2f499b74889600415bbbee8'
ARCHIVE_BASE_PATCH5_1_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-10.bin'
ARCHIVE_BASE_PATCH5_1_PART10_MD5='bf3b28a6d1c8210cff15a0a49d4c3773'
ARCHIVE_BASE_PATCH5_1_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-11.bin'
ARCHIVE_BASE_PATCH5_1_PART11_MD5='fa4fd60332c20e30217197f58e4bbf1b'
ARCHIVE_BASE_PATCH5_1_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-12.bin'
ARCHIVE_BASE_PATCH5_1_PART12_MD5='d00c210e621ab8163a36ca5973d3b8af'
ARCHIVE_BASE_PATCH5_1_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-13.bin'
ARCHIVE_BASE_PATCH5_1_PART13_MD5='80208dd51f3b41543b34b8a08c611bd8'
ARCHIVE_BASE_PATCH5_1_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-14.bin'
ARCHIVE_BASE_PATCH5_1_PART14_MD5='130710e4e6c422769453b7949a783f85'
ARCHIVE_BASE_PATCH5_1_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-15.bin'
ARCHIVE_BASE_PATCH5_1_PART15_MD5='bfc6635ab6f90b5168f67b88d3f7b57a'
ARCHIVE_BASE_PATCH5_1_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-16.bin'
ARCHIVE_BASE_PATCH5_1_PART16_MD5='84f39956129ff4e43c5dbe61a316315a'
ARCHIVE_BASE_PATCH5_1_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-17.bin'
ARCHIVE_BASE_PATCH5_1_PART17_MD5='fb05f610719dfed7278af617d70093e0'
ARCHIVE_BASE_PATCH5_1_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-18.bin'
ARCHIVE_BASE_PATCH5_1_PART18_MD5='40495dfc26875491f29eadeabeb77308'
ARCHIVE_BASE_PATCH5_1_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-19.bin'
ARCHIVE_BASE_PATCH5_1_PART19_MD5='d428eecb383c1317570ef4f9663045c8'
ARCHIVE_BASE_PATCH5_1_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-20.bin'
ARCHIVE_BASE_PATCH5_1_PART20_MD5='cdb6f938deb3ce2bc122f9effcc489b7'
ARCHIVE_BASE_PATCH5_1_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-21.bin'
ARCHIVE_BASE_PATCH5_1_PART21_MD5='6cbcaa9b7c412231b592b436f4e5b77a'
ARCHIVE_BASE_PATCH5_1_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-22.bin'
ARCHIVE_BASE_PATCH5_1_PART22_MD5='a68accd6f697dc9c7542441ce4373c5f'
ARCHIVE_BASE_PATCH5_1_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-23.bin'
ARCHIVE_BASE_PATCH5_1_PART23_MD5='67045ba580bfe38320d046caebf82799'
ARCHIVE_BASE_PATCH5_1_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-24.bin'
ARCHIVE_BASE_PATCH5_1_PART24_MD5='77d5c61d647007d6c2ee522d82354c10'
ARCHIVE_BASE_PATCH5_1_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-25.bin'
ARCHIVE_BASE_PATCH5_1_PART25_MD5='17db3c1c0706d86d074bad776401dfae'
ARCHIVE_BASE_PATCH5_1_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-26.bin'
ARCHIVE_BASE_PATCH5_1_PART26_MD5='6dc6d4ef5c7b3c6fdef926c1dbb79abe'
ARCHIVE_BASE_PATCH5_1_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-27.bin'
ARCHIVE_BASE_PATCH5_1_PART27_MD5='15d16729ba8fd25eaf3fe95bcfd89863'
ARCHIVE_BASE_PATCH5_1_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-28.bin'
ARCHIVE_BASE_PATCH5_1_PART28_MD5='51458a5835f079f452fbb32e57fe29d3'
ARCHIVE_BASE_PATCH5_1_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-29.bin'
ARCHIVE_BASE_PATCH5_1_PART29_MD5='771fe718c64fa6bfd9ac57cba1c18d4e'
ARCHIVE_BASE_PATCH5_1_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-30.bin'
ARCHIVE_BASE_PATCH5_1_PART30_MD5='9d1e8c2dde7c7e8d7be9684a1d2936dc'
ARCHIVE_BASE_PATCH5_1_SIZE='144316256'
ARCHIVE_BASE_PATCH5_1_VERSION='4.1.1.4494476-gog70408'

ARCHIVE_BASE_PATCH5_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888).exe'
ARCHIVE_BASE_PATCH5_0_MD5='6862e7a492de45b737d78e08c281a511'
ARCHIVE_BASE_PATCH5_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH5_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-1.bin'
ARCHIVE_BASE_PATCH5_0_PART1_MD5='186c358ea2dc870e028ec0673a6365e3'
ARCHIVE_BASE_PATCH5_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-2.bin'
ARCHIVE_BASE_PATCH5_0_PART2_MD5='5cce05c8723bed050cda429c0f6c04e1'
ARCHIVE_BASE_PATCH5_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-3.bin'
ARCHIVE_BASE_PATCH5_0_PART3_MD5='d83a39fcd16e69d1279f265b4f01f9b5'
ARCHIVE_BASE_PATCH5_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-4.bin'
ARCHIVE_BASE_PATCH5_0_PART4_MD5='66d9b2aebad820e832e831634c0a7330'
ARCHIVE_BASE_PATCH5_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-5.bin'
ARCHIVE_BASE_PATCH5_0_PART5_MD5='68c8cdafb45c97a0cd1690d168862100'
ARCHIVE_BASE_PATCH5_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-6.bin'
ARCHIVE_BASE_PATCH5_0_PART6_MD5='1f70e6253abca8e03b16e9249ce4debd'
ARCHIVE_BASE_PATCH5_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-7.bin'
ARCHIVE_BASE_PATCH5_0_PART7_MD5='46af9f6c04b624c5049beee3dffc9696'
ARCHIVE_BASE_PATCH5_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-8.bin'
ARCHIVE_BASE_PATCH5_0_PART8_MD5='8f746939ff4e6407b78aa2f43dfc6392'
ARCHIVE_BASE_PATCH5_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-9.bin'
ARCHIVE_BASE_PATCH5_0_PART9_MD5='758b43451029e2f63ed1dbb9c987461b'
ARCHIVE_BASE_PATCH5_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-10.bin'
ARCHIVE_BASE_PATCH5_0_PART10_MD5='5d19fc102d11834f08cf6c1f0b925ea0'
ARCHIVE_BASE_PATCH5_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-11.bin'
ARCHIVE_BASE_PATCH5_0_PART11_MD5='a34ccbb9196795da458df88d16f29001'
ARCHIVE_BASE_PATCH5_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-12.bin'
ARCHIVE_BASE_PATCH5_0_PART12_MD5='4a0b02ed0fe0e213050ba36ca2c1e9bf'
ARCHIVE_BASE_PATCH5_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-13.bin'
ARCHIVE_BASE_PATCH5_0_PART13_MD5='4bba114b9fd38dc3b0c15aee4a7badc7'
ARCHIVE_BASE_PATCH5_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-14.bin'
ARCHIVE_BASE_PATCH5_0_PART14_MD5='26fab2816e6a90c46b26666a6c9825cc'
ARCHIVE_BASE_PATCH5_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-15.bin'
ARCHIVE_BASE_PATCH5_0_PART15_MD5='0c2e8f809fce1dc30d003512eeb9bdf5'
ARCHIVE_BASE_PATCH5_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-16.bin'
ARCHIVE_BASE_PATCH5_0_PART16_MD5='eb11c87799b0870c09dff97cd7d5d721'
ARCHIVE_BASE_PATCH5_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-17.bin'
ARCHIVE_BASE_PATCH5_0_PART17_MD5='679670d1c9e4b80cc4b7e1e8cd46b24a'
ARCHIVE_BASE_PATCH5_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-18.bin'
ARCHIVE_BASE_PATCH5_0_PART18_MD5='c01feb0bdf8b7677af42575c16cea2b3'
ARCHIVE_BASE_PATCH5_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-19.bin'
ARCHIVE_BASE_PATCH5_0_PART19_MD5='7f9b210f8afc3320bead9637edb882ac'
ARCHIVE_BASE_PATCH5_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-20.bin'
ARCHIVE_BASE_PATCH5_0_PART20_MD5='b4bc49e1a36c10cf1ad64665300f3d3a'
ARCHIVE_BASE_PATCH5_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-21.bin'
ARCHIVE_BASE_PATCH5_0_PART21_MD5='aa7c335e7ffc0bcda16d19817e7d2e32'
ARCHIVE_BASE_PATCH5_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-22.bin'
ARCHIVE_BASE_PATCH5_0_PART22_MD5='5d6cef68c2e0067d2aac4b891ddc15fe'
ARCHIVE_BASE_PATCH5_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-23.bin'
ARCHIVE_BASE_PATCH5_0_PART23_MD5='b7596a74a8d17ba53041f4cb65e7c275'
ARCHIVE_BASE_PATCH5_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-24.bin'
ARCHIVE_BASE_PATCH5_0_PART24_MD5='ee7278a6d7ddc74f9e84350c007d83f4'
ARCHIVE_BASE_PATCH5_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-25.bin'
ARCHIVE_BASE_PATCH5_0_PART25_MD5='5f53ee4b9c609e0e2033c24349c7c08f'
ARCHIVE_BASE_PATCH5_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-26.bin'
ARCHIVE_BASE_PATCH5_0_PART26_MD5='8bcc1faddcc9dbaea2181d6407944e91'
ARCHIVE_BASE_PATCH5_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-27.bin'
ARCHIVE_BASE_PATCH5_0_PART27_MD5='4be5806c0d26719004cf3c7f447a9adb'
ARCHIVE_BASE_PATCH5_0_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-28.bin'
ARCHIVE_BASE_PATCH5_0_PART28_MD5='2acf6acde88c6c7e38d2d018b9777321'
ARCHIVE_BASE_PATCH5_0_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-29.bin'
ARCHIVE_BASE_PATCH5_0_PART29_MD5='c02adb5c2f3492580e4b2264d678bbec'
ARCHIVE_BASE_PATCH5_0_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4251417_patch5_hotfix4__japanese_(64bit)_(69888)-30.bin'
ARCHIVE_BASE_PATCH5_0_PART30_MD5='9d686af3f1622d30a4636d97614a0e12'
ARCHIVE_BASE_PATCH5_0_SIZE='144082412'
ARCHIVE_BASE_PATCH5_0_VERSION='4.1.1.4251417-gog69888'

ARCHIVE_BASE_PATCH4_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995).exe'
ARCHIVE_BASE_PATCH4_0_MD5='ab6267432b272ff880127131e7b2f5f3'
ARCHIVE_BASE_PATCH4_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH4_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-1.bin'
ARCHIVE_BASE_PATCH4_0_PART1_MD5='df12c48514a6e053123b993536984db1'
ARCHIVE_BASE_PATCH4_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-2.bin'
ARCHIVE_BASE_PATCH4_0_PART2_MD5='7624eae52e3ba390cc451c92eb22971e'
ARCHIVE_BASE_PATCH4_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-3.bin'
ARCHIVE_BASE_PATCH4_0_PART3_MD5='55926fedfbe8bfc55259f43e279506c2'
ARCHIVE_BASE_PATCH4_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-4.bin'
ARCHIVE_BASE_PATCH4_0_PART4_MD5='6521b33ac90d7da85737fd789a035a4b'
ARCHIVE_BASE_PATCH4_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-5.bin'
ARCHIVE_BASE_PATCH4_0_PART5_MD5='9cab7eb4d37f6970d7c75620604f6260'
ARCHIVE_BASE_PATCH4_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-6.bin'
ARCHIVE_BASE_PATCH4_0_PART6_MD5='d6c465c93781fe3ff757c6c20a2ff373'
ARCHIVE_BASE_PATCH4_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-7.bin'
ARCHIVE_BASE_PATCH4_0_PART7_MD5='75a4703c4ab50e922f35c37dc0b2f91c'
ARCHIVE_BASE_PATCH4_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-8.bin'
ARCHIVE_BASE_PATCH4_0_PART8_MD5='2abf5bf419d07af67fa89ab9cf782401'
ARCHIVE_BASE_PATCH4_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-9.bin'
ARCHIVE_BASE_PATCH4_0_PART9_MD5='156c9711f63b8db03f31e41fd22e59af'
ARCHIVE_BASE_PATCH4_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-10.bin'
ARCHIVE_BASE_PATCH4_0_PART10_MD5='32430ec83c9b780c637c1d6b2de9ce68'
ARCHIVE_BASE_PATCH4_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-11.bin'
ARCHIVE_BASE_PATCH4_0_PART11_MD5='d0ae7f626c2f163f7192f2e6d10f09db'
ARCHIVE_BASE_PATCH4_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-12.bin'
ARCHIVE_BASE_PATCH4_0_PART12_MD5='5378372fae1cf46669db85f60091e77c'
ARCHIVE_BASE_PATCH4_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-13.bin'
ARCHIVE_BASE_PATCH4_0_PART13_MD5='f0e0d239c05867ceddd2f630794db82f'
ARCHIVE_BASE_PATCH4_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-14.bin'
ARCHIVE_BASE_PATCH4_0_PART14_MD5='49324f1d65939e8e41ea5530f369d5cd'
ARCHIVE_BASE_PATCH4_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-15.bin'
ARCHIVE_BASE_PATCH4_0_PART15_MD5='a6547b00be69663430c8c72bfa4a9f85'
ARCHIVE_BASE_PATCH4_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-16.bin'
ARCHIVE_BASE_PATCH4_0_PART16_MD5='c285e952585a260478c2d31f29448745'
ARCHIVE_BASE_PATCH4_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-17.bin'
ARCHIVE_BASE_PATCH4_0_PART17_MD5='d6fb24e9f9781f4f72c5435634ac6ac7'
ARCHIVE_BASE_PATCH4_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-18.bin'
ARCHIVE_BASE_PATCH4_0_PART18_MD5='c05f0ef6d178843fb0da80753752b5b5'
ARCHIVE_BASE_PATCH4_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-19.bin'
ARCHIVE_BASE_PATCH4_0_PART19_MD5='626615ae36a91d6f06b66f82090725e7'
ARCHIVE_BASE_PATCH4_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-20.bin'
ARCHIVE_BASE_PATCH4_0_PART20_MD5='e41563ed5af9e65893968dc4f3a3a11f'
ARCHIVE_BASE_PATCH4_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-21.bin'
ARCHIVE_BASE_PATCH4_0_PART21_MD5='f8c9ca01fa54f40c6720907a6754497c'
ARCHIVE_BASE_PATCH4_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-22.bin'
ARCHIVE_BASE_PATCH4_0_PART22_MD5='6c73b251f90ccdfc3478e36dd5c10ba2'
ARCHIVE_BASE_PATCH4_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-23.bin'
ARCHIVE_BASE_PATCH4_0_PART23_MD5='1b3b77c0ec4d9d0355964662ff82c9eb'
ARCHIVE_BASE_PATCH4_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-24.bin'
ARCHIVE_BASE_PATCH4_0_PART24_MD5='49538632c8eb659f017c3ae1a1698a1f'
ARCHIVE_BASE_PATCH4_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-25.bin'
ARCHIVE_BASE_PATCH4_0_PART25_MD5='6ee062ce652cb6606b9747f3ace8706e'
ARCHIVE_BASE_PATCH4_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-26.bin'
ARCHIVE_BASE_PATCH4_0_PART26_MD5='97fda2b27e9bf32387e17294f2dd05ed'
ARCHIVE_BASE_PATCH4_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-27.bin'
ARCHIVE_BASE_PATCH4_0_PART27_MD5='c4e2eee7ea51aa41ba1fcd2544a7423c'
ARCHIVE_BASE_PATCH4_0_SIZE='126864164'
ARCHIVE_BASE_PATCH4_0_VERSION='4.1.1.3956130-gog68995'

ARCHIVE_BASE_PATCH3_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008).exe'
ARCHIVE_BASE_PATCH3_0_MD5='e2da307eb714d2e746048e8fb7d646a4'
ARCHIVE_BASE_PATCH3_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH3_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-1.bin'
ARCHIVE_BASE_PATCH3_0_PART1_MD5='c1f97403bf1b7aef31aac7ac8a05c52c'
ARCHIVE_BASE_PATCH3_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-2.bin'
ARCHIVE_BASE_PATCH3_0_PART2_MD5='f758ba3cb8c8b92ec3f87d1b923b7c11'
ARCHIVE_BASE_PATCH3_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-3.bin'
ARCHIVE_BASE_PATCH3_0_PART3_MD5='0a74176898bbe90ba6df280d002c608f'
ARCHIVE_BASE_PATCH3_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-4.bin'
ARCHIVE_BASE_PATCH3_0_PART4_MD5='2839a599a52492bf7fc7e21a0f948792'
ARCHIVE_BASE_PATCH3_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-5.bin'
ARCHIVE_BASE_PATCH3_0_PART5_MD5='e6662560a171acf293da789ba73e66a5'
ARCHIVE_BASE_PATCH3_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-6.bin'
ARCHIVE_BASE_PATCH3_0_PART6_MD5='3fa48d0c2cbdb8d2bed0d7b1120e4807'
ARCHIVE_BASE_PATCH3_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-7.bin'
ARCHIVE_BASE_PATCH3_0_PART7_MD5='435d3b387cbd7f77149f4fd48e97172e'
ARCHIVE_BASE_PATCH3_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-8.bin'
ARCHIVE_BASE_PATCH3_0_PART8_MD5='3e6a2f03e58ec7067c9cebffc913144d'
ARCHIVE_BASE_PATCH3_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-9.bin'
ARCHIVE_BASE_PATCH3_0_PART9_MD5='9560938b6aa92559096c7db471c437fa'
ARCHIVE_BASE_PATCH3_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-10.bin'
ARCHIVE_BASE_PATCH3_0_PART10_MD5='42e9165bd6665754052936cf5949269a'
ARCHIVE_BASE_PATCH3_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-11.bin'
ARCHIVE_BASE_PATCH3_0_PART11_MD5='b536ed99f08843c8bb6c7af50f3a14b9'
ARCHIVE_BASE_PATCH3_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-12.bin'
ARCHIVE_BASE_PATCH3_0_PART12_MD5='86a43810f51761fd09a653f1b89e9936'
ARCHIVE_BASE_PATCH3_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-13.bin'
ARCHIVE_BASE_PATCH3_0_PART13_MD5='83d3432202ca5a775952afc001086a03'
ARCHIVE_BASE_PATCH3_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-14.bin'
ARCHIVE_BASE_PATCH3_0_PART14_MD5='db7dcdd36279cf06e014b3d51d06e978'
ARCHIVE_BASE_PATCH3_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-15.bin'
ARCHIVE_BASE_PATCH3_0_PART15_MD5='9e472641d3c34199dfeba8851f7bdcf5'
ARCHIVE_BASE_PATCH3_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-16.bin'
ARCHIVE_BASE_PATCH3_0_PART16_MD5='1f7d14f63ecafdbbcd727de7ac38223c'
ARCHIVE_BASE_PATCH3_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-17.bin'
ARCHIVE_BASE_PATCH3_0_PART17_MD5='f1359a59c61a955f0620febc487a1269'
ARCHIVE_BASE_PATCH3_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-18.bin'
ARCHIVE_BASE_PATCH3_0_PART18_MD5='bfd969ab39637c49b64f7cfaa1f20804'
ARCHIVE_BASE_PATCH3_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-19.bin'
ARCHIVE_BASE_PATCH3_0_PART19_MD5='e8eae4f90a2cea5bcbdee08a1b712aef'
ARCHIVE_BASE_PATCH3_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-20.bin'
ARCHIVE_BASE_PATCH3_0_PART20_MD5='b88525457e4b590b78c34f40e1ba60f0'
ARCHIVE_BASE_PATCH3_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-21.bin'
ARCHIVE_BASE_PATCH3_0_PART21_MD5='d74266b799d4d911838cf9173c87fda6'
ARCHIVE_BASE_PATCH3_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-22.bin'
ARCHIVE_BASE_PATCH3_0_PART22_MD5='75b917c7abbf4483a82b56b5395e39c0'
ARCHIVE_BASE_PATCH3_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-23.bin'
ARCHIVE_BASE_PATCH3_0_PART23_MD5='bd518745958733216fb50f9fce5cb494'
ARCHIVE_BASE_PATCH3_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-24.bin'
ARCHIVE_BASE_PATCH3_0_PART24_MD5='404946034a46864f9172c7b9cf13002b'
ARCHIVE_BASE_PATCH3_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-25.bin'
ARCHIVE_BASE_PATCH3_0_PART25_MD5='f6255a2a3130642c3f96fd43252e9dec'
ARCHIVE_BASE_PATCH3_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-26.bin'
ARCHIVE_BASE_PATCH3_0_PART26_MD5='d2bbcc99329999915b2b478e9d9218e4'
ARCHIVE_BASE_PATCH3_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-27.bin'
ARCHIVE_BASE_PATCH3_0_PART27_MD5='3e8cc3d3b3028f065e73296dcc714712'
ARCHIVE_BASE_PATCH3_0_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-28.bin'
ARCHIVE_BASE_PATCH3_0_PART28_MD5='1ad835b73e36f5fd9706f5a3e3ccd276'
ARCHIVE_BASE_PATCH3_0_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-29.bin'
ARCHIVE_BASE_PATCH3_0_PART29_MD5='27564ccea2ef5b369feee3b246631060'
ARCHIVE_BASE_PATCH3_0_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-30.bin'
ARCHIVE_BASE_PATCH3_0_PART30_MD5='c3729516a6fb77dad2f760ef9d21bb9a'
ARCHIVE_BASE_PATCH3_0_PART31_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-31.bin'
ARCHIVE_BASE_PATCH3_0_PART31_MD5='5fb4854aaac674f56a563dc4616b8792'
ARCHIVE_BASE_PATCH3_0_SIZE='156835644'
ARCHIVE_BASE_PATCH3_0_VERSION='4.1.1.3767641-gog68008'

ARCHIVE_BASE_PATCH2_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336).exe'
ARCHIVE_BASE_PATCH2_0_MD5='6eeac06fdc264d09052dd52a5d8f85fb'
ARCHIVE_BASE_PATCH2_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH2_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-1.bin'
ARCHIVE_BASE_PATCH2_0_PART1_MD5='a8ac39fc4ddd9dc8c8b451ddceb2bed7'
ARCHIVE_BASE_PATCH2_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-2.bin'
ARCHIVE_BASE_PATCH2_0_PART2_MD5='1e1806b014056b87e1d8d38310d27843'
ARCHIVE_BASE_PATCH2_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-3.bin'
ARCHIVE_BASE_PATCH2_0_PART3_MD5='3caaa1250e79563a94689b6cc7777226'
ARCHIVE_BASE_PATCH2_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-4.bin'
ARCHIVE_BASE_PATCH2_0_PART4_MD5='c73405adb39664c2580444be4d8f1e77'
ARCHIVE_BASE_PATCH2_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-5.bin'
ARCHIVE_BASE_PATCH2_0_PART5_MD5='d380505dfa53dfda7cfd446781cadc1e'
ARCHIVE_BASE_PATCH2_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-6.bin'
ARCHIVE_BASE_PATCH2_0_PART6_MD5='bbd932a09811206b178cbaaa3e1961f4'
ARCHIVE_BASE_PATCH2_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-7.bin'
ARCHIVE_BASE_PATCH2_0_PART7_MD5='9096d0e0d58509b010366140d74d0387'
ARCHIVE_BASE_PATCH2_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-8.bin'
ARCHIVE_BASE_PATCH2_0_PART8_MD5='bbfceef39180a8066727f23c9e494f9a'
ARCHIVE_BASE_PATCH2_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-9.bin'
ARCHIVE_BASE_PATCH2_0_PART9_MD5='5a118078fc27f3aa102023ef6f0f8b38'
ARCHIVE_BASE_PATCH2_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-10.bin'
ARCHIVE_BASE_PATCH2_0_PART10_MD5='0f221f4cb8c70bec4a76f605842e4b5a'
ARCHIVE_BASE_PATCH2_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-11.bin'
ARCHIVE_BASE_PATCH2_0_PART11_MD5='03bb396186275434f3630dcaea22f847'
ARCHIVE_BASE_PATCH2_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-12.bin'
ARCHIVE_BASE_PATCH2_0_PART12_MD5='94e6c7a3957f0692587dd1e17e57bd6b'
ARCHIVE_BASE_PATCH2_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-13.bin'
ARCHIVE_BASE_PATCH2_0_PART13_MD5='0e492c7302256ec45e5f01cb6d86f194'
ARCHIVE_BASE_PATCH2_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-14.bin'
ARCHIVE_BASE_PATCH2_0_PART14_MD5='2d476b947cd51d52d5406eb22772b370'
ARCHIVE_BASE_PATCH2_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-15.bin'
ARCHIVE_BASE_PATCH2_0_PART15_MD5='932de8332ecef4512f15942f306e35d9'
ARCHIVE_BASE_PATCH2_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-16.bin'
ARCHIVE_BASE_PATCH2_0_PART16_MD5='e7fd6a1d8b1191726d29beeb671db49a'
ARCHIVE_BASE_PATCH2_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-17.bin'
ARCHIVE_BASE_PATCH2_0_PART17_MD5='586951c282b7937106f303a80911245b'
ARCHIVE_BASE_PATCH2_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-18.bin'
ARCHIVE_BASE_PATCH2_0_PART18_MD5='f9a7d5f8dacd3469bdb79126bd4838e7'
ARCHIVE_BASE_PATCH2_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-19.bin'
ARCHIVE_BASE_PATCH2_0_PART19_MD5='9099f94ffe643239596ce857c1720e08'
ARCHIVE_BASE_PATCH2_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-20.bin'
ARCHIVE_BASE_PATCH2_0_PART20_MD5='9e20afbabdaea6d69bc51045da768f69'
ARCHIVE_BASE_PATCH2_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-21.bin'
ARCHIVE_BASE_PATCH2_0_PART21_MD5='4230156c15022f0634edd98542020683'
ARCHIVE_BASE_PATCH2_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-22.bin'
ARCHIVE_BASE_PATCH2_0_PART22_MD5='0471d8d45cd5eb7accdd16c563c1e972'
ARCHIVE_BASE_PATCH2_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-23.bin'
ARCHIVE_BASE_PATCH2_0_PART23_MD5='50d0b713eaa36adaf530f9bf87600baa'
ARCHIVE_BASE_PATCH2_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-24.bin'
ARCHIVE_BASE_PATCH2_0_PART24_MD5='05c0bdfd7c1b01083d511054f6a9f23a'
ARCHIVE_BASE_PATCH2_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-25.bin'
ARCHIVE_BASE_PATCH2_0_PART25_MD5='96141571c42a53a9bf78960e4c7d83ab'
ARCHIVE_BASE_PATCH2_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-26.bin'
ARCHIVE_BASE_PATCH2_0_PART26_MD5='3e23b9e016c006fae2c3c60a5af44a47'
ARCHIVE_BASE_PATCH2_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-27.bin'
ARCHIVE_BASE_PATCH2_0_PART27_MD5='b50cb9a55312f948909ee57c6ed09469'
ARCHIVE_BASE_PATCH2_0_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-28.bin'
ARCHIVE_BASE_PATCH2_0_PART28_MD5='24910c2975faf1762a177df3cb95c593'
ARCHIVE_BASE_PATCH2_0_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-29.bin'
ARCHIVE_BASE_PATCH2_0_PART29_MD5='2e4c222aabc70fd6068ad8834aaa7b2c'
ARCHIVE_BASE_PATCH2_0_SIZE='145464212'
ARCHIVE_BASE_PATCH2_0_VERSION='4.1.1.3700362-gog67336'
ARCHIVE_BASE_PATCH2_0_URL='https://www.gog.com/game/baldurs_gate_iii'

ARCHIVE_BASE_PATCH1_0_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052).exe'
ARCHIVE_BASE_PATCH1_0_MD5='09401cf3b960c56032b9c8d5492d2316'
ARCHIVE_BASE_PATCH1_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH1_0_PART1_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-1.bin'
ARCHIVE_BASE_PATCH1_0_PART1_MD5='f3a8409e3f4dd3db98bc5df6ce0742f5'
ARCHIVE_BASE_PATCH1_0_PART2_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-2.bin'
ARCHIVE_BASE_PATCH1_0_PART2_MD5='9135194fb160d8d8fb35aac207b668b3'
ARCHIVE_BASE_PATCH1_0_PART3_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-3.bin'
ARCHIVE_BASE_PATCH1_0_PART3_MD5='489c13ad3282beb71aa3de4db880fade'
ARCHIVE_BASE_PATCH1_0_PART4_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-4.bin'
ARCHIVE_BASE_PATCH1_0_PART4_MD5='24caf894181a2d7be008bfd6bce865a6'
ARCHIVE_BASE_PATCH1_0_PART5_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-5.bin'
ARCHIVE_BASE_PATCH1_0_PART5_MD5='17a4f372bd3d56a3b531eb2bf1c9f14d'
ARCHIVE_BASE_PATCH1_0_PART6_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-6.bin'
ARCHIVE_BASE_PATCH1_0_PART6_MD5='5897dad5e3de1419b13ea78ffb200510'
ARCHIVE_BASE_PATCH1_0_PART7_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-7.bin'
ARCHIVE_BASE_PATCH1_0_PART7_MD5='f652711efa1f8328d097be81527260f4'
ARCHIVE_BASE_PATCH1_0_PART8_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-8.bin'
ARCHIVE_BASE_PATCH1_0_PART8_MD5='748370642aefced9eb5647cc4e431828'
ARCHIVE_BASE_PATCH1_0_PART9_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-9.bin'
ARCHIVE_BASE_PATCH1_0_PART9_MD5='01e5e27b88c2d9a610136fafdb4b8f02'
ARCHIVE_BASE_PATCH1_0_PART10_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-10.bin'
ARCHIVE_BASE_PATCH1_0_PART10_MD5='084d3daf2161b8054e5a4d58fd859e80'
ARCHIVE_BASE_PATCH1_0_PART11_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-11.bin'
ARCHIVE_BASE_PATCH1_0_PART11_MD5='6a2e64ba408cfacc1cf4d4c87ef0ef7b'
ARCHIVE_BASE_PATCH1_0_PART12_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-12.bin'
ARCHIVE_BASE_PATCH1_0_PART12_MD5='c7936ac74791438308efb79b748a1a9e'
ARCHIVE_BASE_PATCH1_0_PART13_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-13.bin'
ARCHIVE_BASE_PATCH1_0_PART13_MD5='262a4d8e4c34d382a6220acf44205b84'
ARCHIVE_BASE_PATCH1_0_PART14_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-14.bin'
ARCHIVE_BASE_PATCH1_0_PART14_MD5='ccf42f75bdd18740ddc3680ece6c06b2'
ARCHIVE_BASE_PATCH1_0_PART15_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-15.bin'
ARCHIVE_BASE_PATCH1_0_PART15_MD5='2e2558d1b7c1d5252afcb6a0542b3848'
ARCHIVE_BASE_PATCH1_0_PART16_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-16.bin'
ARCHIVE_BASE_PATCH1_0_PART16_MD5='a7d40cc96e64cdb85aeccc2471900acc'
ARCHIVE_BASE_PATCH1_0_PART17_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-17.bin'
ARCHIVE_BASE_PATCH1_0_PART17_MD5='53b77f130bc641baf7e26007f9fc3849'
ARCHIVE_BASE_PATCH1_0_PART18_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-18.bin'
ARCHIVE_BASE_PATCH1_0_PART18_MD5='26ecb989f6d025bb4ab5ea726cacb496'
ARCHIVE_BASE_PATCH1_0_PART19_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-19.bin'
ARCHIVE_BASE_PATCH1_0_PART19_MD5='8f507b0da3729dba21989460f96d3781'
ARCHIVE_BASE_PATCH1_0_PART20_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-20.bin'
ARCHIVE_BASE_PATCH1_0_PART20_MD5='40493a3fb33da7202533823f1444b526'
ARCHIVE_BASE_PATCH1_0_PART21_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-21.bin'
ARCHIVE_BASE_PATCH1_0_PART21_MD5='8f2abd65aaaae133ac4e6233efda0654'
ARCHIVE_BASE_PATCH1_0_PART22_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-22.bin'
ARCHIVE_BASE_PATCH1_0_PART22_MD5='f5a21a6a93328adb55459b28d7096608'
ARCHIVE_BASE_PATCH1_0_PART23_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-23.bin'
ARCHIVE_BASE_PATCH1_0_PART23_MD5='0f2f3783421bbf5c7c714b0d99dc0bc2'
ARCHIVE_BASE_PATCH1_0_PART24_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-24.bin'
ARCHIVE_BASE_PATCH1_0_PART24_MD5='11ee20ad29f1dfa7ba9618664c974fa9'
ARCHIVE_BASE_PATCH1_0_PART25_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-25.bin'
ARCHIVE_BASE_PATCH1_0_PART25_MD5='4c93abd831b0469f2061f27b6ecaebe0'
ARCHIVE_BASE_PATCH1_0_PART26_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-26.bin'
ARCHIVE_BASE_PATCH1_0_PART26_MD5='610b63465163f61c5e645092800bc3d9'
ARCHIVE_BASE_PATCH1_0_PART27_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-27.bin'
ARCHIVE_BASE_PATCH1_0_PART27_MD5='9e81fa436fb596f0ae071ae1d7d660d6'
ARCHIVE_BASE_PATCH1_0_PART28_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-28.bin'
ARCHIVE_BASE_PATCH1_0_PART28_MD5='8581ed928d138c89a05d68a116684d7a'
ARCHIVE_BASE_PATCH1_0_SIZE='140000000'
ARCHIVE_BASE_PATCH1_0_VERSION='4.1.1.3669438-gog67052'

ARCHIVE_BASE_PATCH0_0_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683).exe'
ARCHIVE_BASE_PATCH0_0_MD5='986cbd346ca2444eba5ca65921557abc'
ARCHIVE_BASE_PATCH0_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH0_0_PART1_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-1.bin'
ARCHIVE_BASE_PATCH0_0_PART1_MD5='14c9146c4ef5c86dae1edcc4ffcf5953'
ARCHIVE_BASE_PATCH0_0_PART2_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-2.bin'
ARCHIVE_BASE_PATCH0_0_PART2_MD5='2768930a5a1f20998c087c483c298d4e'
ARCHIVE_BASE_PATCH0_0_PART3_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-3.bin'
ARCHIVE_BASE_PATCH0_0_PART3_MD5='f6de17882cf9c14bf4d9c35d1408b370'
ARCHIVE_BASE_PATCH0_0_PART4_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-4.bin'
ARCHIVE_BASE_PATCH0_0_PART4_MD5='57821851b52dbc96735e19ed4cea4412'
ARCHIVE_BASE_PATCH0_0_PART5_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-5.bin'
ARCHIVE_BASE_PATCH0_0_PART5_MD5='2699c17f29e4385685fedf8f4c722942'
ARCHIVE_BASE_PATCH0_0_PART6_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-6.bin'
ARCHIVE_BASE_PATCH0_0_PART6_MD5='dfda5cb12822ab47d0fbec331a3bf4e9'
ARCHIVE_BASE_PATCH0_0_PART7_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-7.bin'
ARCHIVE_BASE_PATCH0_0_PART7_MD5='a9c6c86ba6b752fdfe3b17e2bb671da9'
ARCHIVE_BASE_PATCH0_0_PART8_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-8.bin'
ARCHIVE_BASE_PATCH0_0_PART8_MD5='6b8124c98e89a4476fd5ebc5fb6eac4e'
ARCHIVE_BASE_PATCH0_0_PART9_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-9.bin'
ARCHIVE_BASE_PATCH0_0_PART9_MD5='0b40958f3d74bc799e39c0b6757dd210'
ARCHIVE_BASE_PATCH0_0_PART10_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-10.bin'
ARCHIVE_BASE_PATCH0_0_PART10_MD5='274034a44d58e127f845664c7ba290ee'
ARCHIVE_BASE_PATCH0_0_PART11_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-11.bin'
ARCHIVE_BASE_PATCH0_0_PART11_MD5='2f4d7c82fb650731a2e215d28b4aefc8'
ARCHIVE_BASE_PATCH0_0_PART12_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-12.bin'
ARCHIVE_BASE_PATCH0_0_PART12_MD5='bd3a022fe59b2089d97e5f3905bc3962'
ARCHIVE_BASE_PATCH0_0_PART13_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-13.bin'
ARCHIVE_BASE_PATCH0_0_PART13_MD5='712abe64604b05e2fbbc7bd9aacb1413'
ARCHIVE_BASE_PATCH0_0_PART14_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-14.bin'
ARCHIVE_BASE_PATCH0_0_PART14_MD5='4dfd9e4a56ce1d63293a0e7bcc66e7a4'
ARCHIVE_BASE_PATCH0_0_PART15_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-15.bin'
ARCHIVE_BASE_PATCH0_0_PART15_MD5='512fa657892ca991d3f626e21f2d6821'
ARCHIVE_BASE_PATCH0_0_PART16_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-16.bin'
ARCHIVE_BASE_PATCH0_0_PART16_MD5='e364b2302d2e23e79478eceda835b95f'
ARCHIVE_BASE_PATCH0_0_PART17_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-17.bin'
ARCHIVE_BASE_PATCH0_0_PART17_MD5='0623bd7550eb187d569ee66cf2bad6c1'
ARCHIVE_BASE_PATCH0_0_PART18_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-18.bin'
ARCHIVE_BASE_PATCH0_0_PART18_MD5='886a04f956eb69f6a644dd9faff319d0'
ARCHIVE_BASE_PATCH0_0_PART19_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-19.bin'
ARCHIVE_BASE_PATCH0_0_PART19_MD5='c6d3c5c670066872c7e0cf78162d96ad'
ARCHIVE_BASE_PATCH0_0_PART20_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-20.bin'
ARCHIVE_BASE_PATCH0_0_PART20_MD5='6517b23d62e752d5f28e607157690f9b'
ARCHIVE_BASE_PATCH0_0_PART21_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-21.bin'
ARCHIVE_BASE_PATCH0_0_PART21_MD5='e80bbbd92fa5992792679bf0f46d32ad'
ARCHIVE_BASE_PATCH0_0_PART22_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-22.bin'
ARCHIVE_BASE_PATCH0_0_PART22_MD5='16c82788a087f3ad44939854aed5b812'
ARCHIVE_BASE_PATCH0_0_PART23_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-23.bin'
ARCHIVE_BASE_PATCH0_0_PART23_MD5='ee096b68eb210b732348d31e940702ea'
ARCHIVE_BASE_PATCH0_0_PART24_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-24.bin'
ARCHIVE_BASE_PATCH0_0_PART24_MD5='df2a50351cc593ebaf7316afe7a0ae72'
ARCHIVE_BASE_PATCH0_0_PART25_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-25.bin'
ARCHIVE_BASE_PATCH0_0_PART25_MD5='1db116cd2f589addfa9cf258429c085b'
ARCHIVE_BASE_PATCH0_0_PART26_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-26.bin'
ARCHIVE_BASE_PATCH0_0_PART26_MD5='f937efd190dc0a93b918061f97d24ba9'
ARCHIVE_BASE_PATCH0_0_PART27_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-27.bin'
ARCHIVE_BASE_PATCH0_0_PART27_MD5='2c61a47bea3ed93960382139ba15c6b7'
ARCHIVE_BASE_PATCH0_0_SIZE='131000000'
ARCHIVE_BASE_PATCH0_0_VERSION='4.1.1.3635601-gog66683'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
bin'
CONTENT_GAME_L10N_VOICES_FILES='
data/localization/voicemeta.pak'
CONTENT_GAME_L10N_COMMON_FILES='
data/localization/english.pak
data/localization/english_animations.pak'
CONTENT_GAME_L10N_FR_FILES='
data/localization/french'
CONTENT_GAME_DATA_MODELS_FILES='
data/models.pak'
CONTENT_GAME_DATA_SOUNDS_FILES='
data/sharedsoundbanks.pak'
CONTENT_GAME_DATA_TEXTURES_1_FILES='
data/gustav_textures.pak
data/textures.pak
data/textures_1.pak'
CONTENT_GAME_DATA_TEXTURES_2_FILES='
data/textures_2.pak
data/textures_3.pak
data/virtualtextures.pak'
CONTENT_GAME_DATA_TEXTURES_3_FILES='
data/virtualtextures_1.pak
data/virtualtextures_2.pak'
CONTENT_GAME_DATA_TEXTURES_4_FILES='
data/virtualtextures_3.pak
data/virtualtextures_4.pak'
CONTENT_GAME_DATA_TEXTURES_5_FILES='
data/virtualtextures_5.pak
data/virtualtextures_6.pak'
CONTENT_GAME_DATA_TEXTURES_6_FILES='
data/virtualtextures_7.pak
data/virtualtextures_8.pak'
CONTENT_GAME_DATA_TEXTURES_7_FILES='
data/virtualtextures_9.pak
data/virtualtextures_10.pak'
CONTENT_GAME_DATA_TEXTURES_8_FILES='
data/virtualtextures_11.pak
data/virtualtextures_12.pak'
CONTENT_GAME_DATA_TEXTURES_9_FILES='
data/virtualtextures_13.pak
data/virtualtextures_14.pak'
CONTENT_GAME_DATA_TEXTURES_10_FILES='
data/virtualtextures_15.pak
data/virtualtextures_16.pak'
CONTENT_GAME_DATA_TEXTURES_11_FILES='
data/virtualtextures_17.pak
data/virtualtextures_18.pak'
CONTENT_GAME_DATA_TEXTURES_12_FILES='
data/virtualtextures_*.pak'
CONTENT_GAME_DATA_PATCH0_FILES='
data/patch0_hotfix*.pak'
CONTENT_GAME_DATA_PATCH1_FILES='
data/patch1.pak'
CONTENT_GAME_DATA_PATCH2_FILES='
data/patch2.pak
data/patch2_hotfix*.pak'
CONTENT_GAME_DATA_PATCH3_FILES='
data/patch3_hotfix*.pak'
CONTENT_GAME_DATA_PATCH4_FILES='
data/patch4_hotfix*.pak'
CONTENT_GAME_DATA_PATCH5_FILES='
data/patch5_hotfix*.pak'
CONTENT_GAME_DATA_PATCH6_FILES='
data/patch6_hotfix*.pak'
CONTENT_GAME_DATA_FILES='
data/assets.pak
data/day0.pak
data/diceset??.pak
data/effects.pak
data/engine.pak
data/engineshaders.pak
data/game.pak
data/gameplatform.pak
data/gustav_navcloud.pak
data/gustav_video.pak
data/icons.pak
data/lowtex.pak
data/materials.pak
data/shared.pak'

HUGE_FILES_L10N_VOICES='
data/localization/voice.pak'
HUGE_FILES_DATA='
data/gustav.pak'
## The size of sharedsounds.pak goes over the .deb size limit only with patch 5,
## but ./play.it has no problem "splitting" a file into a single chunk,
## at the cost of more time spent in post-install scripts.
## TODO: The library-side implementation of huge files should probably skip files under the size limit,
##       putting the whole file into a dedicated package without "splitting" it into a single chunk first.
HUGE_FILES_DATA_SOUNDS='
data/sharedsounds.pak'
## The _PATCH3 suffix is doubled so this matches:
## PKG_DATA_PATCH3 in the context of ARCHIVE_BASE_PATCH3
## but does not match:
## PKG_DATA in the context of ARCHIVE_BASE_PATCH3.
HUGE_FILES_DATA_PATCH3_PATCH3='
data/patch3.pak'

WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/AppData/Local/Larian Studios/Baldur's Gate 3"
## mfc140u.dll is required.
WINE_WINETRICKS_VERBS='mfc140'

APP_MAIN_EXE='bin/bg3.exe'
## Run the game binary from its parent directory.
APP_MAIN_PRERUN='# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")
'

PACKAGES_LIST_BASE='
PKG_BIN
PKG_L10N_VOICES
PKG_L10N_COMMON
PKG_L10N_EN
PKG_L10N_FR
PKG_DATA_MODELS
PKG_DATA_SOUNDS
PKG_DATA_TEXTURES_1
PKG_DATA_TEXTURES_2
PKG_DATA_TEXTURES_3
PKG_DATA_TEXTURES_4
PKG_DATA_TEXTURES_5
PKG_DATA_TEXTURES_6
PKG_DATA_TEXTURES_7
PKG_DATA_TEXTURES_8
PKG_DATA_TEXTURES_9
PKG_DATA_TEXTURES_10
PKG_DATA_TEXTURES_11
PKG_DATA_TEXTURES_12
PKG_DATA'
PACKAGES_LIST_PATCH0="$PACKAGES_LIST_BASE
PKG_DATA_PATCH0"
PACKAGES_LIST_PATCH1="$PACKAGES_LIST_PATCH0
PKG_DATA_PATCH1"
PACKAGES_LIST_PATCH2="$PACKAGES_LIST_PATCH1
PKG_DATA_PATCH2"
PACKAGES_LIST_PATCH3="$PACKAGES_LIST_PATCH2
PKG_DATA_PATCH3"
## Archives patch0*.pak, patch1*.pak, patch2*.pak and patch3*.pak are dropped with the patch 4 release.
PACKAGES_LIST_PATCH4="$PACKAGES_LIST_BASE
PKG_DATA_PATCH4"
## Archives patch4*.pak are dropped with the patch 5 release.
PACKAGES_LIST_PATCH5="$PACKAGES_LIST_BASE
PKG_DATA_PATCH5"
## Archives patch5*.pak are dropped with the patch 6 release.
PACKAGES_LIST_PATCH6="$PACKAGES_LIST_BASE
PKG_DATA_PATCH6"

PKG_L10N_COMMON_ID="${GAME_ID}-l10n-common"
PKG_L10N_COMMON_DESCRIPTION='localizations - shared files'

PKG_L10N_VOICES_ID="${GAME_ID}-l10n-voices"
PKG_L10N_VOICES_DESCRIPTION="$PKG_L10N_DESCRIPTION - voices"

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_EN_ID="${PKG_L10N_ID}-en"
PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_EN_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_FR_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_EN_DESCRIPTION='English localization'
PKG_L10N_FR_DESCRIPTION='French localization'
PKG_L10N_DEPS="$PKG_L10N_COMMON_ID $PKG_L10N_VOICES_ID"
PKG_L10N_EN_DEPS="$PKG_L10N_DEPS"
PKG_L10N_FR_DEPS="$PKG_L10N_DEPS"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_MODELS_ID="${PKG_DATA_ID}-models"
PKG_DATA_MODELS_DESCRIPTION="$PKG_DATA_DESCRIPTION - models"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_MODELS_ID"

PKG_DATA_SOUNDS_ID="${PKG_DATA_ID}-sounds"
PKG_DATA_SOUNDS_DESCRIPTION="$PKG_DATA_DESCRIPTION - sounds"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_SOUNDS_ID"

PKG_DATA_TEXTURES_ID="${PKG_DATA_ID}-textures"
PKG_DATA_TEXTURES_1_ID="${PKG_DATA_TEXTURES_ID}-1"
PKG_DATA_TEXTURES_2_ID="${PKG_DATA_TEXTURES_ID}-2"
PKG_DATA_TEXTURES_3_ID="${PKG_DATA_TEXTURES_ID}-3"
PKG_DATA_TEXTURES_4_ID="${PKG_DATA_TEXTURES_ID}-4"
PKG_DATA_TEXTURES_5_ID="${PKG_DATA_TEXTURES_ID}-5"
PKG_DATA_TEXTURES_6_ID="${PKG_DATA_TEXTURES_ID}-6"
PKG_DATA_TEXTURES_7_ID="${PKG_DATA_TEXTURES_ID}-7"
PKG_DATA_TEXTURES_8_ID="${PKG_DATA_TEXTURES_ID}-8"
PKG_DATA_TEXTURES_9_ID="${PKG_DATA_TEXTURES_ID}-9"
PKG_DATA_TEXTURES_10_ID="${PKG_DATA_TEXTURES_ID}-10"
PKG_DATA_TEXTURES_11_ID="${PKG_DATA_TEXTURES_ID}-11"
PKG_DATA_TEXTURES_12_ID="${PKG_DATA_TEXTURES_ID}-12"
PKG_DATA_TEXTURES_DESCRIPTION="$PKG_DATA_DESCRIPTION - textures"
PKG_DATA_TEXTURES_1_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 1"
PKG_DATA_TEXTURES_2_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 2"
PKG_DATA_TEXTURES_3_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 3"
PKG_DATA_TEXTURES_4_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 4"
PKG_DATA_TEXTURES_5_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 5"
PKG_DATA_TEXTURES_6_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 6"
PKG_DATA_TEXTURES_7_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 7"
PKG_DATA_TEXTURES_8_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 8"
PKG_DATA_TEXTURES_9_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 9"
PKG_DATA_TEXTURES_10_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 10"
PKG_DATA_TEXTURES_11_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 11"
PKG_DATA_TEXTURES_12_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 12"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_TEXTURES_1_ID $PKG_DATA_TEXTURES_2_ID $PKG_DATA_TEXTURES_3_ID $PKG_DATA_TEXTURES_4_ID $PKG_DATA_TEXTURES_5_ID $PKG_DATA_TEXTURES_6_ID $PKG_DATA_TEXTURES_7_ID $PKG_DATA_TEXTURES_8_ID $PKG_DATA_TEXTURES_9_ID $PKG_DATA_TEXTURES_10_ID $PKG_DATA_TEXTURES_11_ID $PKG_DATA_TEXTURES_12_ID"
## Only 11 texture packages are required prior to patch 5.
PACKAGES_LIST_PATCH4=$(printf '%s' "$PACKAGES_LIST_PATCH4" | grep --invert-match 'PKG_DATA_TEXTURES_12')
PACKAGES_LIST_PATCH3="$PACKAGES_LIST_PATCH4"
PACKAGES_LIST_PATCH2="$PACKAGES_LIST_PATCH4"
PACKAGES_LIST_PATCH1="$PACKAGES_LIST_PATCH4"
PACKAGES_LIST_PATCH0="$PACKAGES_LIST_PATCH4"
PKG_DATA_TEXTURES_11_PROVIDES_PATCH4="${PKG_DATA_TEXTURES_11_PROVIDES:-}
$PKG_DATA_TEXTURES_12_ID"
PKG_DATA_TEXTURES_11_PROVIDES_PATCH3="$PKG_DATA_TEXTURES_11_PROVIDES_PATCH4"
PKG_DATA_TEXTURES_11_PROVIDES_PATCH2="$PKG_DATA_TEXTURES_11_PROVIDES_PATCH4"
PKG_DATA_TEXTURES_11_PROVIDES_PATCH1="$PKG_DATA_TEXTURES_11_PROVIDES_PATCH4"
PKG_DATA_TEXTURES_11_PROVIDES_PATCH0="$PKG_DATA_TEXTURES_11_PROVIDES_PATCH4"

PKG_DATA_PATCH0_ID="${PKG_DATA_ID}-patch0"
PKG_DATA_PATCH1_ID="${PKG_DATA_ID}-patch1"
PKG_DATA_PATCH2_ID="${PKG_DATA_ID}-patch2"
PKG_DATA_PATCH3_ID="${PKG_DATA_ID}-patch3"
PKG_DATA_PATCH4_ID="${PKG_DATA_ID}-patch4"
PKG_DATA_PATCH5_ID="${PKG_DATA_ID}-patch5"
PKG_DATA_PATCH6_ID="${PKG_DATA_ID}-patch6"
PKG_DATA_PATCH0_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch0"
PKG_DATA_PATCH1_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch1"
PKG_DATA_PATCH2_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch2"
PKG_DATA_PATCH3_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch3"
PKG_DATA_PATCH4_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch4"
PKG_DATA_PATCH5_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch5"
PKG_DATA_PATCH6_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch6"
PKG_DATA_DEPS_PATCH0="${PKG_DATA_DEPS:-} $PKG_DATA_PATCH0_ID"
PKG_DATA_DEPS_PATCH1="$PKG_DATA_DEPS_PATCH0 $PKG_DATA_PATCH1_ID"
PKG_DATA_DEPS_PATCH2="$PKG_DATA_DEPS_PATCH1 $PKG_DATA_PATCH2_ID"
PKG_DATA_DEPS_PATCH3="$PKG_DATA_DEPS_PATCH2 $PKG_DATA_PATCH3_ID"
PKG_DATA_DEPS_PATCH4="${PKG_DATA_DEPS:-} $PKG_DATA_PATCH4_ID"
PKG_DATA_DEPS_PATCH5="${PKG_DATA_DEPS:-} $PKG_DATA_PATCH5_ID"
PKG_DATA_DEPS_PATCH6="${PKG_DATA_DEPS:-} $PKG_DATA_PATCH6_ID"
## Archives patch0*.pak, patch1*.pak, patch2*.pak and patch3*.pak are dropped with the patch 4 release.
PKG_DATA_PATCH4_PROVIDES="
$PKG_DATA_PATCH0_ID
$PKG_DATA_PATCH1_ID
$PKG_DATA_PATCH2_ID
$PKG_DATA_PATCH3_ID
${PKG_DATA_PATCH3_ID}-chunk1
${PKG_DATA_PATCH3_ID}-chunk2"
## Archives patch4*.pak are dropped with the patch 5 release.
PKG_DATA_PATCH5_PROVIDES="$PKG_DATA_PATCH4_PROVIDES
$PKG_DATA_PATCH4_ID"
## Archives patch5*.pak are dropped with the patch 6 release.
PKG_DATA_PATCH6_PROVIDES="$PKG_DATA_PATCH5_PROVIDES
$PKG_DATA_PATCH5_ID"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_L10N_ID $PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Generate localizations configuration

l10n_config_source="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/data/localization/language.lsx"
l10n_config_pattern='<attribute id="Value" value=".*" type="20" />'

l10n_config_destination_en="$(package_path 'PKG_L10N_EN')$(path_game_data)/data/localization/language.lsx"
l10n_config_replacement_en='<attribute id="Value" value="English" type="20" />'
mkdir --parents "$(dirname "$l10n_config_destination_en")"
sed --expression="s;${l10n_config_pattern};${l10n_config_replacement_en};" \
	"$l10n_config_source" > "$l10n_config_destination_en"

l10n_config_destination_fr="$(package_path 'PKG_L10N_FR')$(path_game_data)/data/localization/language.lsx"
l10n_config_replacement_fr='<attribute id="Value" value="French" type="20" />'
mkdir --parents "$(dirname "$l10n_config_destination_fr")"
sed --expression="s;${l10n_config_pattern};${l10n_config_replacement_fr};" \
	"$l10n_config_source" > "$l10n_config_destination_fr"

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
case "${LANG%_*}" in
	('fr')
		message='version %s :'
		lang_en='anglaise'
		lang_fr='française'
	;;
	('en'|*)
		message='%s version:'
		lang_en='English'
		lang_fr='French'
	;;
esac
printf '\n'
## English localization
printf "$message" "$lang_en"
print_instructions $(packages_list | sed 's/PKG_L10N_FR//')
## French localization
printf "$message" "$lang_fr"
print_instructions $(packages_list | sed 's/PKG_L10N_EN//')

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
