/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.transform.SourceLocator;
import org.apache.xml.res.XMLMessages;

public class DTMException
extends RuntimeException {
    static final long serialVersionUID = -775576419181334734L;
    SourceLocator locator;
    Throwable containedException;
    static /* synthetic */ Class class$0;

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator location) {
        this.locator = location;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public Throwable getCause() {
        return this.containedException == this ? null : this.containedException;
    }

    public synchronized Throwable initCause(Throwable cause) {
        if (this.containedException == null && cause != null) {
            throw new IllegalStateException(XMLMessages.createXMLMessage("ER_CANNOT_OVERWRITE_CAUSE", null));
        }
        if (cause == this) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_SELF_CAUSATION_NOT_PERMITTED", null));
        }
        this.containedException = cause;
        return this;
    }

    public DTMException(String message) {
        super(message);
        this.containedException = null;
        this.locator = null;
    }

    public DTMException(Throwable e) {
        super(e.getMessage());
        this.containedException = e;
        this.locator = null;
    }

    public DTMException(String message, Throwable e) {
        super(message == null || message.length() == 0 ? e.getMessage() : message);
        this.containedException = e;
        this.locator = null;
    }

    public DTMException(String message, SourceLocator locator) {
        super(message);
        this.containedException = null;
        this.locator = locator;
    }

    public DTMException(String message, SourceLocator locator, Throwable e) {
        super(message);
        this.containedException = e;
        this.locator = locator;
    }

    public String getMessageAndLocation() {
        StringBuffer sbuffer = new StringBuffer();
        String message = super.getMessage();
        if (message != null) {
            sbuffer.append(message);
        }
        if (this.locator != null) {
            String systemID = this.locator.getSystemId();
            int line = this.locator.getLineNumber();
            int column = this.locator.getColumnNumber();
            if (systemID != null) {
                sbuffer.append("; SystemID: ");
                sbuffer.append(systemID);
            }
            if (line != 0) {
                sbuffer.append("; Line#: ");
                sbuffer.append(line);
            }
            if (column != 0) {
                sbuffer.append("; Column#: ");
                sbuffer.append(column);
            }
        }
        return sbuffer.toString();
    }

    public String getLocationAsString() {
        if (this.locator != null) {
            StringBuffer sbuffer = new StringBuffer();
            String systemID = this.locator.getSystemId();
            int line = this.locator.getLineNumber();
            int column = this.locator.getColumnNumber();
            if (systemID != null) {
                sbuffer.append("; SystemID: ");
                sbuffer.append(systemID);
            }
            if (line != 0) {
                sbuffer.append("; Line#: ");
                sbuffer.append(line);
            }
            if (column != 0) {
                sbuffer.append("; Column#: ");
                sbuffer.append(column);
            }
            return sbuffer.toString();
        }
        return null;
    }

    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err, true));
    }

    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new PrintWriter(s));
    }

    public void printStackTrace(PrintWriter s) {
        if (s == null) {
            s = new PrintWriter(System.err, true);
        }
        try {
            String locInfo = this.getLocationAsString();
            if (locInfo != null) {
                s.println(locInfo);
            }
            super.printStackTrace(s);
        }
        catch (Throwable throwable) {}
        boolean isJdk14OrHigher = false;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Throwable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            clazz.getMethod("getCause", null);
            isJdk14OrHigher = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (!isJdk14OrHigher) {
            Throwable exception = this.getException();
            int i = 0;
            while (i < 10 && exception != null) {
                s.println("---------");
                try {
                    String locInfo;
                    if (exception instanceof DTMException && (locInfo = ((DTMException)exception).getLocationAsString()) != null) {
                        s.println(locInfo);
                    }
                    exception.printStackTrace(s);
                }
                catch (Throwable throwable) {
                    s.println("Could not print stack trace...");
                }
                try {
                    Method meth = exception.getClass().getMethod("getException", null);
                    if (meth != null) {
                        Throwable prev = exception;
                        if (prev == (exception = (Throwable)meth.invoke((Object)exception, null))) {
                            break;
                        }
                    } else {
                        exception = null;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    exception = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    exception = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    exception = null;
                }
                ++i;
            }
        }
    }
}

