#
# Makefile for the linear algebra library embedded in ABINIT
#

include ../../config.mk

all_targets all etsf_xc: install
	@echo "$(etsf_xc_pkg_name) is now ready for use."

uncompress: uncompress-stamp
	@echo "$(etsf_xc_pkg_name) has been uncompressed."

configure: configure-stamp
	@echo "$(etsf_xc_pkg_name) has been configured."

build: build-stamp
	@echo "$(etsf_xc_pkg_name) has been built."

install: install-stamp
	@echo "$(etsf_xc_pkg_name) has been installed."

uncompress-stamp:
	tar xf $(abinit_srcdir)/lib/etsf_xc/$(etsf_xc_pkg_name).tar
	touch uncompress-stamp

configure-stamp: uncompress
	cd $(etsf_xc_pkg_name)/libstring_f && CC="$(CC)" CFLAGS="$(CFLAGS)" ./configure
	cd $(etsf_xc_pkg_name)/libxc && CPP="$(CPP)" CPPFLAGS="$(CPPFLAGS)" CC="$(CC)" CFLAGS="$(CFLAGS)" FC="$(FC)" FCFLAGS="$(FCFLAGS_FREEFORM) $(FCFLAGS_ETSF_XC)" ./configure --enable-fortran
	touch configure-stamp

build-stamp: configure
	cd $(etsf_xc_pkg_name)/libstring_f && $(MAKE)
	cd $(etsf_xc_pkg_name)/libxc && $(MAKE)
	$(AR) $(ARFLAGS) libetsf_xc.a $(etsf_xc_pkg_name)/libstring_f/*.o $(etsf_xc_pkg_name)/libxc/src/*.o
	-$(RANLIB) libetsf_xc.a
	touch build-stamp

install-stamp: build
	cp $(etsf_xc_pkg_name)/libxc/src/etsf_xc.mod .
	touch install-stamp

clean:
	rm -rf libstring_f libxc scripts
	rm -f uncompress-stamp configure-stamp build-stamp install-stamp
