// -*- C++ -*-
#ifndef ACE_SUNCC_COMMON_H
#define ACE_SUNCC_COMMON_H
#include /**/ "ace/pre.h"

# define ACE_EXPLICIT_TEMPLATE_DESTRUCTOR_TAKES_ARGS
# define ACE_HAS_THR_C_DEST 1
# define ACE_LACKS_SWAB
#if defined (ACE_HAS_CUSTOM_EXPORT_MACROS) && ACE_HAS_CUSTOM_EXPORT_MACROS == 0
#  undef ACE_HAS_CUSTOM_EXPORT_MACROS
#else
#  ifndef ACE_HAS_CUSTOM_EXPORT_MACROS
#    define ACE_HAS_CUSTOM_EXPORT_MACROS
#  endif  /* !ACE_HAS_CUSTOM_EXPORT_MACROS */
#  define ACE_Proper_Export_Flag __attribute__ ((visibility("default")))
#  define ACE_Proper_Import_Flag
#  define ACE_EXPORT_SINGLETON_DECLARATION(T) template class ACE_Proper_Export_Flag T
#  define ACE_EXPORT_SINGLETON_DECLARE(SINGLETON_TYPE, CLASS, LOCK) template class ACE_Proper_Export_Flag SINGLETON_TYPE <CLASS, LOCK>;
#  define ACE_IMPORT_SINGLETON_DECLARATION(T) __extension__ extern template class T
#  define ACE_IMPORT_SINGLETON_DECLARE(SINGLETON_TYPE, CLASS, LOCK) __extension__ extern template class SINGLETON_TYPE<CLASS, LOCK>;
#endif  /* ACE_HAS_CUSTOM_EXPORT_MACROS == 0 */

#if (defined (i386) || defined (__i386__)) && !defined (ACE_SIZEOF_LONG_DOUBLE)
# define ACE_SIZEOF_LONG_DOUBLE 12
#endif /* i386 */

#if defined (i386) || defined (__i386__)
  // If running an Intel, assume that it's a Pentium so that
  // ACE_OS::gethrtime () can use the RDTSC instruction.  If running a
  // 486 or lower, be sure to comment this out.  (If not running an
  // Intel CPU, this #define will not be seen because of the i386
  // protection, so it can be ignored.)
# define ACE_HAS_PENTIUM
#endif /* i386 */

#if !defined (ACE_LACKS_PRAGMA_ONCE)
  // We define it with a -D with make depend.
# define ACE_LACKS_PRAGMA_ONCE
#endif /* ! ACE_LACKS_PRAGMA_ONCE */

#define ACE_TEMPLATES_REQUIRE_SOURCE

// Solaris Studio 12.4 implements symbol lookup correctly.
#if defined (__SUNPRO_CC) && (__SUNPRO_CC >= 0x5130)
#define ACE_ANY_OPS_USE_NAMESPACE
#endif

#include /**/ "ace/post.h"
#endif /* ACE_SUNCC_COMMON_H */
