# G.1 Are individualist anarchists anti-capitalist?

To answer this question, it is necessary to first define what we mean by
capitalism and socialism. While there is a tendency for supporters of
capitalism (and a few socialists!) to equate it with the market and private
property, this is not the case. It is possible to have both and not have
capitalism (as we discuss in [section G.1.1](secG1.md#secg11) and [section
G.1.2](secG1.md#secg12), respectively). Similarly, the notion that
"socialism" means, by definition, state ownership and/or control, or that
being employed by the state rather than by private capital is "socialism" is
distinctly wrong. While some socialists have, undoubtedly, defined socialism
in precisely such terms, socialism as a historic movement is much wider than
that. As Proudhon put it, _"[m]odern Socialism was not founded as a sect or
church; it has seen a number of different schools."_ [ **Selected Writings of
Pierre-Joseph Proudhon** , p. 177]

As Proudhon, Bakunin, Kropotkin and Tucker all stressed, anarchism is one of
those schools. For Kropotkin, anarchism was _"the no-government system of
socialism."_ [ **Anarchism** , p. 46] Likewise, for Tucker, there were _"two
schools of socialistic thought"_ , one of which represented authority and the
other liberty, namely _"State Socialism and Anarchism."_ [ **The Individualist
Anarchists** , pp. 78-9] It was _"not Socialist Anarchism against
Individualist Anarchism, but of Communist Socialism against Individualist
Socialism."_ [Tucker, **Liberty** , no. 129, p. 2] As one expert on
Individualist Anarchism noted, Tucker _"looked upon anarchism as a branch of
the general socialist movement."_ [James J. Martin, **Men Against the State**
, pp. 226-7] Thus we find Individualist anarchist Victor Yarros, like Tucker,
talking about _"the position and teachings of the Anarchistic Socialists"_
when referring to his ideas. [ **Liberty** , no. 98, p. 5]

Part of problem is that in the 20th century, the statist school of socialism
prevailed both within the labour movement (at least in English speaking
countries or until fascism destroyed it in mainland Europe and elsewhere) and
within the revolutionary movement (first as social democracy, then as
Communism after the Russian Revolution). This lead, it should be noted, to
anarchists not using the term "socialist" to describe their ideas as they did
not want to be confused with either reformed capitalism (social democracy) or
state capitalism (Leninism and Stalinism). As anarchism was understood as
being inherently anti-capitalist, this did not become an issue until certain
right-wing liberals started calling themselves "anarcho"-capitalists (somewhat
ironically, these liberals joined with the state socialists in trying to limit
anarchism to anti-statism and denying their socialist credentials). Another
part of the problem is that many, particularly those in America, derive their
notion of what socialism is from right-wing sources who are more than happy to
agree with the Stalinists that socialism **is** state ownership. This is case
with right-"libertarians", who rarely study the history or ideas of socialism
and instead take their lead from such fanatical anti-socialists as Ludwig von
Mises and Murray Rothbard. Thus they equate socialism with social democracy or
Leninism/Stalinism, i.e. with state ownership of the means of life, the
turning of part or the whole working population into employees of the
government or state regulation and the welfare state. In this they are often
joined by social democrats and Marxists who seek to excommunicate all other
kinds of socialism from the anti-capitalist movement.

All of which leads to some strange contradictions. If "socialism" **is**
equated to state ownership then, clearly, the individualist anarchists are not
socialists but, then, neither are the social anarchists! Thus if we assume
that the prevailing socialism of the 20th century defines what socialism is,
then quite a few self-proclaimed socialists are not, in fact, socialists. This
suggests that socialism cannot be limited to state socialism. Perhaps it would
be easier to define "socialism" as restrictions on private property? If so,
then, clearly, social anarchists are socialists but then, as we will prove, so
are the individualist anarchists!

Of course, not all the individualist anarchists used the term "socialist" or
"socialism" to describe their ideas although many did. Some called their ideas
Mutualism and explicitly opposed socialism (William Greene being the most
obvious example). However, at root the ideas were part of the wider socialist
movement and, in fact, they followed Proudhon in this as he both proclaimed
himself a socialist while also attacking it. The apparent contradiction is
easily explained by noting there are two schools of socialism, state and
libertarian. Thus it is possible to be both a (libertarian) socialist and
condemn (state) socialism in the harshest terms.

So what, then, is socialism? Tucker stated that _"the bottom claim of
Socialism"_ was _"that labour should be put in possession of its own,"_ that
_"the natural wage of labour is its product"_ and _"interest, rent, and profit
. . . constitute the trinity of usury."_ [ **The Individualist Anarchists** ,
p. 78 and p. 80] This definition also found favour with Kropotkin who stated
that socialism _"in its wide, generic, and true sense"_ was an _"effort to
**abolish** the exploitation of labour by capital."_ [ **Anarchism** , p. 169]
For Kropotkin, anarchism was _"brought forth by the same critical and
revolutionary protest which gave rise to Socialism in general"_ , socialism
aiming for _"the negation of Capitalism and of society based on the subjection
of labour to capital."_ Anarchism, unlike other socialists, extended this to
oppose _"what constitutes the real strength of Capitalism: the State and its
principle supports."_ [ **Environment and Evolution** , p. 19] Tucker,
similarly, argued that Individualist anarchism was a form of socialism and
would result in the _"emancipation of the workingman from his present slavery
to capital."_ [ **Instead of a Book** , p. 323]

The various schools of socialism present different solutions to this
exploitation and subjection. From the nationalisation of capitalist property
by the state socialists, to the socialisation of property by the libertarian
communists, to the co-operatives of mutualism, to the free market of the
individualist anarchists, all are seeking, in one way or the other, to ensure
the end of the domination and exploitation of labour by capital. The
disagreements between them all rest in whether their solutions achieve this
aim and whether they will make life worth living and enjoyable (which also
explains why individualist and social anarchists disagree so much!). For
anarchists, state socialism is little more than state **capitalism** , with a
state monopoly replacing capitalist monopolies and workers being exploited by
one boss (the state) rather than many. So all anarchists would agree with
Yarrows when he argued that _"[w]hile **State** Socialism removes the disease
by killing the patient, **no** -State Socialism offers him the means of
recovering strength, health, and vigour."_ [ **Liberty** , no. 98, p. 5]

So, why are the individualist anarchists anti-capitalists? There are two main
reasons.

Firstly, the Individualist Anarchists opposed profits, interest and rent as
forms of exploitation (they termed these non-labour incomes **_"usury"_** ,
but as Tucker stressed usury was _"but another name for the exploitation of
labour."_ [ **Liberty** , no. 122, p. 4]). To use the words of Ezra Heywood,
the Individualist Anarchists thought _"Interest is theft, Rent Robbery, and
Profit Only Another Name for Plunder."_ [quoted by Martin Blatt, _"Ezra
Heywood & Benjamin Tucker,"_, pp. 28-43, **Benjamin R. Tucker and the
Champions of Liberty** , Coughlin, Hamilton and Sullivan (eds.), p. 29] Non-
labour incomes are merely _"different methods of levying tribute for the use
of capital."_ Their vision of the good society was one in which _"the usurer,
the receiver of interest, rent and profit"_ would not exist and Labour would
_"secure its natural wage, its entire product."_ [Tucker, **The Individualist
Anarchists** , p. 80, p. 82 and p. 85] This would also apply to dividends,
_"since no idle shareholders could continue in receipt of dividends were it
not for the support of monopoly, it follows that these dividends are no part
of the proper reward of ability."_ [Tucker, **Liberty** , no. 282, p. 2]

In addition, as a means of social change, the individualists suggested that
activists start _"inducing the people to steadily refuse the payment of rents
and taxes."_ [ **Instead of a Book** pp. 299-300] These are hardly statements
with which capitalists would agree. Tucker, as noted, also opposed interest,
considering it usury (exploitation and a _"crime"_ ) pure and simple and one
of the means by which workers were denied the full fruits of their labour.
Indeed, he looked forward to the day when _"any person who charges more than
cost for any product [will] . . . be regarded very much as we now regard a
pickpocket."_ This _"attitude of hostility to usury, in any form"_ hardly fits
into the capitalist mentality or belief system. [ **Op. Cit.** , p. 155]
Similarly, Ezra Heywood considered profit-taking _"an injustice which ranked
second only to legalising titles to absolute ownership of land or raw-
materials."_ [James J. Martin, **Op. Cit.** , p. 111] Opposition to profits,
rent or interest is hardly capitalistic -- indeed, the reverse.

Thus the Individualist Anarchists, like the social anarchists, opposed the
exploitation of labour and desired to see the end of capitalism by ensuring
that labour would own what it produced. They desired a society in which there
would no longer be capitalists and workers, only workers. The worker would
receive the full product of his/her labour, so ending the exploitation of
labour by capital. In Tucker's words, a free society would see _"each man
reaping the fruits of his labour and no man able to live in idleness on an
income from capital"_ and so society would _"become a great hive of
Anarchistic workers, prosperous and free individuals"_ combining _"to carry on
their production and distribution on the cost principle."_ [ **The
Individualist Anarchists** , p. 276]

Secondly, the Individualist Anarchists favoured a new system of land ownership
based on **_"occupancy and use."_** So, as well as this opposition to
capitalist usury, the individualist anarchists also expressed opposition to
capitalist ideas on property (particularly property in land). J.K. Ingalls,
for example, considered that _"the private domination of the land"_ originated
in _"usurpation only, whether of the camp, the court or the market. Whenever
such a domination excludes or deprives a single human being of his equal
opportunity, it is a violation, not only of the public right, and of the
social duty, but of the very principle of law and morals upon which property
itself is based."_ [quoted by Martin, **Op. Cit.** , p. 148f] As Martin
comments, for Ingalls, _"[t]o reduce land to the status of a commodity was an
act of usurpation, enabling a group to 'profit by its relation to production'
without the expenditure of labour time."_ [ **Op. Cit.** , p. 148] These ideas
are identical to Proudhon's and Ingalls continues in this Proudhonian
_"occupancy and use"_ vein when he argues that possession _"remains
**possession** , and can never become **property** , in the sense of absolute
dominion, except by positive statue [i.e. state action]. Labour can only claim
**occupancy** , and can lay no claim to more than the usufruct."_ Current
property ownership in land were created by _"forceful and fraudulent taking"_
of land, which _"could give no justification to the system."_ [quoted by
Martin, **Op. Cit.** , p. 149]

The capitalist system of land ownership was usually termed the **_"land
monopoly"_** , which consisted of _"the enforcement by government of land
titles which do not rest upon personal occupancy and cultivation."_ Under
anarchism, individuals would _"no longer be protected by their fellows in
anything but personal occupancy and cultivation of land"_ and so _"ground rent
would disappear."_ [Tucker, **The Individualist Anarchists** , p. 85] This
applied to what was on the land as well, such as housing:

> _"If a man exerts himself by erecting a building on land which afterward, by
> the operation of the principle of occupancy and use, rightfully becomes
> another's, he must, upon demand of the subsequent occupant, remove from this
> land the results of his self-exertion, or, failing so to do, sacrifice his
> property therein."_ [ **Liberty** , no. 331, p. 4]

This would apply to both the land and what was on it. This meant that
_"tenants would not be forced to pay . . . rent"_ nor would landlords _"be
allowed to seize their property."_ This, as Tucker noted, was a complete
rejection of the capitalist system of property rights and saw anarchism being
dependent on _"the Anarchistic view that occupancy and use should condition
and limit landholding becom[ing] the prevailing view."_ [ **The Individualist
Anarchists** , p. 162 and p. 159] As Joseph Labadie put it, socialism includes
any theory _"which has for its object the **changing of the present status of
property** and the relations one person or class holds to another. In other
words, any movement which has for its aim the changing of social relations, of
companionships, of associations, of powers of one class over another class, is
Socialism."_ [our emphasis, **Liberty** , no. 158, p. 8] As such, both social
and individualist anarchists are socialists as both aimed at changing the
present status of property.

It should also be noted here that the individualist anarchist ideal that
competition in banking would drive interest to approximately zero is their
equivalent to the social anarchist principle of free access to the means of
life. As the only cost involved would be an administration charge which covers
the labour involved in running the mutual bank, all workers would have access
to "capital" for (in effect) free. Combine this with "occupancy and use" in
terms of land use and it can be seen that both individualist and social
anarchists shared a common aim to make the means of life available to all
without having to pay a tribute to an owner or be dependent on a ruling
capitalist or landlord class.

For these reasons, the Individualist Anarchists are clearly anti-capitalist.
While an Individualist Anarchy would be a market system, it would not be a
capitalist one. As Tucker argued, the anarchists realised _"the fact that one
class of men are dependent for their living upon the sale of their labour,
while another class of men are relieved of the necessity of labour by being
legally privileged to sell something that is not labour. . . . And to such a
state of things I am as much opposed as any one. But the minute you remove
privilege. . . every man will be a labourer exchanging with fellow-labourers .
. . What Anarchistic-Socialism aims to abolish is usury . . . it wants to
deprive capital of its reward."_ As noted above, the term _"usury,"_ for
Tucker, was simply a synonym for _"the exploitation of labour."_ [ **Instead
of a Book** , p. 404 and p. 396]

The similarities with social anarchism are obvious. Like them, the
individualist anarchists opposed capitalism because they saw that profit, rent
and interest were all forms of exploitation. As communist-anarchist Alexander
Berkman noted, _"[i]f the worker would get his due -- that is, the things he
produces or their equivalent -- where would the profits of the capitalist come
from? If labour owned the wealth it produced, there would be no capitalism."_
Like social anarchists they opposed usury, to have to pay purely for
access/use for a resource. It ensured that a _"slice of their daily labour is
taken from [the workers] for the privilege of **using** these factories"_ [
**What is Anarchism?** , p. 44 and p. 8] For Marx, abolishing interest and
interest-bearing capital _"means the abolition of capital and of capitalist
production itself."_ [ **Theories of Surplus Value** , vol. 3, p. 472] A
position, incidentally, also held by Proudhon who maintained that _"reduction
of interest rates to vanishing point is itself a revolutionary act, because it
is destructive of capitalism."_ [quoted by Edward Hyams, **Pierre-Joseph
Proudhon: His Revolutionary Life, Mind and Works** , p. 188] Like many
socialists, Individualist Anarchists used the term "interest" to cover all
forms of surplus value: _"the use of money"_ plus _"house-rent, dividends, or
share of profits"_ and having to _"pay a tax to somebody who owns the land."_
_"In doing away with interest, the cause of inequality in material
circumstances will be done away with."_ [John Beverley Robinson, **The
Individualist Anarchists** , pp. 144-5]

Given that Individualist Anarchism aimed to abolish interest along with rent
and profit it would suggest that it is a socialist theory. Unsurprisingly,
then, Tucker agreed with Marx's analysis on capitalism, namely that it lead to
industry concentrating into the hands of a few and that it robbed workers of
the fruits of the toil (for Francis Tandy it was a case of _"the Marxian
theory of surplus value, upon which all Socialistic philosophy -- whether
State or Anarchistic -- is necessarily based"_ [ **Op. Cit.** , no. 312, p.
3]). Tucker quoted a leading Marxist's analysis of capitalism and noted that
_"Liberty endorses the whole of it, excepting a few phrases concerning the
nationalisation of industry and the assumption of political power by working
people."_ However, he was at pains to argue that this analysis was first
expounded by Proudhon, _"that the tendency and consequences of capitalistic
production . . . were demonstrated to the world time and time again during the
twenty years preceding the publication of 'Das Kapital'"_ by the French
anarchist. This included _"the historical persistence of class struggles in
successive manifestations"_ as well as _"the theory that labour is the source
and measure of value."_ _"Call Marx, then, the father of State socialism, if
you will,"_ argued Tucker, _"but we dispute his paternity of the general
principles of economy on which all schools of socialism agree."_ [ **Liberty**
, no. 35, p. 2]

This opposition to profits, rent and interest as forms of exploitation and
property as a form of theft clearly makes individualist anarchism anti-
capitalist and a form of (libertarian) socialism. In addition, it also
indicates well the common ground between the two threads of anarchism, in
particular their common position to capitalism. The social anarchist Rudolf
Rocker indicates well this common position when he argues:

> _"it is difficult to reconcile personal freedom with the existing economic
> system. Without doubt the present inequality of economic interests and the
> resulting class conflicts in society are a continual danger to the freedom
> of the individual . . . [T]he undisturbed natural development of human
> personality is impossible in a system which has its root in the shameless
> exploitation of the great mass of the members of society. One cannot be free
> either politically or personally so long as one is in economic servitude of
> another and cannot escape from this condition. This was recognised by men
> like Godwin, Warren, Proudhon, Bakunin, [and women like Goldman and de
> Cleyre, we must add!] and many others who subsequently reached the
> conviction that the domination of man over man will not disappear until
> there is an end of the exploitation of man by man."_ [ **Nationalism and
> Culture** , p. 167]

There are other, related, reasons why the individualist anarchists must be
considered left-wing libertarians rather than right-wing ones. Given their
opposition to non-labour income, they saw their proposals as having
egalitarian implications. As regards equality, we discover that they saw their
ideas as promoting it. Thus we find Tucker arguing that that the _"happiness
possible in any society that does not improve upon the present in the matter
of distribution of wealth, can hardly be described as beatific."_ He was
clearly opposed to _"the inequitable distribution of wealth"_ under capitalism
and equally clearly saw his proposals as a means of reducing it substantially.
The abolition of those class monopolies which create interest, rent and profit
would reduce income and wealth inequalities substantially. However, there was
_"one exception, and that a comparatively trivial one"_ , namely economic rent
(the natural differences between different bits of land and individual
labour). This _"will probably remain with us always. Complete liberty will
very much lessen it; of that I have no doubt . . . At the worst, it will be a
small matter, no more worth consideration in comparison with the liberty than
the slight disparity that will always exist in consequence of inequalities of
skill."_ [ **Why I am an Anarchist** , pp. 135-6] Another individualist
anarchist, John Beverley Robinson, agreed:

> _"When privilege is abolished, and the worker retains all that he produces,
> then will come the powerful trend toward equality of material reward for
> labour that will produce substantial financial and social equality, instead
> of the mere political equality that now exists."_ [ **Patterns of Anarchy**
> , pp. 278-9]

As did Lysander Spooner, who pointed out that the _"wheel of fortune, in the
present state of things, is of such enormous diameter"_ and _"those on its top
are on so showy a height"_ while _"those underneath it are in such a pit of
debt, oppression, and despair."_ He argued that under his system _"fortunes
could hardly be represented by a wheel; for it would present no such height,
no such depth, no such irregularity of motion as now. It should rather be
represented by an extended surface, varied somewhat by inequalities, but still
exhibiting a general level, affording a safe position for all, and creating no
necessity, for either force or fraud, on the part of anyone to secure his
standing."_ Thus Individualist anarchism would create a condition _"neither of
poverty, nor riches; but of moderate competency -- such as will neither
enervate him by luxury, nor disable him by destitution; but which will at once
give him and opportunity to labour, (both mentally and physically) and
stimulate him by offering him all the fruits of his labours."_ [quoted by
Stephan L. Newman, **Liberalism at Wit's End** , p. 72 and p. 73]

As one commentator on individualist anarchism, Wm. Gary Kline, correctly
summarised:

> _"Their proposals were designed to establish true equality of opportunity .
> . . and they expected this to result in a society without great wealth or
> poverty. In the absence of monopolistic factors which would distort
> competition, they expected a society of largely self-employed workmen with
> no significant disparity of wealth between any of them since all would be
> required to live at their own expense and not at the expense of exploited
> fellow human beings."_ [ **The Individualist Anarchists: A Critique of
> Liberalism** , pp. 103-4]

Hence, like social anarchists, the Individualist Anarchists saw their ideas as
a means towards equality. By eliminating exploitation, inequality would soon
decrease as wealth would no longer accumulate in the hands of the few (the
owners). Rather, it would flow back into the hands of those who produced it
(i.e. the workers). Until this occurred, society would see _"[o]n one side a
dependent class of wage-workers and on the other a privileged class of wealth-
monopolisers, each become more and more distinct from the other as capitalism
advances."_ This has _"resulted in a grouping and consolidation of wealth
which grows apace by attracting all property, no matter by whom produced, into
the hands of the privileged, and hence property becomes a social power, an
economic force destructive of rights, a fertile source of injustice, a means
of enslaving the dispossessed."_ [William Ballie, **The Individualist
Anarchists** , p. 121]

Moreover, like the social anarchists, the Individualist Anarchists were aware
that the state was not some neutral machine or one that exploited all classes
purely for its own ends. They were aware that it was a vehicle of **class
rule,** namely the rule of the capitalist class over the working class.
Spooner thought that that _"holders of this monopoly [of the money supply] now
rule and rob this nation; and the government, in all its branches, is simply
their tool"_ and that _"the employers of wage labour . . . are also the
monopolists of money."_ [Spooner, **A Letter to Grover Cleveland** , p. 42 and
p. 48] Tucker recognised that _"capital had so manipulated legislation"_ that
they gained an advantage on the capitalist market which allowed them to
exploit labour. [ **The Individualist Anarchists** , pp. 82-3] He was quite
clear that the state was a **capitalist** state, with _"Capitalists hav[ing]
placed and kept on the statute books all sorts of prohibitions and taxes"_ to
ensure a "free market" skewed in favour of themselves. [ **Instead of a Book**
, p. 454] A.H. Simpson argued that the Individualist Anarchist _"knows very
well that the present State . . . is simply the tool of the property-owning
class."_ [ **The Individualist Anarchists** , p. 92] Thus both wings of the
anarchist movement were united in their opposition to capitalist exploitation
and their common recognition that the state was a tool of the capitalist
class, used to allow them to exploit the working class.

Tucker, like other individualist anarchists, also supported labour unions, and
although he opposed violence during strikes he recognised that it was caused
by frustration due to an unjust system. Indeed, like social anarchists, he
considered _"the labourer in these days [as] a soldier. . . His employer is .
. . a member of an opposing army. The whole industrial and commercial world is
in a state of internecine war, in which the proletaires are massed on one side
and the proprietors on the other."_ The cause of strikes rested in the fact
that _"before . . . strikers violated the equal liberty of others, their own
right to equality of liberty had been wantonly and continuously violated"_ by
the capitalists using the state, for the _"capitalists . . . in denying [a
free market] to [the workers] are guilty of criminal invasion."_ [ **Instead
of a Book** , p. 460 and p. 454] _"With our present economic system,"_ Tucker
stressed, _"almost every strike is just. For what is justice in production and
distribution? That labour, which creates all, shall have **all.** "_ [
**Liberty** , no. 19, p. 1]

Another important aspects of unions and strikes were that they represented
both a growing class consciousness and the ability to change society. _"It is
the power of the great unions to paralyse industry and **ignore** the
government that has alarmed the political burglars,"_ argued Victor Yarrows.
This explained why unions and strikes were crushed by force as _"the State can
have no rival, say the plutocrats, and the trades unions, with the sympathetic
strike and boycott as weapons, are becoming too formidable."_ Even defeated
strikes were useful as they ensured that _"the strikers and their sympathisers
will have acquired some additional knowledge of the essential nature of the
beast, government, which plainly has no other purpose at present than to
protect monopoly and put down all opposition to it."_ _"There is such a thing
as the solidarity of labour,"_ Yarrows went on, _"and it is a healthy and
encouraging sign that workmen recognise the need of mutual support and co-
operation in their conflict with monopoly and its official and unofficial
servants. Labour has to fight government as well as capital, 'law and order'
as well as plutocracy. It cannot make the slightest movement against monopoly
without colliding with some sort of 'authority', Federal, State, or
municipal."_ The problem was that the unions _"have no clear general aims and
deal with results rather than causes."_ [ **Liberty** , no. 291, p. 3]

This analysis echoed Tucker's, who applauded the fact that _"[a]nother era of
strikes apparently is upon us. In all trades and in all sections of the
country labour is busy with its demands and its protests. Liberty rejoices in
them. They give evidence of life and spirit and hope and growing intelligence.
They show that the people are beginning to know their rights, and, knowing,
dare to maintain them. Strikes, whenever and wherever inaugurated, deserve
encouragement from all true friends of labour."_ [ **Op. Cit.** , no. 19, p.
1] Even failed strikes were useful, for they exposed _"the tremendous and
dangerous power now wielded by capital."_ [ **Op. Cit.** , no. 39, p. 1] The
_"capitalists and their tools, the legislatures, already begin to scent the
impending dangers of trades-union socialism and initiatory steps are on foot
in the legislatures of several states to construe labour combinations as
conspiracies against commerce and industry, and suppress them by law."_ [
**Op. Cit.** , no. 22, p. 3]

Some individualist anarchists, like Dyer Lum and Joseph Labadie, were union
organisers while Ezra Heywood _"scoffed at supporters of the status quo, who
saw no evidence of the tyranny on the part of capital, and who brought up the
matter of free contract with reference to labourers. This argument was no
longer valid. Capital controlled land, machinery, steam power, waterfalls,
ships, railways, and above all, money and public opinion, and was in a
position to wait out recalcitrancy at its leisure."_ [Martin, **Op. Cit.** ,
p. 107] For Lum, _"behind the capitalist . . . privilege stands as support"_
and so social circumstances matter. _"Does liberty exist,"_ he argued, _"where
rent, interest, and profit hold the employee in economic subjection to the
legalised possessor of the means of life? To plead for individual liberty
under the present social conditions, to refuse to abate one jot of control
that legalised capital has over individual labour, and to assert that the
demand for restrictive or class legislation comes only from the voluntary
associations of workmen [i.e., trade unions] is not alone the height of
impudence, but a barefaced jugglery of words."_ [ **Liberty** , no. 101, p. 5]

Likewise, Tucker advocated and supported many other forms of non-violent
direct action as well as workplace strikes, such as boycotts and rent strikes,
seeing them as important means of radicalising the working class and creating
an anarchist society. However, like social anarchists the Individualist
Anarchists did not consider labour struggle as an end in itself -- they
considered reforms (and discussion of a _"fair wage"_ and _"harmony between
capital and labour"_ ) as essentially _"conservative"_ and would be satisfied
with no less than _"the abolition of the monopoly privileges of capital and
interest-taking, and the return to labour of the full value of its
production."_ [Victor Yarros, quoted by Martin, **Op. Cit.** , p. 206f]

Therefore, it is clear that both social and Individualist Anarchists share
much in common, including an opposition to capitalism. The former may have
been in favour of free exchange but between equally situated individuals. Only
given a context of equality can free exchange be considered to benefit both
parties equally and not generate growing inequalities which benefit the
stronger of the parties involved which, in turn, skews the bargaining position
of those involved in favour of the stronger (also see [section
F.3](secF3.md)).

It is unsurprising, therefore, that the individualist anarchists considered
themselves as socialists. Like Proudhon, they desired a (libertarian)
socialist system based on the market but without exploitation and which rested
on possession rather than capitalist private property. With Proudhon, only the
ignorant or mischievous would suggest that such a system was capitalistic. The
Individualist Anarchists, as can be seen, fit very easily into Kropotkin's
comments that _"the anarchists, in common with all socialists . . . maintain
that the now prevailing system of private ownership in land, and our
capitalist production for the sake of profits, represent a monopoly which runs
against both the principles of justice and the dictates of utility."_ [
**Anarchism** , p. 285] While they rejected the communist-anarchist solution
to the social question, they knew that such a question existed and was rooted
in the exploitation of labour and the prevailing system of property rights.

So why is Individualist Anarchism and Proudhon's mutualism socialist? Simply
because they opposed the exploitation of labour by capital and proposed a
means of ending it. The big debate between social and individualist anarchists
revolves around whether the other school can **really** achieve this common
goal and whether its proposed solution would, in fact, secure meaningful
individual liberty for all.

## G.1.1 What about their support of the free market?

Many, particularly on the "libertarian"-right, would dismiss claims that the
Individualist Anarchists were socialists. By their support of the "free
market" the Individualist Anarchists, they would claim, show themselves as
really supporters of capitalism. Most, if not all, anarchists would reject
this claim. Why is this the case?

This because such claims show an amazing ignorance of socialist ideas and
history. The socialist movement has had a many schools, many of which, but not
all, opposed the market and private property. Given that the right
"libertarians" who make such claims are usually not well informed of the ideas
they oppose (i.e. of socialism, particularly **libertarian** socialism) it is
unsurprising they claim that the Individualist Anarchists are not socialists
(of course the fact that many Individualist Anarchists argued they **were**
socialists is ignored). Coming from a different tradition, it is unsurprising
they are not aware of the fact that socialism is not monolithic. Hence we
discover right-"libertarian" guru von Mises claiming that the _"essence of
socialism is the entire elimination of the market."_ [ **Human Action** , p.
702] This would have come as something of a surprise to, say, Proudhon, who
argued that _"[t]o suppress competition is to suppress liberty itself."_ [
**General Idea of the Revolution** , p. 50] Similarly, it would have surprised
Tucker, who called himself a socialist while supporting a freer market than
von Mises ever dreamt of. As Tucker put it:

> _" **Liberty** has always insisted that Individualism and Socialism are not
> antithetical terms; that, on the contrary, the most perfect Socialism is
> possible only on condition of the most perfect Individualism; and that
> Socialism includes, not only Collectivism and Communism, but also that
> school of Individualist Anarchism which conceives liberty as a means of
> destroying usury and the exploitation of labour."_ [ **Liberty** , no. 129,
> p. 2]

Hence we find Tucker calling his ideas both _"Anarchistic Socialism"_ and
_"Individualist Socialism"_ while other individualist anarchists have used the
terms _"free market anti-capitalism"_ and _"free market socialism"_ to
describe the ideas.

The central fallacy of the argument that support for markets equals support
for capitalism is that many self-proclaimed socialists are not opposed to the
market. Indeed, some of the earliest socialists were market socialists (people
like Thomas Hodgskin and William Thompson, although the former ended up
rejecting socialism and the latter became a communal-socialist). Proudhon, as
noted, was a well known supporter of market exchange. German sociologist Franz
Oppenheimer expounded a similar vision to Proudhon and called himself a
_"liberal socialist"_ as he favoured a free market but recognised that
capitalism was a system of exploitation. [ _"Introduction"_ , **The State** ,
p. vii] Today, market socialists like David Schweickart (see his **Against
Capitalism** and **After Capitalism** ) and David Miller (see his **Market,
State, and community: theoretical foundations of market socialism** ) are
expounding a similar vision to Proudhon's, namely of a market economy based on
co-operatives (albeit one which retains a state). Unfortunately, they rarely,
if ever, acknowledge their debt to Proudhon (needless to say, their Leninist
opponents do as, from their perspective, it damns the market socialists as not
being real socialists).

It could, possibly, be argued that these self-proclaimed socialists did not,
in fact, understand what socialism "really meant." For this to be the case,
**other** , more obviously socialist, writers and thinkers would dismiss them
as not being socialists. This, however, is not the case. Thus we find Karl
Marx, for example, writing of _"the socialism of Proudhon."_ [ **Capital** ,
vol. 1, p. 161f] Engels talked about Proudhon being _"the Socialist of the
small peasant and master-craftsman"_ and of _"the Proudhon school of
Socialism."_ [Marx and Engels, **Selected Works** , p. 254 and p. 255] Bakunin
talked about Proudhon's _"socialism, based on individual and collective
liberty and upon the spontaneous action of free associations."_ He considered
his own ideas as _"Proudhonism widely developed and pushed right to these, its
final consequences"_ [ **Michael Bakunin: Selected Writings** , p. 100 and p.
198] For Kropotkin, while Godwin was the _"first theoriser of Socialism
without government -- that is to say, of Anarchism"_ Proudhon was the second
as he, _"without knowing Godwin's work, laid anew the foundations of
Anarchism."_ He lamented that _"many modern Socialists"_ supported
_"centralisation and the cult of authority"_ and so _"have not yet reached the
level of their two predecessors, Godwin and Proudhon."_ [ **Evolution and
Environment** , pp. 26-7] These renowned socialists did not consider
Proudhon's position to be in any way anti-socialist (although, of course,
being critical of whether it would work and its desirability if it did).
Tucker, it should be noted, called Proudhon _"the father of the Anarchistic
school of Socialism."_ [ **Instead of a Book** , p. 381] Little wonder, then,
that the likes of Tucker considered themselves socialists and stated numerous
times that they were.

Looking at Tucker and the Individualist anarchists we discover that other
socialists considered them socialists. Rudolf Rocker stated that _"it is not
difficult to discover certain fundamental principles which are common to all
of them and which divide them from all other varieties of socialism. They all
agree on the point that man be given the full reward of his labour and
recognise in this right the economic basis of all personal liberty. They all
regard the free competition of individual and social forces as something
inherent in human nature . . . They answered the socialists of other schools
who saw in **free competition** one of the destructive elements of capitalist
society that the evil lies in the fact we have too little rather than too much
competition, since the power of monopoly has made competition impossible."_ [
**Pioneers of American Freedom** , p. 160] Malatesta, likewise, saw many
schools of socialism, including _"anarchist or authoritarian, mutualist or
individualist."_ [ **Errico Malatesta: His Life and Ideas** , p. 95]

Adolph Fischer, one of the Haymarket Martyrs and contemporary of Tucker,
argued that _"every anarchist is a socialist, but every socialist is not
necessarily an anarchist. The anarchists are divided into two factions: the
communistic anarchists and the Proudhon or middle-class anarchists."_ The
former _"advocate the communistic or co-operative method of production"_ while
the latter _"do not advocate the co-operative system of production, and the
common ownership of the means of production, the products and the land."_ [
**The Autobiographies of the Haymarket Martyrs** , p. 81] However, while not
being communists (i.e. aiming to eliminate the market), he obviously
recognised the Individualists Anarchists as fellow socialists (we should point
out that Proudhon **did** support co-operatives, but they did not carry this
to communism as do most social anarchists -- as is clear, Fischer means
communism by the term _"co-operative system of production"_ rather than co-
operatives as they exist today and Proudhon supported -- see [section
G.4.2](secG4.md#secg42)).

Thus claims that the Individualist Anarchists were not "really" socialists
because they supported a market system cannot be supported. The simple fact is
that those who make this claim are, at best, ignorant of the socialist
movement, its ideas and its history or, at worse, desire, like many Marxists,
to write out of history competing socialist theories. For example, Leninist
David McNally talks of the _"anarcho-socialist Pierre-Joseph Proudhon"_ and
how Marx combated _"Proudhonian socialism"_ before concluding that it was
_"non-socialism"_ because it has _"wage-labour and exploitation."_ [ **Against
the Market** , p. 139 and p. 169] Of course, that this is not true (even in a
Marxist sense) did not stop him asserting it. As one reviewer correctly points
out, _"McNally is right that even in market socialism, market forces rule
workers' lives"_ and this is _"a serious objection. But it is not tantamount
to capitalism or to wage labour"_ and it _"does not have exploitation in
Marx's sense (i.e., wrongful expropriation of surplus by non-producers)"_
[Justin Schwartz, **The American Political Science Review** , Vol. 88, No. 4,
p. 982] For Marx, as we noted in [section C.2](secC2.md), commodity
production only becomes capitalism when there is the exploitation of wage
labour. This is the case with Proudhon as well, who differentiated between
possession and private property and argued that co-operatives should replace
capitalist firms. While their specific solutions may have differed (with
Proudhon aiming for a market economy consisting of artisans, peasants and co-
operatives while Marx aimed for communism, i.e. the abolition of money via
state ownership of capital) their analysis of capitalism and private property
were identical -- which Tucker consistently noted (as regards the theory of
surplus value, for example, he argued that _"Proudhon propounded and proved
[it] long before Marx advanced it."_ [ **Liberty** , no. 92, p. 1])

As Tucker argued, _"the fact that State Socialism . . . has overshadowed other
forms of Socialism gives it no right to a monopoly of the Socialistic idea."_
[ **Instead of a Book** , pp. 363-4] It is no surprise that the authoritarian
left and "libertarian" right have united to define socialism in such a way as
to eliminate anarchism from its ranks -- they both have an interest in
removing a theory which exposes the inadequacies of their dogmas, which
explains how we can have both liberty **and** equality and have a decent, free
and just society.

There is another fallacy at the heart of the claim that markets and socialism
do not go together, namely that all markets are capitalist markets. So another
part of the problem is that the same word often means different things to
different people. Both Kropotkin and Lenin said they were "communists" and
aimed for "communism." However, it does not mean that the society Kropotkin
aimed for was the same as that desired by Lenin. Kropotkin's communism was
decentralised, created and run from the bottom-up while Lenin's was
fundamentally centralised and top-down. Similarly, both Tucker and the Social-
Democrat (and leading Marxist) Karl Kautsky called themselves a "socialist"
yet their ideas on what a socialist society would be like were extremely
different. As J.W. Baker notes, _"Tucker considered himself a socialist . . .
as the result of his struggle against 'usury and capitalism,' but anything
that smelled of 'state socialism' was thoroughly rejected."_ [ _"Native
American Anarchism,"_ pp. 43-62, **The Raven** , vol. 10, no. 1, p. 60] This,
of course, does not stop many "anarcho"-capitalists talking about "socialist"
goals as if all socialists were Stalinists (or, at best, social democrats). In
fact, "socialist anarchism" has included (and continues to include) advocates
of truly free markets as well as advocates of a non-market socialism which has
absolutely nothing in common with the state capitalist tyranny of Stalinism.
Similarly, "anarcho"-capitalists accept a completely ahistorical definition of
"capitalism," so ignoring the massive state violence and support by which that
system was created and is maintained.

The same with terms like "property" and the "free market," by which the
"anarcho"-capitalist assumes the individualist anarchist means the same thing
as they do. We can take land as an example. The individualist anarchists
argued for an **_"occupancy and use"_** system of "property" (see [next
section](secG1.md#secg12) for details). Thus in their "free market," land
would not be a commodity as it is under capitalism and so under individualist
anarchism absentee landlords would be considered as aggressors (for under
capitalism they use state coercion to back up their collection of rent against
the actual occupiers of property). Tucker argued that local defence
associations should treat the occupier and user as the rightful owner, and
defend them against the aggression of an absentee landlord who attempted to
collect rent. An "anarcho"-capitalist would consider this as aggression
**against** the landlord and a violation of "free market" principles. Such a
system of "occupancy and use" would involve massive violations of what is
considered normal in a capitalist "free market." Equally, a market system
which was based on capitalist property rights in land would **not** be
considered as genuinely free by the likes of Tucker.

This can be seen from Tucker's debates with supporters of laissez-faire
capitalism such as Auberon Herbert (who, as discussed in [section
F.7.2](secF7.md#secf72), was an English minimal statist and sometimes called
a forerunner of "anarcho"-capitalism). Tucker quoted an English critic of
Herbert, who noted that _"When we come to the question of the ethical basis of
property, Mr. Herbert refers us to 'the open market'. But this is an evasion.
The question is not whether we should be able to sell or acquire 'in the open
market' anything which we rightfully possess, but how we come into rightful
possession."_ [ **Liberty** , no. 172, p. 7] Tucker rejected the idea _"that a
man should be allowed a title to as much of the earth as he, in the course of
his life, with the aid of all the workmen that he can employ, may succeed in
covering with buildings. It is occupancy **and** use that Anarchism regards as
the basis of land ownership, . . . A man cannot be allowed, merely by putting
labour, to the limit of his capacity and beyond the limit of his person use,
into material of which there is a limited supply and the use of which is
essential to the existence of other men, to withhold that material from other
men's use; and any contract based upon or involving such withholding is as
lacking in sanctity or legitimacy as a contract to deliver stolen goods."_ [
**Op. Cit.** , no. 331, p. 4]

In other words, an individualist anarchist would consider an
"anarcho"-capitalist "free market" as nothing of the kind and vice versa. For
the former, the individualist anarchist position on "property" would be
considered as forms of regulation and restrictions on private property and so
the "free market." The individualist anarchist would consider the
"anarcho"-capitalist "free market" as another system of legally maintained
privilege, with the free market distorted in favour of the wealthy. That
capitalist property rights were being maintained by private police would not
stop that regime being unfree. This can be seen when "anarcho"-capitalist
Wendy McElroy states that _"radical individualism hindered itself . . .
Perhaps most destructively, individualism clung to the labour theory of value
and refused to incorporate the economic theories arising within other branches
of individualist thought, theories such as marginal utility. Unable to embrace
statism, the stagnant movement failed to adequately comprehend the logical
alternative to the state -- a free market."_ [ _"Benjamin Tucker, **Liberty**
, and Individualist Anarchism"_, pp. 421-434, **The Independent Review** ,
vol. II, No. 3, p. 433] Therefore, rather than being a source of commonality,
individualist anarchism and "anarcho"-capitalism actually differ quite
considerably on what counts as a genuinely free market.

So it should be remembered that "anarcho"-capitalists at best agree with
Tucker, Spooner, et al on fairly vague notions like the "free market." They do
not bother to find out what the individualist anarchists meant by that term.
Indeed, the "anarcho"-capitalist embrace of different economic theories means
that they actually reject the reasoning that leads up to these nominal
"agreements." It is the "anarcho"-capitalists who, by rejecting the underlying
economics of the mutualists, are forced to take any "agreements" out of
context. It also means that when faced with obviously anti-capitalist
arguments and conclusions of the individualist anarchists, the
"anarcho"-capitalist cannot explain them and are reduced to arguing that the
anti-capitalist concepts and opinions expressed by the likes of Tucker are
somehow "out of context." In contrast, the anarchist can explain these so-
called "out of context" concepts by placing them into the context of the ideas
of the individualist anarchists and the society which shaped them.

The "anarcho"-capitalist usually admits that they totally disagree with many
of the essential premises and conclusions of the individualist anarchist
analyses (see [next section](secG3.md)). The most basic difference is that
the individualist anarchists rooted their ideas in the labour theory of value
while the "anarcho"-capitalists favour mainstream marginalist theory. It does
not take much thought to realise that advocates of socialist theories and
those of capitalist ones will naturally develop differing notions of what is
and what should be happening within a given economic system. One difference
that **has** in fact arisen is that the notion of what constitutes a "free
market" has differed according to the theory of value applied. Many things can
be attributed to the workings of a "free" market under a capitalist analysis
that would be considered symptoms of economic unfreedom under most socialist
driven analyses.

This can be seen if you look closely at the case of Tucker's comments that
anarchism was simply _"consistent Manchesterianism."_ If this is done then a
simple example of this potential confusion can be found. Tucker argued that
anarchists _"accused"_ the Manchester men _"of being inconsistent,"_ that
while being in favour of laissez faire for _"the labourer in order to reduce
his wages"_ they did not believe _"in liberty to compete with the capitalist
in order to reduce his usury."_ [ **The Individualist Anarchists** , p. 83] To
be consistent in this case is to be something other -- and more demanding in
terms of what is accepted as "freedom" -- than the average Manchesterian (i.e.
a supporter of "free market" capitalism). By _"consistent Manchesterism"_ ,
Tucker meant a laissez-faire system in which class monopolies did not exist,
where capitalist private property in land and intellectual property did not
exist. In other words, a free market purged of its capitalist aspects.
Partisans of the capitalist theory see things differently, of course, feeling
justified in calling many things "free" that anarchists would not accept, and
seeing "constraint" in what the anarchists simply thought of as "consistency."
This explains both his criticism of capitalism **and** state socialism:

> _"The complaint of the Archist Socialists that the Anarchists are bourgeois
> is true to this extent and no further -- that, great as is their detestation
> for a bourgeois society, they prefer its partial liberty to the complete
> slavery of State Socialism."_ [ **Why I am an Anarchist** , p. 136]

It should be clear that a "free market" will look somewhat different depending
on your economic presuppositions. Ironically, this is something
"anarcho"-capitalists implicitly acknowledge when they admit they do not agree
with the likes of Spooner and Tucker on many of their key premises and
conclusions (but that does not stop them claiming -- despite all that -- that
their ideas are a modern version of individualist anarchism!). Moreover, the
"anarcho"-capitalist simply dismisses all the reasoning that got Tucker there
-- that is like trying to justify a law citing Leviticus but then saying "but
of course all that God stuff is just absurd." You cannot have it both ways.
And, of course, the "anarcho"-capitalist support for non-labour based
economics allow them to side-step (and so ignore) much of what anarchists --
communists, collectivists, individualists, mutualists and syndicalists alike
-- consider authoritarian and coercive about "actually existing" capitalism.
But the difference in economic analysis is critical. No matter what they are
called, it is pretty clear that individualist anarchist standards for the
freedom of markets are far more demanding than those associated with even the
freest capitalist market system.

This is best seen from the development of individualist anarchism in the 20th
century. As historian Charles A. Madison noted, it _"began to dwindle rapidly
after 1900. Some of its former adherents joined the more aggressive
communistic faction . . . many others began to favour the rising socialist
movement as the only effective weapon against billion-dollar corporations."_ [
_"Benjamin R. Tucker: Individualist and Anarchist,"_ pp. 444-67, **The New
England Quarterly** , Vol. 16, No. 3, pp. p. 464] Other historians have noted
the same. _"By 1908,"_ argued Eunice Minette Schuster _"the industrial system
had fastened its claws into American soil"_ and while the _"Individualist
Anarchists had attempted to destroy monopoly, privilege, and inequality,
originating in the lack of opportunity"_ the _"superior force of the system
which they opposed . . . overwhelmed"_ them. Tucker left America in 1908 and
those who remained _"embraced either Anarchist-Communism as the result of
governmental violence against the labourers and their cause, or abandoned the
cause entirely."_ [ **Native American Anarchism** , p. 158, pp. 159-60 and p.
156] While individualist anarchism did not entirely disappear with the ending
of **Liberty** , social anarchism became the dominant trend in America as it
had elsewhere in the world.

As we note in [section G.4](secG4.md), the apparent impossibility of mutual
banking to eliminate corporations by economic competition was one of the
reasons Voltairine de Cleyre pointed to for rejecting individualist anarchism
in favour of communist-anarchism. This problem was recognised by Tucker
himself thirty years after **Liberty** had been founded. In the postscript to
a 1911 edition of his famous essay _"State Socialism and Anarchism"_ , he
argued that when he wrote it 25 years earlier _"the denial of competition had
not effected the enormous concentration of wealth that now so gravely
threatens social order"_ and so while a policy of mutual banking might have
stopped and reversed the process of accumulation in the past, the way now was
_"not so clear."_ This was because the tremendous capitalisation of industry
now made the money monopoly a convenience, but no longer a necessity. Admitted
Tucker, the _"trust is now a monster which . . . even the freest competition,
could it be instituted, would be unable to destroy"_ as _"concentrated
capital"_ could set aside a sacrifice fund to bankrupt smaller competitors and
continue the process of expansion of reserves. Thus the growth of economic
power, producing as it does natural barriers to entry from the process of
capitalist production and accumulation, had resulted in a situation where
individualist anarchist solutions could no longer reform capitalism away. The
centralisation of capital had _"passed for the moment beyond their reach."_
The problem of the trusts, he argued, _"must be grappled with for a time
solely by forces political or revolutionary,"_ i.e., through confiscation
either through the machinery of government _"or in denial of it."_ Until this
_"great levelling"_ occurred, all individualist anarchists could do was to
spread their ideas as those trying to _"hasten it by joining in the propaganda
of State Socialism or revolution make a sad mistake indeed."_ [quoted by James
J. Martin, **Op. Cit.** , pp. 273-4]

In other words, the economic power of _"concentrated capital"_ and _"enormous
concentration of wealth"_ placed an insurmountable obstacle to the realisation
of anarchy. Which means that the abolition of usury and relative equality were
considered **ends** rather than side effects for Tucker and if free
competition could not achieve these then such a society would **not** be
anarchist. If economic inequality was large enough, it meant anarchism was
impossible as the rule of capital could be maintained by economic power alone
without the need for extensive state intervention (this was, of course, the
position of revolutionary anarchists like Bakunin, Most and Kropotkin in the
1870s and onwards whom Tucker dismissed as not being anarchists).

Victor Yarros is another example, an individualist anarchist and associate of
Tucker, who by the 1920s had abandoned anarchism for social democracy, in part
because he had become convinced that economic privilege could not be fought by
economic means. As he put it, the most _"potent"_ of the _"factors and forces
[which] tended to undermine and discredit that movement"_ was _"the amazing
growth of trusts and syndicates, of holding companies and huge corporations,
of chain banks and chain stores."_ This _"gradually and insidiously shook the
faith of many in the efficacy of mutual banks, co-operative associations of
producers and consumers, and the competition of little fellows. Proudhon's
plan for a bank of the people to make industrial loans without interest to
workers' co-operatives, or other members, seemed remote and inapplicable to an
age of mass production, mechanisation, continental and international
markets."_ [ _"Philosophical Anarchism: Its Rise, Decline, and Eclipse"_ , pp.
470-483, **The American Journal of Sociology** , vol. 41, no. 4, p. 481]

If the individualist anarchists shared the "anarcho"-capitalist position or
even shared a common definition of "free markets" then the _"power of the
trusts"_ would simply not be an issue. This is because "anarcho"-capitalism
does not acknowledge the existence of such power, as, by definition, it does
not exist in capitalism (although as noted in [section F.1](secF1.md)
Rothbard himself proved critics of this assertion right). Tucker's comments,
therefore, indicate well how far individualist anarchism actually is from
"anarcho"-capitalism. The "anarcho"-capitalist desires free markets no matter
their result or the concentration of wealth existing at their introduction. As
can be seen, Tucker saw the existence of concentrations of wealth as a problem
and a hindrance towards anarchy. Thus Tucker was well aware of the dangers to
individual liberty of inequalities of wealth and the economic power they
produce. Equally, if Tucker supported the "free market" above all else then he
would not have argued this point. Clearly, then, Tucker's support for the
"free market" cannot be abstracted from his fundamental principles nor can it
be equated with a "free market" based on capitalist property rights and
massive inequalities in wealth (and so economic power). Thus individualist
anarchist support for the free market does not mean support for a
**capitalist** "free market."

In summary, the "free market" as sought by (say) Tucker would not be classed
as a "free market" by right-wing "libertarians." So the term "free market"
(and, of course, "socialism") can mean different things to different people.
As such, it would be correct to state that **all** anarchists oppose the "free
market" by definition as all anarchists oppose the **capitalist** "free
market." And, just as correctly, "anarcho"-capitalists would oppose the
individualist anarchist "free market," arguing that it would be no such thing
as it would be restrictive of property rights ( **capitalist** property rights
of course). For example, the question of resource use in an individualist
society is totally different than in a capitalist "free market" as landlordism
would not exist. This is a restriction on capitalist property rights and a
violation of a capitalist "free market." So an individualist "free market"
would not be considered so by right-wing "libertarians" due to the substantial
differences in the rights on which it would be based (with no right to
capitalist private property being the most important).

All this means that to go on and on about individualist anarchism and its
support for a free market simply misses the point. No one denies that
individualist anarchists were (and are) in favour of a "free market" but this
did not mean they were not socialists nor that they wanted the same kind of
"free market" desired by "anarcho"-capitalism or that has existed under
capitalism. Of course, whether their economic system would actually result in
the abolition of exploitation and oppression is another matter and it is on
this issue which social anarchists disagree with individualist anarchism
**not** whether they are socialists or not.

## G.1.2 What about their support of "private property"?

The notion that because the Individualist Anarchists supported "private
property" they supported capitalism is distinctly wrong. This is for two
reasons. Firstly, private property is not the distinctive aspect of capitalism
-- exploitation of wage labour is. Secondly and more importantly, what the
Individualist Anarchists meant by "private property" (or "property") was
distinctly different than what is meant by theorists on the
"libertarian"-right or what is commonly accepted as "private property" under
capitalism. Thus support of private property does not indicate a support for
capitalism.

On the first issue, it is important to note that there are many different
kinds of private property. If quoting Karl Marx is not **too** out of place:

> _"Political economy confuses, on principle, two very different kinds of
> private property, one of which rests on the labour of the producer himself,
> and the other on the exploitation of the labour of others. It forgets that
> the latter is not only the direct antithesis of the former, but grows on the
> former's tomb and nowhere else._

> _"In Western Europe, the homeland of political economy, the process of
> primitive accumulation is more or less accomplished . . ._

> _"It is otherwise in the colonies. There the capitalist regime constantly
> comes up against the obstacle presented by the producer, who, as owner of
> his own conditions of labour, employs that labour to enrich himself instead
> of the capitalist. The contradiction of these two diametrically opposed
> economic systems has its practical manifestation here in the struggle
> between them."_ [ **Capital** , vol. 1, p. 931]

So, under capitalism, _"property turns out to be the right, on the part of the
capitalist, to appropriate the unpaid labour of others, or its product, and
the impossibility, on the part of the worker, of appropriating his own
product."_ In other words, property is not viewed as being identical with
capitalism. _"The historical conditions of [Capital's] existence are by no
means given with the mere circulation of money and commodities. It arises only
when the owner of the means of production and subsistence finds the free
worker available on the market, as the seller of his own labour-power."_ Thus
wage-labour, for Marx, is the necessary pre-condition for capitalism, **not**
"private property" as such as _"the means of production and subsistence, while
they remain the property of the immediate producer, are not capital. They only
become capital under circumstances in which they serve at the same time as
means of exploitation of, and domination over, the worker."_ [ **Op. Cit.** ,
p. 730, p. 264 and p. 933]

For Engels, _"[b]efore capitalistic production"_ industry was _"based upon the
private property of the labourers in their means of production"_ , i.e., _"the
agriculture of the small peasant"_ and _"the handicrafts organised in
guilds."_ Capitalism, he argued, was based on capitalists owning _" **social**
means of production only workable by a collectivity of men"_ and so they
_"appropriated . . . the product of the **labour of others**."_ Both, it
should be noted, had also made this same distinction in the **Communist
Manifesto** , stating that _"the distinguishing feature of Communism is not
the abolition of property generally, but the abolition of bourgeois
property."_ Artisan and peasant property is _"a form that preceded the
bourgeois form"_ which there _"is no need to abolish"_ as _"the development of
industry has to a great extent already destroyed it."_ This means that
communism _"deprives no man of the power to appropriate the products of
society; all that it does is to deprive him of the power to subjugate the
labour of others by means of such appropriation."_ [Marx and Engels,
**Selected Works** , p. 412, p. 413, p. 414, p. 47 and p. 49]

We quote Marx and Engels simply because as authorities on socialism go, they
are ones that right-"libertarians" (or Marxists, for that matter) cannot
ignore or dismiss. Needless to say, they are presenting an identical analysis
to that of Proudhon in **What is Property?** and, significantly, Godwin in his
**Political Justice** (although, of course, the conclusions drawn from this
common critique of capitalism were radically different in the case of
Proudhon). This is, it must be stressed, simply Proudhon's distinction between
property and possession (see [section B.3.1](secB3.md#secb31)). The former
is theft and despotism, the latter is liberty. In other words, for genuine
anarchists, "property" is a **_social relation_** and that a key element of
anarchist thinking (both social and individualist) was the need to redefine
that relation in accord with standards of liberty and justice.

So what right-"libertarians" do when they point out that the individualist
anarchists supported property is to misunderstand the socialist critique of
capitalism. They, to paraphrase Marx, confuse two very different kinds of
"property," one of which rests on the labour of the producers themselves and
the other on the exploitation of the labour of others. They do not analyse the
social relationships between people which the property in question generates
and, instead, concentrate on **things** (i.e. property). Thus, rather than
being interested in people and the relationships they create between
themselves, the right-"libertarian" focuses on property (and, more often than
not, just the word rather than what the word describes). This is a strange
position for someone seeking liberty to take, as liberty is a product of
social interaction (i.e. the relations we have and create with others) and not
a product of things (property is not freedom as freedom is a relationship
between people, not things). They confuse property with possession (and vice
versa).

In pre-capitalist social environments, when property is directly owned by the
producer, capitalist defences of private property can be used against it. Even
John Locke's arguments in favour of private property could be used against
capitalism. As Murray Bookchin makes clear regarding pre-capitalist society:

> _"Unknown in the 1640s, the non-bourgeois aspects of Locke's theories were
> very much in the air a century and a half later . . . [In an artisan/peasant
> society] a Lockean argument could be used as effectively against the
> merchants . . . to whom the farmers were indebted, as it could against the
> King [or the State]. Nor did the small proprietors of America ever quite
> lose sight of the view that attempts to seize their farmsteads and
> possessions for unpaid debts were a violation of their 'natural rights,' and
> from the 1770s until as late as the 1930s they took up arms to keep
> merchants and bankers from dispossessing them from land they or their
> ancestors had wrestled from 'nature' by virtue of their own labour. The
> notion that property was sacred was thus highly elastic: it could be used as
> effectively by pre-capitalist strata to hold on to their property as it
> could by capitalists strata to expand their holdings."_ [ **The Third
> Revolution** , vol. 1, pp. 187-8]

The individualist anarchists inherited this perspective on property and sought
means of ending the transformation of American society from one where labour-
property predominated into one where capitalist private property (and so
exploitation) predominated. Thus their opposition to state interference in the
economy as the capitalists were using the state to advance this process (see
[section F.8.5](secF8.md#secf85)).

So artisan and co-operative property is not capitalist. It does not generate
relationships of exploitation and domination as the worker owns and controls
their own means of production. It is, in effect, a form of socialism (a
_"petit bourgeois"_ form of socialism, to use the typical insulting Marxist
phrase). Thus support for "private property" need not mean support for
capitalism (as shown, for example, by the Individualist Anarchists). To claim
otherwise is to ignore the essential insight of socialism and totally distort
the socialist case against capitalism.

To summarise, from an anarchist (and Marxist) perspective capitalism is
**not** defined by "property" as such. Rather, it is defined by private
property, property which is turned into a means of exploiting the labour of
those who use it. For most anarchists, this is done by means of wage labour
and abolished by means of workers' associations and self-management (see [next
section](secG1.md#secg13) for a discussion of individualist anarchism and
wage labour). To use Proudhon's terminology, there is a fundamental difference
between property and possession.

Secondly, and more importantly, what the Individualist Anarchists meant by
"private property" (or "property") was distinctly different than what is meant
by supporters of capitalism. Basically, the "libertarian" right exploit, for
their own ends, the confusion generated by the use of the word "property" by
the likes of Tucker to describe a situation of "possession." Proudhon
recognised this danger. He argued that _"it is proper to call different things
by different names, if we keep the name 'property' for the former [individual
possession], we must call the latter [the domain of property] robbery, repine,
brigandage. If, on the contrary, we reserve the name 'property' for the
latter, we must designate the former by the term **possession** or some other
equivalent; otherwise we should be troubled with an unpleasant synonym."_ [
**What is Property?** , p. 373] Unfortunately Tucker, who translated this
work, did not heed Proudhon's words of wisdom and called possession in an
anarchist society by the word "property" (but then, neither did Proudhon in
the latter part of his life!)

Looking at Tucker's arguments, it is clear that the last thing Tucker
supported was capitalist property rights. For example, he argued that
_"property, in the sense of individual possession, is liberty"_ and contrasted
this with capitalist property. [ **Instead of a Book** , p. 394] That his
ideas on "property" were somewhat different than that associated with
right-"libertarian" thinkers is most clearly seen with regards to land. Here
we discover him advocating _"occupancy and use"_ and rejecting the "right" of
land owners to bar the landless from any land they owned but did not
**personally** use. Rent was _"due to that denial of liberty which takes the
shape of land monopoly, vesting titles to land in individuals and associations
which do not use it, and thereby compelling the non-owning users to pay
tribute to the non-using owners as a condition of admission to the competitive
market."_ Anarchist opposition of rent did _"not mean simply the freeing of
unoccupied land. It means the freeing of all land not occupied **by the
owner.** In other words, it means land ownership limited by occupancy and
use."_ [Tucker, **The Individualist Anarchists** , p. 130 and p. 155] This
would result in a _"system of occupying ownership . . . accompanied by no
legal power to collect rent."_ [ **Instead of a Book** , p. 325]

A similar position was held by John Beverley Robinson. He argued that there
_"are two kinds of land ownership, proprietorship or property, by which the
owner is absolute lord of the land, to use it or to hold it out of use, as it
may please him; and possession, by which he is secure in the tenure of land
which he uses and occupies, but has no claim upon it at all if he ceases to
use it."_ Moreover, _"[a]ll that is necessary to do away with Rent is to away
with absolute property in land."_ [ **Patterns of Anarchy** , p. 272] Joseph
Labadie, likewise, stated that _"the two great sub-divisions of Socialists"_
(anarchists and State Socialists) both _"agree that the resources of nature --
land, mines, and so forth -- should not be held as private property and
subject to being held by the individual for speculative purposes, that use of
these things shall be the only valid title, and that each person has an equal
right to the use of all these things. They all agree that the present social
system is one composed of a class of slaves and a class of masters, and that
justice is impossible under such conditions."_ [ **What is Socialism?** ]

Thus the Individualist Anarchists definition of "property" differed
considerably from that of the capitalist definition. As they themselves
acknowledge. Robinson argued that _"the only real remedy is a change of heart,
through which land using will be recognised as proper and legitimate, but land
holding will be regarded as robbery and piracy."_ [ **Op. Cit.** , p. 273]
Tucker, likewise, indicated that his ideas on "property" were not the same as
existing ones when he argued that _"the present system of land tenure should
be changed to one of occupancy and use"_ and that _"no advocate of occupancy-
and-use tenure of land believes that it can be put in force, until as a theory
it has been as generally . . . seen and accepted as the prevailing theory of
ordinary private property."_ [ **Occupancy and Use verses the Single Tax** ]
Thus, for Tucker, anarchism is dependent on _"the Anarchistic view that
occupancy and use should condition and limit landholding becom[ing] the
prevailing view."_ [ **The Individualist Anarchists** , p. 159]

Based on this theory of "property" Tucker opposed landlords and rent, arguing
that anarchy _"means the freeing of all land not occupied **by the owner** "_
that is, _"land ownership limited by occupancy and use."_ He extended this
principle to housing, arguing that _"Anarchic associations"_ would _"not
collect your rent, and might not even evict your tenant"_ and _"tenants would
not be forced to pay you rent, nor would you be allowed to seize their
property. The Anarchic Associations would look upon your tenants very much as
they would look upon your guests."_ [ **Op. Cit.** , p. 155 and p. 162] In
fact, individualist anarchism would _"accord the actual occupant and user of
land the right to that which is upon the land, who left it there when
abandoning the land."_ [Tucker, **Liberty** , no. 350, p. 4]

In the case of land and housing, almost all Individualist Anarchists argued
that the person who lives or works on it (even under lease) would be regarded
_"as the occupant and user of the land on which the house stands, and as the
owner of the house itself,"_ that is they become _"the owner of both land and
house as soon as he becomes the occupant."_ [Tucker, **Occupancy and Use
Versus the Single Tax** ] For Tucker, occupancy and use was _"the Anarchistic
solution of the land question"_ as it allowed free access to land to all, to
be _"enjoyed by the occupant without payment of tribute to a non-occupant."_
This applied to what was on the land as well, for if A builds a house, and
rents it to B, who lives or works in it under the lease then Tucker would
_"regard B as the occupant and user of the land on which the house stands, and
as **the owner of the house itself.** "_ [ **Liberty** , no. 308, p. 4]

Needless to say, the individualist anarchists were just as opposed to that
mainstay of modern capitalism, the corporation. For Greene corporations
_"disarrange our social organisation, and make the just distribution of the
products of labour impossible."_ [quoted by Wm. Gary Kline, **The
Individualist Anarchists: A Critique of Liberalism** , p. 94] While opposing
state attempts to limit trusts (it did not get to the root of the problem
which lay in class privilege), Tucker took it for granted that _"corporate
privileges are in themselves a wrong."_ [ **The Individualist Anarchists** ,
p. 129] Given that "occupancy and use" applies to what is on the land, it
logically follows that for those workplaces with absentee owners (i.e., owners
who hire managers to run them) then these are abandoned by their owners. By
the "occupancy and use" criteria, the land and what is on it reverts to those
actually using them (i.e., the workers in question). Corporations and
shareowners, in other words, are extremely unlikely to exist in individualist
anarchism.

Hence to claim that the Individualist Anarchists supported capitalist property
rights is false. As can be seen, they advocated a system which differed
significantly to the current system, indeed they urged the restriction of
property rights to a form of possession. Unfortunately, by generally using the
term "property" to describe this new system of possession they generated
exactly the confusion that Proudhon foretold. Sadly, right-"libertarians" use
this confusion to promote the idea that the likes of Tucker supported
capitalist property rights and so capitalism. As Tucker argued, _"[d]efining
it with Proudhon as the sum total of legal privileges bestowed upon the holder
wealth, [individualist anarchism] agrees with Proudhon that property is
robbery. But using the word in the commoner acceptation, as denoting the
labour's individual possession of his product or of his proportional share of
the joint product of himself and others, [it] holds that property is
liberty."_ [ **Liberty** , no. 122, p. 4]

If, as it is sometimes suggested, the difference between right "libertarians"
and left libertarians is that the former despise the state because it hinders
the freedom of property while the latter condemn it because it is a bastion of
property, it is worthwhile to note two important facts. Firstly, that
individualist anarchism condemns the state because it protects the land
monopoly, i.e., capitalist property rights in land and what is on it, rather
than a system of "occupancy and use." Secondly, that all schools of anarchist
oppose capitalism because it is based on the exploitation of labour, an
exploitation which the state protects. Hence de Cleyre: _"I wish a sharp
distinction made between the legal institution of property, and property in
the sense that what a man definitely produces by his own labour is his own."_
The inequality and oppressions of capitalism are _"the inevitable result of
the whole politico-economic lie that man can be free and the institution of
property continue to exist."_ [ **Exquisite Rebel** , p. 297] Given this,
given these bastions of property against which the both the individualist and
social anarchists turn their fire, it is obvious that both schools are left
libertarians.

For these reasons it is clear that just because the Individualist Anarchists
supported (a form of) "property" does not mean they are capitalists. After
all, as we note in the [section G.2](secG2.md) communist-anarchists
recognise the necessity of allowing individuals to own and work their own land
and tools if they so desire yet no one claims that they support "private
property." Equally, that many of the Individualist Anarchists used the term
"property" to describe a system of possession (or _"occupancy-and-use"_ )
should not blind us to the non-capitalist nature of that "property." Once we
move beyond looking at the words they used to what they meant by those words
we clearly see that their ideas are distinctly different from those of
supporters of capitalism. In fact, they share a basic commonality with social
anarchism ( _"Property will lose a certain attribute which sanctifies it now.
The absolute ownership of it -- 'the right to use or abuse' will be abolished
-- and possession, use, will be the only title."_ [Albert R. Parsons,
**Anarchism: Its Philosophy and Scientific Basis** , p. 173]). This should be
unsurprising given the influence of Proudhon on both wings of the movement.

As Malatesta noted, recognising the _"the right of workers to the products of
their own labour,"_ demanding _"the abolition of interest"_ and _"the division
of land and the instruments of labour among those who wish to use them"_ would
be _"a socialist school different from [communist-anarchism], but it is still
socialism."_ It would be a _"mutualist"_ socialism. [ **At the Café** , p. 54
and p. 56] In other words, property need not be incompatible with socialism.
It all depends on the type of property being advocated.

## G.1.3 What about their support for wage labour?

As we have argued in [section A.2.8](secA2.md#seca28) and elsewhere, a
consistent anarchist must oppose wage labour as this is a form of hierarchical
authority. While social anarchism has drawn this logical conclusion from
anarchist principles, individualist anarchism has not. While many of its
supporters have expressed opposition to wage labour along with other forms
hierarchical organisation, some (like Tucker) did not. The question is whether
supporting wage labour disqualifies them from the socialist movement or not.

Within individualist anarchism, there are two different positions on this
matter. Some of them clearly opposed wage labour as inherently exploitative
and saw their socio-economic ideas as a means of ending it. Others argued that
it was not wage labour **as such** which was the problem and, as a
consequence, they did not expect it to disappear under anarchy. So opposition
to exploitation of labour was a universal thread in Individualist Anarchist
thought, as it was in the social anarchist movement. However, opposition to
wage slavery was a common, but not universal, thread within the individualist
anarchist tradition. As we discuss in [section G.4](secG4.md), this is one
of the key reasons why social anarchists reject individualist anarchism,
arguing that this makes it both inconsistent in terms of general anarchist
principles as well in the principles of individualist anarchism.

Voltairine de Cleyre in her overview of anarchism put the difference in terms
of individualist anarchism and mutualist anarchism. As she put it, the
_"extreme individualists"_ held that the _"essential institutions of
Commercialism are in themselves good, and are rendered vicious merely by the
interference by the State."_ This meant _"the system of employer and employed,
buying and selling, banking, and all the other essential institutions of
Commercialism"_ would exist under their form of anarchism. Two key differences
were that property in land would be modified so that it could be _"held by
individuals or companies for such time and in such allotments as they use
only"_ and that _"wages would rise to the full measure of the individual
production, and forever remain there"_ as _"bosses would be hunting for men
rather than men bosses."_ In other words, land would no longer be owned as
under capitalism and workers would no longer be exploited as profit, interest
and rent could not exist and the worker would get the full product of his or
her labour in wages. In contrast, mutualist anarchism _"is a modification of
the program of Individualism, laying more emphasis upon organisation, co-
operation and free federation of the workers. To these the trade union is the
nucleus of the free co-operative group, which will obviate the necessity of an
employer . . . The mutualist position on the land question is identical with
that of the Individualists."_ The _"material factor which accounts for such
differences as there are between Individualists and Mutualists"_ was due to
the former being intellectual workers and so _"never know[ing] directly the
oppressions of the large factory, nor mingled with workers' associations. The
Mutualists had; consequently their leaning towards a greater Communism."_ [
_"Anarchism"_ , **Exquisite Rebel** , p. 77 and p. 78]

Next, we must clarify what is meant by **_"wage labour"_** and the related
term **_"wages system."_** They are not identical. Marx, for example,
corrected the Gotha Programme's _"abolition of the wage system"_ by saying
_"it should read: system of wage labour"_ (although that did not stop him
demanding _"the ultimate abolition of the wages system"_ elsewhere). [Marx and
Engels, **Selected Works** , p. 324 and p. 226] The difference lies in whether
there is communism (distribution according to need) or socialism (distribution
according to work done), as in Marx's (in)famous difference between a lower
and higher phase of communism. It is the difference between a distribution of
goods based on deeds and one based on needs and Kropotkin's famous polemic
_"The collectivist Wages System"_ rests on it. He argued that the wages system
was based on _"renumeration to each according to the time spent in producing,
while taking into account the productivity of his labour"_. In other words:
_"To each according to his deeds."_ [ **The Conquest of Bread** , p. 162 and
p. 167] Such a wages system could exist in different forms. Most obviously,
and the focus of Kropotkin's critique, it could be a regime where the state
owned the means of production and paid its subjects according to their labour
(i.e., state socialism). It could also refer to a system of artisans, peasants
and co-operatives which sold the product of their labour on a market or
exchanged their goods with others based on labour-time notes (i.e.,
associational socialism).

This should not be confused with wage labour, in which a worker sells their
labour to a boss. This results in a hierarchical social relationship being
created in which the worker is the servant of the employer. The employer, as
they own the labour of the worker, also keeps the product of said labour and
as we argued in [section C.2](secC2.md), this places the boss is in a
position to get the worker to produce more than they get back in wages. In
other words, wage labour is based on oppression and can result in exploitation
as the bosses control both the production process (i.e., the labour of the
workers) and the goods it produces. It is this which explains socialist
opposition to wage labour -- it is the means by which labour is exploited
under capitalism (anarchist opposition to wage labour includes this but also
extends it to include its denial of freedom to those subject to workplace
hierarchy).

So for the purposes of this discussion **_"wage labour"_** refers to
hierarchical social relationships **within** production while **_"wages
system"_** refers to how goods are distributed once they are produced. Thus
you can have a wages system without wage labour but not wage labour without a
wages system. Communist-anarchists aim for the abolition of both wage labour
and the wages system while mutualist-anarchists only aim to get rid of the
first one.

The problem is that the terms are sometimes mixed up, with "wages" and "wages
system" being confused with "wage labour." This is the case with the
nineteenth century American labour movement which tended to use the term
"wages system" to refer to wage labour and the expression _"abolition of the
wages system"_ to refer to the aim of replacing capitalism with a market
system based on producer co-operatives. This is reflected in certain
translations of Proudhon. Discussing the _"workmen's associations"_ founded in
France during the 1848 revolution, Proudhon noted that _"the workmen, in order
to dispense with . . . capitalists . . . have had to work a little more, and
get along with less wages."_ So he considered workers associations as paying
"wages" and so, obviously, meant by "wages" labour income, **not** wage
labour. The French word "salariat" was translated as "wages system," so we
find Proudhon arguing that the _"workmen's associations"_ are _"a protest
against the wage system"_ and a _"denial of the rule of capitalists."_ His aim
was _"Capitalistic and proprietary exploitation, stopped everywhere, the wage
system abolished, equal and just exchange guaranteed."_ [ **General Idea of
the Revolution** , pp. 89-90, p. 98 and p. 281] This can also be translated as
_"Capitalist and landlord exploitation halted everywhere, wage-labour
abolished."_ [quoted by John Ehrenberg, **Proudhon and his Age** , p. 116]

We are sorry to belabour this point, but it is essential for understanding the
anarchist position on wage labour and the differences between different
schools of socialism. So before discussing the relation of individualist
anarchism to wage labour we needed to clarify what is meant by the term,
particularly as some people use the term wages to mean any kind of direct
payment for labour and so wage labour is sometimes confused with the wages
system. Similarly, the terms wage labour and wages systems are often used
interchangeably when, in fact, they refer to different things and abolition
the wages system can mean different things depending on who is using the
expression.

So after this unfortunately essential diversion, we can now discuss the
position of individualist anarchism on wage labour. Unfortunately, there is no
consistent position on this issue within the tradition. Some follow social
anarchism in arguing that a free society would see its end, others see no
contradiction between their ideas and wage labour. We will discuss each in
turn.

Joshua King Ingalls, for example, praised attempts to set up communities based
on libertarian principles as _"a demonstration . . . that none need longer
submit to the tyranny and exactions of the swindler and speculator in the
products of others toil. The example would be speedily followed by others who
would break away from the slavery of wages, and assert their independence of
capital."_ [ _"Method of Transition for the Consideration of the True Friends
of Human Rights and Human Progress,"_ **Spirit of the Age** , Vol. I, No. 25,
pp. 385-387] The _"present relation of 'Capital and Labor' is . . . really a
mixed relation between contract and status; held by fiction of law as one of
'freedom of contract,' while it retains potentially all the essential features
of serfdom. Industrially and economically, the relation is substantially the
same as that which existed between the chattel and his owner, and the serf and
his lord."_ Ingalls pointed to _"the terrible fear of being 'out of a job,'
which freedom of contract means to a wage-worker."_ [ _"Industrial Wars and
Governmental Interference,"_ **The Twentieth Century** , September 6, 1894,
pp. 11-12] _"To reward capital,"_ he argued, _"is a direct inversion of
natural right, as the right of man must be acknowledged paramount to that of
property . . . Any system, securing a premium to capital, however small, must
result in the want, degradation and servitude of one class, and in bestowing
unearned wealth and power upon another."_ [ _"Man and Property, their Rights
and Relations,"_ **Spirit of the Age** , vol. I, no. 8, pp. 114-116] Like
Proudhon, he recognised that joint productive activity resulted in an output
greater than that possible by the same number of people working in isolation,
an output monopolised by those who owned the workplace or land in question:

> _"That the operation of any wealth increasing enterprise is co-operative
> needs only stating . . . and its logic in division of the product of the
> conjoint labour, can only be frustrated by the fiction that the worker has
> contracted away his share of the increase by accepting wages. But, being
> dispossessed of his common right to land, and to opportunity to use the
> common materials and forces, he can make no equitable contract and cannot be
> lawfully thus concluded . . . The only pretence which prevents this
> distribution, is the plea that the worker in accepting wages, has tacitly
> contracted away his share of the increase, has made a sale of his interest.
> Even this subterfuge fails logically however, whenever the operators reduce
> the rate of compensation without the full concurrence of the co-operative
> workers, and their just claim to joint ownership obtains again. It is
> altogether too late, to urge that this is a mere matter of exchange; so much
> money, so much labour-; and that the operator may lay off and take on whom
> he pleases. It never was, as economists teach, a matter of exchange, but one
> of co-operative endeavour."_ [ _"Industrial Wars and Governmental
> Interference,"_ **The Twentieth Century** , September 6, 1894, pp. 11-12]

Unsurprisingly given this analysis he saw the need to replace wage labour
(which he called _"false and immoral"_ ) with a better system: _"the adoption
of honesty in our useful industries, and a reciprocal system of exchange,
would unfold a grand and universal cooperative movement, seems so clear to
me."_ [ _"The Wage Question"_ , **The American Socialist** , Vol. 2, No. 38,
p. 298] This would result in a boost to economic activity:

> _"No one, say they, will do anything but for profits. But the man who works
> for wages has no profits; and is not only destitute of this stimulus, but
> his labour product is minus the profits of the capitalist, landlord, and
> forestaller. A rational economy would seem to require, that if any one
> received extra inducement to act, it should be that one who did the most
> labourious and repulsive work. It is thus seen, that while exorbitant
> profits afford an unnatural stimulus, in mere wages we have an inadequate
> motive to action."_ [ _"Labor, Wages, And Capital. Division Of Profits
> Scientifically Considered"_ , **Brittan's Quarterly Journal** , No. I, pp.
> 66-79]

The land monopoly was _"the foundation of class dominion and of poverty and
industrial subjection."_ [quoted by Bowman N. Hall, _"Joshua K. Ingalls,
American Individualist: Land Reformer, Opponent of Henry George and Advocate
of Land Leasing, Now an Established Mode",_ pp. 383-96, **American Journal of
Economics and Sociology** , Vol. 39, No. 4, p. 387] Without access to land,
people would have no option to sell their liberty to others and, as such, the
abolition of slavery and wage labour were related:

> _"The right to life involves the right to land to live and labour upon.
> Commercial ownership of land which enables one to exclude another from it,
> and thus enforces involuntary idleness, is as destructive of human freedom
> as ownership of the person, enforcing involuntary service . . . Liberation
> of the slaves would bring their labour in more direct competition with our
> over-crowded and poorly paid wage-workers. I did not offer this as a reason
> against the abolition of chattel slavery, but as a reason why the friends of
> emancipation from chattel slavery should unite with the friends for the
> emancipation of the wage worker, by restoring him the right to land, for the
> production of the means of life . . . The real issue was between the rights
> of labour and the rights of ownership."_ [quoted by Bowman N. Hall, **Op.
> Cit.** , p. 385]

This analysis was a common theme in pre-civil war libertarian circles. As
historian James J. Martin noted, _"[t]o men like Warren and Evens chattel
slavery was merely one side of a brutal situation, and although sympathetic
with its opponents, refused to take part in the struggle [against slavery]
unless it was extended to a wholesale attack on what they termed 'wage
slavery' in the states where Negro slavery no longer existed."_ [ **Men
Against the State** , p. 81] Such a view, we may add, was commonplace in
radical working class journals and movements of the time. Thus we find George
Henry Evans (who heavily influenced Individualist Anarchists like Warren and
Ingalls with the ideas of land reform based on _"occupancy and use"_ )
writing:

> _"I was formally, like yourself, sir, a very warm advocate of the abolition
> of (black) slavery. This was before I saw that there was white slavery.
> Since I saw this, I have materially changed my views as to the means of
> abolishing Negro slavery. I now see clearly, I think, that to give the
> landless black the privilege of changing masters now possessed by the
> landless white, would hardly be a benefit to him in exchange for his surety
> of support in sickness and old age, although he is in a favourable
> climate."_ [quoted by Martin, **Op. Cit.** , p. 81f]

Ingalls, likewise, _"considered the only 'intelligent' strike [by workers as]
one which would be directed against wage work altogether."_ For Lysander
Spooner, liberty meant that the worker was entitled to _"all the fruits of his
own labour"_ and argued that this _"might be feasible"_ only when _"every man
[was] his own employer or work[s] for himself in a direct way, since working
for another resulted in a portion being diverted to the employer."_ [Martin,
**Op. Cit.** , p. 153 and p. 172] To quote Spooner:

> _"When a man knows that he is to have **all** the fruits of his labour, he
> labours with more zeal, skill, and physical energy, than when he knows -- as
> in the case of one labouring for wages -- that a portion of the fruits of
> his labour are going to another. . . In order that each man may have the
> fruits of his own labour, it is important, as a general rule, that each man
> should be his own employer, or work directly for himself, and not for
> another for wages; because, in the latter case, a part of the fruits of his
> labour go to his employer, instead of coming to himself . . . That each man
> may be his own employer, it is necessary that he have materials, or capital,
> upon which to bestow his labour."_ [ **Poverty: Its Illegal Causes and Legal
> Cure** , p. 8]

Wage labour had a negative impact on those subject to it in terms of their
personal development. _"The mental independence of each individual would be
greatly promoted by his pecuniary independence,"_ Spooner argued. _"Freedom of
thought, and the free utterance of thought, are, to a great degree, suppressed
. . . by their dependence upon the will and favour of others, for that
employment by which they must obtain their daily bread. They dare not
investigate, or if they investigate, dare not freely avow and advocate those
moral, social, religious, political, and economical truths, which alone can
rescue them from their degradation, lest they should thereby sacrifice their
bread by stirring the jealousy of those out whom they are dependent, and who
derive their power, wealth, and consequence from the ignorance and servitude
of the poor."_ [ **Op. Cit.** , p. 54] As we argued in [section
B.1](secB1.md), all forms of hierarchy (including wage labour) distorts the
personality and harms the individual psychologically.

Spooner argued that it was state restrictions on credit and money (the _"money
monopoly"_ based on banks requiring gold/silver to operate) as the reason why
people sell themselves to others on the labour market. As he put it, _"a
monopoly of money . . . . put[s] it wholly out of the power of the great body
of wealth-producers to hire the capital needed for their industries; and thus
compel them . . . -- by the alternative of starvation -- to sell their labour
to the monopolists of money . . . [who] plunder all the producing classes in
the prices of their labour."_ Spooner was well aware that it was capitalists
who ran the state ( _"the employers of wage labour . . . are also the
monopolists of money"_ ). In his ideal society, the _"amount of money capable
of being furnished . . . is so great that every man, woman, and child. . .
could get it, and go into business for himself, or herself -- either singly,
or in partnerships -- and be under no necessity to act as a servant, or sell
his or her labour to others. All the great establishments, of every kind, now
in the hands of a few proprietors, but employing a great number of wage
labourers, would be broken up; for few, or no persons, who could hire capital,
and do business for themselves, would consent to labour for wages for
another."_ [ **A Letter to Grover Cleveland** , p. 20, p. 48 and p. 41]

As Eunice Minette Schuster noted, Spooner's _"was a revolt against the
industrial system"_ , a _" **return** to **pre-industrial** society."_ He
_"would destroy the factory system, wage labour . . . by making every
individual a small capitalist, an independent producer"_ and _"turn the clock
of time backwards, not forward."_ This position seems to have been a common
one, for _"the early American Individualists aimed to return . . . to an
economic system where everyone would be a small, independent proprietor."_ [
**Native American Anarchism** , p. 148, pp. 151-2 and p. 157] As another
commentator on individualist anarchism also noted, _"the dominant vision of
the future was obviously that of a relatively modest scale of production . . .
underpinned by individual, self-employed workers"_ and so the individualist
anarchists _"expected a society of largely self-employed workmen with no
significant disparity of wealth between any of them."_ [Wm. Gary Kline **The
Individualist Anarchists** , p. 95 and p. 104]

This is not to say that all the individualist anarchists ignored the rise of
large scale industrial production. Far from it. Tucker, Greene and Lum all
recognised that anarchism had to adjust to the industrial system and proposed
different solutions for it. Greene and Lum followed Proudhon and advocated co-
operative production while Tucker argued that mutual banks could result in a
non-exploitative form of wage labour developing.

William Greene pronounced that _"[t]here is no device of the political
economists so infernal as the one which ranks labour as a commodity, varying
in value according to supply and demand . . . To speak of labour as
merchandise is treason; for such speech denies the true dignity of man . . .
Where labour is merchandise in fact . . . there man is merchandise also,
whether in England or South Carolina."_ This meant that, _"[c]onsidered from
this point of view, the price of commodities is regulated not by the labour
expended in their production, but by the distress and want of the labouring
class. The greater the distress of the labourer, the more willing will he be
to work for low wages, that is, the higher will be the price he is willing to
give for the necessaries of life. When the wife and children of the labourer
ask for bread, and he has none to give them, then, according to the political
economists, is the community prosperous and happy; for then the rate of wages
is low, and commodities command a high price in labour."_ [ **Mutual Banking**
, pp. 49-50 and p. 49]

Greene's alternative was co-operation in production, consumption and exchange.
_"The triple formula of practical mutualism"_ , he argued, was _"the
associated workshop"_ for production, the _"protective union store"_ for
consumption and the _"the Mutual Bank"_ for exchange. All three were required,
for _"the Associated Workshop cannot exist for a single day without the Mutual
Bank and the Protective Union Store."_ Without mutual banking, the productive
co-operatives would not survive as it would not gain access to credit or at a
high rate ( _"How do you advance the cause of labour by putting your
associated neck under the heel of capital? Your talk about 'the emancipation
of labour' is wind and vapour; labour cannot be emancipated by any such
process."_ ) Thus the _"Associated Workshop ought to be an organisation of
personal credit. For what is its aim and purpose? Is it not the emancipation
of the labourer from all dependence upon capital and capitalists?"_ [ **Op.
Cit.** , p. 37, p. 34, p. 35 and p. 34] The example of the Mondragon co-
operative complex in the Basque country confirms the soundness of Greene's
analysis.

Here we see a similar opposition to the commodification of labour (and so
labourers) within capitalism that also marks social anarchist thought. As
Rocker notes, Greene _"emphasised more strongly the **principle of
association** than did Josiah Warren and more so than Spooner had done."_ He
had a _"strong sympathy for the **principle of association.** In fact, the
theory of Mutualism is nothing less than co-operative labour based on the cost
principle."_ He also _"rejected . . . the designation of labour as a
**commodity** "_ and _"constantly endeavoured to introduce his ideas into the
youthful labour movement . . . so as to prevent the social problem being
regarded by labour as only a question of wages."_ [ **Pioneers of American
Freedom** ,, p. 108, p. 109, pp. 111-2 and p. 112] This support for producers'
associations alongside mutual banks is identical to Proudhon's ideas -- which
is unsurprising as Greene was a declared follower of the French anarchist.
Martin also indicates Greene's support for co-operation and associative labour
and its relation to the wider labour movement:

> _"Coming at a time when the labour and consumer groups were experimenting
> with 'associated workshops' and 'protective union stores,' Greene suggested
> that the mutual bank be incorporated into the movement, forming what he
> called 'complementary units of production, consumption, and exchange . . .
> the triple formula of practical mutualism.'"_ [ **Op. Cit.** , pp. 134-5]

Dyer Lum was another individualist anarchist who opposed wage labour and
supported co-operative production. Like Greene, Lum took an active part in the
labour movement and was a union organiser. As he put it, the Knights of Labor
aimed to work for the _"abolishment of the wage-system"_ as well as the right
of life requiring the right to the means of living. Dyer, while rejecting
their infatuation with political action, had _"the fullest sympathy"_ for
their aims and supported their economic measures. [ **Liberty** , no. 82, p.
7] Unsurprisingly, as one historian notes, _"Lum began to develop an ideology
that centred on the labour reformers' demand: 'The Wage System must go!'"_ He
joined _"the ideological path of labour reformers who turned to a radicalised
laissez-faire explanation of wage slavery."_ [Frank H. Brooks, _"Ideology,
Strategy, and Organization: Dyer Lum and the American Anarchist Movement"_ ,
pp. 57-83, **Labor History** , vol. 34, No. 1, p. 63 and p. 67] Like the
communist-anarchists of the IWPA, for Lum trade unions were both the means of
fighting capitalism and the way to abolish wage labour:

> _"Anarchists in Chicago tended to be much more sympathetic to class
> organisation, specifically unions, because they had many contacts to local
> unions and the Knights of Labor. The issue was not resolved at the founding
> conference of the IWPA, but the Chicago anarchists did manage to get a
> resolution passed stating that 'we view in trades unions based upon
> progressive principles -- the abolition of the wages-system -- the corner-
> stone of a better society structure than the present one.'_

> _"Lum agreed wholeheartedly with this resolution, particularly the phrase
> 'abolition of the wages-system.' This phrase not only confirmed the
> ideological link between anarchism and labour reform, but also paralleled
> similar language in the declaration of principles of the Knights of Labor.
> By 1886, Lum had joined the Knights and he urged other anarchists,
> particularly individualists, to support their struggles. Lum continued to be
> involved with organised labour for the next seven years, seeing unions as a
> practical necessity in the struggle against class politics and state
> repression."_ [Brooks, **Op. Cit.** , pp. 70-1]

However, _"[d]espite the similarity between the evolution of Lum's strategy
and that of the revolutionary anti-statist socialists in the IWPA, his
analysis of 'wage slavery' was considerably more individualistic."_ [Brooks,
**Op. Cit.** , p. 66] Lum saw it as resulting primarily from state
interference in the economy which reduced the options available to working
class people. With a genuine free market based on free land and free credit
workers would work for themselves, either as independent producers or in co-
operatives ( _"where capital seeks labour . . . where authority dissolves
under the genial glow of liberty, and necessity for wage-labour disappears."_
[Dyer D. Lum, contained in Albert Parsons, **Anarchism** , p. 153]). Thus a
key element of _"Lum's anarchism was his mutualist economics, an analysis of
'wage slavery' and a set of reforms that would 'abolish the wage system.'"_
[Brooks, **Op. Cit.** , p. 71] Voltairine de Cleyre, in her individualist
anarchist days, concurred with her mentor Lum, arguing for a _"complete
international federation of labour, whose constituent groups shall take
possession of land, mines, factories, all the instruments of production, issue
their own certificates of exchange, and, in short, conduct their own industry
without regulative interference from law-makers or employers."_ [ **The
Voltairine de Cleyre Reader** , p. 6]

European individualist anarchists, it should be noted had a similar
perspective. As mentioned in [section A.3.1](secA3.md#seca31), Frenchman E.
Armand argued that _"ownership of the means of production and free disposal of
his produce"_ was _"the quintessential guarantee of the autonomy of the
individual"_ but only as long as _"the proprietor does not transfer it to
someone else or reply upon the services of someone else in operating it."_ [
_"Mini-Manual of the Anarchist Individualist"_ , pp. 145-9, **Anarchism** ,
Robert Graham (ed.), p. 147] Another French individualist anarchist, Ernest
Lesigne, argued that in a free society, _"there should be no more
proletaires"_ as _"everybody"_ would be _"proprietor."_ This would result in
_"The land to the cultivator. The mine to the miner. The tool to the labourer.
The product to the producer."_ [quoted approvingly by Tucker, **Instead of a
Book** , p. 17 and p. 18] Lesigne considered _"co-operative production"_ as
_"a solution to the great problem of social economy, -- the delivery of
products to the consumer at cost"_ and as a means of producers to _"receive
the value of your product, of your effort, without having to deal with a mass
of hucksters and exploiters."_ [ **The Individualist Anarchists** , p. 123]

In other words, many individualist anarchists envisioned a society without
wage labour and, instead, based upon peasant, artisan and associated/co-
operative labour (as in Proudhon's vision). In other words, a **non**
-capitalist society or, more positively, a (libertarian) socialist one as the
workers' own and control the means of production they use. Like social
anarchists, they opposed capitalist exploitation, wage slavery and property
rights. However, not all individualist anarchists held this position, a
notable exception being Benjamin Tucker and many of his fellow contributors to
**Liberty**. Tucker asserted against the common labour movement and social
anarchist equation of capitalism with wage slavery that _"[w]ages is not
slavery. Wages is a form of voluntary exchange, and voluntary exchange is a
form of Liberty."_ [ **Liberty** , no. 3, p. 1]

The question now is, does this support of wage labour equate to support for
capitalism? The answer to that depends on whether you see such a system as
resulting in the exploitation of labour. If socialism is, to requote
Kropotkin, _"understood in its wide, generic, and true sense"_ as _"an effort
to **abolish** the exploitation of labour by capital"_ then even those
Individualist Anarchists who support wage labour must be considered as
socialists due to their opposition to usury. It is for this reason we discover
Rudolf Rocker arguing that Stephan P. Andrews was _"one of the most versatile
and significant exponents of libertarian socialism"_ in the USA in spite of
his belief that _"the specific cause of the economic evil [of capitalism] is
founded not on the existence of the wage system"_ but, rather, on the
exploitation of labour, _"on the unjust compensation of the worker"_ and the
usury that _"deprives him of a part of his labour."_ [ **Op. Cit.** , p. 85
and pp. 77-8] His opposition to exploitation meant he was a socialist, an
opposition which individualist anarchism was rooted in from its earliest days
and the ideas of Josiah Warren:

> _"The aim was to circumvent the exploitation inherent in capitalism, which
> Warren characterised as a sort of 'civilised cannibalism,' by exchanging
> goods on co-operative rather than supply and demand principles."_ [J.W.
> Baker, _"Native American Anarchism,"_ pp. 43-62, **The Raven** , vol. 10,
> no. 1, p. 51]

So it should not be implied that the term socialist is restricted simply to
those who oppose wage labour. It should be noted that for many socialists,
wage labour is perfectly acceptable -- as long as the state is the boss. As
Tucker noted, State Socialism's _"principle plank"_ is _"the confiscation of
**all** capital by the State"_, so stopping _"the liberty of those non-
aggressive individuals who are thus prevented from carrying on business for
themselves or assuming relations between themselves as employer and employee
if they prefer, and who are obliged to become employees of the State against
their will."_ [ **Instead of a Book** , p. 378] Of course, such a position is
not a very good form of socialism which is why anarchists have tended to call
such schemes state-capitalism (an analysis which was confirmed once the Soviet
Union was created, incidentally). If state bureaucrats own and control the
means of production, it would not come as too great a surprise if they, like
private bosses, did so to maximise their incomes and minimise that of their
employees.

Which explains why the vast majority of anarchists do not agree with Tucker's
position. Individualist anarchists like Tucker considered it as a truism that
in their society the exploitation of labour could not exist. Thus even if some
workers did sell their liberty, they would still receive the full product of
their labour. As Tucker put it, _"when interest, rent and profit disappear
under the influence of free money, free land, and free trade, it will make no
difference whether men work for themselves, or are employed, or employ others.
In any case they can get nothing but that wage for their labour which free
competition determines."_ [ **Op. Cit.** , p. 274] Whether this could actually
happen when workers sell their liberty to an employer is, of course, where
other anarchists disagree. The owner of a workplace does not own simply his
(labour) share of the total product produced within it. He (and it usually is
a he) owns everything produced while workers get their wages. The employer,
therefore, has an interest in getting workers to produce as much as they can
during the period they are employed. As the future price of the commodity is
unknown, it is extremely unlikely that workers will be able to accurately
predict it and so it is unlikely that their wages will always equal the cost
price of the product. As such, the situation that an individual worker would
get his "natural" wage would be unlikely and so they would be exploited by
their employer. At best, it could be argued that in the long run wages will
rise to that level but, as Keynes noted, in the long run we are all dead and
Tucker did not say that the free market would end exploitation eventually. So
individual ownership of large-scale workplaces would not, therefore, end
exploitation.

In other words, if (as Tucker argued) individualist anarchism desires _"[n]ot
to abolish wages, but to make **every** man dependent upon wages and to secure
every man his **whole** wages"_ then this, logically, can only occur under
workers control. We discuss this in more detail in [section
G.4.1](secG4.md#secg41), where we also indicate how social anarchists
consider Tucker's position to be in a basic contradiction to anarchist
principles. Not only that, as well as being unlikely to ensure that labour
received its full product, it also contradicts his own principle of
**_"occupancy and use"_**. As such, while his support for non-exploitative
wage labour does not exclude him from the socialist (and so anarchist)
movement, it does suggest an inconsistent anarchism, one which can
(fortunately) be easily made consistent by bringing it fully in line with its
own stated ideals and principles.

Finally, we must note that there is a certain irony in this, given how keenly
Tucker presented himself as a follower of Proudhon. This was because Proudhon
agreed with Tucker's anarchist opponents, arguing continually that wage labour
needed to be replaced by co-operative production to end exploitation and
oppression in production. Proudhon and his followers, in the words of one
historian, thought workers _"should be striving for the abolition of salaried
labour and capitalist enterprise."_ This was by means of co-operatives and
their _"perspective was that of artisan labour . . . The manager/employer
(patron) was a superfluous element in the production process who was able to
deny the worker just compensation for his labour merely by possessing the
capital that paid for the workshop, tools, and materials."_ [Julian P. W.
Archer, **The First International in France, 1864-1872** , p. 45] As Frank H.
Brooks put it, _"Lum drew from the French anarchist Proudhon . . . a radical
critique of classical political economy and . . . a set of positive reforms in
land tenure and banking . . . Proudhon paralleled the native labour reform
tradition in several ways. Besides suggesting reforms in land and money,
Proudhon urged producer cooperation."_ [ **Op. Cit.** , p. 72] We discuss this
aspect of Proudhon's ideas in [section G.4.2](secG4.md#secg42).

So, to conclude, it can be seen that individualist anarchists hold two
positions on wage labour. Some are closer to Proudhon and the mainstream
anarchist tradition than others while a few veer extremely close to
liberalism. While all are agreed that their system would end the exploitation
of labour, some of them saw the possibility of a non-exploitative wage labour
while others aimed for artisan and/or co-operative production to replace it.
Suffice to say, while few social anarchists consider non-exploitative wage
labour as being very likely it is the opposition to non-labour income which
makes individualist anarchism socialist (albeit, an inconsistent and flawed
version of libertarian socialism).

## G.1.4 Why is the social context important in evaluating Individualist
Anarchism?

When reading the work of anarchists like Tucker and Warren, we must remember
the social context of their ideas, namely the transformation of America from a
pre-capitalist to a capitalist society. The individualist anarchists, like
other socialists and reformers, viewed with horror the rise of capitalism and
its imposition on an unsuspecting American population, supported and
encouraged by state action (in the form of protection of private property in
land, restricting money issuing to state approved banks using specie,
government orders supporting capitalist industry, tariffs, suppression of
unions and strikes, and so on). In other words, the individualist anarchists
were a response to the social conditions and changes being inflicted on their
country by a process of _"primitive accumulation"_ (see [section
F.8](secF8.md)).

The non-capitalist nature of the early USA can be seen from the early
dominance of self-employment (artisan and peasant production). At the
beginning of the 19th century, around 80% of the working (non-slave) male
population were self-employed. The great majority of Americans during this
time were farmers working their own land, primarily for their own needs. Most
of the rest were self-employed artisans, merchants, traders, and
professionals. Other classes -- employees (wage workers) and employers
(capitalists) in the North, slaves and planters in the South -- were
relatively small. The great majority of Americans were independent and free
from anybody's command -- they owned and controlled their means of production.
Thus early America was, essentially, a pre-capitalist society. However, by
1880, the year before Tucker started **Liberty** , the number of self-employed
had fallen to approximately 33% of the working population. Now it is less than
10%. [Samuel Bowles and Herbert Gintis, **Schooling in Capitalist America** ,
p. 59] As the US Census described in 1900, until about 1850 _"the bulk of
general manufacturing done in the United States was carried on in the shop and
the household, by the labour of the family or individual proprietors, with
apprentice assistants, as contrasted with the present system of factory
labour, compensated by wages, and assisted by power."_ [quoted by Jeremy
Brecher and Tim Costello, **Common Sense for Hard Times** , p. 35] Thus the
post-civil war period saw _"the factory system become general. This led to a
large increase in the class of unskilled and semi-skilled labour with inferior
bargaining power. Population shifted from the country to the city . . . It was
this milieu that the anarchism of Warren-Proudhon wandered."_ [Eunice Minette
Schuster, **Native American Anarchism** , pp. 136-7]

It is **only** in this context that we can understand individualist anarchism,
namely as a revolt against the destruction of working-class independence and
the growth of capitalism, accompanied by the growth of two opposing classes,
capitalists and proletarians. This transformation of society by the rise of
capitalism explains the development of **both** schools of anarchism, social
and individualist. _"American anarchism,"_ Frank H. Brooks argues, _"like its
European counterpart, is best seen as a nineteenth century development, an
ideology that, like socialism generally, responded to the growth of industrial
capitalism, republican government, and nationalism. Although this is clearest
in the more collectivistic anarchist theories and movements of the late
nineteenth century (Bakunin, Kropotkin, Malatesta, communist anarchism,
anarcho-syndicalism), it also helps to explain anarchists of early- to mid-
century such as Proudhon, Stirner and, in America, Warren. For all of these
theorists, a primary concern was the 'labour problem' -- the increasing
dependence and immiseration of manual workers in industrialising economies."_
[ _"Introduction"_ , **The Individualist Anarchists** , p. 4]

The Individualist Anarchists cannot be viewed in isolation. They were part of
a wider movement seeking to stop the capitalist transformation of America. As
Bowles and Ginitis note, this _"process has been far from placid. Rather, it
has involved extended struggles with sections of U.S. labour trying to counter
and temper the effects of their reduction to the status of wage labour."_ The
rise of capitalism _"marked the transition to control of work by nonworkers"_
and _"with the rise of entrepreneurial capital, groups of formerly independent
workers were increasingly drawn into the wage-labour system. Working people's
organisations advocated alternatives to this system; land reform, thought to
allow all to become an independent producer, was a common demand. Worker co-
operatives were a widespread and influential part of the labour movement as
early as the 1840s . . . but failed because sufficient capital could not be
raised."_ [ **Op. Cit.** , p. 59 and p. 62] It is no coincidence that the
issues raised by the Individualist Anarchists (land reform via _"occupancy-
and-use"_ , increasing the supply of money via mutual banks and so on) reflect
these alternatives raised by working class people and their organisations.
Little wonder Tucker argued that:

> _"Make capital free by organising credit on a mutual plan, and then these
> vacant lands will come into use . . . operatives will be able to buy axes
> and rakes and hoes, and then they will be independent of their employers,
> and then the labour problem will solved."_ [ **Instead of a Book** , p. 321]

Thus the Individualist Anarchists reflect the aspirations of working class
people facing the transformation of an society from a pre-capitalist state
into a capitalist one. Changing social conditions explain why Individualist
Anarchism must be considered socialistic. As Murray Bookchin noted:

> _"Th[e] growing shift from artisanal to an industrial economy gave rise to a
> gradual but major shift in socialism itself. For the artisan, socialism
> meant producers' co-operatives composed of men who worked together in small
> shared collectivist associations, although for master craftsmen it meant
> mutual aid societies that acknowledged their autonomy as private producers.
> For the industrial proletarian, by contrast, socialism came to mean the
> formation of a mass organisation that gave factory workers the collective
> power to expropriate a plant that no single worker could properly own. These
> distinctions led to two different interpretations of the 'social question' .
> . . The more progressive craftsmen of the nineteenth century had tried to
> form networks of co-operatives, based on individually or collectively owned
> shops, and a market knitted together by a moral agreement to sell
> commodities according to a 'just price' or the amount of labour that was
> necessary to produce them. Presumably such small-scale ownership and shared
> moral precepts would abolish exploitation and greedy profit-taking. The
> class-conscious proletarian . . . thought in terms of the complete
> socialisation of the means of production, including land, and even of
> abolishing the market **as such** , distributing goods according to needs
> rather than labour . . . They advocated **public** ownership of the means of
> production, whether by the state or by the working class organised in trade
> unions."_ [ **The Third Revolution** , vol. 2, p. 262]

So, in this evolution of socialism we can place the various brands of
anarchism. Individualist anarchism is clearly a form of artisanal socialism
(which reflects its American roots) while communist anarchism and anarcho-
syndicalism are forms of industrial (or proletarian) socialism (which reflects
its roots in Europe). Proudhon's mutualism bridges these extremes, advocating
as it does artisan socialism for small-scale industry and agriculture and co-
operative associations for large-scale industry (which reflects the state of
the French economy in the 1840s to 1860s). With the changing social conditions
in the US, the anarchist movement changed too, as it had in Europe. Hence the
rise of communist-anarchism in addition to the more native individualist
tradition and the change in Individualist Anarchism itself:

> _"Green emphasised more strongly the **principle of association** than did
> Josiah Warren and more so than Spooner had done. Here too Proudhon's
> influence asserts itself. . . In principle there is essentially no
> difference between Warren and Proudhon. The difference between them arises
> from a dissimilarity of their respective environments. Proudhon lived in a
> country where the sub-division of labour made co-operation in social
> production essential, while Warren had to deal with predominantly small
> individual producers. For this reason Proudhon emphasised the **principle of
> association** far more than Warren and his followers did, although Warren
> was by no means opposed to this view."_ [Rudolf Rocker, **Pioneers of
> American Freedom** , p. 108]

As noted in [section A.3](secA3.md), Voltairine de Cleyre subscribed to a
similar analysis, as does another anarchist, Peter Sabatini, more recently:

> _"The chronology of anarchism within the United States corresponds to what
> transpired in Europe and other locations. An organised anarchist movement
> imbued with a revolutionary collectivist, then communist, orientation came
> to fruition in the late 1870s. At that time, Chicago was a primary centre of
> anarchist activity within the USA, due in part to its large immigrant
> population. . ._

> _"The Proudhonist anarchy that Tucker represented was largely superseded in
> Europe by revolutionary collectivism and anarcho-communism. The same
> changeover occurred in the US, although mainly among subgroups of working
> class immigrants who were settling in urban areas. For these recent
> immigrants caught up in tenuous circumstances within the vortex of emerging
> corporate capitalism, a revolutionary anarchy had greater relevancy than go
> slow mutualism."_ [ **Libertarianism: Bogus Anarchy** ]

Murray Bookchin argued that the development of communist-anarchism _"made it
possible for anarchists to adapt themselves to the new working class, the
industrial proletariat, . . . This adaptation was all the more necessary
because capitalism was now transforming not only European [and American]
society but the very nature of the European [and American] labour movement
itself."_ [ **Op. Cit.** , p. 259] In other words, there have been many
schools of socialism, all influenced by the changing society around them. As
Frank H. Brooks notes, _"before Marxists monopolised the term, socialism, was
a broad concept, as indeed Marx's critique of the 'unscientific' varieties of
socialism in the **Communist Manifesto** indicated. Thus, when Tucker claimed
that the individualist anarchism advocated in the pages of **Liberty** was
socialist, he was not engaged in obfuscation or rhetorical bravado."_ [
_"Libertarian Socialism"_ , pp. 75-7, **The Individualist Anarchists** , p.
75]

Looking at the society in which their ideas developed (rather than
ahistorically projecting modern ideas backward) we can see the socialist core
of Individualist Anarchism. It was, in other words, an un-Marxian form of
socialism (as was mutualism and communist-anarchism). Thus, to look at the
Individualist Anarchists from the perspective of "modern socialism" (say,
communist-anarchism or Marxism) means to miss the point. The social conditions
which produced Individualist Anarchism were substantially different from those
existing today (and those which produced communist-anarchism and Marxism) and
so what was a possible solution to the _"social problem"_ **then** may not be
one suitable **now** (and, indeed, point to a different kind of socialism than
that which developed later). Moreover, Europe in the 1870s was distinctly
different than America (although, of course, the USA **was** catching up). For
example, there was still vast tracks of unclaimed land (once the Native
Americans had been removed, of course) available to workers. In the towns and
cities, artisan production _"remained important . . . into the 1880s"_ [David
Montgomery, **The Fall of the House of Labour** , p. 52] Until the 1880s, the
possibility of self-employment was a real one for many workers, a possibility
being hindered by state action (for example, by forcing people to buy land via
Homestead Acts, restricting banking to those with specie, suppressing unions
and strikes and so on -- see [section F.8.5](secF8.md#secf85)). Little
wonder that Individualist Anarchism was considered a real solution to the
problems generated by the creation of capitalism in the USA and that, by the
1880s, Communist Anarchist became the dominant form of anarchism. By that time
the transformation of America was nearing completion and self-employment was
no longer a real solution for the majority of workers.

This social context is essential for understanding the thought of people like
Greene, Spooner and Tucker. For example, as Stephen L. Newman points out,
Spooner _"argues that every man ought to be his own employer, and he envisions
a world of yeoman farmers and independent entrepreneurs."_ [ **Liberalism at
Wit's End** , p. 72] This sort of society was in the process of being
destroyed when Spooner was writing. Needless to say, the Individualist
Anarchists did not think this transformation was unstoppable and proposed,
like other sections of US labour, various solutions to problems society faced.
Given the commonplace awareness in the population of artisan production and
its advantages in terms of liberty, it is hardly surprising that the
individualist anarchists supported "free market" solutions to social problems.
For, given the era, this solution implied workers' control and the selling of
the product of labour, not the labourer him/herself. Unsurprisingly,
therefore, the _"greatest part [of **Liberty** 's readers] proves to be of the
professional/intellectual class: the remainder includes independent
manufacturers and merchants, artisans and skilled workers . . . The
anarchists' hard-core supporters were the socio-economic equivalents of
Jefferson's yeoman-farmers and craftsworkers: a freeholder-artisan-independent
merchant class allied with freethinking professionals and intellectuals. These
groups -- in Europe as well as in America -- had socio-economic independence,
and through their desire to maintain and improve their relatively free
positions, had also the incentive to oppose the growing encroachments of the
capitalist State."_ [Morgan Edwards, _"Neither Bombs Nor Ballots: **Liberty**
& the Strategy of Anarchism"_, pp. 65-91, **Benjamin R. Tucker and the
Champions of Liberty** , Coughlin, Hamilton and Sullivan (eds.), p. 85]

Individualist anarchism is obviously an aspect of a struggle between the
system of peasant and artisan production of early America and the state
encouraged system of capitalism. Indeed, their analysis of the change in
American society from one of mainly independent producers into one based
mainly upon wage labour has many parallels with Karl Marx's analysis of
_"primitive accumulation"_ in the Americas and elsewhere presented in chapter
33 of **Capital** ( _"The Modern Theory of Colonization"_ ). It is this
process which Individualist Anarchism protested against, the use of the state
to favour the rising capitalist class. So the social context the individualist
anarchists lived in must be remembered. America at the times was a
predominantly rural society and industry was not as developed as it is now.
Wage labour would have been minimised. As Wm. Gary Kline argues:

> _"Committed as they were to equality in the pursuit of property, the
> objective for the anarchist became the construction of a society providing
> equal access to those things necessary for creating wealth. The goal of the
> anarchists who extolled mutualism and the abolition of all monopolies was,
> then, a society where everyone willing to work would have the tools and raw
> materials necessary for production in a non-exploitative system . . . the
> dominant vision of the future society . . . [was] underpinned by individual,
> self-employed workers."_ [ **The Individualist Anarchists: A Critique of
> Liberalism** , p. 95]

This social context helps explain why some of the individualist anarchists
were indifferent to the issue of wage labour, unlike most anarchists. A
limited amount of wage labour within a predominantly self-employed economy
does not make a given society capitalist any more than a small amount of
governmental communities within an predominantly anarchist world would make it
statist. As Marx put it, in such socities _"the separation of the worker from
the conditions of labour and from the soil . . . does not yet exist, or only
sporadically, or on too limited a scale . . . Where, amongst such curious
characters, is the 'field of abstinence' for the capitalists? . . . Today's
wage-labourer is tomorrow's independent peasant or artisan, working for
himself. He vanishes from the labour-market -- but not into the workhouse."_
There is a _"constant transformation of wage-labourers into independent
producers, who work for themselves instead of for capital"_ and so _"the
degree of exploitation of the wage-labourer remain[s] indecently low."_ In
addition, the _"wage-labourer also loses, along with the relation of
dependence, the feeling of dependence on the abstemious capitalist."_ [ **Op.
Cit.** , pp. 935-6] Within such a social context, the anti-libertarian aspects
of wage labour are minimised and so could be overlooked by otherwise sharp
critics of authoritarianism as Tucker and Andrews.

Therefore Rocker was correct when he argued that Individualist Anarchism was
_"above all . . . rooted in the peculiar social conditions of America which
differed fundamentally from those of Europe."_ [ **Op. Cit.** , p. 155] As
these conditions changed, the viability of Individualist Anarchism's solution
to the social problem decreased (as acknowledged by Tucker in 1911, for
example -- see [section G.1.1](secG1.md#secg11)). Individualist Anarchism,
argued Morgan Edwards, _"appears to have dwindled into political
insignificance largely because of the erosion of its political-economic base,
rather than from a simple failure of strategy. With the impetus of the Civil
War, capitalism and the State had too great a head start on the centralisation
of economic and political life for the anarchists to catch up. This
centralisation reduced the independence of the intellectual/professional and
merchant artisan group that were the mainstay of the **Liberty** circle."_ [
**Op. Cit.** , pp. 85-6] While many of the individualist anarchists adjusted
their own ideas to changing social circumstances, as can be seen by Greene's
support for co-operatives ( _"the principle of association"_ ) as the only
means of ending exploitation of labour by capital, the main forum of the
movement ( **Liberty** ) did not consistently subscribe to this position nor
did their support for union struggles play a major role in their strategy.
Faced with another form of anarchism which supported both, unsurprisingly
communist-anarchism replaced it as the dominant form of anarchism by the start
of the 20th century in America.

If these social conditions are not taken into account then the ideas of the
likes of Tucker and Spooner will be distorted beyond recognition. Similarly,
by ignoring the changing nature of socialism in the face of a changing society
and economy, the obvious socialistic aspects of their ideas will be lost.
Ultimately, to analyse the Individualist Anarchists in an a-historic manner
means to distort their ideas and ideals. Moreover, to apply those ideas in a
non-artisan economy without the intention of radically transforming the socio-
economic nature of that society towards one based on artisan production one
would mean to create a society distinctly different than one they envisioned
(see [section G.3](secG3.md) for further discussion).

[‹ G.0 Section G Introduction](secGint.md "Go to previous page")
[up](secGcon.md "Go to parent page") [G.2 Why do individualist anarchists
reject social anarchism? ›](secG2.md "Go to next page")

