/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.parser.BindingExpressionBaseVisitor;
import android.databinding.parser.BindingExpressionParser;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.ObjectUtils;

public class ExpressionVisitor
extends BindingExpressionBaseVisitor<Expr> {
    private final ExprModel mModel;

    public ExpressionVisitor(ExprModel model) {
        this.mModel = model;
    }

    @Override
    public Expr visitStringLiteral(@NotNull BindingExpressionParser.StringLiteralContext ctx) {
        String javaString;
        if (ctx.SingleQuoteString() != null) {
            String str = ctx.SingleQuoteString().getText();
            String contents = str.substring(1, str.length() - 1);
            contents = contents.replace("\"", "\\\"").replace("\\`", "`");
            javaString = '\"' + contents + '\"';
        } else {
            javaString = ctx.DoubleQuoteString().getText();
        }
        return this.mModel.symbol(javaString, String.class);
    }

    @Override
    public Expr visitGrouping(@NotNull BindingExpressionParser.GroupingContext ctx) {
        Preconditions.checkArgument(ctx.children.size() == 3, "Grouping expression should have 3 children. # of children: %d", ctx.children.size());
        return this.mModel.group(((ParseTree)ctx.children.get(1)).accept(this));
    }

    @Override
    public Expr visitBindingSyntax(@NotNull BindingExpressionParser.BindingSyntaxContext ctx) {
        try {
            return this.mModel.bindingExpr(ctx.expression().accept(this));
        }
        catch (Exception e) {
            System.out.println("Error while parsing! " + ctx.getText());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Expr visitDotOp(@NotNull BindingExpressionParser.DotOpContext ctx) {
        ModelAnalyzer analyzer = ModelAnalyzer.getInstance();
        ModelClass modelClass = analyzer.findClass(ctx.getText(), this.mModel.getImports());
        if (modelClass == null) {
            return this.mModel.field(ctx.expression().accept(this), ctx.Identifier().getSymbol().getText());
        }
        String name = modelClass.toJavaCode();
        StaticIdentifierExpr expr = this.mModel.staticIdentifier(name);
        expr.setUserDefinedType(name);
        return expr;
    }

    @Override
    public Expr visitQuestionQuestionOp(@NotNull BindingExpressionParser.QuestionQuestionOpContext ctx) {
        Expr left = ctx.left.accept(this);
        return this.mModel.ternary(this.mModel.comparison("==", left, this.mModel.symbol("null", Object.class)), ctx.right.accept(this), left);
    }

    @Override
    public Expr visitTerminal(@NotNull TerminalNode node) {
        Class<Object> classType;
        int type = node.getSymbol().getType();
        switch (type) {
            case 45: {
                classType = Integer.TYPE;
                break;
            }
            case 46: {
                classType = Float.TYPE;
                break;
            }
            case 47: {
                classType = Boolean.TYPE;
                break;
            }
            case 48: {
                classType = Character.TYPE;
                break;
            }
            case 49: 
            case 50: {
                classType = String.class;
                break;
            }
            case 51: {
                classType = Object.class;
                break;
            }
            default: {
                throw new RuntimeException("cannot create expression from terminal node " + node.toString());
            }
        }
        return this.mModel.symbol(node.getText(), classType);
    }

    @Override
    public Expr visitComparisonOp(@NotNull BindingExpressionParser.ComparisonOpContext ctx) {
        return this.mModel.comparison(ctx.op.getText(), ctx.left.accept(this), ctx.right.accept(this));
    }

    @Override
    public Expr visitIdentifier(@NotNull BindingExpressionParser.IdentifierContext ctx) {
        return this.mModel.identifier(ctx.getText());
    }

    @Override
    public Expr visitTernaryOp(@NotNull BindingExpressionParser.TernaryOpContext ctx) {
        return this.mModel.ternary(ctx.left.accept(this), ctx.iftrue.accept(this), ctx.iffalse.accept(this));
    }

    @Override
    public Expr visitMethodInvocation(@NotNull BindingExpressionParser.MethodInvocationContext ctx) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        if (ctx.args != null) {
            for (ParseTree item : ctx.args.children) {
                if (ObjectUtils.equals(item.getText(), ",")) continue;
                args.add(item.accept(this));
            }
        }
        return this.mModel.methodCall(ctx.target.accept(this), ctx.Identifier().getText(), args);
    }

    @Override
    public Expr visitMathOp(@NotNull BindingExpressionParser.MathOpContext ctx) {
        return this.mModel.math(ctx.left.accept(this), ctx.op.getText(), ctx.right.accept(this));
    }

    @Override
    public Expr visitAndOrOp(@NotNull BindingExpressionParser.AndOrOpContext ctx) {
        return this.mModel.logical(ctx.left.accept(this), ctx.op.getText(), ctx.right.accept(this));
    }

    @Override
    public Expr visitBinaryOp(@NotNull BindingExpressionParser.BinaryOpContext ctx) {
        return this.mModel.math(ctx.left.accept(this), ctx.op.getText(), ctx.right.accept(this));
    }

    @Override
    public Expr visitBitShiftOp(@NotNull BindingExpressionParser.BitShiftOpContext ctx) {
        return this.mModel.bitshift(ctx.left.accept(this), ctx.op.getText(), ctx.right.accept(this));
    }

    @Override
    public Expr visitInstanceOfOp(@NotNull BindingExpressionParser.InstanceOfOpContext ctx) {
        return this.mModel.instanceOfOp(ctx.expression().accept(this), ctx.type().getText());
    }

    @Override
    public Expr visitUnaryOp(@NotNull BindingExpressionParser.UnaryOpContext ctx) {
        return this.mModel.unary(ctx.op.getText(), ctx.expression().accept(this));
    }

    @Override
    public Expr visitResources(@NotNull BindingExpressionParser.ResourcesContext ctx) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        if (ctx.resourceParameters() != null) {
            for (ParseTree item : ctx.resourceParameters().expressionList().children) {
                if (ObjectUtils.equals(item.getText(), ",")) continue;
                args.add(item.accept(this));
            }
        }
        String resourceReference = ctx.ResourceReference().getText();
        int colonIndex = resourceReference.indexOf(58);
        int slashIndex = resourceReference.indexOf(47);
        String packageName = colonIndex < 0 ? null : resourceReference.substring(1, colonIndex).trim();
        int startIndex = Math.max(1, colonIndex + 1);
        String resourceType = resourceReference.substring(startIndex, slashIndex).trim();
        String resourceName = resourceReference.substring(slashIndex + 1).trim();
        return this.mModel.resourceExpr(packageName, resourceType, resourceName, args);
    }

    @Override
    public Expr visitBracketOp(@NotNull BindingExpressionParser.BracketOpContext ctx) {
        return this.mModel.bracketExpr((Expr)this.visit(ctx.expression(0)), (Expr)this.visit(ctx.expression(1)));
    }

    @Override
    public Expr visitCastOp(@NotNull BindingExpressionParser.CastOpContext ctx) {
        return this.mModel.castExpr(ctx.type().getText(), (Expr)this.visit(ctx.expression()));
    }
}

