/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 10:20:09 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.text.StyledEditorKit;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.ActionController;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ActionController_ESTest extends ActionController_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      // Undeclared exception!
      try { 
        actionController0.entryGroupChanged((EntryGroupChangeEvent) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ActionController", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      // Undeclared exception!
      try { 
        actionController0.addUndoMenu((JMenuItem) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ActionController", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      // Undeclared exception!
      try { 
        actionController0.addRedoMenu((JMenuItem) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ActionController", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      EntryChangeEvent entryChangeEvent0 = new EntryChangeEvent(actionController0, entry0, 0);
      actionController0.entryChanged(entryChangeEvent0);
      assertEquals(1, EntryChangeEvent.FEATURE_DELETED);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      EntryGroupChangeEvent entryGroupChangeEvent0 = new EntryGroupChangeEvent(simpleEntryGroup0, entry0, 2);
      actionController0.entryGroupChanged(entryGroupChangeEvent0);
      assertEquals(3, EntryGroupChangeEvent.ENTRY_ACTIVE);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      actionController0.startAction();
      // Undeclared exception!
      try { 
        actionController0.featureChanged((FeatureChangeEvent) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown event type: null
         //
         verifyException("uk.ac.sanger.artemis.Action", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      actionController0.featureChanged((FeatureChangeEvent) null);
      assertFalse(actionController0.canUndo());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      actionController0.startAction();
      // Undeclared exception!
      try { 
        actionController0.entryChanged((EntryChangeEvent) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown event type: null
         //
         verifyException("uk.ac.sanger.artemis.Action", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("G0 OI+O64Pw0G}=/", "G0 OI+O64Pw0G}=/");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "G0 OI+O64Pw0G}=/");
      Entry entry0 = filteredEntryGroup0.createEntry("G0 OI+O64Pw0G}=/");
      EntryGroupChangeEvent entryGroupChangeEvent0 = new EntryGroupChangeEvent(simpleEntryGroup0, entry0, 1);
      actionController0.entryGroupChanged(entryGroupChangeEvent0);
      assertEquals(5, EntryGroupChangeEvent.NEW_DEFAULT_ENTRY);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      JPopupMenu jPopupMenu0 = new JPopupMenu("H2V5<-4xk^");
      StyledEditorKit.BoldAction styledEditorKit_BoldAction0 = new StyledEditorKit.BoldAction();
      JMenuItem jMenuItem0 = jPopupMenu0.add((javax.swing.Action) styledEditorKit_BoldAction0);
      actionController0.addRedoMenu(jMenuItem0);
      actionController0.addRedoMenu(jMenuItem0);
      assertFalse(actionController0.canUndo());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      JRadioButtonMenuItem jRadioButtonMenuItem0 = new JRadioButtonMenuItem();
      actionController0.addUndoMenu(jRadioButtonMenuItem0);
      JCheckBoxMenuItem jCheckBoxMenuItem0 = new JCheckBoxMenuItem("Dispatcher-");
      actionController0.addUndoMenu(jCheckBoxMenuItem0);
      assertFalse(actionController0.canUndo());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      boolean boolean0 = actionController0.redo();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "W888(p$g:NHs2");
      ActionController actionController0 = filteredEntryGroup0.getActionController();
      boolean boolean0 = actionController0.undo();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      boolean boolean0 = actionController0.canUndo();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      actionController0.endAction();
      assertFalse(actionController0.canUndo());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      actionController0.startAction();
      // Undeclared exception!
      try { 
        actionController0.startAction();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - ActionController.startAction() called twice
         //
         verifyException("uk.ac.sanger.artemis.ActionController", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      actionController0.startAction();
      actionController0.endAction();
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      ActionController actionController0 = new ActionController();
      Range range0 = new Range(597, 597);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(597, 2, range0);
      actionController0.sequenceChanged(sequenceChangeEvent0);
      assertEquals(0, sequenceChangeEvent0.getLength());
  }
}
