/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 12:07:18 GMT 2018
 */

package uk.ac.sanger.artemis.components.filetree;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import javax.swing.JProgressBar;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.filetree.FileList;
import uk.ac.sanger.artemis.j2ssh.FTProgress;
import uk.ac.sanger.artemis.j2ssh.SshFileManager;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FileList_ESTest extends FileList_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      MockFile mockFile0 = new MockFile("o_JdLN(>8NeT;E<dot*");
      // Undeclared exception!
      try { 
        fileList0.getZipEntryContents("", "o_JdLN(>8NeT;E<dot*", mockFile0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      boolean boolean0 = FileList.isConnected();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FileList fileList0 = null;
      try {
        fileList0 = new FileList();
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      // Undeclared exception!
      try { 
        fileList0.stat("Ia,c]");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      JProgressBar jProgressBar0 = new JProgressBar(0, 47);
      FTProgress fTProgress0 = new FTProgress(jProgressBar0, "9+dMMDW:Z'O*t[c,D]R");
      // Undeclared exception!
      try { 
        fileList0.getFileContents("9+dMMDW:Z'O*t[c,D]R", fTProgress0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      // Undeclared exception!
      try { 
        fileList0.rename(".gz | gunzip", (String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      // Undeclared exception!
      try { 
        fileList0.pwd();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      MockFile mockFile0 = new MockFile((String) null, "el(O>m@[*{.nE|");
      JProgressBar jProgressBar0 = new JProgressBar();
      FTProgress fTProgress0 = new FTProgress(jProgressBar0, (String) null);
      // Undeclared exception!
      try { 
        fileList0.put(".gz", mockFile0, fTProgress0, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      // Undeclared exception!
      try { 
        fileList0.delete("R)gxA01UC@eV_JAm=j");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      // Undeclared exception!
      try { 
        fileList0.mkdir("jCC xmXHS::");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      // Undeclared exception!
      try { 
        fileList0.getDirList("");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      // Undeclared exception!
      try { 
        fileList0.isDirectory("dbKB.jT9VbkC.8aDl}.");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }
}
