/*
 * Do not edit: automatically generated by mkavrintel.pl
 *
 * avrintel.h
 *
 * Atmel AVR8L, AVR8, XMEGA and AVR8X family description of interrupts and more
 *
 * published under GNU General Public License, version 3 (GPL-3.0)
 * meta-author Stefan Rueger <stefan.rueger@urclocks.com>
 *
 * v 1.1
 * 02.01.2023
 *
 */

#ifndef AVRINTEL_H
#define AVRINTEL_H

#include "libavrdude.h"

typedef struct {                // Value of -1 typically means unknown
  const char *name;             // Name of part
  uint16_t mcuid;               // ID of MCU in 0..2039
  uint8_t  avrarch;             // F_AVR8L, F_AVR8, F_XMEGA or F_AVR8X
  uint8_t sigs[3];              // Signature bytes
  int32_t flashoffset;          // Flash offset
  int32_t flashsize;            // Flash size
  int16_t pagesize;             // Flash page size
  int8_t  nboots;               // Number of supported boot sectors
  int16_t bootsize;             // Size of (smallest) boot sector
  int32_t eepromoffset;         // EEPROM offset
  int32_t eepromsize;           // EEPROM size
  int32_t eeprompagesize;       // EEPROM page size
  int32_t sramstart;            // SRAM offset
  int32_t sramsize;             // SRAM size
  int8_t  nfuses;               // Number of fuse bytes
  int8_t  nlocks;               // Number of lock bytes
  uint8_t ninterrupts;          // Number of vectors in interrupt vector table
  const char * const *isrtable; // Interrupt vector table vector names
} uPcore_t;

#define F_AVR8L               1 // TPI programming, ATtiny(4|5|9|10|20|40|102|104)
#define F_AVR8                2 // ISP programming with SPI, "classic" AVRs
#define F_XMEGA               4 // PDI programming, ATxmega family
#define F_AVR8X               8 // UPDI programming, newer 8-bit MCUs

#define UB_N_MCU           2040 // mcuid is in 0..2039

// MCU id: running number in arbitrary order; once assigned never change for backward compatibility
#define id_attiny4           0u
#define id_attiny5           1u
#define id_attiny9           2u
#define id_attiny10          3u
#define id_attiny20          4u
#define id_attiny40          5u
#define id_attiny102         6u
#define id_attiny104         7u
#define id_attiny11          8u
#define id_attiny12          9u
#define id_attiny13         10u
#define id_attiny13a        11u
#define id_attiny15         12u
#define id_attiny22         13u
#define id_attiny24         14u
#define id_attiny24a        15u
#define id_attiny25         16u
#define id_attiny26         17u
#define id_attiny28         18u
#define id_attiny43u        19u
#define id_attiny44         20u
#define id_attiny44a        21u
#define id_attiny45         22u
#define id_attiny48         23u
#define id_attiny84         24u
#define id_attiny84a        25u
#define id_attiny85         26u
#define id_attiny87         27u
#define id_attiny88         28u
#define id_attiny167        29u
#define id_attiny261        30u
#define id_attiny261a       31u
#define id_attiny441        32u
#define id_attiny461        33u
#define id_attiny461a       34u
#define id_attiny828        35u
#define id_attiny828r       36u
#define id_attiny841        37u
#define id_attiny861        38u
#define id_attiny861a       39u
#define id_attiny1634       40u
#define id_attiny1634r      41u
#define id_attiny2313       42u
#define id_attiny2313a      43u
#define id_attiny4313       44u
#define id_atmega8          45u
#define id_atmega8a         46u
#define id_atmega8hva       47u
#define id_atmega8u2        48u
#define id_atmega16         49u
#define id_atmega16a        50u
#define id_atmega16hva      51u
#define id_atmega16hvb      52u
#define id_atmega16hvbrevb  53u
#define id_atmega16m1       54u
#define id_atmega16hva2     55u
#define id_atmega16u2       56u
#define id_atmega16u4       57u
#define id_atmega32         58u
#define id_atmega32a        59u
#define id_atmega32hvb      60u
#define id_atmega32hvbrevb  61u
#define id_atmega32c1       62u
#define id_atmega32m1       63u
#define id_atmega32u2       64u
#define id_atmega32u4       65u
#define id_atmega32u6       66u
#define id_atmega48         67u
#define id_atmega48a        68u
#define id_atmega48p        69u
#define id_atmega48pa       70u
#define id_atmega48pb       71u
#define id_atmega64         72u
#define id_atmega64a        73u
#define id_atmega64hve      74u
#define id_atmega64c1       75u
#define id_atmega64m1       76u
#define id_atmega64hve2     77u
#define id_atmega64rfr2     78u
#define id_atmega88         79u
#define id_atmega88a        80u
#define id_atmega88p        81u
#define id_atmega88pa       82u
#define id_atmega88pb       83u
#define id_atmega103        84u
#define id_atmega128        85u
#define id_atmega128a       86u
#define id_atmega128rfa1    87u
#define id_atmega128rfr2    88u
#define id_atmega161        89u
#define id_atmega162        90u
#define id_atmega163        91u
#define id_atmega164a       92u
#define id_atmega164p       93u
#define id_atmega164pa      94u
#define id_atmega165        95u
#define id_atmega165a       96u
#define id_atmega165p       97u
#define id_atmega165pa      98u
#define id_atmega168        99u
#define id_atmega168a      100u
#define id_atmega168p      101u
#define id_atmega168pa     102u
#define id_atmega168pb     103u
#define id_atmega169       104u
#define id_atmega169a      105u
#define id_atmega169p      106u
#define id_atmega169pa     107u
#define id_atmega256rfr2   108u
#define id_atmega323       109u
#define id_atmega324a      110u
#define id_atmega324p      111u
#define id_atmega324pa     112u
#define id_atmega324pb     113u
#define id_atmega325       114u
#define id_atmega325a      115u
#define id_atmega325p      116u
#define id_atmega325pa     117u
#define id_atmega328       118u
#define id_atmega328p      119u
#define id_atmega328pb     120u
#define id_atmega329       121u
#define id_atmega329a      122u
#define id_atmega329p      123u
#define id_atmega329pa     124u
#define id_atmega406       125u
#define id_atmega640       126u
#define id_atmega644       127u
#define id_atmega644a      128u
#define id_atmega644p      129u
#define id_atmega644pa     130u
#define id_atmega644rfr2   131u
#define id_atmega645       132u
#define id_atmega645a      133u
#define id_atmega645p      134u
#define id_atmega649       135u
#define id_atmega649a      136u
#define id_atmega649p      137u
#define id_atmega1280      138u
#define id_atmega1281      139u
#define id_atmega1284      140u
#define id_atmega1284p     141u
#define id_atmega1284rfr2  142u
#define id_atmega2560      143u
#define id_atmega2561      144u
#define id_atmega2564rfr2  145u
#define id_atmega3250      146u
#define id_atmega3250a     147u
#define id_atmega3250p     148u
#define id_atmega3250pa    149u
#define id_atmega3290      150u
#define id_atmega3290a     151u
#define id_atmega3290p     152u
#define id_atmega3290pa    153u
#define id_atmega6450      154u
#define id_atmega6450a     155u
#define id_atmega6450p     156u
#define id_atmega6490      157u
#define id_atmega6490a     158u
#define id_atmega6490p     159u
#define id_atmega8515      160u
#define id_atmega8535      161u
#define id_at43usb320      162u
#define id_at43usb355      163u
#define id_at76c711        164u
#define id_at86rf401       165u
#define id_at90pwm1        166u
#define id_at90pwm2        167u
#define id_at90pwm2b       168u
#define id_at90pwm3        169u
#define id_at90pwm3b       170u
#define id_at90can32       171u
#define id_at90can64       172u
#define id_at90pwm81       173u
#define id_at90usb82       174u
#define id_at90scr100      175u
#define id_at90can128      176u
#define id_at90pwm161      177u
#define id_at90usb162      178u
#define id_at90pwm216      179u
#define id_at90pwm316      180u
#define id_at90usb646      181u
#define id_at90usb647      182u
#define id_at90s1200       183u
#define id_at90usb1286     184u
#define id_at90usb1287     185u
#define id_at90s2313       186u
#define id_at90s2323       187u
#define id_at90s2333       188u
#define id_at90s2343       189u
#define id_at90s4414       190u
#define id_at90s4433       191u
#define id_at90s4434       192u
#define id_at90s8515       193u
#define id_at90c8534       194u
#define id_at90s8535       195u
#define id_at94k           196u
#define id_ata5272         197u
#define id_ata5505         198u
#define id_ata5700m322     199u
#define id_ata5702m322     200u
#define id_ata5781         201u
#define id_ata5782         202u
#define id_ata5783         203u
#define id_ata5787         204u
#define id_ata5790         205u
#define id_ata5790n        206u
#define id_ata5791         207u
#define id_ata5795         208u
#define id_ata5831         209u
#define id_ata5832         210u
#define id_ata5833         211u
#define id_ata5835         212u
#define id_ata6285         213u
#define id_ata6286         214u
#define id_ata6289         215u
#define id_ata6612c        216u
#define id_ata6613c        217u
#define id_ata6614q        218u
#define id_ata6616c        219u
#define id_ata6617c        220u
#define id_ata8210         221u
#define id_ata8215         222u
#define id_ata8510         223u
#define id_ata8515         224u
#define id_ata664251       225u
#define id_m3000           226u
#define id_lgt8f88p        227u
#define id_lgt8f168p       228u
#define id_lgt8f328p       229u
#define id_atxmega8e5      230u
#define id_atxmega16a4     231u
#define id_atxmega16a4u    232u
#define id_atxmega16c4     233u
#define id_atxmega16d4     234u
#define id_atxmega16e5     235u
#define id_atxmega32c3     236u
#define id_atxmega32d3     237u
#define id_atxmega32a4     238u
#define id_atxmega32a4u    239u
#define id_atxmega32c4     240u
#define id_atxmega32d4     241u
#define id_atxmega32e5     242u
#define id_atxmega64a1     243u
#define id_atxmega64a1u    244u
#define id_atxmega64b1     245u
#define id_atxmega64a3     246u
#define id_atxmega64a3u    247u
#define id_atxmega64b3     248u
#define id_atxmega64c3     249u
#define id_atxmega64d3     250u
#define id_atxmega64a4     251u
#define id_atxmega64a4u    252u
#define id_atxmega64d4     253u
#define id_atxmega128a1    254u
#define id_atxmega128a1revd 255u
#define id_atxmega128a1u   256u
#define id_atxmega128b1    257u
#define id_atxmega128a3    258u
#define id_atxmega128a3u   259u
#define id_atxmega128b3    260u
#define id_atxmega128c3    261u
#define id_atxmega128d3    262u
#define id_atxmega128a4    263u
#define id_atxmega128a4u   264u
#define id_atxmega128d4    265u
#define id_atxmega192a1    266u
#define id_atxmega192a3    267u
#define id_atxmega192a3u   268u
#define id_atxmega192c3    269u
#define id_atxmega192d3    270u
#define id_atxmega256a1    271u
#define id_atxmega256a3    272u
#define id_atxmega256a3b   273u
#define id_atxmega256a3bu  274u
#define id_atxmega256a3u   275u
#define id_atxmega256c3    276u
#define id_atxmega256d3    277u
#define id_atxmega384c3    278u
#define id_atxmega384d3    279u
#define id_attiny202       280u
#define id_attiny204       281u
#define id_attiny212       282u
#define id_attiny214       283u
#define id_attiny402       284u
#define id_attiny404       285u
#define id_attiny406       286u
#define id_attiny412       287u
#define id_attiny414       288u
#define id_attiny416       289u
#define id_attiny416auto   290u
#define id_attiny417       291u
#define id_attiny424       292u
#define id_attiny426       293u
#define id_attiny427       294u
#define id_attiny804       295u
#define id_attiny806       296u
#define id_attiny807       297u
#define id_attiny814       298u
#define id_attiny816       299u
#define id_attiny817       300u
#define id_attiny824       301u
#define id_attiny826       302u
#define id_attiny827       303u
#define id_attiny1604      304u
#define id_attiny1606      305u
#define id_attiny1607      306u
#define id_attiny1614      307u
#define id_attiny1616      308u
#define id_attiny1617      309u
#define id_attiny1624      310u
#define id_attiny1626      311u
#define id_attiny1627      312u
#define id_attiny3214      313u
#define id_attiny3216      314u
#define id_attiny3217      315u
#define id_attiny3224      316u
#define id_attiny3226      317u
#define id_attiny3227      318u
#define id_atmega808       319u
#define id_atmega809       320u
#define id_atmega1608      321u
#define id_atmega1609      322u
#define id_atmega3208      323u
#define id_atmega3209      324u
#define id_atmega4808      325u
#define id_atmega4809      326u
#define id_avr8ea28        327u
#define id_avr8ea32        328u
#define id_avr16dd14       329u
#define id_avr16dd20       330u
#define id_avr16dd28       331u
#define id_avr16ea28       332u
#define id_avr16dd32       333u
#define id_avr16ea32       334u
#define id_avr16ea48       335u
#define id_avr32dd14       336u
#define id_avr32dd20       337u
#define id_avr32da28       338u
#define id_avr32db28       339u
#define id_avr32dd28       340u
#define id_avr32ea28       341u
#define id_avr32da32       342u
#define id_avr32db32       343u
#define id_avr32dd32       344u
#define id_avr32ea32       345u
#define id_avr32da48       346u
#define id_avr32db48       347u
#define id_avr32ea48       348u
#define id_avr64dd14       349u
#define id_avr64dd20       350u
#define id_avr64da28       351u
#define id_avr64db28       352u
#define id_avr64dd28       353u
#define id_avr64ea28       354u
#define id_avr64da32       355u
#define id_avr64db32       356u
#define id_avr64dd32       357u
#define id_avr64ea32       358u
#define id_avr64da48       359u
#define id_avr64db48       360u
#define id_avr64ea48       361u
#define id_avr64da64       362u
#define id_avr64db64       363u
#define id_avr128da28      364u
#define id_avr128db28      365u
#define id_avr128da32      366u
#define id_avr128db32      367u
#define id_avr128da48      368u
#define id_avr128db48      369u
#define id_avr128da64      370u
#define id_avr128db64      371u

// Interrupt vector table sizes (number of vectors)
#define vts_attiny4          10
#define vts_attiny5          11
#define vts_attiny9          10
#define vts_attiny10         11
#define vts_attiny20         17
#define vts_attiny40         18
#define vts_attiny102        16
#define vts_attiny104        16
#define vts_attiny11          5
#define vts_attiny12          6
#define vts_attiny13         10
#define vts_attiny13a        10
#define vts_attiny15          9
#define vts_attiny22          3
#define vts_attiny24         17
#define vts_attiny24a        17
#define vts_attiny25         15
#define vts_attiny26         12
#define vts_attiny28          6
#define vts_attiny43u        16
#define vts_attiny44         17
#define vts_attiny44a        17
#define vts_attiny45         15
#define vts_attiny48         20
#define vts_attiny84         17
#define vts_attiny84a        17
#define vts_attiny85         15
#define vts_attiny87         20
#define vts_attiny88         20
#define vts_attiny167        20
#define vts_attiny261        19
#define vts_attiny261a       19
#define vts_attiny441        30
#define vts_attiny461        19
#define vts_attiny461a       19
#define vts_attiny828        26
#define vts_attiny841        30
#define vts_attiny861        19
#define vts_attiny861a       19
#define vts_attiny1634       28
#define vts_attiny2313       19
#define vts_attiny2313a      21
#define vts_attiny4313       21
#define vts_atmega8          19
#define vts_atmega8a         19
#define vts_atmega8hva       21
#define vts_atmega8u2        29
#define vts_atmega16         21
#define vts_atmega16a        21
#define vts_atmega16hva      21
#define vts_atmega16hvb      29
#define vts_atmega16hvbrevb  29
#define vts_atmega16m1       31
#define vts_atmega16hva2     22
#define vts_atmega16u2       29
#define vts_atmega16u4       43
#define vts_atmega32         21
#define vts_atmega32a        21
#define vts_atmega32hvb      29
#define vts_atmega32hvbrevb  29
#define vts_atmega32c1       31
#define vts_atmega32m1       31
#define vts_atmega32u2       29
#define vts_atmega32u4       43
#define vts_atmega32u6       38
#define vts_atmega48         26
#define vts_atmega48a        26
#define vts_atmega48p        26
#define vts_atmega48pa       26
#define vts_atmega48pb       27
#define vts_atmega64         35
#define vts_atmega64a        35
#define vts_atmega64hve      25
#define vts_atmega64c1       31
#define vts_atmega64m1       31
#define vts_atmega64hve2     25
#define vts_atmega64rfr2     77
#define vts_atmega88         26
#define vts_atmega88a        26
#define vts_atmega88p        26
#define vts_atmega88pa       26
#define vts_atmega88pb       27
#define vts_atmega103        24
#define vts_atmega128        35
#define vts_atmega128a       35
#define vts_atmega128rfa1    72
#define vts_atmega128rfr2    77
#define vts_atmega161        21
#define vts_atmega162        28
#define vts_atmega163        18
#define vts_atmega164a       31
#define vts_atmega164p       31
#define vts_atmega164pa      31
#define vts_atmega165        22
#define vts_atmega165a       22
#define vts_atmega165p       22
#define vts_atmega165pa      22
#define vts_atmega168        26
#define vts_atmega168a       26
#define vts_atmega168p       26
#define vts_atmega168pa      26
#define vts_atmega168pb      27
#define vts_atmega169        23
#define vts_atmega169a       23
#define vts_atmega169p       23
#define vts_atmega169pa      23
#define vts_atmega256rfr2    77
#define vts_atmega323        21
#define vts_atmega324a       31
#define vts_atmega324p       31
#define vts_atmega324pa      31
#define vts_atmega324pb      51
#define vts_atmega325        22
#define vts_atmega325a       22
#define vts_atmega325p       22
#define vts_atmega325pa      22
#define vts_atmega328        26
#define vts_atmega328p       26
#define vts_atmega328pb      45
#define vts_atmega329        23
#define vts_atmega329a       23
#define vts_atmega329p       23
#define vts_atmega329pa      23
#define vts_atmega406        23
#define vts_atmega640        57
#define vts_atmega644        28
#define vts_atmega644a       31
#define vts_atmega644p       31
#define vts_atmega644pa      31
#define vts_atmega644rfr2    77
#define vts_atmega645        22
#define vts_atmega645a       22
#define vts_atmega645p       22
#define vts_atmega649        23
#define vts_atmega649a       23
#define vts_atmega649p       23
#define vts_atmega1280       57
#define vts_atmega1281       57
#define vts_atmega1284       35
#define vts_atmega1284p      35
#define vts_atmega1284rfr2   77
#define vts_atmega2560       57
#define vts_atmega2561       57
#define vts_atmega2564rfr2   77
#define vts_atmega3250       25
#define vts_atmega3250a      25
#define vts_atmega3250p      25
#define vts_atmega3250pa     25
#define vts_atmega3290       25
#define vts_atmega3290a      25
#define vts_atmega3290p      25
#define vts_atmega3290pa     25
#define vts_atmega6450       25
#define vts_atmega6450a      25
#define vts_atmega6450p      25
#define vts_atmega6490       25
#define vts_atmega6490a      25
#define vts_atmega6490p      25
#define vts_atmega8515       17
#define vts_atmega8535       21
#define vts_at86rf401         3
#define vts_at90pwm1         32
#define vts_at90pwm2         32
#define vts_at90pwm2b        32
#define vts_at90pwm3         32
#define vts_at90pwm3b        32
#define vts_at90can32        37
#define vts_at90can64        37
#define vts_at90pwm81        20
#define vts_at90usb82        29
#define vts_at90scr100       38
#define vts_at90can128       37
#define vts_at90pwm161       20
#define vts_at90usb162       29
#define vts_at90pwm216       32
#define vts_at90pwm316       32
#define vts_at90usb646       38
#define vts_at90usb647       38
#define vts_at90s1200         4
#define vts_at90usb1286      38
#define vts_at90usb1287      38
#define vts_at90s2313        11
#define vts_at90s2323         3
#define vts_at90s2333        14
#define vts_at90s2343         3
#define vts_at90s4414        13
#define vts_at90s4433        14
#define vts_at90s4434        17
#define vts_at90s8515        13
#define vts_at90s8535        17
#define vts_ata5272          37
#define vts_ata5505          20
#define vts_ata5700m322      51
#define vts_ata5702m322      51
#define vts_ata5781          42
#define vts_ata5782          42
#define vts_ata5783          42
#define vts_ata5787          44
#define vts_ata5790          30
#define vts_ata5790n         31
#define vts_ata5791          31
#define vts_ata5795          23
#define vts_ata5831          42
#define vts_ata5832          42
#define vts_ata5833          42
#define vts_ata5835          44
#define vts_ata6285          27
#define vts_ata6286          27
#define vts_ata6289          27
#define vts_ata6612c         26
#define vts_ata6613c         26
#define vts_ata6614q         26
#define vts_ata6616c         20
#define vts_ata6617c         20
#define vts_ata8210          42
#define vts_ata8215          42
#define vts_ata8510          42
#define vts_ata8515          42
#define vts_ata664251        20
#define vts_atxmega8e5       43
#define vts_atxmega16a4      94
#define vts_atxmega16a4u    127
#define vts_atxmega16c4     127
#define vts_atxmega16d4      91
#define vts_atxmega16e5      43
#define vts_atxmega32c3     127
#define vts_atxmega32d3     114
#define vts_atxmega32a4      94
#define vts_atxmega32a4u    127
#define vts_atxmega32c4     127
#define vts_atxmega32d4      91
#define vts_atxmega32e5      43
#define vts_atxmega64a1     125
#define vts_atxmega64a1u    127
#define vts_atxmega64b1      81
#define vts_atxmega64a3     122
#define vts_atxmega64a3u    127
#define vts_atxmega64b3      54
#define vts_atxmega64c3     127
#define vts_atxmega64d3     114
#define vts_atxmega64a4u    127
#define vts_atxmega64d4      91
#define vts_atxmega128a1    125
#define vts_atxmega128a1u   127
#define vts_atxmega128b1     81
#define vts_atxmega128a3    122
#define vts_atxmega128a3u   127
#define vts_atxmega128b3     54
#define vts_atxmega128c3    127
#define vts_atxmega128d3    114
#define vts_atxmega128a4u   127
#define vts_atxmega128d4     91
#define vts_atxmega192a3    122
#define vts_atxmega192a3u   127
#define vts_atxmega192c3    127
#define vts_atxmega192d3    114
#define vts_atxmega256a3    122
#define vts_atxmega256a3b   122
#define vts_atxmega256a3bu  127
#define vts_atxmega256a3u   127
#define vts_atxmega256c3    127
#define vts_atxmega256d3    114
#define vts_atxmega384c3    127
#define vts_atxmega384d3    114
#define vts_attiny202        26
#define vts_attiny204        26
#define vts_attiny212        26
#define vts_attiny214        26
#define vts_attiny402        26
#define vts_attiny404        26
#define vts_attiny406        26
#define vts_attiny412        26
#define vts_attiny414        26
#define vts_attiny416        26
#define vts_attiny416auto    26
#define vts_attiny417        26
#define vts_attiny424        30
#define vts_attiny426        30
#define vts_attiny427        30
#define vts_attiny804        31
#define vts_attiny806        31
#define vts_attiny807        31
#define vts_attiny814        26
#define vts_attiny816        26
#define vts_attiny817        26
#define vts_attiny824        30
#define vts_attiny826        30
#define vts_attiny827        30
#define vts_attiny1604       31
#define vts_attiny1606       31
#define vts_attiny1607       31
#define vts_attiny1614       31
#define vts_attiny1616       31
#define vts_attiny1617       31
#define vts_attiny1624       30
#define vts_attiny1626       30
#define vts_attiny1627       30
#define vts_attiny3214       31
#define vts_attiny3216       31
#define vts_attiny3217       31
#define vts_attiny3224       30
#define vts_attiny3226       30
#define vts_attiny3227       30
#define vts_atmega808        36
#define vts_atmega809        40
#define vts_atmega1608       36
#define vts_atmega1609       40
#define vts_atmega3208       36
#define vts_atmega3209       40
#define vts_atmega4808       36
#define vts_atmega4809       40
#define vts_avr16dd14        36
#define vts_avr16dd20        36
#define vts_avr16dd28        36
#define vts_avr16dd32        36
#define vts_avr32dd14        36
#define vts_avr32dd20        36
#define vts_avr32da28        41
#define vts_avr32db28        42
#define vts_avr32dd28        36
#define vts_avr32da32        44
#define vts_avr32db32        44
#define vts_avr32dd32        36
#define vts_avr32da48        58
#define vts_avr32db48        61
#define vts_avr64dd14        36
#define vts_avr64dd20        36
#define vts_avr64da28        41
#define vts_avr64db28        42
#define vts_avr64dd28        36
#define vts_avr64ea28        37
#define vts_avr64da32        44
#define vts_avr64db32        44
#define vts_avr64dd32        36
#define vts_avr64ea32        37
#define vts_avr64da48        58
#define vts_avr64db48        61
#define vts_avr64ea48        45
#define vts_avr64da64        64
#define vts_avr64db64        65
#define vts_avr128da28       41
#define vts_avr128db28       42
#define vts_avr128da32       44
#define vts_avr128db32       44
#define vts_avr128da48       58
#define vts_avr128db48       61
#define vts_avr128da64       64
#define vts_avr128db64       65

// Suggested vector bootloader interrupt: first unused vector or slot just above vector table
#define vbu_attiny4          10
#define vbu_attiny5          11
#define vbu_attiny9          10
#define vbu_attiny10         11
#define vbu_attiny20         17
#define vbu_attiny40         18
#define vbu_attiny102        16
#define vbu_attiny104        16
#define vbu_attiny11          5
#define vbu_attiny12          6
#define vbu_attiny13         10
#define vbu_attiny13a        10
#define vbu_attiny15          9
#define vbu_attiny22          3
#define vbu_attiny24         17
#define vbu_attiny24a        17
#define vbu_attiny25         15
#define vbu_attiny26         12
#define vbu_attiny28          6
#define vbu_attiny43u        16
#define vbu_attiny44         17
#define vbu_attiny44a        17
#define vbu_attiny45         15
#define vbu_attiny48         20
#define vbu_attiny84         17
#define vbu_attiny84a        17
#define vbu_attiny85         15
#define vbu_attiny87         20
#define vbu_attiny88         20
#define vbu_attiny167        20
#define vbu_attiny261        19
#define vbu_attiny261a       19
#define vbu_attiny441        30
#define vbu_attiny461        19
#define vbu_attiny461a       19
#define vbu_attiny828        26
#define vbu_attiny841        30
#define vbu_attiny861        19
#define vbu_attiny861a       19
#define vbu_attiny1634       28
#define vbu_attiny2313       19
#define vbu_attiny2313a      21
#define vbu_attiny4313       21
#define vbu_atmega8          19
#define vbu_atmega8a         19
#define vbu_atmega8hva       21
#define vbu_atmega8u2        29
#define vbu_atmega16         21
#define vbu_atmega16a        21
#define vbu_atmega16hva      21
#define vbu_atmega16hvb      29
#define vbu_atmega16hvbrevb  29
#define vbu_atmega16m1       31
#define vbu_atmega16hva2     22
#define vbu_atmega16u2       29
#define vbu_atmega16u4       43
#define vbu_atmega32         21
#define vbu_atmega32a        21
#define vbu_atmega32hvb      29
#define vbu_atmega32hvbrevb  29
#define vbu_atmega32c1       31
#define vbu_atmega32m1       31
#define vbu_atmega32u2       29
#define vbu_atmega32u4       43
#define vbu_atmega32u6       38
#define vbu_atmega48         26
#define vbu_atmega48a        26
#define vbu_atmega48p        26
#define vbu_atmega48pa       26
#define vbu_atmega48pb       27
#define vbu_atmega64         35
#define vbu_atmega64a        35
#define vbu_atmega64hve      25
#define vbu_atmega64c1       31
#define vbu_atmega64m1       31
#define vbu_atmega64hve2     25
#define vbu_atmega64rfr2     77
#define vbu_atmega88         26
#define vbu_atmega88a        26
#define vbu_atmega88p        26
#define vbu_atmega88pa       26
#define vbu_atmega88pb       27
#define vbu_atmega103        24
#define vbu_atmega128        35
#define vbu_atmega128a       35
#define vbu_atmega128rfa1    72
#define vbu_atmega128rfr2    77
#define vbu_atmega161        21
#define vbu_atmega162        28
#define vbu_atmega163        18
#define vbu_atmega164a       31
#define vbu_atmega164p       31
#define vbu_atmega164pa      31
#define vbu_atmega165        22
#define vbu_atmega165a       22
#define vbu_atmega165p       22
#define vbu_atmega165pa      22
#define vbu_atmega168        26
#define vbu_atmega168a       26
#define vbu_atmega168p       26
#define vbu_atmega168pa      26
#define vbu_atmega168pb      27
#define vbu_atmega169        23
#define vbu_atmega169a       23
#define vbu_atmega169p       23
#define vbu_atmega169pa      23
#define vbu_atmega256rfr2    77
#define vbu_atmega323        21
#define vbu_atmega324a       31
#define vbu_atmega324p       31
#define vbu_atmega324pa      31
#define vbu_atmega324pb      51
#define vbu_atmega325        22
#define vbu_atmega325a       22
#define vbu_atmega325p       22
#define vbu_atmega325pa      22
#define vbu_atmega328        26
#define vbu_atmega328p       26
#define vbu_atmega328pb      45
#define vbu_atmega329        23
#define vbu_atmega329a       23
#define vbu_atmega329p       23
#define vbu_atmega329pa      23
#define vbu_atmega406        23
#define vbu_atmega640        57
#define vbu_atmega644        28
#define vbu_atmega644a       31
#define vbu_atmega644p       31
#define vbu_atmega644pa      31
#define vbu_atmega644rfr2    77
#define vbu_atmega645        22
#define vbu_atmega645a       22
#define vbu_atmega645p       22
#define vbu_atmega649        23
#define vbu_atmega649a       23
#define vbu_atmega649p       23
#define vbu_atmega1280       57
#define vbu_atmega1281       57
#define vbu_atmega1284       35
#define vbu_atmega1284p      35
#define vbu_atmega1284rfr2   77
#define vbu_atmega2560       57
#define vbu_atmega2561       57
#define vbu_atmega2564rfr2   77
#define vbu_atmega3250       25
#define vbu_atmega3250a      25
#define vbu_atmega3250p      25
#define vbu_atmega3250pa     25
#define vbu_atmega3290       25
#define vbu_atmega3290a      25
#define vbu_atmega3290p      25
#define vbu_atmega3290pa     25
#define vbu_atmega6450       25
#define vbu_atmega6450a      25
#define vbu_atmega6450p      25
#define vbu_atmega6490       25
#define vbu_atmega6490a      25
#define vbu_atmega6490p      25
#define vbu_atmega8515       17
#define vbu_atmega8535       21
#define vbu_at86rf401         3
#define vbu_at90pwm1         32
#define vbu_at90pwm2         14
#define vbu_at90pwm2b        32
#define vbu_at90pwm3         32
#define vbu_at90pwm3b        32
#define vbu_at90can32        37
#define vbu_at90can64        37
#define vbu_at90pwm81        20
#define vbu_at90usb82        29
#define vbu_at90scr100       38
#define vbu_at90can128       37
#define vbu_at90pwm161       20
#define vbu_at90usb162       29
#define vbu_at90pwm216       32
#define vbu_at90pwm316       32
#define vbu_at90usb646       38
#define vbu_at90usb647       38
#define vbu_at90s1200         4
#define vbu_at90usb1286      38
#define vbu_at90usb1287      38
#define vbu_at90s2313        11
#define vbu_at90s2323         3
#define vbu_at90s2333        14
#define vbu_at90s2343         3
#define vbu_at90s4414        13
#define vbu_at90s4433        14
#define vbu_at90s4434        17
#define vbu_at90s8515        13
#define vbu_at90s8535        17
#define vbu_ata5272          17
#define vbu_ata5505          20
#define vbu_ata5700m322      51
#define vbu_ata5702m322      51
#define vbu_ata5781          42
#define vbu_ata5782          42
#define vbu_ata5783          42
#define vbu_ata5787          44
#define vbu_ata5790          30
#define vbu_ata5790n         31
#define vbu_ata5791          31
#define vbu_ata5795          23
#define vbu_ata5831          42
#define vbu_ata5832          42
#define vbu_ata5833          42
#define vbu_ata5835          44
#define vbu_ata6285          27
#define vbu_ata6286          27
#define vbu_ata6289          27
#define vbu_ata6612c         26
#define vbu_ata6613c         26
#define vbu_ata6614q         26
#define vbu_ata6616c         20
#define vbu_ata6617c         20
#define vbu_ata8210          42
#define vbu_ata8215          42
#define vbu_ata8510          42
#define vbu_ata8515          42
#define vbu_ata664251        20
#define vbu_atxmega8e5       43
#define vbu_atxmega16a4      36
#define vbu_atxmega16a4u     36
#define vbu_atxmega16c4       6
#define vbu_atxmega16d4       6
#define vbu_atxmega16e5      43
#define vbu_atxmega32c3       6
#define vbu_atxmega32d3       6
#define vbu_atxmega32a4      36
#define vbu_atxmega32a4u     36
#define vbu_atxmega32c4       6
#define vbu_atxmega32d4       6
#define vbu_atxmega32e5      43
#define vbu_atxmega64a1     102
#define vbu_atxmega64a1u    102
#define vbu_atxmega64b1       8
#define vbu_atxmega64a3      75
#define vbu_atxmega64a3u     75
#define vbu_atxmega64b3       8
#define vbu_atxmega64c3       6
#define vbu_atxmega64d3       6
#define vbu_atxmega64a4u     36
#define vbu_atxmega64d4       6
#define vbu_atxmega128a1    102
#define vbu_atxmega128a1u   102
#define vbu_atxmega128b1      8
#define vbu_atxmega128a3     75
#define vbu_atxmega128a3u    75
#define vbu_atxmega128b3      8
#define vbu_atxmega128c3      6
#define vbu_atxmega128d3      6
#define vbu_atxmega128a4u    36
#define vbu_atxmega128d4      6
#define vbu_atxmega192a3     75
#define vbu_atxmega192a3u    75
#define vbu_atxmega192c3      6
#define vbu_atxmega192d3      6
#define vbu_atxmega256a3     75
#define vbu_atxmega256a3b    57
#define vbu_atxmega256a3bu   57
#define vbu_atxmega256a3u    75
#define vbu_atxmega256c3      6
#define vbu_atxmega256d3      6
#define vbu_atxmega384c3      8
#define vbu_atxmega384d3      6
#define vbu_attiny202         4
#define vbu_attiny204         5
#define vbu_attiny212         4
#define vbu_attiny214         5
#define vbu_attiny402         4
#define vbu_attiny404         5
#define vbu_attiny406        14
#define vbu_attiny412         4
#define vbu_attiny414         5
#define vbu_attiny416        26
#define vbu_attiny416auto    26
#define vbu_attiny417        26
#define vbu_attiny424        30
#define vbu_attiny426        30
#define vbu_attiny427        30
#define vbu_attiny804        14
#define vbu_attiny806        14
#define vbu_attiny807        14
#define vbu_attiny814         5
#define vbu_attiny816        26
#define vbu_attiny817        26
#define vbu_attiny824        30
#define vbu_attiny826        30
#define vbu_attiny827        30
#define vbu_attiny1604       14
#define vbu_attiny1606       14
#define vbu_attiny1607       14
#define vbu_attiny1614        5
#define vbu_attiny1616       31
#define vbu_attiny1617       31
#define vbu_attiny1624       30
#define vbu_attiny1626       30
#define vbu_attiny1627       30
#define vbu_attiny3214       31
#define vbu_attiny3216       31
#define vbu_attiny3217       31
#define vbu_attiny3224       30
#define vbu_attiny3226       30
#define vbu_attiny3227       30
#define vbu_atmega808        36
#define vbu_atmega809        40
#define vbu_atmega1608       36
#define vbu_atmega1609       40
#define vbu_atmega3208       36
#define vbu_atmega3209       40
#define vbu_atmega4808       36
#define vbu_atmega4809       40
#define vbu_avr16dd14        36
#define vbu_avr16dd20        36
#define vbu_avr16dd28        36
#define vbu_avr16dd32        36
#define vbu_avr32dd14        36
#define vbu_avr32dd20        36
#define vbu_avr32da28        41
#define vbu_avr32db28        42
#define vbu_avr32dd28        36
#define vbu_avr32da32        41
#define vbu_avr32db32        44
#define vbu_avr32dd32        36
#define vbu_avr32da48        58
#define vbu_avr32db48        59
#define vbu_avr64dd14        36
#define vbu_avr64dd20        36
#define vbu_avr64da28        41
#define vbu_avr64db28        42
#define vbu_avr64dd28        36
#define vbu_avr64ea28        37
#define vbu_avr64da32        41
#define vbu_avr64db32        44
#define vbu_avr64dd32        36
#define vbu_avr64ea32        37
#define vbu_avr64da48        58
#define vbu_avr64db48        59
#define vbu_avr64ea48        45
#define vbu_avr64da64        64
#define vbu_avr64db64        65
#define vbu_avr128da28       41
#define vbu_avr128db28       42
#define vbu_avr128da32       41
#define vbu_avr128db32       44
#define vbu_avr128da48       58
#define vbu_avr128db48       59
#define vbu_avr128da64       64
#define vbu_avr128db64       65

// Aliases for parts with the same vector table
#define vtab_attiny4         vtab_attiny9
#define vtab_attiny5         vtab_attiny10
#define vtab_attiny102       vtab_attiny104
#define vtab_attiny13        vtab_attiny13a
#define vtab_attiny24        vtab_attiny84a
#define vtab_attiny24a       vtab_attiny84a
#define vtab_attiny25        vtab_attiny85
#define vtab_attiny44        vtab_attiny84a
#define vtab_attiny44a       vtab_attiny84a
#define vtab_attiny45        vtab_attiny85
#define vtab_attiny48        vtab_attiny88
#define vtab_attiny84        vtab_attiny84a
#define vtab_attiny87        vtab_attiny167
#define vtab_attiny261       vtab_attiny861a
#define vtab_attiny261a      vtab_attiny861a
#define vtab_attiny441       vtab_attiny841
#define vtab_attiny461       vtab_attiny861a
#define vtab_attiny461a      vtab_attiny861a
#define vtab_attiny861       vtab_attiny861a
#define vtab_attiny2313a     vtab_attiny4313
#define vtab_atmega8         vtab_atmega8a
#define vtab_atmega8hva      vtab_atmega16hva
#define vtab_atmega8u2       vtab_atmega32u2
#define vtab_atmega16        vtab_atmega16a
#define vtab_atmega16hvb     vtab_atmega32hvbrevb
#define vtab_atmega16hvbrevb vtab_atmega32hvbrevb
#define vtab_atmega16m1      vtab_atmega64m1
#define vtab_atmega16u2      vtab_atmega32u2
#define vtab_atmega16u4      vtab_atmega32u4
#define vtab_atmega32        vtab_atmega323
#define vtab_atmega32a       vtab_atmega323
#define vtab_atmega32hvb     vtab_atmega32hvbrevb
#define vtab_atmega32c1      vtab_atmega64m1
#define vtab_atmega32m1      vtab_atmega64m1
#define vtab_atmega48        vtab_atmega328p
#define vtab_atmega48a       vtab_atmega328p
#define vtab_atmega48p       vtab_atmega328p
#define vtab_atmega48pa      vtab_atmega328p
#define vtab_atmega48pb      vtab_atmega168pb
#define vtab_atmega64        vtab_atmega128a
#define vtab_atmega64a       vtab_atmega128a
#define vtab_atmega64hve     vtab_atmega64hve2
#define vtab_atmega64c1      vtab_atmega64m1
#define vtab_atmega64rfr2    vtab_atmega2564rfr2
#define vtab_atmega88        vtab_atmega328p
#define vtab_atmega88a       vtab_atmega328p
#define vtab_atmega88p       vtab_atmega328p
#define vtab_atmega88pa      vtab_atmega328p
#define vtab_atmega88pb      vtab_atmega168pb
#define vtab_atmega128       vtab_atmega128a
#define vtab_atmega128rfr2   vtab_atmega2564rfr2
#define vtab_atmega164a      vtab_atmega644pa
#define vtab_atmega164p      vtab_atmega644pa
#define vtab_atmega164pa     vtab_atmega644pa
#define vtab_atmega165       vtab_atmega645p
#define vtab_atmega165a      vtab_atmega645p
#define vtab_atmega165p      vtab_atmega645p
#define vtab_atmega165pa     vtab_atmega645p
#define vtab_atmega168       vtab_atmega328
#define vtab_atmega168a      vtab_atmega328p
#define vtab_atmega168p      vtab_atmega328p
#define vtab_atmega168pa     vtab_atmega328p
#define vtab_atmega169       vtab_atmega649p
#define vtab_atmega169a      vtab_atmega649p
#define vtab_atmega169p      vtab_atmega649p
#define vtab_atmega169pa     vtab_atmega649p
#define vtab_atmega256rfr2   vtab_atmega2564rfr2
#define vtab_atmega324a      vtab_atmega644pa
#define vtab_atmega324p      vtab_atmega644pa
#define vtab_atmega324pa     vtab_atmega644pa
#define vtab_atmega325       vtab_atmega645p
#define vtab_atmega325a      vtab_atmega645p
#define vtab_atmega325p      vtab_atmega645p
#define vtab_atmega325pa     vtab_atmega645p
#define vtab_atmega329       vtab_atmega649p
#define vtab_atmega329a      vtab_atmega649p
#define vtab_atmega329p      vtab_atmega649p
#define vtab_atmega329pa     vtab_atmega649p
#define vtab_atmega640       vtab_atmega2561
#define vtab_atmega644a      vtab_atmega644pa
#define vtab_atmega644p      vtab_atmega644pa
#define vtab_atmega644rfr2   vtab_atmega2564rfr2
#define vtab_atmega645       vtab_atmega645p
#define vtab_atmega645a      vtab_atmega645p
#define vtab_atmega649       vtab_atmega649p
#define vtab_atmega649a      vtab_atmega649p
#define vtab_atmega1280      vtab_atmega2561
#define vtab_atmega1281      vtab_atmega2561
#define vtab_atmega1284      vtab_atmega1284p
#define vtab_atmega1284rfr2  vtab_atmega2564rfr2
#define vtab_atmega2560      vtab_atmega2561
#define vtab_atmega3250      vtab_atmega6450p
#define vtab_atmega3250a     vtab_atmega6450p
#define vtab_atmega3250p     vtab_atmega6450p
#define vtab_atmega3250pa    vtab_atmega6450p
#define vtab_atmega3290      vtab_atmega6490p
#define vtab_atmega3290a     vtab_atmega6490p
#define vtab_atmega3290p     vtab_atmega6490p
#define vtab_atmega3290pa    vtab_atmega6490p
#define vtab_atmega6450      vtab_atmega6450p
#define vtab_atmega6450a     vtab_atmega6450p
#define vtab_atmega6490      vtab_atmega6490p
#define vtab_atmega6490a     vtab_atmega6490p
#define vtab_at90pwm1        vtab_at90pwm316
#define vtab_at90pwm2b       vtab_at90pwm3b
#define vtab_at90pwm3        vtab_at90pwm3b
#define vtab_at90can32       vtab_at90can128
#define vtab_at90can64       vtab_at90can128
#define vtab_at90pwm81       vtab_at90pwm161
#define vtab_at90usb82       vtab_atmega32u2
#define vtab_at90usb162      vtab_atmega32u2
#define vtab_at90pwm216      vtab_at90pwm316
#define vtab_at90usb646      vtab_atmega32u6
#define vtab_at90usb647      vtab_atmega32u6
#define vtab_at90usb1286     vtab_atmega32u6
#define vtab_at90usb1287     vtab_atmega32u6
#define vtab_at90s2323       vtab_attiny22
#define vtab_at90s2333       vtab_at90s4433
#define vtab_at90s2343       vtab_attiny22
#define vtab_at90s4414       vtab_at90s8515
#define vtab_at90s4434       vtab_at90s8535
#define vtab_ata5505         vtab_attiny167
#define vtab_ata5700m322     vtab_ata5702m322
#define vtab_ata5781         vtab_ata8515
#define vtab_ata5782         vtab_ata8515
#define vtab_ata5783         vtab_ata8515
#define vtab_ata5787         vtab_ata5835
#define vtab_ata5790n        vtab_ata5791
#define vtab_ata5831         vtab_ata8515
#define vtab_ata5832         vtab_ata8515
#define vtab_ata5833         vtab_ata8515
#define vtab_ata6285         vtab_ata6289
#define vtab_ata6286         vtab_ata6289
#define vtab_ata6612c        vtab_atmega328p
#define vtab_ata6613c        vtab_atmega328p
#define vtab_ata6614q        vtab_atmega328p
#define vtab_ata6616c        vtab_attiny167
#define vtab_ata6617c        vtab_attiny167
#define vtab_ata8210         vtab_ata8515
#define vtab_ata8215         vtab_ata8515
#define vtab_ata8510         vtab_ata8515
#define vtab_ata664251       vtab_attiny167
#define vtab_atxmega8e5      vtab_atxmega32e5
#define vtab_atxmega16a4     vtab_atxmega32a4
#define vtab_atxmega16a4u    vtab_atxmega128a4u
#define vtab_atxmega16c4     vtab_atxmega32c4
#define vtab_atxmega16d4     vtab_atxmega32d4
#define vtab_atxmega16e5     vtab_atxmega32e5
#define vtab_atxmega32c3     vtab_atxmega256c3
#define vtab_atxmega32d3     vtab_atxmega384d3
#define vtab_atxmega32a4u    vtab_atxmega128a4u
#define vtab_atxmega64a1     vtab_atxmega128a1
#define vtab_atxmega64a1u    vtab_atxmega128a1u
#define vtab_atxmega64b1     vtab_atxmega128b1
#define vtab_atxmega64a3     vtab_atxmega256a3
#define vtab_atxmega64a3u    vtab_atxmega256a3u
#define vtab_atxmega64b3     vtab_atxmega128b3
#define vtab_atxmega64c3     vtab_atxmega256c3
#define vtab_atxmega64d3     vtab_atxmega384d3
#define vtab_atxmega64a4u    vtab_atxmega128a4u
#define vtab_atxmega64d4     vtab_atxmega128d4
#define vtab_atxmega128a3    vtab_atxmega256a3
#define vtab_atxmega128a3u   vtab_atxmega256a3u
#define vtab_atxmega128c3    vtab_atxmega256c3
#define vtab_atxmega128d3    vtab_atxmega384d3
#define vtab_atxmega192a3    vtab_atxmega256a3
#define vtab_atxmega192a3u   vtab_atxmega256a3u
#define vtab_atxmega192c3    vtab_atxmega256c3
#define vtab_atxmega192d3    vtab_atxmega384d3
#define vtab_atxmega256d3    vtab_atxmega384d3
#define vtab_attiny202       vtab_attiny402
#define vtab_attiny204       vtab_attiny404
#define vtab_attiny212       vtab_attiny412
#define vtab_attiny214       vtab_attiny814
#define vtab_attiny414       vtab_attiny814
#define vtab_attiny416       vtab_attiny817
#define vtab_attiny416auto   vtab_attiny817
#define vtab_attiny417       vtab_attiny817
#define vtab_attiny424       vtab_attiny3227
#define vtab_attiny426       vtab_attiny3227
#define vtab_attiny427       vtab_attiny3227
#define vtab_attiny804       vtab_attiny1607
#define vtab_attiny806       vtab_attiny1607
#define vtab_attiny807       vtab_attiny1607
#define vtab_attiny816       vtab_attiny817
#define vtab_attiny824       vtab_attiny3227
#define vtab_attiny826       vtab_attiny3227
#define vtab_attiny827       vtab_attiny3227
#define vtab_attiny1604      vtab_attiny1607
#define vtab_attiny1606      vtab_attiny1607
#define vtab_attiny1616      vtab_attiny3217
#define vtab_attiny1617      vtab_attiny3217
#define vtab_attiny1624      vtab_attiny3227
#define vtab_attiny1626      vtab_attiny3227
#define vtab_attiny1627      vtab_attiny3227
#define vtab_attiny3216      vtab_attiny3217
#define vtab_attiny3224      vtab_attiny3227
#define vtab_attiny3226      vtab_attiny3227
#define vtab_atmega808       vtab_atmega4808
#define vtab_atmega809       vtab_atmega4809
#define vtab_atmega1608      vtab_atmega4808
#define vtab_atmega1609      vtab_atmega4809
#define vtab_atmega3208      vtab_atmega4808
#define vtab_atmega3209      vtab_atmega4809
#define vtab_avr16dd14       vtab_avr64dd32
#define vtab_avr16dd20       vtab_avr64dd32
#define vtab_avr16dd28       vtab_avr64dd32
#define vtab_avr16dd32       vtab_avr64dd32
#define vtab_avr32dd14       vtab_avr64dd32
#define vtab_avr32dd20       vtab_avr64dd32
#define vtab_avr32da28       vtab_avr128da28
#define vtab_avr32db28       vtab_avr128db28
#define vtab_avr32dd28       vtab_avr64dd32
#define vtab_avr32da32       vtab_avr128da32
#define vtab_avr32db32       vtab_avr128db32
#define vtab_avr32dd32       vtab_avr64dd32
#define vtab_avr32da48       vtab_avr128da48
#define vtab_avr32db48       vtab_avr128db48
#define vtab_avr64dd14       vtab_avr64dd32
#define vtab_avr64dd20       vtab_avr64dd32
#define vtab_avr64da28       vtab_avr128da28
#define vtab_avr64db28       vtab_avr128db28
#define vtab_avr64dd28       vtab_avr64dd32
#define vtab_avr64ea28       vtab_avr64ea32
#define vtab_avr64da32       vtab_avr128da32
#define vtab_avr64db32       vtab_avr128db32
#define vtab_avr64da48       vtab_avr128da48
#define vtab_avr64db48       vtab_avr128db48
#define vtab_avr64da64       vtab_avr128da64
#define vtab_avr64db64       vtab_avr128db64

// Interrupt vector table interrupt names
extern const char * const vtab_attiny9[10];       // ATtiny9, ATtiny4
extern const char * const vtab_attiny10[11];      // ATtiny10, ATtiny5
extern const char * const vtab_attiny20[17];      // ATtiny20
extern const char * const vtab_attiny40[18];      // ATtiny40
extern const char * const vtab_attiny104[16];     // ATtiny104, ATtiny102
extern const char * const vtab_attiny11[5];       // ATtiny11
extern const char * const vtab_attiny12[6];       // ATtiny12
extern const char * const vtab_attiny13a[10];     // ATtiny13A, ATtiny13
extern const char * const vtab_attiny15[9];       // ATtiny15
extern const char * const vtab_attiny22[3];       // ATtiny22, AT90S2343, AT90S2323
extern const char * const vtab_attiny26[12];      // ATtiny26
extern const char * const vtab_attiny28[6];       // ATtiny28
extern const char * const vtab_attiny43u[16];     // ATtiny43U
extern const char * const vtab_attiny84a[17];     // ATtiny84A, ATtiny84, ATtiny44A, ATtiny44, ATtiny24A, ATtiny24
extern const char * const vtab_attiny85[15];      // ATtiny85, ATtiny45, ATtiny25
extern const char * const vtab_attiny88[20];      // ATtiny88, ATtiny48
extern const char * const vtab_attiny167[20];     // ATtiny167, ATtiny87, ATA664251, ATA6617C, ATA6616C, ATA5505
extern const char * const vtab_attiny828[26];     // ATtiny828
extern const char * const vtab_attiny841[30];     // ATtiny841, ATtiny441
extern const char * const vtab_attiny861a[19];    // ATtiny861A, ATtiny861, ATtiny461A, ATtiny461, ATtiny261A, ATtiny261
extern const char * const vtab_attiny1634[28];    // ATtiny1634
extern const char * const vtab_attiny2313[19];    // ATtiny2313
extern const char * const vtab_attiny4313[21];    // ATtiny4313, ATtiny2313A
extern const char * const vtab_atmega8a[19];      // ATmega8A, ATmega8
extern const char * const vtab_atmega16a[21];     // ATmega16A, ATmega16
extern const char * const vtab_atmega16hva[21];   // ATmega16HVA, ATmega8HVA
extern const char * const vtab_atmega16hva2[22];  // ATmega16HVA2
extern const char * const vtab_atmega32hvbrevb[29]; // ATmega32HVBrevB, ATmega32HVB, ATmega16HVBrevB, ATmega16HVB
extern const char * const vtab_atmega32u2[29];    // ATmega32U2, ATmega16U2, ATmega8U2, AT90USB162, AT90USB82
extern const char * const vtab_atmega32u4[43];    // ATmega32U4, ATmega16U4
extern const char * const vtab_atmega32u6[38];    // ATmega32U6, AT90USB1287, AT90USB1286, AT90USB647, AT90USB646
extern const char * const vtab_atmega64m1[31];    // ATmega64M1, ATmega64C1, ATmega32M1, ATmega32C1, ATmega16M1
extern const char * const vtab_atmega64hve2[25];  // ATmega64HVE2, ATmega64HVE
extern const char * const vtab_atmega103[24];     // ATmega103
extern const char * const vtab_atmega128a[35];    // ATmega128A, ATmega128, ATmega64A, ATmega64
extern const char * const vtab_atmega128rfa1[72]; // ATmega128RFA1
extern const char * const vtab_atmega161[21];     // ATmega161
extern const char * const vtab_atmega162[28];     // ATmega162
extern const char * const vtab_atmega163[18];     // ATmega163
extern const char * const vtab_atmega168pb[27];   // ATmega168PB, ATmega88PB, ATmega48PB
extern const char * const vtab_atmega323[21];     // ATmega323, ATmega32A, ATmega32
extern const char * const vtab_atmega324pb[51];   // ATmega324PB
extern const char * const vtab_atmega328[26];     // ATmega328, ATmega168
extern const char * const vtab_atmega328p[26];    // ATmega328P, ATmega168PA, ATmega168P, ATmega168A, ATmega88PA, ATmega88P, ATmega88A, ATmega88, ATmega48PA, ATmega48P, ATmega48A, ATmega48, ATA6614Q, ATA6613C, ATA6612C
extern const char * const vtab_atmega328pb[45];   // ATmega328PB
extern const char * const vtab_atmega406[23];     // ATmega406
extern const char * const vtab_atmega644[28];     // ATmega644
extern const char * const vtab_atmega644pa[31];   // ATmega644PA, ATmega644P, ATmega644A, ATmega324PA, ATmega324P, ATmega324A, ATmega164PA, ATmega164P, ATmega164A
extern const char * const vtab_atmega645p[22];    // ATmega645P, ATmega645A, ATmega645, ATmega325PA, ATmega325P, ATmega325A, ATmega325, ATmega165PA, ATmega165P, ATmega165A, ATmega165
extern const char * const vtab_atmega649p[23];    // ATmega649P, ATmega649A, ATmega649, ATmega329PA, ATmega329P, ATmega329A, ATmega329, ATmega169PA, ATmega169P, ATmega169A, ATmega169
extern const char * const vtab_atmega1284p[35];   // ATmega1284P, ATmega1284
extern const char * const vtab_atmega2561[57];    // ATmega2561, ATmega2560, ATmega1281, ATmega1280, ATmega640
extern const char * const vtab_atmega2564rfr2[77]; // ATmega2564RFR2, ATmega1284RFR2, ATmega644RFR2, ATmega256RFR2, ATmega128RFR2, ATmega64RFR2
extern const char * const vtab_atmega6450p[25];   // ATmega6450P, ATmega6450A, ATmega6450, ATmega3250PA, ATmega3250P, ATmega3250A, ATmega3250
extern const char * const vtab_atmega6490p[25];   // ATmega6490P, ATmega6490A, ATmega6490, ATmega3290PA, ATmega3290P, ATmega3290A, ATmega3290
extern const char * const vtab_atmega8515[17];    // ATmega8515
extern const char * const vtab_atmega8535[21];    // ATmega8535
extern const char * const vtab_at86rf401[3];      // AT86RF401
extern const char * const vtab_at90pwm2[32];      // AT90PWM2
extern const char * const vtab_at90pwm3b[32];     // AT90PWM3B, AT90PWM3, AT90PWM2B
extern const char * const vtab_at90scr100[38];    // AT90SCR100
extern const char * const vtab_at90can128[37];    // AT90CAN128, AT90CAN64, AT90CAN32
extern const char * const vtab_at90pwm161[20];    // AT90PWM161, AT90PWM81
extern const char * const vtab_at90pwm316[32];    // AT90PWM316, AT90PWM216, AT90PWM1
extern const char * const vtab_at90s1200[4];      // AT90S1200
extern const char * const vtab_at90s2313[11];     // AT90S2313
extern const char * const vtab_at90s4433[14];     // AT90S4433, AT90S2333
extern const char * const vtab_at90s8515[13];     // AT90S8515, AT90S4414
extern const char * const vtab_at90s8535[17];     // AT90S8535, AT90S4434
extern const char * const vtab_ata5272[37];       // ATA5272
extern const char * const vtab_ata5702m322[51];   // ATA5702M322, ATA5700M322
extern const char * const vtab_ata5790[30];       // ATA5790
extern const char * const vtab_ata5791[31];       // ATA5791, ATA5790N
extern const char * const vtab_ata5795[23];       // ATA5795
extern const char * const vtab_ata5835[44];       // ATA5835, ATA5787
extern const char * const vtab_ata6289[27];       // ATA6289, ATA6286, ATA6285
extern const char * const vtab_ata8515[42];       // ATA8515, ATA8510, ATA8215, ATA8210, ATA5833, ATA5832, ATA5831, ATA5783, ATA5782, ATA5781
extern const char * const vtab_atxmega32a4[94];   // ATxmega32A4, ATxmega16A4
extern const char * const vtab_atxmega32c4[127];  // ATxmega32C4, ATxmega16C4
extern const char * const vtab_atxmega32d4[91];   // ATxmega32D4, ATxmega16D4
extern const char * const vtab_atxmega32e5[43];   // ATxmega32E5, ATxmega16E5, ATxmega8E5
extern const char * const vtab_atxmega128a1[125]; // ATxmega128A1, ATxmega64A1
extern const char * const vtab_atxmega128a1u[127]; // ATxmega128A1U, ATxmega64A1U
extern const char * const vtab_atxmega128b1[81];  // ATxmega128B1, ATxmega64B1
extern const char * const vtab_atxmega128b3[54];  // ATxmega128B3, ATxmega64B3
extern const char * const vtab_atxmega128a4u[127]; // ATxmega128A4U, ATxmega64A4U, ATxmega32A4U, ATxmega16A4U
extern const char * const vtab_atxmega128d4[91];  // ATxmega128D4, ATxmega64D4
extern const char * const vtab_atxmega256a3[122]; // ATxmega256A3, ATxmega192A3, ATxmega128A3, ATxmega64A3
extern const char * const vtab_atxmega256a3b[122]; // ATxmega256A3B
extern const char * const vtab_atxmega256a3bu[127]; // ATxmega256A3BU
extern const char * const vtab_atxmega256a3u[127]; // ATxmega256A3U, ATxmega192A3U, ATxmega128A3U, ATxmega64A3U
extern const char * const vtab_atxmega256c3[127]; // ATxmega256C3, ATxmega192C3, ATxmega128C3, ATxmega64C3, ATxmega32C3
extern const char * const vtab_atxmega384c3[127]; // ATxmega384C3
extern const char * const vtab_atxmega384d3[114]; // ATxmega384D3, ATxmega256D3, ATxmega192D3, ATxmega128D3, ATxmega64D3, ATxmega32D3
extern const char * const vtab_attiny402[26];     // ATtiny402, ATtiny202
extern const char * const vtab_attiny404[26];     // ATtiny404, ATtiny204
extern const char * const vtab_attiny406[26];     // ATtiny406
extern const char * const vtab_attiny412[26];     // ATtiny412, ATtiny212
extern const char * const vtab_attiny814[26];     // ATtiny814, ATtiny414, ATtiny214
extern const char * const vtab_attiny817[26];     // ATtiny817, ATtiny816, ATtiny417, ATtiny416auto, ATtiny416
extern const char * const vtab_attiny1607[31];    // ATtiny1607, ATtiny1606, ATtiny1604, ATtiny807, ATtiny806, ATtiny804
extern const char * const vtab_attiny1614[31];    // ATtiny1614
extern const char * const vtab_attiny3214[31];    // ATtiny3214
extern const char * const vtab_attiny3217[31];    // ATtiny3217, ATtiny3216, ATtiny1617, ATtiny1616
extern const char * const vtab_attiny3227[30];    // ATtiny3227, ATtiny3226, ATtiny3224, ATtiny1627, ATtiny1626, ATtiny1624, ATtiny827, ATtiny826, ATtiny824, ATtiny427, ATtiny426, ATtiny424
extern const char * const vtab_atmega4808[36];    // ATmega4808, ATmega3208, ATmega1608, ATmega808
extern const char * const vtab_atmega4809[40];    // ATmega4809, ATmega3209, ATmega1609, ATmega809
extern const char * const vtab_avr64dd32[36];     // AVR64DD32, AVR64DD28, AVR64DD20, AVR64DD14, AVR32DD32, AVR32DD28, AVR32DD20, AVR32DD14, AVR16DD32, AVR16DD28, AVR16DD20, AVR16DD14
extern const char * const vtab_avr64ea32[37];     // AVR64EA32, AVR64EA28
extern const char * const vtab_avr64ea48[45];     // AVR64EA48
extern const char * const vtab_avr128da28[41];    // AVR128DA28, AVR64DA28, AVR32DA28
extern const char * const vtab_avr128db28[42];    // AVR128DB28, AVR64DB28, AVR32DB28
extern const char * const vtab_avr128da32[44];    // AVR128DA32, AVR64DA32, AVR32DA32
extern const char * const vtab_avr128db32[44];    // AVR128DB32, AVR64DB32, AVR32DB32
extern const char * const vtab_avr128da48[58];    // AVR128DA48, AVR64DA48, AVR32DA48
extern const char * const vtab_avr128db48[61];    // AVR128DB48, AVR64DB48, AVR32DB48
extern const char * const vtab_avr128da64[64];    // AVR128DA64, AVR64DA64
extern const char * const vtab_avr128db64[65];    // AVR128DB64, AVR64DB64

extern const uPcore_t uP_table[372];

#endif
